/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.cluster;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.cluster.ClusteringAlgorithm;
import edu.cmu.tetrad.cluster.metrics.Dissimilarity;
import edu.cmu.tetrad.cluster.metrics.SquaredErrorLoss;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DivisiveClustering
implements ClusteringAlgorithm {
    private Dissimilarity metric = new SquaredErrorLoss();
    private double threshold = 0.1;
    private DoubleMatrix2D data;
    private List<List<Integer>> clusters;

    @Override
    public List<List<Integer>> getClusters() {
        return this.clusters;
    }

    @Override
    public void cluster(DoubleMatrix2D data) {
        this.data = data;
        ArrayList<List<Integer>> clusters = new ArrayList<List<Integer>>();
        ArrayList clustersToDivide = new ArrayList();
        ArrayList<Integer> initialCluster = new ArrayList<Integer>();
        for (int i = 0; i < data.rows(); ++i) {
            initialCluster.add(i);
        }
        clustersToDivide.add(initialCluster);
        while (clustersToDivide.size() > 0) {
            for (List cluster : new ArrayList(clustersToDivide)) {
                int[] farPoints = this.getFarPoints2(cluster);
                int i1 = farPoints[0];
                int i2 = farPoints[1];
                double dd = this.distance(i1, i2);
                System.out.println("dd = " + dd);
                if (dd < this.getThreshold()) {
                    clustersToDivide.remove(cluster);
                    if (cluster.size() <= 50) continue;
                    clusters.add(cluster);
                    continue;
                }
                ArrayList<Integer> cluster1 = new ArrayList<Integer>();
                ArrayList<Integer> cluster2 = new ArrayList<Integer>();
                Iterator i$ = cluster.iterator();
                while (i$.hasNext()) {
                    int j = (Integer)i$.next();
                    if (this.distance(i1, j) < this.distance(i2, j)) {
                        cluster1.add(j);
                        continue;
                    }
                    cluster2.add(j);
                }
                clustersToDivide.remove(cluster);
                if (!cluster1.isEmpty()) {
                    clustersToDivide.add(cluster1);
                }
                if (cluster2.isEmpty()) continue;
                clustersToDivide.add(cluster2);
            }
        }
        this.clusters = clusters;
    }

    @Override
    public DoubleMatrix2D getPrototypes() {
        return null;
    }

    @Override
    public void setVerbose(boolean verbose) {
    }

    private int[] getFarPoints1(List<Integer> cluster) {
        int i1 = cluster.get(0);
        int i2 = cluster.get(0);
        double max = 0.0;
        for (int i = 0; i < cluster.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                double d = this.distance(i, j);
                if (!(d >= max)) continue;
                i1 = cluster.get(i);
                i2 = cluster.get(j);
                max = d;
            }
        }
        return new int[]{i1, i2};
    }

    private int[] getFarPoints2(List<Integer> cluster) {
        int j;
        int i1 = cluster.get(0);
        int i2 = -1;
        while (i2 != (j = this.furthestPoint(i1, cluster))) {
            i2 = i1;
            i1 = j;
        }
        return new int[]{i1, i2};
    }

    private int furthestPoint(int i1, List<Integer> cluster) {
        double min = 0.0;
        int v2 = -1;
        for (int j : cluster) {
            double dissimilarity = this.distance(i1, j);
            if (!(dissimilarity >= min)) continue;
            min = dissimilarity;
            v2 = j;
        }
        if (v2 == -1) {
            System.out.println();
        }
        return v2;
    }

    private double distance(int i1, int j) {
        return this.getMetric().dissimilarity(this.data.viewRow(i1), this.data.viewRow(j));
    }

    public Dissimilarity getMetric() {
        return this.metric;
    }

    public void setMetric(Dissimilarity metric) {
        this.metric = metric;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }
}

