/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.cluster;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class Thresholder {
    private DoubleMatrix2D data;
    private List<Double> scores;

    public Thresholder(DoubleMatrix2D data) {
        this.data = data;
        this.scores = new ArrayList<Double>(data.rows());
        for (int i = 0; i < data.rows(); ++i) {
            this.scores.add(Double.NaN);
        }
    }

    public void setScore(int i, double score) {
        this.scores.set(i, score);
    }

    public double getScore(int i) {
        return this.scores.get(i);
    }

    public DoubleMatrix2D getThresholdedData(double cutoff) {
        ArrayList<Integer> includedRows = new ArrayList<Integer>();
        for (int i = 0; i < this.data.rows(); ++i) {
            double score = this.getScore(i);
            if (!(score > cutoff)) continue;
            includedRows.add(i);
        }
        ArrayList<Integer> includedColumns = new ArrayList<Integer>();
        for (int j = 0; j < this.data.columns(); ++j) {
            includedColumns.add(j);
        }
        int[] rows = new int[includedRows.size()];
        for (int i = 0; i < includedRows.size(); ++i) {
            rows[i] = (Integer)includedRows.get(i);
        }
        int[] columns = new int[includedColumns.size()];
        for (int j = 0; j < includedColumns.size(); ++j) {
            columns[j] = (Integer)includedColumns.get(j);
        }
        return this.data.viewSelection(rows, columns).copy();
    }

    public DoubleMatrix2D getTopFractionPoints(double topFraction) {
        int i;
        ArrayList<Integer> _points = new ArrayList<Integer>();
        final HashMap<Integer, Double> _values = new HashMap<Integer, Double>();
        ArrayList<Integer> includedColumns = new ArrayList<Integer>();
        for (int j = 0; j < this.data.columns(); ++j) {
            includedColumns.add(j);
        }
        for (int i2 = 0; i2 < this.data.rows(); ++i2) {
            DenseDoubleMatrix1D vector = new DenseDoubleMatrix1D(includedColumns.size());
            for (int j = 0; j < includedColumns.size(); ++j) {
                vector.set(j, ((Integer)includedColumns.get(j)).intValue());
            }
            _points.add(i2);
            _values.put(i2, this.getScore(i2));
        }
        Collections.sort(_points, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                double v2;
                double v1 = (Double)_values.get(o1);
                return v1 < (v2 = ((Double)_values.get(o2)).doubleValue()) ? -1 : (v1 == v2 ? 0 : 1);
            }
        });
        ArrayList points = new ArrayList();
        for (int i3 = (int)((1.0 - topFraction) * (double)_points.size()); i3 < _points.size(); ++i3) {
            points.add(_points.get(i3));
        }
        try {
            PrintWriter out = new PrintWriter(new File("/home/jdramsey/singlecolumn.txt"));
            for (i = 0; i < _points.size(); ++i) {
                out.println(_values.get(_points.get(i)));
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        DenseDoubleMatrix2D thresholdedData = new DenseDoubleMatrix2D(points.size(), this.data.columns());
        for (i = 0; i < points.size(); ++i) {
            thresholdedData.viewRow(i).assign(this.data.viewRow((Integer)points.get(i)));
        }
        return thresholdedData;
    }
}

