/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataBox;
import edu.cmu.tetrad.data.ShortDataBox;

public class ColtDataBox
implements DataBox {
    static final long serialVersionUID = 23L;
    private DoubleMatrix2D data;

    public ColtDataBox(int rows, int cols) {
        this.data = new DenseDoubleMatrix2D(rows, cols);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.data.set(i, j, Double.NaN);
            }
        }
    }

    public static BoxDataSet serializableInstance() {
        return new BoxDataSet(new ShortDataBox(4, 4), null);
    }

    public ColtDataBox(DoubleMatrix2D data) {
        this.data = data;
    }

    @Override
    public int numRows() {
        return this.data.rows();
    }

    @Override
    public int numCols() {
        return this.data.columns();
    }

    @Override
    public void set(int row, int col, Number value) {
        if (value == null) {
            this.data.set(row, col, Double.NaN);
        } else {
            this.data.set(row, col, value.doubleValue());
        }
    }

    @Override
    public Number get(int row, int col) {
        double datum = this.data.get(row, col);
        if (Double.isNaN(datum)) {
            return null;
        }
        return datum;
    }

    @Override
    public DataBox copy() {
        ColtDataBox box = new ColtDataBox(this.numRows(), this.numCols());
        for (int i = 0; i < this.numRows(); ++i) {
            for (int j = 0; j < this.numCols(); ++j) {
                box.set(i, j, this.get(i, j));
            }
        }
        return box;
    }

    @Override
    public DataBox like(int rows, int cols) {
        return new ColtDataBox(rows, cols);
    }
}

