/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DelimiterType;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.Lineizer;
import edu.cmu.tetrad.data.RegexTokenizer;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public final class DataReader {
    private DelimiterType delimiterType = DelimiterType.WHITESPACE;
    private boolean varNamesSupplied = true;
    private boolean idsSupplied = false;
    private String idLabel = null;
    private String commentMarker = "//";
    private char quoteChar = (char)34;
    private String missingValueMarker = "*";
    private int maxIntegralDiscrete = 0;
    private List<Node> knownVariables = new LinkedList<Node>();
    private TetradLogger logger = TetradLogger.getInstance();
    private boolean logEmptyTokens = false;
    private boolean readVariablesLowercase = false;
    private boolean readVariablesUppercase = false;

    public void setLogEmptyTokens(boolean log) {
        this.logEmptyTokens = log;
    }

    public void setCommentMarker(String commentMarker) {
        if (commentMarker == null) {
            throw new NullPointerException("Cannot be null.");
        }
        this.commentMarker = commentMarker;
    }

    public void setDelimiter(DelimiterType delimiterType) {
        if (delimiterType == null) {
            throw new NullPointerException("Cannot be null.");
        }
        this.delimiterType = delimiterType;
    }

    public void setQuoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
    }

    public void setVariablesSupplied(boolean varNamesSupplied) {
        this.varNamesSupplied = varNamesSupplied;
    }

    public void setIdsSupplied(boolean caseIdsPresent) {
        this.idsSupplied = caseIdsPresent;
    }

    public void setIdLabel(String caseIdsLabel) {
        this.idLabel = caseIdsLabel;
    }

    public void setMissingValueMarker(String missingValueMarker) {
        if (missingValueMarker == null) {
            throw new NullPointerException("Cannot be null.");
        }
        this.missingValueMarker = missingValueMarker;
    }

    public void setMaxIntegralDiscrete(int maxIntegralDiscrete) {
        if (maxIntegralDiscrete < -1) {
            throw new IllegalArgumentException("Must be >= -1: " + maxIntegralDiscrete);
        }
        this.maxIntegralDiscrete = maxIntegralDiscrete;
    }

    public void setKnownVariables(List<Node> knownVariables) {
        if (knownVariables == null) {
            throw new NullPointerException();
        }
        this.knownVariables = knownVariables;
    }

    public DataSet parseTabular(File file) throws IOException {
        FileReader reader = null;
        InputStreamReader reader2 = null;
        try {
            reader = new FileReader(file);
            DataSetDescription description = this.doFirstTabularPass(reader);
            reader.close();
            reader2 = new FileReader(file);
            DataSet dataSet = this.doSecondTabularPass(description, reader2);
            dataSet.setName(file.getName());
            this.logger.log("info", "\nData set loaded!");
            this.logger.reset();
            return dataSet;
        }
        catch (IOException e) {
            if (reader != null) {
                reader.close();
            }
            throw e;
        }
        catch (Exception e) {
            if (reader != null) {
                reader.close();
            }
            if (reader2 != null) {
                reader2.close();
            }
            throw new RuntimeException("Parsing failed.", e);
        }
    }

    public DataSet parseTabular(char[] chars) {
        CharArrayReader reader = new CharArrayReader(chars);
        DataSetDescription description = this.doFirstTabularPass(reader);
        reader.close();
        CharArrayReader reader2 = new CharArrayReader(chars);
        DataSet dataSet = this.doSecondTabularPass(description, reader2);
        this.logger.log("info", "\nData set loaded!");
        this.logger.reset();
        return dataSet;
    }

    private DataSetDescription doFirstTabularPass(Reader reader) {
        RegexTokenizer tokenizer;
        ArrayList<String> varNames;
        Lineizer lineizer = new Lineizer(reader, this.commentMarker);
        if (!lineizer.hasMoreLines()) {
            throw new IllegalArgumentException("Data source is empty.");
        }
        this.logger.log("info", "\nDATA LOADING PARAMETERS:");
        this.logger.log("info", "File type = TABULAR");
        this.logger.log("info", "Comment marker = " + this.commentMarker);
        this.logger.log("info", "Delimiter chars = " + this.delimiterType);
        this.logger.log("info", "Quote char = " + this.quoteChar);
        this.logger.log("info", "Var names first row = " + this.varNamesSupplied);
        this.logger.log("info", "IDs supplied = " + this.idsSupplied);
        this.logger.log("info", "ID label = " + this.idLabel);
        this.logger.log("info", "Missing value marker = " + this.missingValueMarker);
        this.logger.log("info", "Max discrete = " + this.maxIntegralDiscrete);
        this.logger.log("info", "--------------------");
        Pattern delimiter = this.delimiterType.getPattern();
        String line = lineizer.nextLine();
        if (line.subSequence(line.length() - 1, line.length()).equals("\t")) {
            line = line.substring(0, line.length() - 1);
        }
        boolean variableSectionIncluded = false;
        if (line.startsWith("/variables")) {
            variableSectionIncluded = true;
            block0: while (lineizer.hasMoreLines() && !(line = lineizer.nextLine()).startsWith("/data")) {
                RegexTokenizer tokenizer2 = new RegexTokenizer(line, DelimiterType.COLON.getPattern(), this.quoteChar);
                String name = tokenizer2.nextToken().trim();
                if ("".equals(name)) {
                    throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Expected a variable name, got an empty token.");
                }
                for (Node node : this.knownVariables) {
                    if (!name.equals(node.getName())) continue;
                    continue block0;
                }
                String values = tokenizer2.nextToken();
                if ("".equals(values.trim())) {
                    throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Empty variable specification for variable " + name + ".");
                }
                if ("Continuous".equalsIgnoreCase(values.trim())) {
                    ContinuousVariable variable = new ContinuousVariable(name);
                    this.knownVariables.add(variable);
                    continue;
                }
                LinkedList<String> categories = new LinkedList<String>();
                tokenizer2 = new RegexTokenizer(values, this.delimiterType.getPattern(), this.quoteChar);
                while (tokenizer2.hasMoreTokens()) {
                    String token = tokenizer2.nextToken().trim();
                    if ("".equals(token)) {
                        throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Expected a category name, got an empty token, " + "for variable " + name + ".");
                    }
                    if (categories.contains(token)) {
                        throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Duplicate category (" + token + ") for variable " + name + ".");
                    }
                    categories.add(token);
                }
                DiscreteVariable variable = new DiscreteVariable(name, categories);
                variable.setAccommodateNewCategories(false);
                this.knownVariables.add(variable);
            }
        }
        if (variableSectionIncluded && !line.startsWith("/data")) {
            throw new IllegalArgumentException("If a /variables section is included, a /data section must follow.");
        }
        String dataFirstLine = line;
        if (line.startsWith("/data")) {
            dataFirstLine = lineizer.nextLine();
        }
        if (this.varNamesSupplied) {
            varNames = new ArrayList();
            tokenizer = new RegexTokenizer(dataFirstLine, delimiter, this.quoteChar);
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken().trim();
                if ("".equals(name)) {
                    throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Expected variable name, got empty token: " + line);
                }
                if (varNames.contains(name)) {
                    throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Duplicate variable name (" + name + ").");
                }
                if (this.readVariablesLowercase) {
                    varNames.add(name.toLowerCase());
                    continue;
                }
                if (this.readVariablesUppercase) {
                    varNames.add(name.toUpperCase());
                    continue;
                }
                varNames.add(name);
            }
            dataFirstLine = null;
        } else {
            varNames = new LinkedList();
            tokenizer = new RegexTokenizer(dataFirstLine, delimiter, this.quoteChar);
            if (this.idsSupplied && this.idLabel == null && tokenizer.hasMoreTokens()) {
                tokenizer.nextToken();
            }
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                tokenizer.nextToken();
                varNames.add("X" + ++i);
            }
        }
        int idIndex = this.adjustForId(varNames, lineizer);
        DataSetDescription description = this.scanForDescription(varNames, lineizer, delimiter, dataFirstLine, idIndex, variableSectionIncluded);
        return description;
    }

    private DataSet doSecondTabularPass(DataSetDescription description, Reader reader2) {
        Knowledge knowledge;
        String line2;
        Lineizer lineizer = new Lineizer(reader2, this.commentMarker);
        if (description.isVariablesSectionIncluded()) {
            while (lineizer.hasMoreLines() && !(line2 = lineizer.nextLine()).startsWith("/data")) {
            }
        }
        if ((line2 = lineizer.nextLine()).startsWith("/data")) {
            line2 = lineizer.nextLine();
        }
        String dataFirstLine = line2;
        if (this.varNamesSupplied) {
            dataFirstLine = line2 = lineizer.nextLine();
        }
        ColtDataSet dataSet = new ColtDataSet(description.getNumRows(), description.getVariables());
        int row = -1;
        while (lineizer.hasMoreLines()) {
            if (dataFirstLine == null) {
                line2 = lineizer.nextLine();
            } else {
                line2 = dataFirstLine;
                dataFirstLine = null;
            }
            if (line2.startsWith("/knowledge")) break;
            ++row;
            RegexTokenizer tokenizer1 = new RegexTokenizer(line2, description.getDelimiter(), this.quoteChar);
            if (description.isMultColumnIncluded() && tokenizer1.hasMoreTokens()) {
                String token = tokenizer1.nextToken().trim();
                int multiplier = Integer.parseInt(token);
                dataSet.setMultiplier(row, multiplier);
            }
            int col = -1;
            while (tokenizer1.hasMoreTokens()) {
                String token = tokenizer1.nextToken().trim();
                this.setValue(dataSet, row, ++col, token);
            }
        }
        if (description.getIdIndex() != -1) {
            DiscreteVariable idVar = (DiscreteVariable)dataSet.getVariable(description.getIdIndex());
            for (int i = 0; i < dataSet.getNumRows(); ++i) {
                int index = dataSet.getInt(i, description.getIdIndex());
                if (index == -99) continue;
                String id = idVar.getCategories().get(index);
                dataSet.setCaseId(i, id);
            }
            dataSet.removeColumn(idVar);
        }
        if ((knowledge = this.parseKnowledge(lineizer, this.delimiterType.getPattern())) != null) {
            dataSet.setKnowledge(knowledge);
        }
        return dataSet;
    }

    public CovarianceMatrix parseCovariance(File file) throws IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            CovarianceMatrix covarianceMatrix = this.doCovariancePass(reader);
            this.logger.log("info", "\nCovariance matrix loaded!");
            this.logger.reset();
            return covarianceMatrix;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            if (reader != null) {
                reader.close();
            }
            throw new RuntimeException("Parsing failed.", e);
        }
    }

    public CovarianceMatrix parseCovariance(char[] chars) {
        CharArrayReader reader = new CharArrayReader(chars);
        DataSetDescription description = this.doFirstTabularPass(reader);
        reader.close();
        CharArrayReader reader2 = new CharArrayReader(chars);
        CovarianceMatrix covarianceMatrix = this.doCovariancePass(reader2);
        this.logger.log("info", "\nData set loaded!");
        this.logger.reset();
        return covarianceMatrix;
    }

    public CovarianceMatrix doCovariancePass(Reader reader) {
        int n;
        this.logger.log("info", "\nDATA LOADING PARAMETERS:");
        this.logger.log("info", "File type = COVARIANCE");
        this.logger.log("info", "Comment marker = " + this.commentMarker);
        this.logger.log("info", "Delimiter type = " + this.delimiterType);
        this.logger.log("info", "Quote char = " + this.quoteChar);
        this.logger.log("info", "Missing value marker = " + this.missingValueMarker);
        this.logger.log("info", "--------------------");
        Lineizer lineizer = new Lineizer(reader, this.commentMarker);
        String line = lineizer.nextLine();
        if ("/Covariance".equalsIgnoreCase(line.trim())) {
            line = lineizer.nextLine();
        }
        RegexTokenizer st = new RegexTokenizer(line, this.delimiterType.getPattern(), this.quoteChar);
        String token = st.nextToken();
        System.out.println("zzz  " + line);
        try {
            n = Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected a sample size here, got \"" + token + "\".");
        }
        if (st.hasMoreTokens() && !"".equals(st.nextToken())) {
            throw new IllegalArgumentException("Line from file has more tokens than expected: \"" + st.nextToken() + "\"");
        }
        line = lineizer.nextLine();
        if (line.subSequence(line.length() - 1, line.length()).equals("\t")) {
            line = line.substring(0, line.length() - 1);
        }
        st = new RegexTokenizer(line, this.delimiterType.getPattern(), this.quoteChar);
        ArrayList<String> vars = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String _token = st.nextToken();
            if ("".equals(_token)) {
                TetradLogger.getInstance().log("emptyToken", "Parsed an empty token for a variable name--ignoring.");
                continue;
            }
            vars.add(_token);
        }
        String[] varNames = vars.toArray(new String[vars.size()]);
        this.logger.log("info", "Variables:");
        for (String varName : varNames) {
            this.logger.log("info", varName + " --> Continuous");
        }
        DenseDoubleMatrix2D c = new DenseDoubleMatrix2D(vars.size(), vars.size());
        for (int i = 0; i < vars.size(); ++i) {
            st = new RegexTokenizer(lineizer.nextLine(), this.delimiterType.getPattern(), this.quoteChar);
            for (int j = 0; j <= i; ++j) {
                if (!st.hasMoreTokens()) {
                    throw new IllegalArgumentException("Expecting " + (i + 1) + " numbers on line " + (i + 1) + " of the covariance " + "matrix input.");
                }
                String literal = st.nextToken();
                if ("".equals(literal)) {
                    TetradLogger.getInstance().log("emptyToken", "Parsed an empty token for a covariance value--ignoring.");
                    continue;
                }
                double r = Double.parseDouble(literal);
                c.set(i, j, r);
                c.set(j, i, r);
            }
        }
        Knowledge knowledge = this.parseKnowledge(lineizer, this.delimiterType.getPattern());
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(DataUtils.createContinuousVariables(varNames), c, n);
        if (knowledge != null) {
            covarianceMatrix.setKnowledge(knowledge);
        }
        this.logger.log("info", "\nData set loaded!");
        this.logger.reset();
        return covarianceMatrix;
    }

    public Knowledge parseKnowledge(File file) throws IOException {
        return this.parseKnowledge(DataReader.loadChars(file));
    }

    public Knowledge parseKnowledge(char[] chars) {
        CharArrayReader reader = new CharArrayReader(chars);
        Lineizer lineizer = new Lineizer(reader, this.commentMarker);
        Knowledge knowledge = this.parseKnowledge(lineizer, this.delimiterType.getPattern());
        this.logger.reset();
        return knowledge;
    }

    private int adjustForId(List<String> varNames, Lineizer lineizer) {
        int idIndex = -1;
        if (this.idsSupplied) {
            if (this.idLabel == null) {
                idIndex = 0;
                varNames.add(0, "");
            } else {
                idIndex = varNames.indexOf(this.idLabel);
                if (idIndex == -1) {
                    throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": The given ID column label (" + this.idLabel + ") was not among " + "the list of variables.");
                }
            }
        }
        return idIndex;
    }

    private void setValue(DataSet dataSet, int row, int col, String s) {
        if (s == null || s.equals("") || s.trim().equals(this.missingValueMarker)) {
            return;
        }
        if (col >= dataSet.getNumColumns()) {
            return;
        }
        Node node = dataSet.getVariable(col);
        if (node instanceof ContinuousVariable) {
            try {
                double value = Double.parseDouble(s);
                dataSet.setDouble(row, col, value);
            }
            catch (NumberFormatException e) {
                dataSet.setDouble(row, col, Double.NaN);
            }
        } else if (node instanceof DiscreteVariable) {
            DiscreteVariable var = (DiscreteVariable)node;
            int value = var.getCategories().indexOf(s.trim());
            if (value == -1) {
                dataSet.setInt(row, col, -99);
            } else {
                dataSet.setInt(row, col, value);
            }
        }
    }

    private Knowledge parseKnowledge(Lineizer lineizer, Pattern delimiter) {
        String line;
        Knowledge knowledge = new Knowledge();
        if (!lineizer.hasMoreLines()) {
            return null;
        }
        String firstLine = line = lineizer.nextLine();
        if (line.startsWith("/knowledge")) {
            firstLine = line = lineizer.nextLine();
        }
        this.logger.log("info", "\nLoading knowledge.");
        block0: while (lineizer.hasMoreLines()) {
            String to;
            String from;
            line = firstLine == null ? lineizer.nextLine() : firstLine;
            if ("addtemporal".equalsIgnoreCase(line.trim())) {
                while (lineizer.hasMoreLines()) {
                    line = lineizer.nextLine();
                    if (line.startsWith("forbiddirect")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("requiredirect")) {
                        firstLine = line;
                        continue block0;
                    }
                    int tier = -1;
                    RegexTokenizer st = new RegexTokenizer(line, delimiter, this.quoteChar);
                    if (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        boolean forbiddenWithin = false;
                        if (token.endsWith("*")) {
                            forbiddenWithin = true;
                            token = token.substring(0, token.length() - 1);
                        }
                        if ((tier = Integer.parseInt(token)) < 1) {
                            throw new IllegalArgumentException(lineizer.getLineNumber() + ": Tiers must be 1, 2...");
                        }
                        if (forbiddenWithin) {
                            knowledge.setTierForbiddenWithin(tier - 1, true);
                        }
                    }
                    while (st.hasMoreTokens()) {
                        String name = DataReader.substitutePeriodsForSpaces(st.nextToken());
                        knowledge.addToTier(tier - 1, name);
                        this.logger.log("info", "Adding to tier " + (tier - 1) + " " + name);
                    }
                }
                continue;
            }
            if ("forbiddirect".equalsIgnoreCase(line.trim())) {
                while (lineizer.hasMoreLines()) {
                    line = lineizer.nextLine();
                    if (line.startsWith("addtemporal")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("requiredirect")) {
                        firstLine = line;
                        continue block0;
                    }
                    RegexTokenizer st = new RegexTokenizer(line, delimiter, this.quoteChar);
                    from = null;
                    to = null;
                    if (st.hasMoreTokens()) {
                        from = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        to = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Lines contains more than two elements.");
                    }
                    if (from == null || to == null) {
                        throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Line contains fewer than two elements.");
                    }
                    knowledge.setEdgeForbidden(from, to, true);
                }
                continue;
            }
            if ("requiredirect".equalsIgnoreCase(line.trim())) {
                while (lineizer.hasMoreLines()) {
                    line = lineizer.nextLine();
                    if (line.startsWith("forbiddirect")) {
                        firstLine = line;
                        continue block0;
                    }
                    if (line.startsWith("addtemporal")) {
                        firstLine = line;
                        continue block0;
                    }
                    RegexTokenizer st = new RegexTokenizer(line, delimiter, this.quoteChar);
                    from = null;
                    to = null;
                    if (st.hasMoreTokens()) {
                        from = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        to = st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Lines contains more than two elements.");
                    }
                    if (from == null || to == null) {
                        throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Line contains fewer than two elements.");
                    }
                    knowledge.setEdgeRequired(from, to, true);
                }
                continue;
            }
            throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": Expecting 'addtemporal', 'forbiddirect' or 'requiredirect'.");
        }
        return knowledge;
    }

    private static String substitutePeriodsForSpaces(String s) {
        return s.replaceAll(" ", ".");
    }

    public void setReadVariablesLowercase(boolean readVariablesLowercase) {
        this.readVariablesLowercase = true;
    }

    public void setReadVariablesUppercase(boolean readVariablesUppercase) {
        this.readVariablesLowercase = true;
    }

    private DataSetDescription scanForDescription(List<String> varNames, Lineizer lineizer, Pattern delimiter, String firstLine, int idIndex, boolean variableSectionIncluded) {
        ArrayList dataStrings = new ArrayList();
        for (int i = 0; i < varNames.size(); ++i) {
            dataStrings.add(new HashSet(varNames.size()));
        }
        int row = -1;
        while (lineizer.hasMoreLines()) {
            String line;
            if (firstLine == null) {
                line = lineizer.nextLine();
            } else {
                line = firstLine;
                firstLine = null;
            }
            if (line.startsWith("/knowledge")) break;
            ++row;
            RegexTokenizer tokenizer = new RegexTokenizer(line, delimiter, this.quoteChar);
            int col = -1;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (++col >= dataStrings.size() || "".equals(token) || this.missingValueMarker.equals(token)) continue;
                ((Set)dataStrings.get(col)).add(token);
            }
            if (col < varNames.size() - 1) {
                this.logger.log("info", "Line " + lineizer.getLineNumber() + ": Too few tokens; expected " + varNames.size() + " tokens but got " + (col + 1) + " tokens.");
            }
            if (col <= varNames.size() - 1) continue;
            this.logger.log("info", "Line " + lineizer.getLineNumber() + ": Too many tokens; expected " + varNames.size() + " tokens but got " + (col + 1) + " tokens.");
        }
        this.logger.log("info", "\nNumber of data rows = " + (row + 1));
        int numRows = row + 1;
        ArrayList<Node> variables = new ArrayList<Node>();
        block3: for (int i = 0; i < varNames.size(); ++i) {
            Set strings = (Set)dataStrings.get(i);
            for (Node variable : this.knownVariables) {
                if (!variable.getName().equals(varNames.get(i))) continue;
                variables.add(variable);
                continue block3;
            }
            if (DataReader.isDouble(strings) && !DataReader.isIntegral(strings) && i != idIndex) {
                variables.add(new ContinuousVariable(varNames.get(i)));
                continue;
            }
            if (DataReader.isIntegral(strings) && this.tooManyDiscreteValues(strings) && i != idIndex) {
                String name = varNames.get(i);
                if (name.contains(" ")) {
                    name = name.replaceAll(" ", "_");
                    varNames.set(i, name);
                }
                if (!NamingProtocol.isLegalName(name)) {
                    throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": This cannot be used as a variable name: " + name + ".");
                }
                variables.add(new ContinuousVariable(name));
                continue;
            }
            LinkedList<String> categories = new LinkedList<String>(strings);
            categories.remove(null);
            categories.remove("");
            categories.remove(this.missingValueMarker);
            Collections.sort(categories, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            String name = varNames.get(i);
            if (name.contains(" ")) {
                name = name.replaceAll(" ", "_");
                varNames.set(i, name);
            }
            if (!NamingProtocol.isLegalName(name)) {
                throw new IllegalArgumentException("Line " + lineizer.getLineNumber() + ": This cannot be used as a variable name: " + name + ".");
            }
            variables.add(new DiscreteVariable(name, categories));
        }
        boolean multColumnIncluded = false;
        if (((Node)variables.get(0)).getName().equals("MULT")) {
            multColumnIncluded = true;
            variables.remove(0);
            varNames.remove(0);
        }
        for (int i = 0; i < varNames.size(); ++i) {
            if (i == idIndex) continue;
            Node node = (Node)variables.get(i);
            if (node instanceof ContinuousVariable) {
                this.logger.log("info", node + " --> Continuous");
                continue;
            }
            if (!(node instanceof DiscreteVariable)) continue;
            StringBuilder buf = new StringBuilder();
            buf.append(node).append(" --> <");
            List<String> categories = ((DiscreteVariable)node).getCategories();
            for (int j = 0; j < categories.size(); ++j) {
                buf.append(categories.get(j));
                if (j >= categories.size() - 1) continue;
                buf.append(", ");
            }
            buf.append(">");
            this.logger.log("info", buf.toString());
        }
        return new DataSetDescription(variables, numRows, idIndex, variableSectionIncluded, delimiter, multColumnIncluded);
    }

    private boolean tooManyDiscreteValues(Set<String> strings) {
        return strings.size() > this.maxIntegralDiscrete;
    }

    private static boolean isIntegral(Set<String> strings) {
        for (String s : strings) {
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private static boolean isDouble(Set<String> strings) {
        for (String s : strings) {
            try {
                Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private static char[] loadChars(File file) throws IOException {
        int c;
        FileReader reader = new FileReader(file);
        CharArrayWriter writer = new CharArrayWriter();
        while ((c = reader.read()) != -1) {
            writer.write(c);
        }
        return writer.toCharArray();
    }

    private static class DataSetDescription {
        private List<Node> variables;
        private int numRows;
        private int idIndex;
        private boolean variablesSectionIncluded;
        private Pattern delimiter;
        private boolean multColumnIncluded;

        public DataSetDescription(List<Node> variables, int numRows, int idIndex, boolean variablesSectionIncluded, Pattern delimiter, boolean multColumnIncluded) {
            this.variables = variables;
            this.numRows = numRows;
            this.idIndex = idIndex;
            this.variablesSectionIncluded = variablesSectionIncluded;
            this.delimiter = delimiter;
            this.multColumnIncluded = multColumnIncluded;
        }

        public List<Node> getVariables() {
            return this.variables;
        }

        public int getNumRows() {
            return this.numRows;
        }

        public int getIdIndex() {
            return this.idIndex;
        }

        public boolean isVariablesSectionIncluded() {
            return this.variablesSectionIncluded;
        }

        public Pattern getDelimiter() {
            return this.delimiter;
        }

        public boolean isMultColumnIncluded() {
            return this.multColumnIncluded;
        }
    }
}

