/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;

public final class DataWriter {
    public static void writeRectangularData(DataSet dataSet, Writer out, char separator) throws IOException {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        StringBuilder buf = new StringBuilder();
        boolean isCaseMultipliersCollapsed = dataSet.isMulipliersCollapsed();
        if (isCaseMultipliersCollapsed) {
            buf.append("MULT").append(separator);
        }
        for (int col = 0; col < dataSet.getNumColumns(); ++col) {
            String name = dataSet.getVariable(col).getName();
            if (name.trim().equals("")) {
                name = "C" + (col - 1);
            }
            buf.append(name);
            if (col >= dataSet.getNumColumns() - 1) continue;
            buf.append(separator);
        }
        for (int row = 0; row < dataSet.getNumRows(); ++row) {
            buf.append("\n");
            if (isCaseMultipliersCollapsed) {
                int multiplier = dataSet.getMultiplier(row);
                buf.append(multiplier).append(separator);
            }
            for (int col = 0; col < dataSet.getNumColumns(); ++col) {
                Node variable = dataSet.getVariable(col);
                if (variable instanceof ContinuousVariable) {
                    double value = dataSet.getDouble(row, col);
                    if (ContinuousVariable.isDoubleMissingValue(value)) {
                        buf.append("*");
                    } else {
                        buf.append(nf.format(value));
                    }
                    if (col >= dataSet.getNumColumns() - 1) continue;
                    buf.append(separator);
                    continue;
                }
                if (!(variable instanceof DiscreteVariable)) continue;
                Object obj = dataSet.getObject(row, col);
                String val = obj == null ? "" : obj.toString();
                buf.append(val);
                if (col >= dataSet.getNumColumns() - 1) continue;
                buf.append(separator);
            }
        }
        buf.append("\n");
        out.write(buf.toString());
    }

    public static void writeCovMatrix(CovarianceMatrix covMatrix, PrintWriter out, NumberFormat nf) {
        int numVars = covMatrix.getVariableNames().size();
        out.println(covMatrix.getSampleSize());
        for (int i = 0; i < numVars; ++i) {
            String name = covMatrix.getVariableNames().get(i);
            out.print(name + "\t");
        }
        out.println();
        for (int j = 0; j < numVars; ++j) {
            for (int i = 0; i <= j; ++i) {
                out.print(nf.format(covMatrix.getValue(i, j)) + "\t");
            }
            out.println();
        }
    }
}

