/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.data.KnowledgeGroup;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Knowledge
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private SortedSet<String> variables = new TreeSet<String>();
    private Map<String, Integer> tierMap;
    private Set<KnowledgeEdge> requiredEdges;
    private Set<KnowledgeEdge> allRequiredEdges = new HashSet<KnowledgeEdge>();
    private Set<KnowledgeEdge> forbiddenEdges;
    private Set<KnowledgeEdge> explicitlyForbiddenEdges;
    private Set<KnowledgeEdge> requiredCommonCauses;
    private Set<KnowledgeEdge> forbiddenCommonCauses;
    private Set<Integer> tiersForbiddenWithin = new HashSet<Integer>();
    private List<KnowledgeGroup> knowledgeGroups = new ArrayList<KnowledgeGroup>();
    private boolean defaultToKnowledgeLayout = false;

    public Knowledge() {
        this.clearExplicitKnowledge();
        this.clearTiers();
    }

    public Knowledge(Knowledge knowledge) {
        this.tierMap = new HashMap<String, Integer>(knowledge.tierMap);
        this.allRequiredEdges = new HashSet<KnowledgeEdge>(knowledge.allRequiredEdges);
        this.requiredEdges = new HashSet<KnowledgeEdge>(knowledge.requiredEdges);
        this.forbiddenEdges = new HashSet<KnowledgeEdge>(knowledge.forbiddenEdges);
        this.explicitlyForbiddenEdges = new HashSet<KnowledgeEdge>(knowledge.explicitlyForbiddenEdges);
        this.requiredCommonCauses = new HashSet<KnowledgeEdge>(knowledge.requiredCommonCauses);
        this.forbiddenCommonCauses = new HashSet<KnowledgeEdge>(knowledge.forbiddenCommonCauses);
        this.tiersForbiddenWithin = new HashSet<Integer>(knowledge.tiersForbiddenWithin);
        this.defaultToKnowledgeLayout = knowledge.defaultToKnowledgeLayout;
        this.knowledgeGroups = knowledge.knowledgeGroups;
    }

    public static Knowledge serializableInstance() {
        return new Knowledge();
    }

    public final void addToTier(int tier, String var) {
        if (!this.variables.contains(var)) {
            this.addVariable(var);
        }
        if (tier < 0) {
            throw new IllegalArgumentException();
        }
        if (var == null) {
            throw new NullPointerException();
        }
        for (String var2 : this.tierMap.keySet()) {
            int tier2 = this.tierMap.get(var2);
            if (tier2 < tier) {
                if (!this.edgeRequired(var, var2)) continue;
                throw new IllegalStateException("Edge " + var + "-->" + var2 + " is a required edge. Please remove that requirement " + "or adjust \nthe tiers so that " + var + "-->" + var2 + " will not be forbidden.");
            }
            if (tier >= tier2 || !this.edgeRequired(var2, var)) continue;
            throw new IllegalStateException("Edge " + var2 + "-->" + var + " is a required edge. Please remove that requirement " + "or adjust \nthe tiers so that " + var2 + "-->" + var + " will not be forbidden.");
        }
        this.tierMap.put(var, tier);
        this.generateForbiddenEdgeList();
    }

    public final void addToTiersByVarNames(List<String> varNames) {
        if (!this.variables.containsAll(varNames)) {
            for (String varName : varNames) {
                this.addVariable(varName);
            }
        }
        for (String varName : varNames) {
            String node = varName;
            int index = node.lastIndexOf(":t");
            if (index == -1) continue;
            String substring = node.substring(index + 2);
            this.addToTier(new Integer(substring), node);
        }
    }

    public List<KnowledgeGroup> getKnowledgeGroups() {
        return Collections.unmodifiableList(this.knowledgeGroups);
    }

    public void removeKnowledgeGroup(int index) {
        this.knowledgeGroups.remove(index);
        this.generateRequiredEdgeSet();
        this.generateForbiddenEdgeList();
    }

    public void addKnowledgeGroup(KnowledgeGroup group) {
        for (int i = 0; i < this.knowledgeGroups.size(); ++i) {
            KnowledgeGroup g = this.knowledgeGroups.get(i);
            if (!group.isConflict(g)) continue;
            throw new IllegalArgumentException("Conflict with group at index " + (i + 1));
        }
        List<KnowledgeEdge> edges = group.getEdges();
        if (group.getType() == 1) {
            for (KnowledgeEdge edge : edges) {
                this.checkAgainstForbidden(edge);
            }
        } else if (group.getType() == 2) {
            for (KnowledgeEdge edge : edges) {
                this.checkAgainstRequired(edge);
            }
        }
        this.knowledgeGroups.add(group);
        if (!group.isEmpty()) {
            this.generateRequiredEdgeSet();
            this.generateForbiddenEdgeList();
        }
    }

    public void setKnowledgeGroup(int index, KnowledgeGroup group) {
        for (int i = 0; i < this.knowledgeGroups.size(); ++i) {
            KnowledgeGroup g;
            if (i == index || !group.isConflict(g = this.knowledgeGroups.get(i))) continue;
            throw new IllegalArgumentException("Changes to the knowedge group at " + (index + 1) + " conflict with the knowledge group at " + (i + 1));
        }
        List<KnowledgeEdge> edges = group.getEdges();
        if (group.getType() == 1) {
            for (KnowledgeEdge edge : edges) {
                this.checkAgainstForbidden(edge);
            }
        } else if (group.getType() == 2) {
            for (KnowledgeEdge edge : edges) {
                this.checkAgainstRequired(edge);
            }
        }
        this.knowledgeGroups.set(index, group);
        this.generateRequiredEdgeSet();
        this.generateForbiddenEdgeList();
    }

    private void clearTiers() {
        this.tierMap = new HashMap<String, Integer>();
    }

    public final Iterator<KnowledgeEdge> forbiddenCommonCausesIterator() {
        return Collections.unmodifiableSet(this.forbiddenCommonCauses).iterator();
    }

    public final Iterator<KnowledgeEdge> forbiddenEdgesIterator() {
        return Collections.unmodifiableSet(this.forbiddenEdges).iterator();
    }

    public final Iterator<KnowledgeEdge> explicitlyForbiddenEdgesIterator() {
        return Collections.unmodifiableSet(this.explicitlyForbiddenEdges).iterator();
    }

    public final List<String> getVarsNotInTier() {
        ArrayList<String> notInTier = new ArrayList<String>(this.variables);
        for (int i = 0; i < this.getNumTiers(); ++i) {
            List<String> tier = this.getTier(i);
            notInTier.removeAll(tier);
        }
        return notInTier;
    }

    public final List<String> getTier(int tier) {
        LinkedList<String> _tier = new LinkedList<String>();
        for (String o : this.tierMap.keySet()) {
            Integer v = this.tierMap.get(o);
            if (!v.equals(tier) || _tier.contains(o)) continue;
            _tier.add(o);
        }
        Collections.sort(_tier);
        return _tier;
    }

    public final int getNumTiers() {
        ArrayList<Integer> s = new ArrayList<Integer>(this.tierMap.values());
        int max = -1;
        for (Integer value : s) {
            if (value <= max) continue;
            max = value;
        }
        return max + 1;
    }

    public final int isInWhichTier(Node node) {
        int ntiers = this.getNumTiers();
        for (int i = 0; i < ntiers; ++i) {
            List<String> tier = this.getTier(i);
            if (!tier.contains(node.getName())) continue;
            return i;
        }
        return -1;
    }

    public final boolean commonCauseForbidden(String var1, String var2) {
        return this.forbiddenCommonCauses.contains(new KnowledgeEdge(var1, var2));
    }

    public final boolean edgeExplicitlyRequired(String var1, String var2) {
        return this.requiredEdges.contains(new KnowledgeEdge(var1, var2));
    }

    public final boolean edgeExplicitlyRequired(KnowledgeEdge edge) {
        return this.requiredEdges.contains(edge);
    }

    public final boolean edgeForbidden(String var1, String var2) {
        KnowledgeEdge edge = new KnowledgeEdge(var1, var2);
        return this.forbiddenEdges.contains(edge);
    }

    public final boolean edgeRequired(String var1, String var2) {
        KnowledgeEdge edge = new KnowledgeEdge(var1, var2);
        return this.allRequiredEdges.contains(edge);
    }

    public final boolean edgeRequiredByGroups(String var1, String var2) {
        KnowledgeEdge edge = new KnowledgeEdge(var1, var2);
        for (KnowledgeGroup group : this.knowledgeGroups) {
            if (group.getType() != 1 || !group.containsEdge(edge)) continue;
            return true;
        }
        return false;
    }

    public final boolean edgeForbiddenByGroups(String var1, String var2) {
        KnowledgeEdge edge = new KnowledgeEdge(var1, var2);
        for (KnowledgeGroup group : this.knowledgeGroups) {
            if (group.getType() != 2 || !group.containsEdge(edge)) continue;
            return true;
        }
        return false;
    }

    public final boolean noEdgeRequired(String x, String y) {
        return !this.isCommonCauseRequired(x, y) && !this.edgeRequired(x, y) && !this.edgeRequired(y, x);
    }

    private boolean isCommonCauseRequired(String var1, String var2) {
        return this.requiredCommonCauses.contains(new KnowledgeEdge(var1, var2));
    }

    public final boolean isForbiddenByTiers(String var1, String var2) {
        if (var1.equals(var2)) {
            throw new IllegalArgumentException();
        }
        Integer tier1 = this.tierMap.get(var1);
        Integer tier2 = this.tierMap.get(var2);
        if (tier1 == null || tier2 == null) {
            return false;
        }
        if (tier1.equals(tier2) && this.isTierForbiddenWithin(tier1)) {
            return true;
        }
        return tier1 > tier2;
    }

    public final boolean isEmpty() {
        return this.allRequiredEdges.isEmpty() && this.forbiddenEdges.isEmpty() && this.requiredCommonCauses.isEmpty() && this.forbiddenCommonCauses.isEmpty() && this.isGroupKnowledgeEmpty();
    }

    public static void saveKnowledge(Knowledge knowledge, Writer out) throws IOException {
        String to;
        String from;
        KnowledgeEdge pair;
        StringBuilder buf = new StringBuilder();
        buf.append("/knowledge");
        buf.append("\naddtemporal");
        for (int i = 0; i < knowledge.getNumTiers(); ++i) {
            String forbiddenWithin = knowledge.isTierForbiddenWithin(i) ? "*" : "";
            buf.append("\n").append(i + 1).append(forbiddenWithin).append(" ");
            List<String> tier = knowledge.getTier(i);
            Iterator<String> i$ = tier.iterator();
            while (i$.hasNext()) {
                String aTier;
                String name = aTier = i$.next();
                buf.append(name).append(" ");
            }
        }
        buf.append("\n\nforbiddirect");
        Iterator<KnowledgeEdge> i = knowledge.forbiddenEdgesIterator();
        while (i.hasNext()) {
            pair = i.next();
            from = pair.getFrom();
            if (knowledge.isForbiddenByTiers(from, to = pair.getTo())) continue;
            buf.append("\n").append(from).append(" ").append(to);
        }
        buf.append("\n\nrequiredirect");
        i = knowledge.requiredEdgesIterator();
        while (i.hasNext()) {
            pair = i.next();
            from = pair.getFrom();
            to = pair.getTo();
            buf.append("\n").append(from).append(" ").append(to);
        }
        out.write(buf.toString());
    }

    public final Iterator<KnowledgeEdge> requiredCommonCausesIterator() {
        return Collections.unmodifiableSet(this.requiredCommonCauses).iterator();
    }

    public final Iterator<KnowledgeEdge> requiredEdgesIterator() {
        return Collections.unmodifiableSet(this.allRequiredEdges).iterator();
    }

    public final Iterator<KnowledgeEdge> explicitlyRequiredEdgesIterator() {
        return Collections.unmodifiableSet(this.requiredEdges).iterator();
    }

    public final void setEdgeForbidden(String var1, String var2, boolean forbid) {
        if (forbid) {
            if (this.edgeForbidden(var1, var2)) {
                return;
            }
            if (this.edgeRequiredByGroups(var1, var2)) {
                throw new IllegalStateException("The edge " + var1 + "-->" + var2 + " is required by a knowledge group. Please remove that requirement first.");
            }
            if (this.edgeRequired(var1, var2)) {
                throw new IllegalStateException("The edge " + var1 + "-->" + var2 + " is already required. Please first remove that requirement.");
            }
            this.explicitlyForbiddenEdges.add(new KnowledgeEdge(var1, var2));
            this.generateForbiddenEdgeList();
        } else {
            if (this.isForbiddenByTiers(var1, var2)) {
                throw new IllegalStateException("The edge " + var1 + "-->" + var2 + " is forbidden by tiers. Please adjust tiers first.");
            }
            this.explicitlyForbiddenEdges.remove(new KnowledgeEdge(var1, var2));
            this.generateForbiddenEdgeList();
        }
    }

    public final void setEdgeRequired(String var1, String var2, boolean required) {
        if (required) {
            if (this.isForbiddenByTiers(var1, var2)) {
                throw new IllegalArgumentException("The edge " + var1 + " --> " + var2 + " is forbidden by temporal tiers. Please adjust tiers first.");
            }
            if (this.edgeForbiddenByGroups(var1, var2)) {
                throw new IllegalArgumentException("The edge " + var1 + " --> " + var2 + "is forbidden by a knowledge group. Please remove this requirement first");
            }
            if (this.edgeForbidden(var1, var2)) {
                throw new IllegalArgumentException("The edge " + var1 + " --> " + var2 + " has been forbidden explicitly. Please adjust that " + "requirement first.");
            }
            KnowledgeEdge edge = new KnowledgeEdge(var1, var2);
            if (!this.requiredEdges.contains(edge)) {
                this.requiredEdges.add(edge);
                this.generateRequiredEdgeSet();
            }
        } else if (this.requiredEdges.contains(new KnowledgeEdge(var1, var2))) {
            this.requiredEdges.remove(new KnowledgeEdge(var1, var2));
            this.generateRequiredEdgeSet();
        }
    }

    public final void removeFromTiers(String var) {
        this.tierMap.remove(var);
        this.generateForbiddenEdgeList();
    }

    public final void setTierForbiddenWithin(int tier, boolean forbidden) {
        if (forbidden) {
            this.tiersForbiddenWithin.add(tier);
        } else {
            this.tiersForbiddenWithin.remove(tier);
        }
        this.generateForbiddenEdgeList();
    }

    public final boolean isTierForbiddenWithin(int tier) {
        return this.tiersForbiddenWithin.contains(tier);
    }

    public final int getMaxTierForbiddenWithin() {
        int max = -1;
        for (Integer aTiersForbiddenWithin : this.tiersForbiddenWithin) {
            if (aTiersForbiddenWithin <= max) continue;
            max = aTiersForbiddenWithin;
        }
        return max;
    }

    public final void setDefaultToKnowledgeLayout(boolean defaultToKnowledgeLayout) {
        this.defaultToKnowledgeLayout = defaultToKnowledgeLayout;
    }

    public final boolean isDefaultToKnowledgeLayout() {
        return this.defaultToKnowledgeLayout;
    }

    public final void clear() {
        this.clearExplicitKnowledge();
        this.clearTiers();
    }

    public final int hashCode() {
        int hash = 37;
        hash += 17 * ((Object)this.tierMap).hashCode() + 37;
        hash += 17 * ((Object)this.requiredEdges).hashCode() + 37;
        hash += 17 * ((Object)this.allRequiredEdges).hashCode() + 37;
        hash += 17 * ((Object)this.forbiddenEdges).hashCode() + 37;
        hash += 17 * ((Object)this.explicitlyForbiddenEdges).hashCode() + 37;
        hash += 17 * ((Object)this.requiredCommonCauses).hashCode() + 37;
        hash += 17 * ((Object)this.forbiddenCommonCauses).hashCode() + 37;
        hash += 17 * ((Object)this.tiersForbiddenWithin).hashCode() + 37;
        hash += 17 * ((Object)this.knowledgeGroups).hashCode() + 37;
        return hash += 17 * Boolean.valueOf(this.defaultToKnowledgeLayout).hashCode() + 37;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Knowledge)) {
            return false;
        }
        Knowledge knowledge = (Knowledge)o;
        if (!((Object)this.tierMap).equals(knowledge.tierMap)) {
            return false;
        }
        if (!((Object)this.allRequiredEdges).equals(knowledge.allRequiredEdges)) {
            return false;
        }
        if (!((Object)this.requiredEdges).equals(knowledge.requiredEdges)) {
            return false;
        }
        if (!((Object)this.forbiddenEdges).equals(knowledge.forbiddenEdges)) {
            return false;
        }
        if (!((Object)this.explicitlyForbiddenEdges).equals(knowledge.explicitlyForbiddenEdges)) {
            return false;
        }
        if (!((Object)this.requiredCommonCauses).equals(knowledge.requiredCommonCauses)) {
            return false;
        }
        if (!((Object)this.forbiddenCommonCauses).equals(knowledge.forbiddenCommonCauses)) {
            return false;
        }
        if (!((Object)this.tiersForbiddenWithin).equals(knowledge.tiersForbiddenWithin)) {
            return false;
        }
        if (!((Object)this.knowledgeGroups).equals(knowledge.knowledgeGroups)) {
            return false;
        }
        return this.defaultToKnowledgeLayout == knowledge.defaultToKnowledgeLayout;
    }

    public final String toString() {
        try {
            CharArrayWriter out = new CharArrayWriter();
            Knowledge.saveKnowledge(this, out);
            return out.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not render knowledge.");
        }
    }

    private boolean isGroupKnowledgeEmpty() {
        for (KnowledgeGroup group : this.knowledgeGroups) {
            if (group.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void checkAgainstRequired(KnowledgeEdge edge) {
        if (this.requiredEdges.contains(edge)) {
            throw new IllegalArgumentException("The edge " + edge.getFrom() + " --> " + edge.getTo() + " is already required. Please first remove that requirement.");
        }
    }

    private void checkAgainstForbidden(KnowledgeEdge edge) {
        if (this.isForbiddenByTiers(edge.getFrom(), edge.getTo())) {
            throw new IllegalArgumentException("The edge " + edge.getFrom() + " --> " + edge.getTo() + " is forbidden by temporal tiers. Please adjust tiers first.");
        }
        if (this.explicitlyForbiddenEdges.contains(edge)) {
            throw new IllegalArgumentException("The edge " + edge.getFrom() + " --> " + edge.getTo() + " has been forbidden explicitly. Please adjust that " + "requirement first.");
        }
    }

    private void setCommonCauseForbidden(String var1, String var2, boolean forbidden) {
        KnowledgeEdge edge1 = new KnowledgeEdge(var1, var2);
        KnowledgeEdge edge2 = new KnowledgeEdge(var2, var1);
        if (forbidden) {
            this.setCommonCauseRequired(var1, var2, false);
            this.forbiddenCommonCauses.add(edge1);
            this.forbiddenCommonCauses.add(edge2);
        } else {
            this.forbiddenCommonCauses.remove(edge1);
            this.forbiddenCommonCauses.remove(edge2);
        }
    }

    private void setCommonCauseRequired(String var1, String var2, boolean required) {
        KnowledgeEdge edge1 = new KnowledgeEdge(var1, var2);
        KnowledgeEdge edge2 = new KnowledgeEdge(var2, var1);
        if (required) {
            this.setCommonCauseForbidden(var1, var2, false);
            this.requiredCommonCauses.add(edge1);
            this.requiredCommonCauses.add(edge2);
        } else {
            this.requiredCommonCauses.remove(edge1);
            this.requiredCommonCauses.remove(edge2);
        }
    }

    private void clearExplicitKnowledge() {
        this.requiredEdges = new HashSet<KnowledgeEdge>();
        this.forbiddenEdges = new HashSet<KnowledgeEdge>();
        this.explicitlyForbiddenEdges = new HashSet<KnowledgeEdge>();
        this.requiredCommonCauses = new HashSet<KnowledgeEdge>();
        this.forbiddenCommonCauses = new HashSet<KnowledgeEdge>();
        this.knowledgeGroups = new ArrayList<KnowledgeGroup>();
        this.allRequiredEdges = new HashSet<KnowledgeEdge>();
        this.tierMap = new HashMap<String, Integer>();
    }

    private void generateRequiredEdgeSet() {
        this.allRequiredEdges.clear();
        for (KnowledgeGroup group : this.knowledgeGroups) {
            if (group.getType() != 1) continue;
            this.allRequiredEdges.addAll(group.getEdges());
        }
        this.allRequiredEdges.addAll(this.requiredEdges);
    }

    private void generateForbiddenEdgeList() {
        this.forbiddenEdges.clear();
        ArrayList<String> vars = new ArrayList<String>(this.tierMap.keySet());
        for (int i = 0; i < vars.size(); ++i) {
            for (int j = 0; j < vars.size(); ++j) {
                String var2;
                String var1;
                if (i == j || !this.isForbiddenByTiers(var1 = (String)vars.get(i), var2 = (String)vars.get(j))) continue;
                this.forbiddenEdges.add(new KnowledgeEdge(var1, var2));
            }
        }
        for (KnowledgeGroup group : this.knowledgeGroups) {
            if (group.getType() != 2) continue;
            this.forbiddenEdges.addAll(group.getEdges());
        }
        this.forbiddenEdges.addAll(this.explicitlyForbiddenEdges);
    }

    private static String readLineSkippingComments(BufferedReader in, String commentIndicator, int[] lineNo) throws IOException {
        String line;
        if (commentIndicator == null) {
            lineNo[0] = lineNo[0] + 1;
            return in.readLine();
        }
        while ((line = in.readLine()) != null) {
            lineNo[0] = lineNo[0] + 1;
            if (Knowledge.isCommentLine(line, commentIndicator)) continue;
            return line;
        }
        return null;
    }

    private static boolean isCommentLine(String line, String commentIndicator) {
        return line.startsWith(commentIndicator) || "".equals(line);
    }

    private static String substitutePeriodsForSpaces(String s) {
        return s.replaceAll(" ", ".");
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.requiredEdges == null) {
            throw new NullPointerException();
        }
        if (this.forbiddenEdges == null) {
            throw new NullPointerException();
        }
        if (this.explicitlyForbiddenEdges == null) {
            throw new NullPointerException();
        }
        if (this.requiredCommonCauses == null) {
            throw new NullPointerException();
        }
        if (this.forbiddenCommonCauses == null) {
            throw new NullPointerException();
        }
        if (this.tierMap == null) {
            throw new NullPointerException();
        }
        if (this.knowledgeGroups == null) {
            this.knowledgeGroups = new ArrayList<KnowledgeGroup>();
        }
        if (this.allRequiredEdges == null) {
            this.allRequiredEdges = new HashSet<KnowledgeEdge>();
            this.generateRequiredEdgeSet();
        }
    }

    public boolean isViolatedBy(Graph graph) {
        for (Edge edge : graph.getEdges()) {
            if (!edge.isDirected()) continue;
            Node from = Edges.getDirectedEdgeTail(edge);
            Node to = Edges.getDirectedEdgeHead(edge);
            if (!this.edgeForbidden(from.getName(), to.getName())) continue;
            System.out.println("That edge was forbidden: " + edge);
            return true;
        }
        return false;
    }

    public void setTier(int tier, List<String> vars) {
        for (String varName : vars) {
            this.tierMap.put(varName, tier);
        }
        this.generateForbiddenEdgeList();
    }

    public void addVariable(String varName) {
        this.variables.add(varName);
    }

    public void removeVariable(String varName) {
        this.variables.remove(varName);
        this.tierMap.remove(varName);
        this.removeFrom(varName, this.requiredEdges);
        this.removeFrom(varName, this.allRequiredEdges);
        this.removeFrom(varName, this.forbiddenEdges);
        this.removeFrom(varName, this.forbiddenCommonCauses);
        this.removeFrom(varName, this.explicitlyForbiddenEdges);
        for (KnowledgeGroup group : this.knowledgeGroups) {
            group.getFromVariables().remove(varName);
            group.getToVariables().remove(varName);
        }
    }

    private void removeFrom(String varName, Set<KnowledgeEdge> set) {
        for (KnowledgeEdge edge : set) {
            if (!edge.getFrom().equals(varName) && !edge.getTo().equals(varName)) continue;
            set.remove(edge);
        }
    }

    public List<String> getVariables() {
        return new ArrayList<String>(this.variables);
    }
}

