/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.TriangularMatrix;
import edu.cmu.tetrad.util.StatUtils;
import java.io.File;
import java.io.IOException;

public class ShortTriangularMatrix
implements TriangularMatrix {
    private short[][] matrix;

    public ShortTriangularMatrix() {
    }

    public ShortTriangularMatrix(int size) {
        this.create(size);
    }

    public void becomeCorrelationMatrix(DataSet dataSet) {
        int i;
        for (int i2 = 0; i2 < dataSet.getNumColumns(); ++i2) {
            this.matrix[i2][i2] = 10000;
        }
        DoubleMatrix2D doubleData = dataSet.getDoubleData();
        DoubleMatrix1D[] views = new DoubleMatrix1D[dataSet.getNumColumns()];
        for (i = 0; i < views.length; ++i) {
            views[i] = doubleData.viewColumn(i);
        }
        for (i = 0; i < dataSet.getNumColumns() - 1; ++i) {
            for (int j = i + 1; j < dataSet.getNumColumns(); ++j) {
                this.matrix[j][i] = StatUtils.compressedCorrelation(views[i], views[j]);
            }
        }
    }

    @Override
    public void create(int size) {
        this.matrix = new short[size][];
        for (int i = 0; i < size; ++i) {
            this.matrix[i] = new short[i + 1];
            for (int j = 0; j < i + 1; ++j) {
                this.matrix[i][j] = (short)i;
            }
        }
    }

    @Override
    public short getShort(int row, int col) {
        if (col > row) {
            int temp = col;
            col = row;
            row = temp;
        }
        return this.matrix[row][col];
    }

    @Override
    public double getDouble(int row, int col) {
        if (col > row) {
            int temp = col;
            col = row;
            row = temp;
        }
        return (double)this.matrix[row][col] / 10000.0;
    }

    public boolean set(int row, int col, long value) {
        return this.set(row, col, (short)value);
    }

    public boolean set(int row, int col, int value) {
        return this.set(row, col, (short)value);
    }

    @Override
    public boolean set(int row, int col, short value) {
        if (col > row) {
            int temp = col;
            col = row;
            row = temp;
        }
        this.matrix[row][col] = value;
        return true;
    }

    @Override
    public boolean set(int row, int col, double value) {
        if (col > row) {
            int temp = col;
            col = row;
            row = temp;
        }
        this.matrix[row][col] = (short)(value * 10000.0);
        return true;
    }

    public String toString() {
        String out = "";
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[i].length; ++j) {
                out = out + this.getDouble(i, j) + "\t\t";
            }
            out = out + "\n";
        }
        return out;
    }

    public static void main(String[] args) {
        ShortTriangularMatrix test = new ShortTriangularMatrix();
        DataReader reader = new DataReader();
        File file = new File("C:/data1.txt");
        ColtDataSet data = null;
        try {
            data = (ColtDataSet)reader.parseTabular(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        test.becomeCorrelationMatrix(data);
        System.out.println(test.toString());
        CorrelationMatrix m = new CorrelationMatrix(data);
        System.out.println(m.toString());
        System.out.println(test.getDouble(1, 3));
        System.out.println(test.getDouble(3, 1));
    }
}

