/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestColtDataSet
extends TestCase {
    public TestColtDataSet(String name) {
        super(name);
    }

    public final void testContinuous() {
        int rows = 10;
        int cols = 5;
        LinkedList<Node> _variables = new LinkedList<Node>();
        for (int i = 0; i < cols; ++i) {
            _variables.add(new ContinuousVariable("X" + i));
        }
        ColtDataSet dataSet = new ColtDataSet(rows, _variables);
        RandomUtil randomUtil = RandomUtil.getInstance();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                dataSet.setDouble(i, j, randomUtil.nextDouble());
            }
        }
        System.out.println(dataSet);
        List<Node> variables = dataSet.getVariables();
        LinkedList<Node> newVars = new LinkedList<Node>();
        newVars.add(variables.get(2));
        newVars.add(variables.get(4));
        DataSet _dataSet = dataSet.subsetColumns(newVars);
        System.out.println(_dataSet);
        TestColtDataSet.assertTrue(((Object)dataSet).equals(dataSet));
    }

    public static void testDiscrete() {
        int rows = 10;
        int cols = 5;
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int i = 0; i < cols; ++i) {
            DiscreteVariable variable = new DiscreteVariable("X" + i, 10);
            variables.add(variable);
        }
        ColtDataSet dataSet = new ColtDataSet(rows, variables);
        RandomUtil randomUtil = RandomUtil.getInstance();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                dataSet.setInt(i, j, randomUtil.nextInt(10));
            }
        }
        System.out.println(dataSet);
    }

    public static void testInitialization() {
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int i = 0; i < 5; ++i) {
            DiscreteVariable variable = new DiscreteVariable("X" + i, 10);
            variables.add(variable);
        }
        ColtDataSet dataSet = new ColtDataSet(5, variables);
        System.out.println(dataSet);
    }

    public static void testDiscreteFromScratch() {
        ColtDataSet dataSet = new ColtDataSet(0, Collections.EMPTY_LIST);
        DiscreteVariable x1 = new DiscreteVariable("X1");
        dataSet.addVariable(x1);
        dataSet.setInt(0, 0, 0);
        dataSet.setInt(1, 0, 2);
        dataSet.setInt(2, 0, 1);
        DiscreteVariable x2 = new DiscreteVariable("X2");
        dataSet.addVariable(x2);
        dataSet.setInt(0, 1, 0);
        dataSet.setInt(1, 1, 2);
        dataSet.setInt(2, 1, 1);
        System.out.println(dataSet);
    }

    public static void testMixed() {
        LinkedList<Node> variables = new LinkedList<Node>();
        DiscreteVariable x1 = new DiscreteVariable("X1");
        variables.add(x1);
        ContinuousVariable x2 = new ContinuousVariable("X2");
        variables.add(x2);
        ColtDataSet dataSet = new ColtDataSet(5, variables);
        System.out.println(dataSet);
    }

    public static void testRemoveColumn() {
        int rows = 10;
        int cols = 5;
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int i = 0; i < cols; ++i) {
            variables.add(new ContinuousVariable("X" + i));
        }
        ColtDataSet dataSet = new ColtDataSet(rows, variables);
        RandomUtil randomUtil = RandomUtil.getInstance();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                dataSet.setDouble(i, j, randomUtil.nextDouble());
            }
        }
        System.out.println(dataSet);
        int[] _cols = new int[]{1, 2};
        dataSet.removeCols(_cols);
        System.out.println(dataSet);
    }

    public static void testRemoveRows() {
        int rows = 10;
        int cols = 5;
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int i = 0; i < cols; ++i) {
            variables.add(new ContinuousVariable("X" + i));
        }
        ColtDataSet dataSet = new ColtDataSet(rows, variables);
        RandomUtil randomUtil = RandomUtil.getInstance();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                dataSet.setDouble(i, j, randomUtil.nextDouble());
            }
        }
        System.out.println(dataSet);
        int[] _rows = new int[]{1, 2};
        dataSet.removeRows(_rows);
        System.out.println(dataSet);
    }

    public static void testRowSubset() {
        int rows = 10;
        int cols = 5;
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int i = 0; i < cols; ++i) {
            variables.add(new ContinuousVariable("X" + i));
        }
        ColtDataSet dataSet = new ColtDataSet(rows, variables);
        RandomUtil randomUtil = RandomUtil.getInstance();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                dataSet.setDouble(i, j, randomUtil.nextDouble());
            }
        }
        System.out.println(dataSet);
        DataSet _dataSet = dataSet.subsetRows(new int[]{0, 1, 2});
        System.out.println(_dataSet);
    }

    public static void testPermuteRows() {
        ColtDataSet dataSet = new ColtDataSet(0, Collections.EMPTY_LIST);
        DiscreteVariable x1 = new DiscreteVariable("X1");
        dataSet.addVariable(x1);
        dataSet.setInt(0, 0, 0);
        dataSet.setInt(1, 0, 2);
        dataSet.setInt(2, 0, 1);
        DiscreteVariable x2 = new DiscreteVariable("X2");
        dataSet.addVariable(x2);
        dataSet.setInt(0, 1, 0);
        dataSet.setInt(1, 1, 2);
        dataSet.setInt(2, 1, 1);
        System.out.println(dataSet);
        dataSet.permuteRows();
        System.out.println(dataSet);
    }

    public static Test suite() {
        return new TestSuite(TestColtDataSet.class);
    }
}

