/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeGroup;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestKnowledge
extends TestCase {
    private Knowledge knowledge;

    public TestKnowledge(String name) {
        super(name);
    }

    @Override
    public final void setUp() {
        this.knowledge = new Knowledge();
    }

    public final void testForbiddenGroups() {
        Knowledge knowledge = new Knowledge();
        Set<String> from = TestKnowledge.createSet("x1", "x2");
        Set<String> to = TestKnowledge.createSet("x3");
        KnowledgeGroup group = new KnowledgeGroup(2, from, to);
        knowledge.addKnowledgeGroup(group);
        from = TestKnowledge.createSet("x3");
        to = TestKnowledge.createSet("x5");
        group = new KnowledgeGroup(2, from, to);
        knowledge.addKnowledgeGroup(group);
        TestKnowledge.assertTrue(knowledge.getKnowledgeGroups().size() == 2);
        TestKnowledge.assertTrue(knowledge.edgeForbidden("x1", "x3"));
        TestKnowledge.assertTrue(knowledge.edgeForbiddenByGroups("x1", "x3"));
        TestKnowledge.assertTrue(knowledge.edgeForbidden("x2", "x3"));
        TestKnowledge.assertTrue(knowledge.edgeForbiddenByGroups("x2", "x3"));
        TestKnowledge.assertTrue(knowledge.edgeForbidden("x3", "x5"));
        TestKnowledge.assertTrue(knowledge.edgeForbiddenByGroups("x3", "x5"));
        TestKnowledge.assertFalse(knowledge.edgeForbidden("x3", "x1"));
        TestKnowledge.assertFalse(knowledge.edgeForbidden("x2", "x1"));
    }

    public final void testRequiredGroups() {
        Knowledge knowledge = new Knowledge();
        Set<String> from = TestKnowledge.createSet("x1", "x2");
        Set<String> to = TestKnowledge.createSet("x3");
        KnowledgeGroup group = new KnowledgeGroup(1, from, to);
        knowledge.addKnowledgeGroup(group);
        from = TestKnowledge.createSet("x3");
        to = TestKnowledge.createSet("x5");
        group = new KnowledgeGroup(1, from, to);
        knowledge.addKnowledgeGroup(group);
        TestKnowledge.assertTrue(knowledge.getKnowledgeGroups().size() == 2);
        TestKnowledge.assertTrue(knowledge.edgeRequired("x1", "x3"));
        TestKnowledge.assertTrue(knowledge.edgeRequiredByGroups("x1", "x3"));
        TestKnowledge.assertTrue(knowledge.edgeRequired("x2", "x3"));
        TestKnowledge.assertTrue(knowledge.edgeRequiredByGroups("x2", "x3"));
        TestKnowledge.assertTrue(knowledge.edgeRequired("x3", "x5"));
        TestKnowledge.assertTrue(knowledge.edgeRequiredByGroups("x3", "x5"));
        TestKnowledge.assertFalse(knowledge.edgeRequired("x3", "x1"));
        TestKnowledge.assertFalse(knowledge.edgeRequired("x2", "x1"));
    }

    public final void testSetEdgeForbidden() {
        this.knowledge.clear();
        this.knowledge.setEdgeForbidden("X1", "X2", true);
        this.knowledge.setEdgeForbidden("X4", "X5", true);
        this.knowledge.setEdgeForbidden("X1", "X3", false);
        TestKnowledge.assertTrue(this.knowledge.edgeForbidden("X4", "X5"));
        TestKnowledge.assertTrue(!this.knowledge.edgeForbidden("X1", "X3"));
        TestKnowledge.assertTrue(!this.knowledge.edgeForbidden("X2", "X3"));
    }

    public final void testSetEdgeRequired() {
        this.knowledge.clear();
        this.knowledge.setEdgeRequired("X1", "X2", true);
        this.knowledge.setEdgeRequired("X4", "X5", true);
        this.knowledge.setEdgeRequired("X1", "X3", false);
        TestKnowledge.assertTrue(this.knowledge.edgeRequired("X4", "X5"));
        TestKnowledge.assertTrue(!this.knowledge.edgeRequired("X1", "X3"));
        TestKnowledge.assertTrue(!this.knowledge.edgeRequired("X2", "X3"));
    }

    public final void testForbiddenRequiredMix() {
        this.knowledge.clear();
        this.knowledge.setEdgeForbidden("X1", "X2", true);
        this.knowledge.setEdgeForbidden("X1", "X2", false);
        System.out.println(this.knowledge);
        this.knowledge.setEdgeRequired("X1", "X2", true);
        TestKnowledge.assertTrue(this.knowledge.edgeRequired("X1", "X2"));
        TestKnowledge.assertTrue(!this.knowledge.edgeForbidden("X1", "X2"));
        this.knowledge.setEdgeRequired("X1", "X2", false);
        this.knowledge.setEdgeForbidden("X1", "X2", true);
        TestKnowledge.assertTrue(!this.knowledge.edgeRequired("X1", "X2"));
        TestKnowledge.assertTrue(this.knowledge.edgeForbidden("X1", "X2"));
    }

    public static void rtestLoadKnowledge() {
        try {
            String filename = "test_data/knowledge.txt";
            File file = new File(filename);
            DataReader reader = new DataReader();
            Knowledge knowledge = reader.parseKnowledge(file);
            System.out.println(knowledge);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void testSaveKnowledge() {
        Knowledge knowledge = new Knowledge();
        knowledge.addToTier(1, "x1");
        knowledge.addToTier(1, "x2");
        knowledge.addToTier(2, "x3");
        knowledge.addToTier(2, "x4");
        knowledge.addToTier(4, "x5");
        knowledge.setEdgeForbidden("x5", "x1", true);
        knowledge.setEdgeForbidden("x6", "x1", true);
        knowledge.setEdgeRequired("x1", "x3", true);
        knowledge.setEdgeRequired("x2", "x4", true);
        try {
            CharArrayWriter writer = new CharArrayWriter();
            Knowledge.saveKnowledge(knowledge, writer);
            System.out.println(writer.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void testCopyKnowledge() {
        Knowledge knowledge = new Knowledge();
        knowledge.addToTier(0, "x1");
        knowledge.addToTier(0, "x2");
        knowledge.addToTier(1, "x3");
        knowledge.addToTier(1, "x4");
        knowledge.addToTier(3, "x6");
        knowledge.addToTier(3, "x7");
        knowledge.addToTier(4, "x5");
        Set<String> from = TestKnowledge.createSet("x10", "x11");
        Set<String> to = TestKnowledge.createSet("x12");
        KnowledgeGroup group = new KnowledgeGroup(1, from, to);
        knowledge.addKnowledgeGroup(group);
        System.out.println(knowledge);
        Knowledge knowledge2 = new Knowledge(knowledge);
        System.out.println(knowledge2);
        TestKnowledge.assertEquals(knowledge, knowledge2);
    }

    public static Test suite() {
        return new TestSuite(TestKnowledge.class);
    }

    private static Set<String> createSet(String ... vars) {
        HashSet<String> set = new HashSet<String>();
        for (String v : vars) {
            set.add(v);
        }
        return set;
    }
}

