/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.graph;

import edu.cmu.tetrad.gene.graph.ManualLagGraphParams;
import edu.cmu.tetrad.gene.history.BasicLagGraph;
import edu.cmu.tetrad.gene.history.LagGraph;
import edu.cmu.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetrad.util.PointXy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;

public final class ManualLagGraph
implements LagGraph {
    static final long serialVersionUID = 23L;
    private final BasicLagGraph lagGraph = new BasicLagGraph();

    public ManualLagGraph(ManualLagGraphParams params) {
        this.addFactors("G", params.getVarsPerInd());
        this.setMaxLagAllowable(params.getMlag());
        for (String factor : this.getFactors()) {
            LaggedFactor laggedFactor = new LaggedFactor(factor, 1);
            this.addEdge(factor, laggedFactor);
        }
    }

    public static ManualLagGraph serializableInstance() {
        return new ManualLagGraph(ManualLagGraphParams.serializableInstance());
    }

    @Override
    public void addEdge(String factor, LaggedFactor laggedFactor) throws IllegalArgumentException {
        this.lagGraph.addEdge(factor, laggedFactor);
    }

    @Override
    public void clearEdges() {
        this.lagGraph.clearEdges();
    }

    @Override
    public void addFactor(String factor) {
        if (!NamingProtocol.isLegalName(factor)) {
            throw new IllegalArgumentException(NamingProtocol.getProtocolDescription());
        }
        this.lagGraph.addFactor(factor);
    }

    @Override
    public boolean existsFactor(String factor) {
        return this.lagGraph.existsFactor(factor);
    }

    @Override
    public boolean existsEdge(String factor, LaggedFactor laggedFactor) {
        return this.lagGraph.existsEdge(factor, laggedFactor);
    }

    public SortedSet getParents(String factor) {
        return this.lagGraph.getParents(factor);
    }

    @Override
    public void removeEdge(String factor, LaggedFactor laggedFactor) {
        this.lagGraph.removeEdge(factor, laggedFactor);
    }

    @Override
    public int getMaxLagAllowable() {
        return this.lagGraph.getMaxLagAllowable();
    }

    @Override
    public void setMaxLagAllowable(int maxLagAllowable) {
        this.lagGraph.setMaxLagAllowable(maxLagAllowable);
    }

    @Override
    public int getMaxLag() {
        return this.lagGraph.getMaxLag();
    }

    @Override
    public void removeFactor(String factor) {
        this.lagGraph.removeFactor(factor);
    }

    public SortedMap getConnectivity() {
        return this.lagGraph.getConnectivity();
    }

    @Override
    public void renameFactor(String oldName, String newName) {
        this.lagGraph.renameFactor(oldName, newName);
    }

    @Override
    public int getNumFactors() {
        return this.lagGraph.getNumFactors();
    }

    public SortedSet getFactors() {
        return this.lagGraph.getFactors();
    }

    @Override
    public String toString() {
        return this.lagGraph.toString();
    }

    @Override
    public void addFactors(String base, int numFactors) {
        this.lagGraph.addFactors(base, numFactors);
    }

    @Override
    public void setLocation(String factor, PointXy point) {
        this.lagGraph.setLocation(factor, point);
    }

    @Override
    public PointXy getLocation(String factor) {
        return this.lagGraph.getLocation(factor);
    }

    @Override
    public Map getLocations() {
        return this.lagGraph.getLocations();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.lagGraph == null) {
            throw new NullPointerException();
        }
    }
}

