/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.history;

import edu.cmu.tetrad.gene.history.IndexedParent;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BooleanFunction
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private IndexedParent[] parents;
    private boolean[] lookupTable;

    public BooleanFunction(IndexedParent[] parents) {
        if (parents == null) {
            throw new NullPointerException();
        }
        for (IndexedParent parent : parents) {
            if (parent != null) continue;
            throw new NullPointerException();
        }
        this.parents = parents;
        int length = 1;
        for (int i = 0; i < parents.length; ++i) {
            length *= 2;
        }
        this.lookupTable = new boolean[length];
    }

    public static BooleanFunction serializableInstance() {
        IndexedParent[] parents = new IndexedParent[]{new IndexedParent(0, 1), new IndexedParent(1, 2)};
        return new BooleanFunction(parents);
    }

    public Object[] getParents() {
        return this.parents;
    }

    public boolean getValue(int row) {
        return this.lookupTable[row];
    }

    public void setValue(int row, boolean value) {
        this.lookupTable[row] = value;
    }

    public int getRow(boolean[] parentValues) {
        int row = 0;
        for (int i = this.parents.length - 1; i >= 0; --i) {
            row *= 2;
            row += parentValues[i] ? 0 : 1;
        }
        return row;
    }

    public int getNumRows() {
        return this.lookupTable.length;
    }

    public boolean[] getParentValues(int row) {
        boolean[] parentValues = new boolean[this.parents.length];
        if (row >= this.lookupTable.length) {
            throw new IllegalArgumentException();
        }
        for (int i = this.parents.length - 1; i >= 0; --i) {
            parentValues[i] = row % 2 == 1;
            row /= 2;
        }
        return parentValues;
    }

    public void randomize() {
        for (int i = 0; i < this.lookupTable.length; ++i) {
            this.lookupTable[i] = RandomUtil.getInstance().nextDouble() > 0.5;
        }
    }

    public boolean isCanalyzing() {
        int[] lastValues = new int[2];
        for (int jump = 1; jump < this.lookupTable.length; jump *= 2) {
            lastValues[0] = -1;
            lastValues[1] = -1;
            for (int row = 0; row < this.lookupTable.length; ++row) {
                int parentValue;
                int value = this.lookupTable[row] ? 1 : 0;
                int n = parentValue = row / jump % 2 == 0 ? 1 : 0;
                if (-2 == lastValues[parentValue] || value == lastValues[parentValue]) continue;
                lastValues[parentValue] = -1 == lastValues[parentValue] ? value : -2;
            }
            if (lastValues[0] == -2 && lastValues[1] == -2) continue;
            return true;
        }
        return false;
    }

    public boolean isEffective() {
        boolean[] result = new boolean[this.parents.length];
        for (int row = 0; row < this.lookupTable.length; ++row) {
            int jump = 1;
            for (int i = 0; i < this.parents.length; ++i) {
                if (row / jump % 2 == 0 && this.lookupTable[row] != this.lookupTable[row + jump]) {
                    result[i] = true;
                }
                jump *= 2;
            }
        }
        for (int i = 0; i < this.parents.length; ++i) {
            if (result[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("\nBoolean Function:");
        for (int i = 0; i < this.lookupTable.length; ++i) {
            buf.append("\n").append(i).append("\t");
            buf.append(this.lookupTable[i]);
        }
        buf.append("\n\n");
        return buf.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.parents == null) {
            throw new NullPointerException();
        }
        if (this.lookupTable == null) {
            throw new NullPointerException();
        }
    }
}

