/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.history;

import edu.cmu.tetrad.gene.history.BasalInitializer;
import edu.cmu.tetrad.gene.history.BooleanGlassFunction;
import edu.cmu.tetrad.gene.history.DishModel;
import edu.cmu.tetrad.gene.history.Initializer;
import edu.cmu.tetrad.gene.history.UpdateFunction;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;

public class GeneHistory
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private Initializer initializer;
    private UpdateFunction updateFunction;
    private int[] updatePeriods;
    private int step;
    private double[][] historyArray;
    private boolean initSync = true;
    private double[][] syncInitialization;
    private DishModel dishModel;

    public GeneHistory(Initializer initializer, UpdateFunction updateFunction) {
        if (initializer == null) {
            throw new NullPointerException("Initializer cannot be null.");
        }
        if (updateFunction == null) {
            throw new NullPointerException("Updater cannot be null.");
        }
        this.initializer = initializer;
        this.updateFunction = updateFunction;
        this.updatePeriods = new int[updateFunction.getNumFactors()];
        for (int i = 0; i < this.updatePeriods.length; ++i) {
            this.updatePeriods[i] = 1;
        }
    }

    public static GeneHistory serializableInstance() {
        return new GeneHistory(BasalInitializer.serializableInstance(), BooleanGlassFunction.serializableInstance());
    }

    public Initializer getInitializer() {
        return this.initializer;
    }

    public UpdateFunction getUpdateFunction() {
        return this.updateFunction;
    }

    public int getStep() {
        return this.step;
    }

    public double[][] getHistoryArray() {
        return this.historyArray;
    }

    public void setInitSync(boolean initSync) {
        this.initSync = initSync;
    }

    public boolean getInitSync() {
        return this.initSync;
    }

    public void reset() {
        this.syncInitialization = null;
    }

    public void setDishModel(DishModel dishModel) {
        this.dishModel = dishModel;
    }

    public DishModel getDishModel() {
        return this.dishModel;
    }

    public void update() {
        int i;
        double[] last = this.historyArray[this.historyArray.length - 1];
        for (i = this.historyArray.length - 1; i > 0; --i) {
            this.historyArray[i] = this.historyArray[i - 1];
        }
        this.historyArray[0] = last;
        ++this.step;
        for (i = 0; i < this.updateFunction.getNumFactors(); ++i) {
            if (this.step % this.updatePeriods[i] != 0) continue;
            this.historyArray[0][i] = this.updateFunction.getValue(i, this.historyArray);
        }
    }

    public void initialize() {
        int numFactors = this.updateFunction.getNumFactors();
        int maxLag = this.updateFunction.getMaxLag();
        if (this.initSync) {
            if (this.syncInitialization == null) {
                this.syncInitialization = new double[maxLag + 1][numFactors];
                this.historyArray = new double[maxLag + 1][numFactors];
                this.getInitializer().initialize(this.syncInitialization);
            }
            for (int i = 0; i < this.historyArray.length; ++i) {
                for (int j = 0; j < this.historyArray[0].length; ++j) {
                    this.historyArray[i][j] = this.getDishModel() == null ? this.syncInitialization[i][j] : this.getDishModel().bumpInitialization(this.syncInitialization[i][j]);
                }
            }
        } else {
            if (this.historyArray == null) {
                this.historyArray = new double[maxLag + 1][numFactors];
            }
            this.getInitializer().initialize(this.historyArray);
        }
        this.step = -1;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.initializer == null) {
            throw new NullPointerException();
        }
        if (this.updateFunction == null) {
            throw new NullPointerException();
        }
        if (this.updatePeriods == null) {
            throw new NullPointerException();
        }
    }
}

