/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.gene.history;

import edu.cmu.tetrad.gene.history.BasicLagGraph;
import edu.cmu.tetrad.gene.history.IndexedParent;
import edu.cmu.tetrad.gene.history.LagGraph;
import edu.cmu.tetrad.gene.history.LaggedFactor;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;

public class IndexedConnectivity
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private List<String> factors;
    private IndexedParent[][] parents;

    public IndexedConnectivity(LagGraph lagGraph) {
        this(lagGraph, false);
    }

    public IndexedConnectivity(LagGraph lagGraph, boolean excludeSelfOneBack) {
        if (lagGraph == null) {
            throw new NullPointerException("Lag graph must not be null.");
        }
        this.factors = new ArrayList<String>(lagGraph.getFactors());
        this.parents = new IndexedParent[this.factors.size()][];
        for (int i = 0; i < this.factors.size(); ++i) {
            String factor = this.factors.get(i);
            SortedSet<LaggedFactor> factorParents = lagGraph.getParents(factor);
            ArrayList<IndexedParent> list = new ArrayList<IndexedParent>();
            for (LaggedFactor factorParent1 : factorParents) {
                int index = this.factors.indexOf(factorParent1.getFactor());
                int lag = factorParent1.getLag();
                if (excludeSelfOneBack && index == i && lag == 1) continue;
                IndexedParent parent = new IndexedParent(index, lag);
                list.add(parent);
            }
            IndexedParent[] _parents = new IndexedParent[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                _parents[i2] = (IndexedParent)list.get(i2);
            }
            this.parents[i] = _parents;
        }
    }

    public static IndexedConnectivity serializableInstance() {
        return new IndexedConnectivity(BasicLagGraph.serializableInstance());
    }

    public int getNumFactors() {
        return this.factors.size();
    }

    public String getFactor(int factor) {
        return this.factors.get(factor);
    }

    public int getIndex(String factor) {
        return this.factors.indexOf(factor);
    }

    public int getIndex(String factor, LaggedFactor parent) {
        int factorIndex = this.factors.indexOf(factor);
        int parentIndex = this.factors.indexOf(parent.getFactor());
        IndexedParent indexedParent = new IndexedParent(parentIndex, parent.getLag());
        return this.getIndex(factorIndex, indexedParent);
    }

    public int getIndex(int factor, IndexedParent parent) {
        for (int i = 0; i < this.parents[factor].length; ++i) {
            if (!parent.equals(this.parents[factor][i])) continue;
            return i;
        }
        return -1;
    }

    public int getNumParents(int factor) {
        return this.parents[factor].length;
    }

    public IndexedParent getParent(int factor, int parent) {
        return this.parents[factor][parent];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nIndexed connectivity:\n");
        for (int i = 0; i < this.getNumFactors(); ++i) {
            String factor = this.getFactor(i);
            buf.append("\n");
            buf.append(factor);
            buf.append("\t<-- ");
            for (int j = 0; j < this.getNumParents(i); ++j) {
                IndexedParent parent = this.getParent(i, j);
                buf.append("\t");
                buf.append(this.getFactor(parent.getIndex()));
                buf.append(":");
                buf.append(parent.getLag());
            }
        }
        buf.append("\n");
        return buf.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.factors == null) {
            throw new NullPointerException();
        }
        if (this.parents == null) {
            throw new IllegalStateException();
        }
    }
}

