/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.AtMostOneEdgePerPair;
import edu.cmu.tetrad.graph.DirectedEdgesOnly;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConstraint;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.InArrowImpliesNonancestor;
import edu.cmu.tetrad.graph.MeasuredLatentOnly;
import edu.cmu.tetrad.graph.NoEdgesToSelf;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public final class Dag
implements Graph {
    static final long serialVersionUID = 23L;
    private static final GraphConstraint[] constraints = new GraphConstraint[]{new MeasuredLatentOnly(), new AtMostOneEdgePerPair(), new NoEdgesToSelf(), new DirectedEdgesOnly(), new InArrowImpliesNonancestor()};
    private final Graph graph;
    private transient int[][] dpath;
    private transient LinkedList<Edge> dpathNewEdges = new LinkedList();
    private transient List<Node> dpathNodes;

    public Dag() {
        this.graph = new EdgeListGraph();
        this.setGraphConstraintsChecked(true);
        List<GraphConstraint> constraints1 = Arrays.asList(constraints);
        for (GraphConstraint aConstraints1 : constraints1) {
            this.addGraphConstraint(aConstraints1);
        }
    }

    public Dag(List<Node> nodes) {
        this.graph = new EdgeListGraph(nodes);
        this.setGraphConstraintsChecked(true);
        List<GraphConstraint> constraints1 = Arrays.asList(constraints);
        for (GraphConstraint aConstraints1 : constraints1) {
            this.addGraphConstraint(aConstraints1);
        }
    }

    public Dag(Graph graph) throws IllegalArgumentException {
        this.graph = new EdgeListGraph();
        List<GraphConstraint> constraints1 = Arrays.asList(constraints);
        for (GraphConstraint aConstraints1 : constraints1) {
            this.addGraphConstraint(aConstraints1);
        }
        this.transferNodesAndEdges(graph);
        this.resetDPath();
    }

    public static Dag serializableInstance() {
        Dag dag = new Dag();
        GraphNode node1 = new GraphNode("X");
        dag.addNode(node1);
        return dag;
    }

    @Override
    public boolean addBidirectedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addEdge(Edge edge) {
        this.reconstituteDpath();
        Node _node1 = Edges.getDirectedEdgeTail(edge);
        Node _node2 = Edges.getDirectedEdgeHead(edge);
        int _index1 = this.dpathNodes.indexOf(_node1);
        int _index2 = this.dpathNodes.indexOf(_node2);
        if (this.dpath[_index2][_index1] == 1) {
            return false;
        }
        boolean added = this.getGraph().addEdge(edge);
        if (added) {
            this.dpathNewEdges().add(edge);
        }
        return added;
    }

    @Override
    public boolean addDirectedEdge(Node node1, Node node2) {
        return this.addEdge(Edges.directedEdge(node1, node2));
    }

    @Override
    public boolean addGraphConstraint(GraphConstraint gc) {
        return this.getGraph().addGraphConstraint(gc);
    }

    @Override
    public boolean addPartiallyOrientedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addNode(Node node) {
        boolean added = this.getGraph().addNode(node);
        if (added) {
            this.resetDPath();
        }
        return added;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getGraph().addPropertyChangeListener(l);
    }

    @Override
    public boolean addUndirectedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addNondirectedEdge(Node node1, Node node2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.getGraph().clear();
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.getGraph().containsEdge(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.getGraph().containsNode(node);
    }

    @Override
    public boolean defNonDescendent(Node node1, Node node2) {
        return this.getGraph().defNonDescendent(node1, node2);
    }

    @Override
    public boolean existsDirectedCycle() {
        return false;
    }

    @Override
    public boolean defVisible(Edge edge) {
        return this.getGraph().defVisible(edge);
    }

    @Override
    public boolean isDefNoncollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefNoncollider(node1, node2, node3);
    }

    @Override
    public boolean isDefCollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefCollider(node1, node2, node3);
    }

    @Override
    public boolean existsTrek(Node node1, Node node2) {
        return this.getGraph().existsTrek(node1, node2);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.getGraph()).equals(o);
    }

    @Override
    public boolean existsDirectedPathFromTo(Node node1, Node node2) {
        this.resetDPath();
        this.reconstituteDpath();
        int index1 = this.dpathNodes.indexOf(node1);
        int index2 = this.dpathNodes.indexOf(node2);
        return this.dpath[index1][index2] == 1;
    }

    @Override
    public boolean existsUndirectedPathFromTo(Node node1, Node node2) {
        return false;
    }

    @Override
    public boolean existsSemiDirectedPathFromTo(Node node1, Set<Node> nodes) {
        return this.getGraph().existsSemiDirectedPathFromTo(node1, nodes);
    }

    @Override
    public boolean existsInducingPath(Node node1, Node node2, Set<Node> observedNodes, Set<Node> conditioningNodes) {
        return this.getGraph().existsInducingPath(node1, node2, observedNodes, conditioningNodes);
    }

    @Override
    public void fullyConnect(Endpoint endpoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        return this.getGraph().getEndpoint(node1, node2);
    }

    @Override
    public Endpoint[][] getEndpointMatrix() {
        return this.getGraph().getEndpointMatrix();
    }

    @Override
    public List<Node> getAdjacentNodes(Node node) {
        return this.getGraph().getAdjacentNodes(node);
    }

    @Override
    public List<Node> getNodesInTo(Node node, Endpoint endpoint) {
        return this.getGraph().getNodesInTo(node, endpoint);
    }

    @Override
    public List<Node> getNodesOutTo(Node node, Endpoint n) {
        return this.getGraph().getNodesOutTo(node, n);
    }

    @Override
    public List<Node> getNodes() {
        return this.getGraph().getNodes();
    }

    @Override
    public List<Edge> getEdges() {
        return this.getGraph().getEdges();
    }

    @Override
    public List<Edge> getEdges(Node node) {
        return this.getGraph().getEdges(node);
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        return this.getGraph().getEdges(node1, node2);
    }

    @Override
    public Node getNode(String name) {
        return this.getGraph().getNode(name);
    }

    @Override
    public int getNumEdges() {
        return this.getGraph().getNumEdges();
    }

    @Override
    public int getNumNodes() {
        return this.getGraph().getNumNodes();
    }

    @Override
    public int getNumEdges(Node node) {
        return this.getGraph().getNumEdges(node);
    }

    @Override
    public List<GraphConstraint> getGraphConstraints() {
        return this.getGraph().getGraphConstraints();
    }

    public List<List<Node>> getTiers() {
        HashSet found = new HashSet();
        HashSet<Node> notFound = new HashSet<Node>();
        LinkedList<List<Node>> tiers = new LinkedList<List<Node>>();
        for (Node node1 : this.getNodes()) {
            notFound.add(node1);
        }
        while (!notFound.isEmpty()) {
            LinkedList<Node> thisTier = new LinkedList<Node>();
            for (Node node : notFound) {
                if (!found.containsAll(this.getParents(node))) continue;
                thisTier.add(node);
            }
            notFound.removeAll(thisTier);
            found.addAll(thisTier);
            tiers.add(thisTier);
        }
        return tiers;
    }

    @Override
    public List<Node> getChildren(Node node) {
        return this.getGraph().getChildren(node);
    }

    @Override
    public int getConnectivity() {
        return this.getGraph().getConnectivity();
    }

    @Override
    public List<Node> getDescendants(List<Node> nodes) {
        return this.getGraph().getDescendants(nodes);
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        return this.getGraph().getEdge(node1, node2);
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        return this.getGraph().getDirectedEdge(node1, node2);
    }

    @Override
    public List<Node> getParents(Node node) {
        return this.getGraph().getParents(node);
    }

    @Override
    public int getIndegree(Node node) {
        return this.getGraph().getIndegree(node);
    }

    @Override
    public int getOutdegree(Node node) {
        return this.getGraph().getOutdegree(node);
    }

    @Override
    public List<Node> getTierOrdering() {
        LinkedList<Node> found = new LinkedList<Node>();
        HashSet<Node> notFound = new HashSet<Node>();
        for (Node node1 : this.getNodes()) {
            notFound.add(node1);
        }
        while (!notFound.isEmpty()) {
            Iterator it = notFound.iterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (!found.containsAll(this.getParents(node))) continue;
                found.add(node);
                it.remove();
            }
        }
        return found;
    }

    @Override
    public boolean isAdjacentTo(Node nodeX, Node nodeY) {
        return this.getGraph().isAdjacentTo(nodeX, nodeY);
    }

    @Override
    public boolean isAncestorOf(Node node1, Node node2) {
        return node1 == node2 || this.isProperAncestorOf(node1, node2);
    }

    @Override
    public boolean isDirectedFromTo(Node node1, Node node2) {
        return this.getGraph().isDirectedFromTo(node1, node2);
    }

    @Override
    public boolean isUndirectedFromTo(Node node1, Node node2) {
        return false;
    }

    @Override
    public boolean isGraphConstraintsChecked() {
        return this.getGraph().isGraphConstraintsChecked();
    }

    @Override
    public boolean isParentOf(Node node1, Node node2) {
        return this.getGraph().isParentOf(node1, node2);
    }

    @Override
    public boolean isProperAncestorOf(Node node1, Node node2) {
        return this.existsDirectedPathFromTo(node1, node2);
    }

    @Override
    public boolean isProperDescendentOf(Node node1, Node node2) {
        return this.existsDirectedPathFromTo(node2, node1);
    }

    @Override
    public boolean isExogenous(Node node) {
        return this.getGraph().isExogenous(node);
    }

    @Override
    public boolean isDConnectedTo(Node node1, Node node2, List<Node> conditioningNodes) {
        return this.getGraph().isDConnectedTo(node1, node2, conditioningNodes);
    }

    @Override
    public boolean isDSeparatedFrom(Node node1, Node node2, List<Node> z) {
        return this.getGraph().isDSeparatedFrom(node1, node2, z);
    }

    @Override
    public boolean isChildOf(Node node1, Node node2) {
        return this.getGraph().isChildOf(node1, node2);
    }

    @Override
    public boolean isDescendentOf(Node node1, Node node2) {
        return node1 == node2 || this.isProperDescendentOf(node1, node2);
    }

    public void printTiers(PrintStream out) {
        List<List<Node>> tiers = this.getTiers();
        System.out.println();
        for (List<Node> thisTier : tiers) {
            for (Node thisNode : thisTier) {
                out.print(thisNode + "\t");
            }
            out.println();
        }
        out.println("done");
    }

    public void printTierOrdering() {
        List<Node> v = this.getTierOrdering();
        System.out.println();
        for (Node aV : v) {
            System.out.print(aV + "\t");
        }
        System.out.println();
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        boolean removed = this.getGraph().removeEdge(node1, node2);
        if (removed) {
            this.resetDPath();
        }
        return removed;
    }

    @Override
    public boolean removeEdges(Node node1, Node node2) {
        boolean removed = this.getGraph().removeEdges(node1, node2);
        if (removed) {
            this.resetDPath();
        }
        return removed;
    }

    @Override
    public boolean setEndpoint(Node node1, Node node2, Endpoint endpoint) {
        boolean ret = this.getGraph().setEndpoint(node1, node2, endpoint);
        this.resetDPath();
        return ret;
    }

    @Override
    public Graph subgraph(List<Node> nodes) {
        return this.getGraph().subgraph(nodes);
    }

    @Override
    public void setGraphConstraintsChecked(boolean checked) {
        this.getGraph().setGraphConstraintsChecked(checked);
    }

    @Override
    public boolean removeEdge(Edge edge) {
        boolean removed = this.getGraph().removeEdge(edge);
        this.resetDPath();
        return removed;
    }

    @Override
    public boolean removeEdges(List<Edge> edges) {
        boolean change = false;
        for (Edge edge : edges) {
            boolean _change = this.removeEdge(edge);
            change = change || _change;
        }
        return change;
    }

    @Override
    public boolean removeNode(Node node) {
        boolean removed = this.getGraph().removeNode(node);
        if (removed) {
            this.resetDPath();
        }
        return removed;
    }

    @Override
    public boolean removeNodes(List<Node> nodes) {
        return this.getGraph().removeNodes(nodes);
    }

    @Override
    public void reorientAllWith(Endpoint endpoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean possibleAncestor(Node node1, Node node2) {
        return this.getGraph().possibleAncestor(node1, node2);
    }

    @Override
    public List<Node> getAncestors(List<Node> nodes) {
        return this.getGraph().getAncestors(nodes);
    }

    @Override
    public boolean possDConnectedTo(Node node1, Node node2, List<Node> z) {
        return this.getGraph().possDConnectedTo(node1, node2, z);
    }

    private void resetDPath() {
        this.dpath = null;
        this.dpathNewEdges().clear();
        this.dpathNewEdges().addAll(this.getEdges());
    }

    private void reconstituteDpath() {
        if (this.dpath == null) {
            this.dpathNodes = this.getNodes();
            int numNodes = this.dpathNodes.size();
            this.dpath = new int[numNodes][numNodes];
        }
        while (!this.dpathNewEdges().isEmpty()) {
            Edge edge = this.dpathNewEdges().removeFirst();
            Node _node1 = Edges.getDirectedEdgeTail(edge);
            Node _node2 = Edges.getDirectedEdgeHead(edge);
            int _index1 = this.dpathNodes.indexOf(_node1);
            int _index2 = this.dpathNodes.indexOf(_node2);
            this.dpath[_index1][_index2] = 1;
            for (int i = 0; i < this.dpathNodes.size(); ++i) {
                if (this.dpath[i][_index1] == 1) {
                    this.dpath[i][_index2] = 1;
                }
                if (this.dpath[_index2][i] != 1) continue;
                this.dpath[_index1][i] = 1;
            }
        }
    }

    @Override
    public final void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        this.getGraph().transferNodesAndEdges(graph);
    }

    @Override
    public Set<Triple> getAmbiguousTriples() {
        return this.getGraph().getAmbiguousTriples();
    }

    @Override
    public Set<Triple> getUnderLines() {
        return this.getGraph().getUnderLines();
    }

    @Override
    public Set<Triple> getDottedUnderlines() {
        return this.getGraph().getDottedUnderlines();
    }

    @Override
    public boolean isAmbiguousTriple(Node x, Node y, Node z) {
        return this.getGraph().isAmbiguousTriple(x, y, z);
    }

    @Override
    public boolean isUnderlineTriple(Node x, Node y, Node z) {
        return this.getGraph().isUnderlineTriple(x, y, z);
    }

    @Override
    public boolean isDottedUnderlineTriple(Node x, Node y, Node z) {
        return this.getGraph().isDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void addAmbiguousTriple(Node x, Node y, Node z) {
        this.getGraph().addAmbiguousTriple(x, y, z);
    }

    @Override
    public void addUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().addUnderlineTriple(x, y, z);
    }

    @Override
    public void addDottedUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().addDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void removeAmbiguousTriple(Node x, Node y, Node z) {
        this.getGraph().removeAmbiguousTriple(x, y, z);
    }

    @Override
    public void removeUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().removeUnderlineTriple(x, y, z);
    }

    @Override
    public void removeDottedUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().removeDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void setAmbiguousTriples(Set<Triple> triples) {
        this.getGraph().setAmbiguousTriples(triples);
    }

    @Override
    public void setUnderLineTriples(Set<Triple> triples) {
        this.getGraph().setUnderLineTriples(triples);
    }

    @Override
    public void setDottedUnderLineTriples(Set<Triple> triples) {
        this.getGraph().setDottedUnderLineTriples(triples);
    }

    @Override
    public List<String> getNodeNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public String toString() {
        return ((Object)this.getGraph()).toString();
    }

    private LinkedList<Edge> dpathNewEdges() {
        if (this.dpathNewEdges == null) {
            this.dpathNewEdges = new LinkedList();
        }
        return this.dpathNewEdges;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getGraph() == null) {
            throw new NullPointerException();
        }
    }

    public List<Node> getExogenousTerms() {
        Vector<Node> errorTerms = new Vector<Node>();
        List<Node> nodes = this.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!this.getParents(node).isEmpty()) continue;
            errorTerms.add(node);
        }
        return errorTerms;
    }

    private Graph getGraph() {
        return this.graph;
    }

    public static boolean isDag(Graph graph) {
        try {
            new Dag(graph);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

