/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Node;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class Edges {
    public static Edge bidirectedEdge(Node nodeA, Node nodeB) {
        return new Edge(nodeA, nodeB, Endpoint.ARROW, Endpoint.ARROW);
    }

    public static Edge directedEdge(Node nodeA, Node nodeB) {
        return new Edge(nodeA, nodeB, Endpoint.TAIL, Endpoint.ARROW);
    }

    public static Edge partiallyOrientedEdge(Node nodeA, Node nodeB) {
        return new Edge(nodeA, nodeB, Endpoint.CIRCLE, Endpoint.ARROW);
    }

    public static Edge nondirectedEdge(Node nodeA, Node nodeB) {
        return new Edge(nodeA, nodeB, Endpoint.CIRCLE, Endpoint.CIRCLE);
    }

    public static Edge undirectedEdge(Node nodeA, Node nodeB) {
        return new Edge(nodeA, nodeB, Endpoint.TAIL, Endpoint.TAIL);
    }

    public static boolean isBidirectedEdge(Edge edge) {
        return edge.getEndpoint1() == Endpoint.ARROW && edge.getEndpoint2() == Endpoint.ARROW;
    }

    public static boolean isDirectedEdge(Edge edge) {
        return edge.getEndpoint1() == Endpoint.TAIL ? edge.getEndpoint2() == Endpoint.ARROW : edge.getEndpoint2() == Endpoint.TAIL && edge.getEndpoint1() == Endpoint.ARROW;
    }

    public static boolean isPartiallyOrientedEdge(Edge edge) {
        return edge.getEndpoint1() == Endpoint.CIRCLE ? edge.getEndpoint2() == Endpoint.ARROW : edge.getEndpoint2() == Endpoint.CIRCLE && edge.getEndpoint1() == Endpoint.ARROW;
    }

    public static boolean isNondirectedEdge(Edge edge) {
        return edge.getEndpoint1() == Endpoint.CIRCLE && edge.getEndpoint2() == Endpoint.CIRCLE;
    }

    public static boolean isUndirectedEdge(Edge edge) {
        return edge.getEndpoint1() == Endpoint.TAIL && edge.getEndpoint2() == Endpoint.TAIL;
    }

    public static Node traverse(Node node, Edge edge) {
        if (node == null) {
            return null;
        }
        if (((Object)node).equals(edge.getNode1())) {
            return edge.getNode2();
        }
        if (((Object)node).equals(edge.getNode2())) {
            return edge.getNode1();
        }
        return null;
    }

    public static Node traverseDirected(Node node, Edge edge) {
        if (node == edge.getNode1()) {
            if (edge.getEndpoint1() == Endpoint.TAIL && edge.getEndpoint2() == Endpoint.ARROW) {
                return edge.getNode2();
            }
        } else if (node == edge.getNode2() && edge.getEndpoint2() == Endpoint.TAIL && edge.getEndpoint1() == Endpoint.ARROW) {
            return edge.getNode1();
        }
        return null;
    }

    public static Node traverseReverseDirected(Node node, Edge edge) {
        if (node == edge.getNode1()) {
            if (edge.getEndpoint1() == Endpoint.ARROW && edge.getEndpoint2() == Endpoint.TAIL) {
                return edge.getNode2();
            }
        } else if (node == edge.getNode2() && edge.getEndpoint2() == Endpoint.ARROW && edge.getEndpoint1() == Endpoint.TAIL) {
            return edge.getNode1();
        }
        return null;
    }

    public static Node traverseSemiDirected(Node node, Edge edge) {
        if (node == edge.getNode1()) {
            if (edge.getEndpoint1() != Endpoint.ARROW) {
                return edge.getNode2();
            }
        } else if (node == edge.getNode2() && edge.getEndpoint2() != Endpoint.ARROW) {
            return edge.getNode1();
        }
        return null;
    }

    public static Node traverseUndirected(Node node, Edge edge) {
        if (node == edge.getNode1()) {
            return edge.getNode2();
        }
        if (node == edge.getNode2()) {
            return edge.getNode1();
        }
        return null;
    }

    public static Node getDirectedEdgeHead(Edge edge) {
        if (edge.getEndpoint1() == Endpoint.ARROW && edge.getEndpoint2() == Endpoint.TAIL) {
            return edge.getNode1();
        }
        if (edge.getEndpoint2() == Endpoint.ARROW && edge.getEndpoint1() == Endpoint.TAIL) {
            return edge.getNode2();
        }
        throw new IllegalArgumentException("Not a directed edge: " + edge);
    }

    public static Node getDirectedEdgeTail(Edge edge) {
        if (edge.getEndpoint2() == Endpoint.ARROW && edge.getEndpoint1() == Endpoint.TAIL) {
            return edge.getNode1();
        }
        if (edge.getEndpoint1() == Endpoint.ARROW && edge.getEndpoint2() == Endpoint.TAIL) {
            return edge.getNode2();
        }
        throw new IllegalArgumentException("Not a directed edge: " + edge);
    }

    public static void sortEdges(List<Edge> edges) {
        Collections.sort(edges, new Comparator<Edge>(){

            @Override
            public int compare(Edge edge1, Edge edge2) {
                Node left1 = edge1.getNode1();
                Node right1 = edge1.getNode2();
                Node left2 = edge2.getNode1();
                Node right2 = edge2.getNode2();
                int compareLeft = ((Object)left1).toString().compareTo(((Object)left2).toString());
                int compareRight = ((Object)right1).toString().compareTo(((Object)right2).toString());
                if (compareLeft != 0) {
                    return compareLeft;
                }
                return compareRight;
            }
        });
    }
}

