/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;

public final class LayeredDrawing {
    private Graph graph;

    public LayeredDrawing(Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.graph = graph;
    }

    public void doLayout() {
        List<List<Node>> tiers = this.placeInTiers(this.graph);
        int y = 0;
        for (List<Node> tier1 : tiers) {
            y += 60;
            int x = 0;
            for (Node aTier : tier1) {
                aTier.setCenterX(x += 90);
                aTier.setCenterY(y);
            }
        }
    }

    private List<List<Node>> placeInTiers(Graph graph) {
        List<List<Node>> connectedComponents = GraphUtils.connectedComponents(graph);
        ArrayList<List<Node>> tiers = new ArrayList<List<Node>>();
        for (List<Node> component : connectedComponents) {
            Node firstNode = component.get(0);
            HashMap<Node, Integer> componentTiers = new HashMap<Node, Integer>();
            this.placeNodes(firstNode, componentTiers, graph);
            MultiHashMap reversedMap = new MultiHashMap();
            for (Node _node : component) {
                Integer _tier = (Integer)componentTiers.get(_node);
                reversedMap.put(_tier, _node);
            }
            ArrayList indices = new ArrayList(reversedMap.keySet());
            Collections.sort(indices);
            int start = tiers.size();
            Iterator i$ = indices.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                Collection collection = (Collection)reversedMap.get(i);
                tiers.add(new ArrayList(collection));
            }
            for (int i = start; i < tiers.size() - 1; ++i) {
                List tier1 = (List)tiers.get(i);
                List tier2 = (List)tiers.get(i + 1);
                ArrayList saveArray = new ArrayList();
                int saveCrossings = Integer.MAX_VALUE;
                for (int j = 0; j < 4 * tier2.size(); ++j) {
                    Collections.shuffle(tier2);
                    int numCrossings = this.numCrossings(tier1, tier2, graph);
                    if (numCrossings >= saveCrossings) continue;
                    saveArray = new ArrayList(tier2);
                    saveCrossings = numCrossings;
                }
                tiers.set(i + 1, saveArray);
            }
        }
        return tiers;
    }

    private int numCrossings(List<Node> tier1, List<Node> tier2, Graph graph) {
        int[] choice;
        if (tier2.size() < 2) {
            return 0;
        }
        ChoiceGenerator cg = new ChoiceGenerator(tier2.size(), 2);
        int numCrossings = 0;
        while ((choice = cg.next()) != null) {
            List<Node> list1 = graph.getAdjacentNodes(tier2.get(choice[0]));
            List<Node> list2 = graph.getAdjacentNodes(tier2.get(choice[1]));
            list1.retainAll(tier1);
            list2.retainAll(tier1);
            for (Node node0 : list1) {
                for (Node node1 : list2) {
                    if (list1.indexOf(node0) <= list1.indexOf(node1)) continue;
                    ++numCrossings;
                }
            }
        }
        return numCrossings;
    }

    private void placeNodes(Node node, Map<Node, Integer> tiers, Graph graph) {
        if (tiers.keySet().contains(node)) {
            return;
        }
        Set<Node> keySet = tiers.keySet();
        List<Node> parents = graph.getParents(node);
        parents.retainAll(keySet);
        List<Node> children = graph.getChildren(node);
        children.retainAll(keySet);
        if (parents.isEmpty() && children.isEmpty()) {
            tiers.put(node, 0);
        } else {
            if (parents.isEmpty()) {
                int cMin = this.getCMin(children, tiers);
                tiers.put(node, cMin - 1);
                this.placeChildren(node, tiers, graph);
                return;
            }
            int pMax = this.getPMax(parents, tiers);
            int cMin = this.getCMin(children, tiers);
            tiers.put(node, pMax + 1);
            if (!children.isEmpty() && cMin < pMax + 2) {
                int diff = pMax + 2 - cMin;
                List<Node> descendants = graph.getDescendants(Collections.singletonList(node));
                descendants.retainAll(keySet);
                descendants.remove(node);
                for (Node descendant : descendants) {
                    Integer index = tiers.get(descendant);
                    tiers.put(descendant, index + diff);
                }
            }
        }
        this.placeChildren(node, tiers, graph);
    }

    private void placeChildren(Node node, Map<Node, Integer> tiers, Graph graph) {
        List<Node> adj = graph.getAdjacentNodes(node);
        for (Node _node : adj) {
            this.placeNodes(_node, tiers, graph);
        }
    }

    private int getPMax(List<Node> parents, Map<Node, Integer> tiers) {
        int pMax = Integer.MIN_VALUE;
        for (Node parent : parents) {
            Integer index = tiers.get(parent);
            if (index <= pMax) continue;
            pMax = index;
        }
        return pMax;
    }

    private int getCMin(List<Node> children, Map<Node, Integer> tiers) {
        int cMin = Integer.MAX_VALUE;
        for (Node child : children) {
            Integer index = tiers.get(child);
            if (index >= cMin) continue;
            cMin = index;
        }
        return cMin;
    }
}

