/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConstraint;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;

public final class NoEdgesIntoError
implements GraphConstraint {
    static final long serialVersionUID = 23L;

    public static NoEdgesIntoError serializableInstance() {
        return new NoEdgesIntoError();
    }

    @Override
    public boolean isEdgeAddable(Edge edge, Graph graph) {
        if (Edges.isDirectedEdge(edge)) {
            Node into = edge.getEndpoint1() == Endpoint.ARROW ? edge.getNode1() : edge.getNode2();
            return into.getNodeType() != NodeType.ERROR;
        }
        return true;
    }

    @Override
    public boolean isNodeAddable(Node node, Graph graph) {
        return true;
    }

    @Override
    public boolean isEdgeRemovable(Edge edge, Graph graph) {
        return true;
    }

    @Override
    public boolean isNodeRemovable(Node node, Graph graph) {
        return true;
    }

    @Override
    public String toString() {
        return "<Directed edges must be into non-error nodes.>";
    }
}

