/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.AtMostOneEdgePerPair;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConstraint;
import edu.cmu.tetrad.graph.MeasuredLatentOnly;
import edu.cmu.tetrad.graph.NoEdgesToSelf;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.util.TetradSerializable;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class Pag
implements TetradSerializable,
Graph {
    static final long serialVersionUID = 23L;
    private final GraphConstraint[] constraints = new GraphConstraint[]{new MeasuredLatentOnly(), new AtMostOneEdgePerPair(), new NoEdgesToSelf()};
    private final Graph graph = new EdgeListGraph();
    private List<Triple> underLineTriples;
    private List<Triple> dottedUnderLineTriples;

    public Pag() {
        List<GraphConstraint> constraints1 = Arrays.asList(this.constraints);
        for (GraphConstraint aConstraints1 : constraints1) {
            this.addGraphConstraint(aConstraints1);
        }
    }

    public Pag(Pag p) {
        this((Graph)p);
    }

    public Pag(List<Node> nodes) {
        this();
        if (nodes == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < nodes.size(); ++i) {
            if (nodes.get(i) == null) {
                throw new NullPointerException();
            }
            for (int j = 0; j < i; ++j) {
                if (!((Object)nodes.get(i)).equals(nodes.get(j))) continue;
                throw new IllegalArgumentException();
            }
        }
        for (Node variable : nodes) {
            if (this.addNode(variable)) continue;
            throw new IllegalArgumentException();
        }
    }

    public Pag(Graph graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new NullPointerException("Please specify a PAG.");
        }
        List<GraphConstraint> constraints1 = Arrays.asList(this.constraints);
        for (GraphConstraint aConstraints1 : constraints1) {
            this.addGraphConstraint(aConstraints1);
        }
        this.transferNodesAndEdges(graph);
        this.closeInducingPaths();
    }

    public static Pag serializableInstance() {
        return new Pag(Dag.serializableInstance());
    }

    @Override
    public final void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        this.getGraph().transferNodesAndEdges(graph);
    }

    public void closeInducingPaths() {
        LinkedList<Node> list = new LinkedList<Node>(this.getNodes());
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list.size(); ++j) {
                HashSet<Node> empty;
                HashSet<Node> allNodes;
                Node node2;
                Node node1;
                if (i == j || !this.existsInducingPath(node1 = (Node)list.get(i), node2 = (Node)list.get(j), allNodes = new HashSet<Node>(list), empty = new HashSet<Node>()) || !this.getEdges(node1, node2).isEmpty()) continue;
                this.addEdge(this.appropriateClosingEdge(node1, node2));
            }
        }
    }

    private Edge appropriateClosingEdge(Node node1, Node node2) {
        if (this.isAncestorOf(node1, node2)) {
            return Edges.directedEdge(node1, node2);
        }
        if (this.isAncestorOf(node2, node1)) {
            return Edges.directedEdge(node2, node1);
        }
        return Edges.nondirectedEdge(node1, node2);
    }

    @Override
    public void fullyConnect(Endpoint endpoint) {
        this.getGraph().fullyConnect(endpoint);
    }

    @Override
    public void reorientAllWith(Endpoint endpoint) {
        this.getGraph().reorientAllWith(endpoint);
    }

    @Override
    public Endpoint[][] getEndpointMatrix() {
        return this.getGraph().getEndpointMatrix();
    }

    @Override
    public List<Node> getAdjacentNodes(Node node) {
        return this.getGraph().getAdjacentNodes(node);
    }

    @Override
    public List<Node> getNodesInTo(Node node, Endpoint endpoint) {
        return this.getGraph().getNodesInTo(node, endpoint);
    }

    @Override
    public List<Node> getNodesOutTo(Node node, Endpoint n) {
        return this.getGraph().getNodesOutTo(node, n);
    }

    @Override
    public List<Node> getNodes() {
        return this.getGraph().getNodes();
    }

    @Override
    public List<String> getNodeNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        return this.getGraph().removeEdge(node1, node2);
    }

    @Override
    public boolean removeEdges(Node node1, Node node2) {
        return this.getGraph().removeEdges(node1, node2);
    }

    @Override
    public boolean isAdjacentTo(Node nodeX, Node nodeY) {
        return this.getGraph().isAdjacentTo(nodeX, nodeY);
    }

    @Override
    public boolean setEndpoint(Node node1, Node node2, Endpoint endpoint) {
        return this.getGraph().setEndpoint(node1, node2, endpoint);
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        return this.getGraph().getEndpoint(node1, node2);
    }

    @Override
    public Graph subgraph(List<Node> nodes) {
        return this.getGraph().subgraph(nodes);
    }

    @Override
    public boolean existsDirectedPathFromTo(Node node1, Node node2) {
        return this.getGraph().existsDirectedPathFromTo(node1, node2);
    }

    @Override
    public boolean existsUndirectedPathFromTo(Node node1, Node node2) {
        return this.getGraph().existsUndirectedPathFromTo(node1, node2);
    }

    @Override
    public boolean existsSemiDirectedPathFromTo(Node node1, Set<Node> nodes2) {
        return this.getGraph().existsSemiDirectedPathFromTo(node1, nodes2);
    }

    @Override
    public boolean addDirectedEdge(Node nodeA, Node nodeB) {
        return this.getGraph().addDirectedEdge(nodeA, nodeB);
    }

    @Override
    public boolean addUndirectedEdge(Node nodeA, Node nodeB) {
        return this.getGraph().addUndirectedEdge(nodeA, nodeB);
    }

    @Override
    public boolean addNondirectedEdge(Node nodeA, Node nodeB) {
        return this.getGraph().addNondirectedEdge(nodeA, nodeB);
    }

    @Override
    public boolean addPartiallyOrientedEdge(Node nodeA, Node nodeB) {
        return this.getGraph().addPartiallyOrientedEdge(nodeA, nodeB);
    }

    @Override
    public boolean addBidirectedEdge(Node nodeA, Node nodeB) {
        return this.getGraph().addBidirectedEdge(nodeA, nodeB);
    }

    @Override
    public boolean addEdge(Edge edge) {
        return this.getGraph().addEdge(edge);
    }

    @Override
    public boolean addNode(Node node) {
        return this.getGraph().addNode(node);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getGraph().addPropertyChangeListener(l);
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.getGraph().containsEdge(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.getGraph().containsNode(node);
    }

    @Override
    public List<Edge> getEdges() {
        return this.getGraph().getEdges();
    }

    @Override
    public List<Edge> getEdges(Node node) {
        return this.getGraph().getEdges(node);
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        return this.getGraph().getEdges(node1, node2);
    }

    @Override
    public Node getNode(String name) {
        return this.getGraph().getNode(name);
    }

    @Override
    public int getNumEdges() {
        return this.getGraph().getNumEdges();
    }

    @Override
    public int getNumNodes() {
        return this.getGraph().getNumNodes();
    }

    @Override
    public int getNumEdges(Node node) {
        return this.getGraph().getNumEdges(node);
    }

    @Override
    public List<GraphConstraint> getGraphConstraints() {
        return this.getGraph().getGraphConstraints();
    }

    @Override
    public boolean isGraphConstraintsChecked() {
        return this.getGraph().isGraphConstraintsChecked();
    }

    @Override
    public void setGraphConstraintsChecked(boolean checked) {
        this.getGraph().setGraphConstraintsChecked(checked);
    }

    @Override
    public boolean removeEdge(Edge edge) {
        return this.getGraph().removeEdge(edge);
    }

    @Override
    public boolean removeEdges(List<Edge> edges) {
        return this.getGraph().removeEdges(edges);
    }

    @Override
    public boolean removeNode(Node node) {
        return this.getGraph().removeNode(node);
    }

    @Override
    public void clear() {
        this.getGraph().clear();
    }

    @Override
    public boolean removeNodes(List<Node> nodes) {
        return this.getGraph().removeNodes(nodes);
    }

    @Override
    public boolean existsDirectedCycle() {
        return this.getGraph().existsDirectedCycle();
    }

    @Override
    public boolean isDirectedFromTo(Node node1, Node node2) {
        return this.getGraph().isDirectedFromTo(node1, node2);
    }

    @Override
    public boolean isUndirectedFromTo(Node node1, Node node2) {
        return this.getGraph().isUndirectedFromTo(node1, node2);
    }

    @Override
    public boolean defVisible(Edge edge) {
        return this.getGraph().defVisible(edge);
    }

    @Override
    public boolean existsTrek(Node node1, Node node2) {
        return this.getGraph().existsTrek(node1, node2);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return this.getGraph().getChildren(node);
    }

    @Override
    public int getConnectivity() {
        return this.getGraph().getConnectivity();
    }

    @Override
    public List<Node> getDescendants(List<Node> nodes) {
        return this.getGraph().getDescendants(nodes);
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        return this.getGraph().getEdge(node1, node2);
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        return this.getGraph().getDirectedEdge(node1, node2);
    }

    @Override
    public List<Node> getParents(Node node) {
        return this.getGraph().getParents(node);
    }

    @Override
    public int getIndegree(Node node) {
        return this.getGraph().getIndegree(node);
    }

    @Override
    public int getOutdegree(Node node) {
        return this.getGraph().getOutdegree(node);
    }

    @Override
    public boolean isAncestorOf(Node node1, Node node2) {
        return this.getGraph().isAncestorOf(node1, node2);
    }

    @Override
    public boolean possibleAncestor(Node node1, Node node2) {
        return this.getGraph().possibleAncestor(node1, node2);
    }

    @Override
    public List<Node> getAncestors(List<Node> nodes) {
        return this.getGraph().getAncestors(nodes);
    }

    @Override
    public boolean isChildOf(Node node1, Node node2) {
        return this.getGraph().isChildOf(node1, node2);
    }

    @Override
    public boolean isDescendentOf(Node node1, Node node2) {
        return this.getGraph().isDescendentOf(node1, node2);
    }

    @Override
    public boolean defNonDescendent(Node node1, Node node2) {
        return this.getGraph().defNonDescendent(node1, node2);
    }

    @Override
    public boolean isDefNoncollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefNoncollider(node1, node2, node3);
    }

    @Override
    public boolean isDefCollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefCollider(node1, node2, node3);
    }

    @Override
    public boolean isDConnectedTo(Node node1, Node node2, List<Node> conditioningNodes) {
        return this.getGraph().isDConnectedTo(node1, node2, conditioningNodes);
    }

    @Override
    public boolean isDSeparatedFrom(Node node1, Node node2, List<Node> z) {
        return this.getGraph().isDSeparatedFrom(node1, node2, z);
    }

    @Override
    public boolean possDConnectedTo(Node node1, Node node2, List<Node> z) {
        return this.getGraph().possDConnectedTo(node1, node2, z);
    }

    @Override
    public boolean existsInducingPath(Node node1, Node node2, Set<Node> observedNodes, Set<Node> conditioningNodes) {
        return this.getGraph().existsInducingPath(node1, node2, observedNodes, conditioningNodes);
    }

    @Override
    public boolean isParentOf(Node node1, Node node2) {
        return this.getGraph().isParentOf(node1, node2);
    }

    @Override
    public boolean isProperAncestorOf(Node node1, Node node2) {
        return this.getGraph().isProperAncestorOf(node1, node2);
    }

    @Override
    public boolean isProperDescendentOf(Node node1, Node node2) {
        return this.getGraph().isProperDescendentOf(node1, node2);
    }

    @Override
    public boolean isExogenous(Node node) {
        return this.getGraph().isExogenous(node);
    }

    @Override
    public String toString() {
        String graphString = ((Object)this.getGraph()).toString();
        String ulTrips = "Underline triples:   \n";
        for (Triple underLineTriple : this.getUnderLines()) {
            ulTrips = ulTrips + ((Object)underLineTriple).toString() + "\n";
        }
        String dotUlTrips = "Dotted underline triples:  \n";
        for (Triple dottedUnderLineTriple : this.getDottedUnderlines()) {
            dotUlTrips = dotUlTrips + ((Object)dottedUnderLineTriple).toString() + "\n";
        }
        return graphString + ulTrips + dotUlTrips;
    }

    @Override
    public boolean addGraphConstraint(GraphConstraint gc) {
        return this.getGraph().addGraphConstraint(gc);
    }

    @Override
    public Set<Triple> getAmbiguousTriples() {
        return this.getGraph().getAmbiguousTriples();
    }

    @Override
    public Set<Triple> getUnderLines() {
        return this.getGraph().getUnderLines();
    }

    @Override
    public Set<Triple> getDottedUnderlines() {
        return this.getGraph().getDottedUnderlines();
    }

    @Override
    public boolean isAmbiguousTriple(Node x, Node y, Node z) {
        return this.getGraph().isAmbiguousTriple(x, y, z);
    }

    @Override
    public boolean isUnderlineTriple(Node x, Node y, Node z) {
        return this.getGraph().isUnderlineTriple(x, y, z);
    }

    @Override
    public boolean isDottedUnderlineTriple(Node x, Node y, Node z) {
        return this.getGraph().isDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void addAmbiguousTriple(Node x, Node y, Node z) {
        this.getGraph().addAmbiguousTriple(x, y, z);
    }

    @Override
    public void addUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().addUnderlineTriple(x, y, z);
    }

    @Override
    public void addDottedUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().addDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void removeAmbiguousTriple(Node x, Node y, Node z) {
        this.getGraph().removeAmbiguousTriple(x, y, z);
    }

    @Override
    public void removeUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().removeUnderlineTriple(x, y, z);
    }

    @Override
    public void removeDottedUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().removeDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void setAmbiguousTriples(Set<Triple> triples) {
        this.getGraph().setAmbiguousTriples(triples);
    }

    @Override
    public void setUnderLineTriples(Set<Triple> triples) {
        this.getGraph().setUnderLineTriples(triples);
    }

    @Override
    public void setDottedUnderLineTriples(Set<Triple> triples) {
        this.getGraph().setDottedUnderLineTriples(triples);
    }

    @Override
    public List<Node> getTierOrdering() {
        return this.getGraph().getTierOrdering();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public int hashCode() {
        int hashCode = 17;
        for (Node node : this.getNodes()) {
            hashCode += 23 * ((Object)node).hashCode();
        }
        for (Edge edge : this.getEdges()) {
            hashCode += 29 * edge.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Graph pag = (Graph)o;
        List<Node> tNodes = pag.getNodes();
        List<Node> oNodes = this.getGraph().getNodes();
        Iterator<Node> it = tNodes.iterator();
        block0: while (it.hasNext()) {
            Node thisNode = it.next();
            Iterator<Node> it2 = oNodes.iterator();
            while (it2.hasNext()) {
                Node otherNode = it2.next();
                if (!thisNode.getName().equals(otherNode.getName())) continue;
                it.remove();
                it2.remove();
                continue block0;
            }
        }
        if (!tNodes.isEmpty() || !oNodes.isEmpty()) {
            return false;
        }
        List<Edge> tEdges = pag.getEdges();
        List<Edge> oEdges = this.getGraph().getEdges();
        Iterator<Edge> it2 = tEdges.iterator();
        block2: while (it2.hasNext()) {
            Edge thisEdge = it2.next();
            Iterator<Edge> it22 = oEdges.iterator();
            while (it22.hasNext()) {
                Edge otherEdge = it22.next();
                if (!thisEdge.equals(otherEdge)) continue;
                it2.remove();
                it22.remove();
                continue block2;
            }
        }
        if (!tEdges.isEmpty() || !oEdges.isEmpty()) {
            return false;
        }
        if (!new HashSet<Triple>(this.getUnderLines()).equals(new HashSet<Triple>(pag.getUnderLines()))) {
            return false;
        }
        return new HashSet<Triple>(this.getDottedUnderlines()).equals(new HashSet<Triple>(pag.getDottedUnderlines()));
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getGraph() == null) {
            throw new NullPointerException();
        }
        if (this.underLineTriples != null) {
            this.getGraph().setUnderLineTriples(new HashSet<Triple>(this.underLineTriples));
            this.underLineTriples = null;
        }
        if (this.dottedUnderLineTriples != null) {
            this.getGraph().setDottedUnderLineTriples(new HashSet<Triple>(this.dottedUnderLineTriples));
            this.dottedUnderLineTriples = null;
        }
    }
}

