/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConstraint;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.util.TetradSerializable;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SemGraph
implements Graph,
TetradSerializable {
    static final long serialVersionUID = 23L;
    private final Graph graph;
    private Map<Node, Node> errorNodes = new HashMap<Node, Node>();
    private Map<Node, Node> rememberedErrorNodes;
    private boolean showErrorTerms = false;

    public SemGraph() {
        this.graph = new EdgeListGraph();
    }

    public SemGraph(Graph graph) {
        if (graph instanceof SemGraph) {
            this.graph = new EdgeListGraph(graph);
            this.errorNodes = new HashMap<Node, Node>(((SemGraph)graph).errorNodes);
            this.showErrorTerms = ((SemGraph)graph).showErrorTerms;
        } else {
            this.graph = new EdgeListGraph();
            for (Node node : graph.getNodes()) {
                this.addNode(node);
            }
            this.setGraphConstraintsChecked(false);
            for (Edge edge : graph.getEdges()) {
                if (Edges.isDirectedEdge(edge)) {
                    this.addEdge(edge);
                    continue;
                }
                if (Edges.isBidirectedEdge(edge)) {
                    Node node1 = edge.getNode1();
                    Node node2 = edge.getNode2();
                    this.addBidirectedEdge(this.getExogenous(node1), this.getExogenous(node2));
                    continue;
                }
                throw new IllegalArgumentException("A SEM graph may contain only directed and bidirected edges: " + edge);
            }
            this.setGraphConstraintsChecked(true);
        }
    }

    public SemGraph(SemGraph graph) {
        this.graph = new EdgeListGraph(graph.getGraph());
        this.errorNodes = new HashMap<Node, Node>(graph.errorNodes);
        this.showErrorTerms = graph.showErrorTerms;
    }

    public static SemGraph serializableInstance() {
        return new SemGraph();
    }

    public Node getErrorNode(Node node) {
        return this.errorNodes.get(node);
    }

    public List<List<Node>> getTiers() {
        HashSet found = new HashSet();
        HashSet<Node> notFound = new HashSet<Node>();
        LinkedList<List<Node>> tiers = new LinkedList<List<Node>>();
        for (Node node : this.getNodes()) {
            notFound.add(node);
        }
        while (!notFound.isEmpty()) {
            LinkedList<Node> thisTier = new LinkedList<Node>();
            for (Node aNotFound : notFound) {
                if (!found.containsAll(this.getParents(aNotFound))) continue;
                thisTier.add(aNotFound);
            }
            notFound.removeAll(thisTier);
            found.addAll(thisTier);
            tiers.add(thisTier);
        }
        return tiers;
    }

    @Override
    public List<Node> getTierOrdering() {
        if (this.existsDirectedCycle()) {
            throw new IllegalStateException("The tier ordering method assumes acyclicity.");
        }
        LinkedList<Node> found = new LinkedList<Node>();
        HashSet<Node> notFound = new HashSet<Node>();
        for (Node node1 : this.getNodes()) {
            notFound.add(node1);
        }
        LinkedList<Node> errorTerms = new LinkedList<Node>();
        for (Node node : notFound) {
            if (node.getNodeType() != NodeType.ERROR) continue;
            errorTerms.add(node);
        }
        notFound.removeAll(errorTerms);
        while (!notFound.isEmpty()) {
            Iterator it = notFound.iterator();
            while (it.hasNext()) {
                Node node;
                node = (Node)it.next();
                List<Node> parents = this.getParents(node);
                parents.removeAll(errorTerms);
                if (!found.containsAll(parents)) continue;
                found.add(node);
                it.remove();
            }
        }
        return found;
    }

    public List<Node> getFullTierOrdering() {
        if (this.existsDirectedCycle()) {
            throw new IllegalStateException("The tier ordering method assumes acyclicity.");
        }
        LinkedList<Node> found = new LinkedList<Node>();
        HashSet<Node> notFound = new HashSet<Node>(this.getNodes());
        while (!notFound.isEmpty()) {
            Iterator it = notFound.iterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                List<Node> parents = this.getParents(node);
                if (!found.containsAll(parents)) continue;
                found.add(node);
                it.remove();
            }
        }
        return found;
    }

    public void printTiers() {
        List<List<Node>> tiers = this.getTiers();
        System.out.println();
        for (List<Node> thisTier : tiers) {
            for (Node thisNode : thisTier) {
                System.out.print(thisNode + "\t");
            }
            System.out.println();
        }
        System.out.println("done");
    }

    public void printTierOrdering() {
        List<Node> v = this.getTierOrdering();
        System.out.println();
        for (Node aV : v) {
            System.out.print(aV + "\t");
        }
        System.out.println();
    }

    public static boolean isErrorEdge(Edge edge) {
        return edge.getNode1().getNodeType() == NodeType.ERROR || edge.getNode2().getNodeType() == NodeType.ERROR;
    }

    public Node getVarNode(Node node) {
        boolean isError;
        boolean bl = isError = node.getNodeType() == NodeType.ERROR;
        if (!this.containsNode(node)) {
            throw new IllegalArgumentException("Node is not in graph: " + node);
        }
        if (isError) {
            return GraphUtils.getAssociatedNode(node, this);
        }
        return node;
    }

    public Node getExogenous(Node node) {
        return this.isExogenous(node) ? node : this.errorNodes.get(node);
    }

    @Override
    public final void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Triple> getAmbiguousTriples() {
        return this.getGraph().getAmbiguousTriples();
    }

    @Override
    public Set<Triple> getUnderLines() {
        return this.getGraph().getUnderLines();
    }

    @Override
    public Set<Triple> getDottedUnderlines() {
        return this.getGraph().getDottedUnderlines();
    }

    @Override
    public boolean isAmbiguousTriple(Node x, Node y, Node z) {
        return this.getGraph().isAmbiguousTriple(x, y, z);
    }

    @Override
    public boolean isUnderlineTriple(Node x, Node y, Node z) {
        return this.getGraph().isUnderlineTriple(x, y, z);
    }

    @Override
    public boolean isDottedUnderlineTriple(Node x, Node y, Node z) {
        return this.getGraph().isDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void addAmbiguousTriple(Node x, Node y, Node z) {
        this.getGraph().addAmbiguousTriple(x, y, z);
    }

    @Override
    public void addUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().addUnderlineTriple(x, y, z);
    }

    @Override
    public void addDottedUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().addDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void removeAmbiguousTriple(Node x, Node y, Node z) {
        this.getGraph().removeAmbiguousTriple(x, y, z);
    }

    @Override
    public void removeUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().removeUnderlineTriple(x, y, z);
    }

    @Override
    public void removeDottedUnderlineTriple(Node x, Node y, Node z) {
        this.getGraph().removeDottedUnderlineTriple(x, y, z);
    }

    @Override
    public void setAmbiguousTriples(Set<Triple> triples) {
        this.getGraph().setAmbiguousTriples(triples);
    }

    @Override
    public void setUnderLineTriples(Set<Triple> triples) {
        this.getGraph().setUnderLineTriples(triples);
    }

    @Override
    public void setDottedUnderLineTriples(Set<Triple> triples) {
        this.getGraph().setDottedUnderLineTriples(triples);
    }

    @Override
    public List<String> getNodeNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public void fullyConnect(Endpoint endpoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reorientAllWith(Endpoint endpoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Endpoint[][] getEndpointMatrix() {
        return this.getGraph().getEndpointMatrix();
    }

    @Override
    public List<Node> getAdjacentNodes(Node node) {
        return this.getGraph().getAdjacentNodes(node);
    }

    @Override
    public List<Node> getNodesInTo(Node node, Endpoint endpoint) {
        return this.getGraph().getNodesInTo(node, endpoint);
    }

    @Override
    public List<Node> getNodesOutTo(Node node, Endpoint n) {
        return this.getGraph().getNodesOutTo(node, n);
    }

    @Override
    public List<Node> getNodes() {
        return this.getGraph().getNodes();
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        List<Edge> edges = this.getEdges(node1, node2);
        if (edges.size() > 1) {
            throw new IllegalStateException("There is more than one edge between " + node1 + " and " + node2);
        }
        return this.removeEdges(edges);
    }

    @Override
    public boolean removeEdges(Node node1, Node node2) {
        return this.removeEdges(this.getEdges(node1, node2));
    }

    @Override
    public boolean isAdjacentTo(Node nodeX, Node nodeY) {
        return this.getGraph().isAdjacentTo(nodeX, nodeY);
    }

    @Override
    public boolean setEndpoint(Node node1, Node node2, Endpoint endpoint) {
        return this.getGraph().setEndpoint(node1, node2, endpoint);
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        return this.getGraph().getEndpoint(node1, node2);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.getGraph()).equals(o);
    }

    @Override
    public Graph subgraph(List<Node> nodes) {
        return this.getGraph().subgraph(nodes);
    }

    @Override
    public boolean existsDirectedPathFromTo(Node node1, Node node2) {
        return this.getGraph().existsDirectedPathFromTo(node1, node2);
    }

    @Override
    public boolean existsUndirectedPathFromTo(Node node1, Node node2) {
        return this.getGraph().existsUndirectedPathFromTo(node1, node2);
    }

    @Override
    public boolean existsSemiDirectedPathFromTo(Node node1, Set<Node> nodes2) {
        return this.getGraph().existsSemiDirectedPathFromTo(node1, nodes2);
    }

    @Override
    public boolean addDirectedEdge(Node nodeA, Node nodeB) {
        return this.addEdge(Edges.directedEdge(nodeA, nodeB));
    }

    @Override
    public boolean addUndirectedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addNondirectedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addPartiallyOrientedEdge(Node nodeA, Node nodeB) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addBidirectedEdge(Node nodeA, Node nodeB) {
        return this.addEdge(Edges.bidirectedEdge(nodeA, nodeB));
    }

    @Override
    public boolean addEdge(Edge edge) {
        Node node1 = edge.getNode1();
        Node node2 = edge.getNode2();
        if (!this.getGraph().containsNode(node1) || !this.getGraph().containsNode(node2)) {
            throw new IllegalArgumentException("Nodes for edge must be in graph already: " + edge);
        }
        if (Edges.isDirectedEdge(edge)) {
            if (this.getGraph().containsEdge(edge)) {
                return false;
            }
            Node head = Edges.getDirectedEdgeHead(edge);
            if (head.getNodeType() == NodeType.ERROR) {
                return false;
            }
            this.getGraph().addEdge(edge);
            this.adjustErrorForNode(head);
            return true;
        }
        if (Edges.isBidirectedEdge(edge)) {
            if (this.getGraph().containsEdge(edge)) {
                return false;
            }
            this.getGraph().addEdge(edge);
            return true;
        }
        throw new IllegalArgumentException("Only directed and bidirected edges allowed.");
    }

    @Override
    public boolean addNode(Node node) {
        if (node.getNodeType() == NodeType.ERROR) {
            throw new IllegalArgumentException("Error nodes cannot be added directly to the graph: " + node);
        }
        return this.getGraph().addNode(node);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getGraph().addPropertyChangeListener(l);
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.getGraph().containsEdge(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.getGraph().containsNode(node);
    }

    @Override
    public List<Edge> getEdges() {
        return this.getGraph().getEdges();
    }

    @Override
    public List<Edge> getEdges(Node node) {
        return this.getGraph().getEdges(node);
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        return this.getGraph().getEdges(node1, node2);
    }

    @Override
    public Node getNode(String name) {
        return this.getGraph().getNode(name);
    }

    @Override
    public int getNumEdges() {
        return this.getGraph().getNumEdges();
    }

    @Override
    public int getNumNodes() {
        return this.getGraph().getNumNodes();
    }

    @Override
    public int getNumEdges(Node node) {
        return this.getGraph().getNumEdges(node);
    }

    @Override
    public List<GraphConstraint> getGraphConstraints() {
        return this.getGraph().getGraphConstraints();
    }

    @Override
    public boolean isGraphConstraintsChecked() {
        return this.getGraph().isGraphConstraintsChecked();
    }

    @Override
    public void setGraphConstraintsChecked(boolean checked) {
        this.getGraph().setGraphConstraintsChecked(checked);
    }

    @Override
    public boolean removeEdge(Edge edge) {
        if (!this.getGraph().containsEdge(edge)) {
            throw new IllegalArgumentException("Can only remove edges that are already in the graph: " + edge);
        }
        if (Edges.isDirectedEdge(edge)) {
            Node head = Edges.getDirectedEdgeHead(edge);
            Node tail = Edges.getDirectedEdgeTail(edge);
            if (tail.getNodeType() != NodeType.ERROR) {
                this.getGraph().removeEdge(edge);
                this.adjustErrorForNode(head);
                return true;
            }
            return false;
        }
        if (Edges.isBidirectedEdge(edge)) {
            return this.getGraph().removeEdge(edge);
        }
        throw new IllegalArgumentException("Only directed and bidirected edges allowed.");
    }

    @Override
    public boolean removeEdges(List<Edge> edges) {
        boolean change = false;
        for (Edge edge : edges) {
            boolean _change = this.removeEdge(edge);
            change = change || _change;
        }
        return change;
    }

    @Override
    public boolean removeNode(Node node) {
        if (!this.getGraph().containsNode(node)) {
            throw new IllegalArgumentException("Graph must contain node: " + node);
        }
        if (node.getNodeType() == NodeType.ERROR) {
            throw new IllegalArgumentException("Error nodes cannot be removed directly from the graph: " + node);
        }
        Node errorNode = this.getErrorNode(node);
        if (errorNode != null) {
            this.getGraph().removeNode(errorNode);
            this.errorNodes.remove(errorNode);
            this.errorNodes.remove(node);
        }
        List<Node> children = this.getGraph().getChildren(node);
        this.getGraph().removeNode(node);
        for (int i = 0; i > children.size(); ++i) {
            Node child = children.get(i);
            this.adjustErrorForNode(child);
        }
        return true;
    }

    @Override
    public void clear() {
        this.getGraph().clear();
    }

    @Override
    public boolean removeNodes(List<Node> nodes) {
        return this.getGraph().removeNodes(nodes);
    }

    @Override
    public boolean existsDirectedCycle() {
        return this.getGraph().existsDirectedCycle();
    }

    @Override
    public boolean isDirectedFromTo(Node node1, Node node2) {
        return this.getGraph().isDirectedFromTo(node1, node2);
    }

    @Override
    public boolean isUndirectedFromTo(Node node1, Node node2) {
        return this.getGraph().isUndirectedFromTo(node1, node2);
    }

    @Override
    public boolean defVisible(Edge edge) {
        return this.getGraph().defVisible(edge);
    }

    @Override
    public boolean isDefNoncollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefNoncollider(node1, node2, node3);
    }

    @Override
    public boolean isDefCollider(Node node1, Node node2, Node node3) {
        return this.getGraph().isDefCollider(node1, node2, node3);
    }

    @Override
    public boolean existsTrek(Node node1, Node node2) {
        return this.getGraph().existsTrek(node1, node2);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return this.getGraph().getChildren(node);
    }

    @Override
    public int getConnectivity() {
        return this.getGraph().getConnectivity();
    }

    @Override
    public List<Node> getDescendants(List<Node> nodes) {
        return this.getGraph().getDescendants(nodes);
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        return this.getGraph().getEdge(node1, node2);
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        return this.getGraph().getDirectedEdge(node1, node2);
    }

    @Override
    public List<Node> getParents(Node node) {
        return this.getGraph().getParents(node);
    }

    @Override
    public int getIndegree(Node node) {
        return this.getGraph().getIndegree(node);
    }

    @Override
    public int getOutdegree(Node node) {
        return this.getGraph().getOutdegree(node);
    }

    @Override
    public boolean isAncestorOf(Node node1, Node node2) {
        return this.getGraph().isAncestorOf(node1, node2);
    }

    @Override
    public boolean possibleAncestor(Node node1, Node node2) {
        return this.getGraph().possibleAncestor(node1, node2);
    }

    @Override
    public List<Node> getAncestors(List<Node> nodes) {
        return this.getGraph().getAncestors(nodes);
    }

    @Override
    public boolean isChildOf(Node node1, Node node2) {
        return this.getGraph().isChildOf(node1, node2);
    }

    @Override
    public boolean isDescendentOf(Node node1, Node node2) {
        return this.getGraph().isDescendentOf(node1, node2);
    }

    @Override
    public boolean defNonDescendent(Node node1, Node node2) {
        return this.getGraph().defNonDescendent(node1, node2);
    }

    @Override
    public boolean isDConnectedTo(Node node1, Node node2, List<Node> conditioningNodes) {
        return this.getGraph().isDConnectedTo(node1, node2, conditioningNodes);
    }

    @Override
    public boolean isDSeparatedFrom(Node node1, Node node2, List<Node> z) {
        return this.getGraph().isDSeparatedFrom(node1, node2, z);
    }

    @Override
    public boolean possDConnectedTo(Node node1, Node node2, List<Node> z) {
        return this.getGraph().possDConnectedTo(node1, node2, z);
    }

    @Override
    public boolean existsInducingPath(Node node1, Node node2, Set<Node> observedNodes, Set<Node> conditioningNodes) {
        return this.getGraph().existsInducingPath(node1, node2, observedNodes, conditioningNodes);
    }

    @Override
    public boolean isParentOf(Node node1, Node node2) {
        return this.getGraph().isParentOf(node1, node2);
    }

    @Override
    public boolean isProperAncestorOf(Node node1, Node node2) {
        return this.getGraph().isProperAncestorOf(node1, node2);
    }

    @Override
    public boolean isProperDescendentOf(Node node1, Node node2) {
        return this.getGraph().isProperDescendentOf(node1, node2);
    }

    @Override
    public boolean isExogenous(Node node) {
        return this.getGraph().isExogenous(node) || this.isShowErrorTerms() && this.getErrorNode(node) == null;
    }

    @Override
    public String toString() {
        return ((Object)this.getGraph()).toString();
    }

    @Override
    public boolean addGraphConstraint(GraphConstraint gc) {
        throw new UnsupportedOperationException();
    }

    public boolean isShowErrorTerms() {
        return this.showErrorTerms;
    }

    public void setShowErrorTerms(boolean showErrorTerms) {
        this.showErrorTerms = showErrorTerms;
        List<Node> nodes = this.getNodes();
        for (Node node : nodes) {
            if (node.getNodeType() == NodeType.ERROR) continue;
            this.adjustErrorForNode(node);
        }
    }

    private Node addErrorNode(Node node) {
        if (this.errorNodes.get(node) != null) {
            throw new IllegalArgumentException("Node already in map.");
        }
        List<Node> nodes = this.getGraph().getNodes();
        Node error = this.errorNodes().get(node);
        if (error == null) {
            error = new GraphNode("E_" + node.getName());
            error.setCenter(node.getCenterX() + 50, node.getCenterY() + 50);
            error.setNodeType(NodeType.ERROR);
            this.errorNodes.put(node, error);
        }
        for (Node possibleError : nodes) {
            if (!error.getName().equals(possibleError.getName())) continue;
            this.moveAttachedBidirectedEdges(possibleError, node);
            this.getGraph().removeNode(possibleError);
            this.errorNodes.remove(node);
            this.errorNodes.remove(possibleError);
        }
        this.getGraph().addNode(error);
        this.errorNodes.put(node, error);
        this.errorNodes.put(error, error);
        this.addEdge(Edges.directedEdge(error, node));
        return error;
    }

    private Map<Node, Node> errorNodes() {
        if (this.errorNodes == null) {
            this.errorNodes = new HashMap<Node, Node>();
        }
        return this.errorNodes;
    }

    private void moveAttachedBidirectedEdges(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            throw new IllegalArgumentException("Node must not be null.");
        }
        LinkedList<Edge> attachedEdges = new LinkedList<Edge>(this.getGraph().getEdges(node1));
        for (Edge edge : attachedEdges) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            this.getGraph().removeEdge(edge);
            Node distal = edge.getDistalNode(node1);
            this.getGraph().addBidirectedEdge(node2, distal);
        }
    }

    private void adjustErrorForNode(Node node) {
        if (!this.showErrorTerms) {
            Node errorNode = this.getErrorNode(node);
            if (errorNode != null) {
                this.moveAttachedBidirectedEdges(errorNode, node);
                this.getGraph().removeNode(errorNode);
                this.errorNodes.remove(node);
                this.errorNodes.remove(errorNode);
            }
        } else {
            Node errorNode = this.getErrorNode(node);
            if (errorNode == null) {
                this.addErrorNode(node);
            }
            errorNode = this.getErrorNode(node);
            this.moveAttachedBidirectedEdges(node, errorNode);
        }
    }

    private boolean shouldBeExogenous(Node node) {
        List<Node> parents = this.getGraph().getParents(node);
        for (Node parent : parents) {
            if (parent.getNodeType() == NodeType.ERROR) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getGraph() == null) {
            throw new NullPointerException();
        }
    }

    private Graph getGraph() {
        return this.graph;
    }

    public void resetErrorPositions() {
        for (Node node : this.getNodes()) {
            Node error = this.errorNodes().get(node);
            if (error == null) continue;
            error.setCenter(node.getCenterX() + 50, node.getCenterY() + 50);
        }
    }
}

