/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestEndpointMatrixGraph
extends TestCase {
    private Node x1;
    private Node x2;
    private Node x3;
    private Node x4;
    private Node x5;
    private Graph graph;

    public TestEndpointMatrixGraph(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        this.x1 = new GraphNode("x1");
        this.x2 = new GraphNode("x2");
        this.x3 = new GraphNode("x3");
        this.x4 = new GraphNode("x4");
        this.x5 = new GraphNode("x5");
        this.graph = new EdgeListGraph();
    }

    public void testSequence1() {
        this.graph.clear();
        this.graph.addNode(this.x1);
        this.graph.addNode(this.x2);
        this.graph.addNode(this.x3);
        this.graph.addNode(this.x4);
        this.graph.addNode(this.x5);
        this.graph.addDirectedEdge(this.x1, this.x2);
        this.graph.addDirectedEdge(this.x2, this.x3);
        this.graph.addDirectedEdge(this.x3, this.x4);
        List<Node> children = this.graph.getChildren(this.x1);
        List<Node> parents = this.graph.getParents(this.x4);
        TestEndpointMatrixGraph.assertEquals(children, Collections.singletonList(this.x2));
        TestEndpointMatrixGraph.assertEquals(parents, Collections.singletonList(this.x3));
        TestEndpointMatrixGraph.assertTrue(this.graph.isDConnectedTo(this.x1, this.x3, new LinkedList<Node>()));
        this.graph.removeNode(this.x2);
        TestEndpointMatrixGraph.assertTrue(!this.graph.existsDirectedCycle());
        EdgeListGraph graph2 = new EdgeListGraph(this.graph);
        TestEndpointMatrixGraph.assertEquals(this.graph, graph2);
        EdgeListGraph graph3 = new EdgeListGraph(this.graph);
        TestEndpointMatrixGraph.assertEquals(this.graph, graph3);
    }

    public void testSequence2() {
        this.graph.clear();
        this.graph.addNode(this.x1);
        this.graph.addNode(this.x2);
        this.graph.addNode(this.x3);
        this.graph.addNode(this.x4);
        this.graph.addNode(this.x5);
        TestEndpointMatrixGraph.assertTrue(!this.graph.existsDirectedCycle());
        this.graph.addDirectedEdge(this.x1, this.x3);
        try {
            this.graph.addDirectedEdge(this.x1, this.x3);
            TestEndpointMatrixGraph.fail("Shouldn't have been able to add an edge already in the graph.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.graph.addDirectedEdge(this.x3, this.x4);
        this.graph.addDirectedEdge(this.x4, this.x1);
        this.graph.addDirectedEdge(this.x1, this.x2);
        this.graph.addDirectedEdge(this.x2, this.x3);
        this.graph.addDirectedEdge(this.x3, this.x5);
        this.graph.addDirectedEdge(this.x5, this.x2);
        System.out.println(this.graph);
        TestEndpointMatrixGraph.assertTrue(this.graph.existsDirectedCycle());
        this.graph.removeEdge(this.x1, this.x3);
        this.graph.removeEdge(this.graph.getEdge(this.x3, this.x4));
        System.out.println(this.graph);
    }

    public static Test suite() {
        return new TestSuite(TestEndpointMatrixGraph.class);
    }
}

