/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import nu.xom.Element;
import nu.xom.ParsingException;

public final class TestGraph
extends TestCase {
    public TestGraph(String name) {
        super(name);
    }

    public void testSearchGraph() {
        this.checkGraph(new EdgeListGraph());
    }

    public void testEdgeListGraph() {
        this.checkGraph(new EdgeListGraph());
    }

    private void checkGraph(Graph graph) {
        this.checkAddRemoveNodes(graph);
        this.checkCopy(graph);
    }

    public void testXml() {
        Dag graph = GraphUtils.randomDag(10, 10, false);
        HashSet<Triple> ambiguousTriples = new HashSet<Triple>();
        ambiguousTriples.add(this.pickRandomTriple(graph));
        ambiguousTriples.add(this.pickRandomTriple(graph));
        graph.setAmbiguousTriples(ambiguousTriples);
        HashSet<Triple> underlineTriples = new HashSet<Triple>();
        underlineTriples.add(this.pickRandomTriple(graph));
        underlineTriples.add(this.pickRandomTriple(graph));
        graph.setUnderLineTriples(underlineTriples);
        HashSet<Triple> dottedUnderlineTriples = new HashSet<Triple>();
        dottedUnderlineTriples.add(this.pickRandomTriple(graph));
        dottedUnderlineTriples.add(this.pickRandomTriple(graph));
        graph.setDottedUnderLineTriples(dottedUnderlineTriples);
        System.out.println(graph);
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        for (Node node : graph.getNodes()) {
            nodes.put(node.getName(), node);
        }
        System.out.println(GraphUtils.graphToXml(graph));
        Element element = GraphUtils.convertToXml(graph);
        try {
            Graph _graph = GraphUtils.parseGraphXml(element, nodes);
            TestGraph.assertEquals(graph, _graph);
        }
        catch (ParsingException e) {
            e.printStackTrace();
        }
    }

    public void testTripleCode() {
        EdgeListGraph graph = new EdgeListGraph();
        GraphNode x = new GraphNode("X");
        GraphNode y = new GraphNode("Y");
        GraphNode z = new GraphNode("Z");
        GraphNode w = new GraphNode("W");
        graph.addNode(x);
        graph.addNode(y);
        graph.addNode(z);
        graph.addNode(w);
        graph.addDirectedEdge(x, z);
        graph.addDirectedEdge(y, z);
        graph.addDirectedEdge(z, w);
        graph.addAmbiguousTriple(x, z, w);
        graph.addUnderlineTriple(x, z, w);
        graph.addDottedUnderlineTriple(x, z, w);
        graph.addUnderlineTriple(y, z, w);
        graph.addUnderlineTriple(y, z, x);
        System.out.println("Ambiguous " + graph.getAmbiguousTriples());
        System.out.println("Underline " + graph.getUnderLines());
        System.out.println("Dotted underline " + graph.getDottedUnderlines());
        TestGraph.assertTrue(graph.getAmbiguousTriples().size() == 1);
        TestGraph.assertTrue(graph.getUnderLines().size() == 3);
        TestGraph.assertTrue(graph.getDottedUnderlines().size() == 1);
        TestGraph.assertTrue(graph.isAmbiguousTriple(x, z, w));
        TestGraph.assertTrue(!graph.isAmbiguousTriple(y, z, w));
        try {
            graph.isAmbiguousTriple(z, x, y);
            TestGraph.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            graph.isDottedUnderlineTriple(z, x, y);
            TestGraph.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        graph.removeAmbiguousTriple(x, z, w);
        graph.removeUnderlineTriple(x, z, w);
        graph.removeDottedUnderlineTriple(x, z, w);
        TestGraph.assertTrue(graph.getAmbiguousTriples().size() == 0);
        TestGraph.assertTrue(graph.getUnderLines().size() == 2);
        TestGraph.assertTrue(graph.getDottedUnderlines().size() == 0);
        graph.addAmbiguousTriple(x, z, w);
        graph.addUnderlineTriple(x, z, w);
        graph.addDottedUnderlineTriple(x, z, w);
        graph.removeNode(z);
        TestGraph.assertTrue(graph.getAmbiguousTriples().size() == 0);
        TestGraph.assertTrue(graph.getUnderLines().size() == 0);
        TestGraph.assertTrue(graph.getDottedUnderlines().size() == 0);
        graph.addNode(z);
        graph.addDirectedEdge(x, z);
        graph.addDirectedEdge(y, z);
        graph.addDirectedEdge(z, w);
        graph.addAmbiguousTriple(x, z, w);
        graph.addUnderlineTriple(x, z, w);
        graph.addDottedUnderlineTriple(x, z, w);
        graph.addUnderlineTriple(y, z, w);
        graph.addUnderlineTriple(y, z, x);
        graph.removeEdge(z, w);
        TestGraph.assertTrue(graph.getAmbiguousTriples().size() == 0);
        TestGraph.assertTrue(graph.getUnderLines().size() == 1);
        TestGraph.assertTrue(graph.getDottedUnderlines().size() == 0);
        graph.addDirectedEdge(z, w);
        HashSet<Triple> triples = new HashSet<Triple>();
        triples.add(new Triple(x, z, w));
        triples.add(new Triple(x, y, z));
        try {
            graph.setAmbiguousTriples(triples);
            TestGraph.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        triples.remove(new Triple(x, y, z));
        graph.setAmbiguousTriples(triples);
        graph.setUnderLineTriples(triples);
        graph.setDottedUnderLineTriples(triples);
    }

    private Triple pickRandomTriple(Graph graph) {
        List<Node> nodes = graph.getNodes();
        int trial = 0;
        while (++trial < 1000) {
            int j2;
            int j1;
            int i = RandomUtil.getInstance().nextInt(nodes.size());
            Node y = nodes.get(i);
            List<Node> adjCenter = graph.getAdjacentNodes(y);
            if (adjCenter.isEmpty() || (j1 = RandomUtil.getInstance().nextInt(adjCenter.size())) == (j2 = RandomUtil.getInstance().nextInt(adjCenter.size()))) continue;
            Node x = adjCenter.get(j1);
            Node z = adjCenter.get(j2);
            return new Triple(x, y, z);
        }
        throw new IllegalArgumentException("Couldn't find a random triple.");
    }

    private void checkAddRemoveNodes(Graph graph) {
        GraphNode x1 = new GraphNode("x1");
        GraphNode x2 = new GraphNode("x2");
        GraphNode x3 = new GraphNode("x3");
        GraphNode x4 = new GraphNode("x4");
        GraphNode x5 = new GraphNode("x5");
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addDirectedEdge(x1, x2);
        graph.addDirectedEdge(x2, x3);
        graph.addDirectedEdge(x3, x4);
        System.out.println(graph);
        List<Node> children = graph.getChildren(x1);
        List<Node> parents = graph.getParents(x4);
        System.out.println("Children of x1 = " + children);
        System.out.println("Parents of x4 = " + parents);
        TestGraph.assertTrue(graph.isDConnectedTo(x1, x3, new LinkedList<Node>()));
        graph.removeNode(x2);
        System.out.println("Without x2: " + graph);
    }

    private void checkCopy(Graph graph) {
        EdgeListGraph graph2 = new EdgeListGraph(graph);
        TestGraph.assertEquals(graph, graph2);
    }

    public static Test suite() {
        return new TestSuite(TestGraph.class);
    }
}

