/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.UniformGraphGenerator;
import edu.cmu.tetrad.graph.UniformGraphGenerator2;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestUniformGraphGenerator
extends TestCase {
    public TestUniformGraphGenerator(String name) {
        super(name);
    }

    public void testRandomDag1() {
        long start = System.currentTimeMillis();
        UniformGraphGenerator generator = new UniformGraphGenerator(0);
        generator.setNumNodes(20);
        generator.setMaxDegree(3);
        generator.setNumIterations(50000);
        generator.generate();
        long stop = System.currentTimeMillis();
        System.out.println("Elapsed time " + (stop - start) + " ms.");
        System.out.println(generator.getDag());
    }

    public void testRandomDag2() {
        long start = System.currentTimeMillis();
        UniformGraphGenerator generator = new UniformGraphGenerator(1);
        generator.setNumNodes(50);
        generator.setMaxDegree(4);
        generator.setMaxEdges(20);
        generator.generate();
        long stop = System.currentTimeMillis();
        System.out.println("Elapsed time " + (stop - start) + " ms.");
        System.out.println(generator.getDag());
    }

    public void testRandomDag3() {
        long start = System.currentTimeMillis();
        UniformGraphGenerator generator = new UniformGraphGenerator(1);
        generator.setNumNodes(20);
        generator.setMaxDegree(3);
        generator.setNumIterations(20000);
        generator.generate();
        long stop = System.currentTimeMillis();
        System.out.println("Elapsed time " + (stop - start) + " ms.");
        System.out.println(generator.getDag());
    }

    public void testRandomDag4() {
        long start = System.currentTimeMillis();
        UniformGraphGenerator generator = new UniformGraphGenerator(1);
        generator.setNumNodes(20);
        generator.setMaxInDegree(1);
        generator.setMaxDegree(3);
        generator.generate();
        long stop = System.currentTimeMillis();
        System.out.println("Elapsed time " + (stop - start) + " ms.");
        System.out.println(generator.getDag());
    }

    public void testRandomDag5() {
        long start = System.currentTimeMillis();
        UniformGraphGenerator generator = new UniformGraphGenerator(1);
        generator.setNumNodes(20);
        generator.setMaxDegree(3);
        generator.generate();
        long stop = System.currentTimeMillis();
        System.out.println("Elapsed time " + (stop - start) + " ms.");
        System.out.println(generator.getDag());
    }

    public void testRandomDag6() {
        long start = System.currentTimeMillis();
        UniformGraphGenerator generator = new UniformGraphGenerator(0);
        generator.setNumNodes(40);
        generator.setMaxDegree(39);
        generator.setMaxInDegree(2);
        generator.setMaxEdges(10);
        generator.generate();
        long stop = System.currentTimeMillis();
        System.out.println("Elapsed time " + (stop - start) + " ms.");
        generator.printEdges();
        System.out.println(generator.getDag());
    }

    public void testRandomDag7() {
        long start = System.currentTimeMillis();
        UniformGraphGenerator generator = new UniformGraphGenerator(1);
        generator.setNumNodes(20);
        generator.setMaxInDegree(2);
        generator.setMaxOutDegree(3);
        generator.generate();
        long stop = System.currentTimeMillis();
        System.out.println("Elapsed time " + (stop - start) + " ms.");
        System.out.println(generator.getDag());
    }

    public void testRandomDag8() {
        long start = System.currentTimeMillis();
        UniformGraphGenerator generator = new UniformGraphGenerator(1);
        generator.setNumNodes(15);
        generator.setMaxDegree(14);
        generator.generate();
        long stop = System.currentTimeMillis();
        System.out.println("Elapsed time " + (stop - start) + " ms.");
        System.out.println(generator.getDag());
    }

    public void testRandomDag9() {
        long start = System.currentTimeMillis();
        int N = 25;
        int E = N * (N - 1) / 2;
        System.out.println("N = " + N + ", E = " + E);
        UniformGraphGenerator2 generator = new UniformGraphGenerator2(0);
        generator.setNumNodes(N);
        generator.setMaxEdges(E);
        generator.setMinEdges(E - 5);
        generator.generate();
        long stop = System.currentTimeMillis();
        System.out.println("Elapsed time " + (stop - start) + " ms.");
        System.out.println(generator.getDag());
    }

    public static Test suite() {
        return new TestSuite(TestUniformGraphGenerator.class);
    }
}

