/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;

public final class Underline
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private final Node first;
    private final Node second;
    private final Node third;

    public Underline(Node u1, Node u2, Node u3) {
        if (u1 == null || u2 == null || u3 == null) {
            throw new IllegalArgumentException("An underline is determined by three non-null nodes");
        }
        this.first = u1;
        this.second = u2;
        this.third = u3;
    }

    public static Underline serializableInstance() {
        return new Underline(new GraphNode("X"), new GraphNode("Y"), new GraphNode("Z"));
    }

    public Node getFirst() {
        return this.first;
    }

    public Node getSecond() {
        return this.second;
    }

    public Node getThird() {
        return this.third;
    }

    public void print() {
        System.out.println("  " + this.first + " " + this.second + " " + this.third);
    }

    public String toString() {
        return "  " + this.first + " " + this.second + " " + this.third;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.first == null) {
            throw new NullPointerException();
        }
        if (this.second == null) {
            throw new NullPointerException();
        }
        if (this.third == null) {
            throw new NullPointerException();
        }
    }
}

