/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.manipulated_graph;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import edu.cmu.tetrad.manip.experimental_setup.VariableManipulation;
import edu.cmu.tetrad.manip.manipulated_graph.EdgeManipulation;
import edu.cmu.tetrad.manip.manipulated_graph.ManipulatedEdge;
import edu.cmu.tetrad.manip.manipulated_graph.ManipulatedGraph;
import junit.framework.TestCase;

public class TestManipulatedGraph
extends TestCase {
    Graph correctGraph;
    ExperimentalSetup experiment;

    public TestManipulatedGraph(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.correctGraph = this.makeModel("Education", "Income", "Happiness");
        this.experiment = new ExperimentalSetup("experiment 1", this.correctGraph);
    }

    public void testRandomizedType() {
        this.experiment.getVariable("Education").setRandomized();
        ManipulatedGraph manipulatedGraph = new ManipulatedGraph(this.correctGraph, this.experiment);
        TestManipulatedGraph.assertTrue(manipulatedGraph.getManipulationFor("Education") == VariableManipulation.RANDOMIZED);
        TestManipulatedGraph.assertTrue(manipulatedGraph.getManipulationFor("Income") == VariableManipulation.NONE);
        TestManipulatedGraph.assertTrue(manipulatedGraph.getManipulationFor("Happiness") == VariableManipulation.NONE);
        TestManipulatedGraph.assertTrue(manipulatedGraph.getManipulationFor("Latent") == VariableManipulation.NONE);
        TestManipulatedGraph.assertNull((Object)manipulatedGraph.getManipulationFor("foo"));
        ManipulatedEdge[] brokenEdges = manipulatedGraph.getBrokenEdges();
        TestManipulatedGraph.assertTrue(brokenEdges.length == 1);
        TestManipulatedGraph.assertTrue(brokenEdges[0].toString().equals("Latent --> Education"));
        TestManipulatedGraph.assertTrue(brokenEdges[0].getType() == EdgeManipulation.BROKEN);
    }

    public void testLockedType() {
        this.experiment.getVariable("Education").setLocked("fake value");
        ManipulatedGraph manipulatedGraph = new ManipulatedGraph(this.correctGraph, this.experiment);
        TestManipulatedGraph.assertTrue(manipulatedGraph.getManipulationFor("Education") == VariableManipulation.LOCKED);
        TestManipulatedGraph.assertTrue(manipulatedGraph.getManipulationFor("Income") == VariableManipulation.NONE);
        TestManipulatedGraph.assertTrue(manipulatedGraph.getManipulationFor("Happiness") == VariableManipulation.NONE);
        TestManipulatedGraph.assertTrue(manipulatedGraph.getManipulationFor("Latent") == VariableManipulation.NONE);
        TestManipulatedGraph.assertNull((Object)manipulatedGraph.getManipulationFor("foo"));
        ManipulatedEdge[] brokenEdges = manipulatedGraph.getBrokenEdges();
        ManipulatedEdge[] frozenEdges = manipulatedGraph.getFrozenEdges();
        TestManipulatedGraph.assertTrue(brokenEdges.length == 1);
        TestManipulatedGraph.assertTrue(frozenEdges.length == 2);
        TestManipulatedGraph.assertTrue(brokenEdges[0].toString().equals("Latent --> Education") && brokenEdges[0].getType() == EdgeManipulation.BROKEN);
        TestManipulatedGraph.assertTrue(frozenEdges[0].toString().equals("Education --> Income") && frozenEdges[0].getType() == EdgeManipulation.FROZEN);
        TestManipulatedGraph.assertTrue(frozenEdges[1].toString().equals("Education --> Happiness") && frozenEdges[1].getType() == EdgeManipulation.FROZEN);
    }

    private Graph makeModel(String a, String b, String c) {
        Dag m1 = new Dag();
        m1.addNode(new GraphNode(a));
        m1.addNode(new GraphNode(b));
        m1.addNode(new GraphNode(c));
        GraphNode tn = new GraphNode("Latent");
        tn.setNodeType(NodeType.LATENT);
        m1.addNode(tn);
        m1.addDirectedEdge(m1.getNode(a), m1.getNode(b));
        m1.addDirectedEdge(m1.getNode(a), m1.getNode(c));
        m1.addDirectedEdge(m1.getNode("Latent"), m1.getNode(a));
        return m1;
    }
}

