/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.sample;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetup;
import edu.cmu.tetrad.manip.manipulated_graph.AbstractManipulatedGraph;
import edu.cmu.tetrad.manip.manipulated_graph.ManipulatedGraph;
import edu.cmu.tetrad.manip.population.Population;
import edu.cmu.tetrad.manip.sample.BayesSample;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestSample
extends TestCase {
    Population pop;
    Graph graph;
    BayesPm pm;
    MlBayesIm im;
    ExperimentalSetup exp;
    ExperimentalSetup expVarStudied;
    AbstractManipulatedGraph manipGraph;
    BayesSample sample;
    long seed;

    public TestSample(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.makeModel();
        this.makePM(this.graph);
        this.makeIM(this.pm);
        this.makeExperiment(this.graph);
        this.makeManipulatedGraph(this.graph, this.exp);
        this.seed = System.currentTimeMillis();
        this.sample = new BayesSample(this.im, this.exp, 10, this.seed);
    }

    public void testGetNumSampleCases() {
        TestSample.assertTrue(this.sample.getNumSampleCases() == 10);
    }

    public void testGetSampleCase() {
        TestSample.assertTrue(this.sample.getSampleCase(0, this.expVarStudied).length == 4);
        this.expVarStudied.getVariable("education").setStudied(false);
        TestSample.assertTrue(this.sample.getSampleCase(0, this.expVarStudied).length == 3);
    }

    public void testGetSampleCaseColumnNames() {
        String[] headers = this.sample.getSampleCaseColumnNames(this.expVarStudied);
        TestSample.assertTrue(headers.length == 4);
        TestSample.assertTrue(headers[0].equals("#"));
        TestSample.assertTrue(headers[1].equals("education"));
        TestSample.assertTrue(headers[2].equals("happiness"));
        TestSample.assertTrue(headers[3].equals("income"));
    }

    public void testGetNumSampleCaseFrequencies() {
        TestSample.assertTrue(this.sample.getNumSampleCaseFrequencies(this.expVarStudied) == 18);
        this.expVarStudied.getVariable("education").setStudied(false);
        TestSample.assertTrue(this.sample.getNumSampleCaseFrequencies(this.expVarStudied) == 6);
    }

    public void testGetSampleFrequencies() {
        BayesSample aSample = new BayesSample(this.im, this.exp, 1000, this.seed);
        for (int i = 0; i < aSample.getNumSampleCaseFrequencies(this.expVarStudied); ++i) {
            double count1 = Population.getProbability(this.im, this.exp, this.expVarStudied, i);
            double count2 = aSample.getSampleCaseFrequency(i, this.expVarStudied);
            TestSample.assertEquals(count1, count2, 0.05);
        }
    }

    public void testGetSampleFrequenciesColumnNames() {
        String[] headers = this.sample.getSampleFrequenciesColumnNames(this.expVarStudied);
        TestSample.assertTrue(headers.length == 4);
        TestSample.assertTrue(headers[0].equals("education"));
        TestSample.assertTrue(headers[1].equals("happiness"));
        TestSample.assertTrue(headers[2].equals("income"));
        TestSample.assertTrue(headers[3].equals("%"));
    }

    public void rtest45() {
        for (int i = 0; i < 100; ++i) {
            Dag graph = GraphUtils.randomDag(10, 0, 10, 4, 4, 4, false);
            SemPm semPm = new SemPm(graph);
            SemIm semIm1 = new SemIm(semPm);
            SemIm semIm2 = new SemIm(semPm);
            DataSet dataSet = semIm1.simulateData(1000, false);
            DoubleMatrix2D sample = new CovarianceMatrix(dataSet).getMatrix();
            semIm2.setDataSet(dataSet);
            DoubleMatrix2D implied = semIm2.getImplCovar();
            double detSample = new Algebra().det(sample);
            double detImplied = new Algebra().det(implied);
            DoubleMatrix2D inverseImplied = new Algebra().inverse(implied);
            DoubleMatrix2D product = new Algebra().mult(sample, inverseImplied);
            double trace = new Algebra().trace(product);
            System.out.println(trace);
        }
    }

    public void testReCalculateFromSeed() {
        BayesSample sampleA = new BayesSample(this.im, this.exp, 10, this.seed);
        BayesSample sampleB = new BayesSample(this.im, this.exp, 10, this.seed);
        for (int i = 0; i < 10; ++i) {
            String[] caseA = sampleA.getSampleCase(i, this.expVarStudied);
            String[] caseB = sampleB.getSampleCase(i, this.expVarStudied);
            for (int j = 0; j < caseA.length; ++j) {
                TestSample.assertTrue(caseA[j].equals(caseB[j]));
            }
        }
    }

    private void makeModel() {
        Dag m1 = new Dag();
        m1.addNode(new GraphNode("education"));
        m1.addNode(new GraphNode("happiness"));
        m1.addNode(new GraphNode("income"));
        GraphNode tn = new GraphNode("Latent");
        tn.setNodeType(NodeType.LATENT);
        m1.addNode(tn);
        m1.addDirectedEdge(m1.getNode("education"), m1.getNode("happiness"));
        m1.addDirectedEdge(m1.getNode("education"), m1.getNode("income"));
        m1.addDirectedEdge(m1.getNode("Latent"), m1.getNode("education"));
        this.graph = m1;
    }

    private void makePM(Graph aGraph) {
        this.pm = new BayesPm(new Dag(aGraph));
        ArrayList<String> varVals = new ArrayList<String>();
        varVals.add("college");
        varVals.add("High school");
        varVals.add("none");
        this.pm.setCategories(this.pm.getDag().getNode("education"), varVals);
        varVals = new ArrayList();
        varVals.add("high");
        varVals.add("medium");
        varVals.add("low");
        this.pm.setCategories(this.pm.getDag().getNode("income"), varVals);
        varVals = new ArrayList();
        varVals.add("true");
        varVals.add("false");
        this.pm.setCategories(this.pm.getDag().getNode("happiness"), varVals);
        varVals = new ArrayList();
        varVals.add("true");
        varVals.add("false");
        this.pm.setCategories(this.pm.getDag().getNode("Latent"), varVals);
    }

    private void makeIM(BayesPm aPm) {
        this.im = new MlBayesIm(aPm);
        int i = this.im.getNodeIndex(this.im.getNode("Latent"));
        this.im.setProbability(i, 0, 0, 0.5);
        this.im.setProbability(i, 0, 1, 0.5);
        i = this.im.getNodeIndex(this.im.getNode("education"));
        this.im.setProbability(i, 0, 0, 0.3);
        this.im.setProbability(i, 0, 1, 0.3);
        this.im.setProbability(i, 0, 2, 0.4);
        this.im.setProbability(i, 1, 0, 0.3);
        this.im.setProbability(i, 1, 1, 0.3);
        this.im.setProbability(i, 1, 2, 0.4);
        i = this.im.getNodeIndex(this.im.getNode("happiness"));
        this.im.setProbability(i, 0, 0, 0.5);
        this.im.setProbability(i, 0, 1, 0.5);
        this.im.setProbability(i, 1, 0, 0.5);
        this.im.setProbability(i, 1, 1, 0.5);
        this.im.setProbability(i, 2, 0, 0.5);
        this.im.setProbability(i, 2, 1, 0.5);
        i = this.im.getNodeIndex(this.im.getNode("income"));
        this.im.setProbability(i, 0, 0, 0.3);
        this.im.setProbability(i, 0, 1, 0.3);
        this.im.setProbability(i, 0, 2, 0.4);
        this.im.setProbability(i, 1, 0, 0.3);
        this.im.setProbability(i, 1, 1, 0.3);
        this.im.setProbability(i, 1, 2, 0.4);
        this.im.setProbability(i, 2, 0, 0.3);
        this.im.setProbability(i, 2, 1, 0.3);
        this.im.setProbability(i, 2, 2, 0.4);
    }

    public void test5() {
        double d = 0.3333333333333333;
        System.out.println(d);
        double d2 = d - d % 0.01;
        System.out.println(d2);
    }

    private void makeExperiment(Graph aGraph) {
        this.exp = new ExperimentalSetup("experiment", aGraph);
        this.exp.getVariable("happiness").setLocked("true");
        this.exp.getVariable("income").setRandomized();
        this.exp.getVariable("happiness").setLocked("true");
        this.expVarStudied = this.exp;
    }

    private void makeManipulatedGraph(Graph aGraph, ExperimentalSetup exp) {
        this.manipGraph = new ManipulatedGraph(aGraph, exp);
    }
}

