/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.network;

import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

class ConnectionListener
extends Thread {
    private Vector<Socket> workers;
    private Vector<PrintWriter> workerStreams;
    private int expectedConnections;
    private boolean listen;
    private boolean done;
    private ServerSocket gateway;

    public ConnectionListener(Vector<Socket> workers, Vector<PrintWriter> workerStreams, int expectedConnections) {
        this.workers = workers;
        this.workerStreams = workerStreams;
        this.expectedConnections = expectedConnections;
        this.listen = true;
        this.done = false;
        try {
            this.gateway = new ServerSocket(10803);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void run() {
        System.out.println("Listener called run()");
        while (this.listen) {
            try {
                Socket socket = this.gateway.accept();
                this.workers.add(socket);
                this.workerStreams.add(new PrintWriter(socket.getOutputStream(), true));
                System.out.println("Now we have " + this.workers.size() + " many workers (expected: " + this.expectedConnections + ")");
                System.out.println(this.workers);
                if (this.workers.size() == this.expectedConnections) {
                    this.done = true;
                    this.listen = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            System.out.println("Cycling listener. . .");
        }
    }

    public void stopListening() {
        System.out.println("Halting listener.");
        this.listen = false;
    }
}

