/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.predict;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class OrderingGenerator {
    private int N;
    private boolean[] block;
    private int[] solution;
    private Graph pi;
    private List<Node> allNodes;
    private List<List<Node>> answers;

    public OrderingGenerator(Graph P) {
        this.pi = P;
        this.allNodes = this.pi.getNodes();
        this.N = this.allNodes.size();
        this.answers = new LinkedList<List<Node>>();
        this.block = new boolean[this.N];
        this.solution = new int[this.N];
        this.genOrds(0);
    }

    public void genOrds(int n) {
        if (n < this.N) {
            for (int i = 0; i < this.N; ++i) {
                if (this.block[i]) continue;
                this.block[i] = true;
                this.solution[n] = i;
                this.genOrds(n + 1);
                this.block[i] = false;
            }
        } else {
            int i;
            boolean[] flags = new boolean[this.N];
            for (i = 0; i < this.N; ++i) {
                flags[i] = true;
            }
            block2: for (i = 0; i < this.N; ++i) {
                int currIndex = this.solution[i];
                Node curr = this.allNodes.get(currIndex);
                List<Node> preds = this.pi.getAncestors(Collections.singletonList(curr));
                block3: for (Node pred : preds) {
                    if (!flags[i]) continue block2;
                    flags[i] = false;
                    int ancIndex = this.allNodes.indexOf(pred);
                    for (int a = 0; a <= i; ++a) {
                        if (this.solution[a] != ancIndex) continue;
                        flags[i] = true;
                        continue block3;
                    }
                }
            }
            boolean flg = true;
            for (int i2 = 0; i2 < this.N; ++i2) {
                if (flags[i2]) continue;
                flg = false;
                break;
            }
            if (flg) {
                LinkedList<Node> solList = new LinkedList<Node>();
                for (int i3 = 0; i3 < this.N; ++i3) {
                    solList.add(this.allNodes.get(this.solution[i3]));
                }
                this.answers.add(solList);
            }
        }
    }

    public List<List<Node>> getOrders() {
        return this.answers;
    }
}

