/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.regression;

import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;

public class LogisticRegressionResult
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private String result;
    private String[] variableNames;
    private String target;
    private int ny0;
    private int ny1;
    private int numRegressors;
    private double[] coefs;
    private double[] stdErrs;
    private double[] probs;
    private double[] xMeans;
    private double[] xStdDevs;
    private double intercept;

    public LogisticRegressionResult(String target, String[] variableNames, double[] xMeans, double[] xStdDevs, int numRegressors, int ny0, int ny1, double[] coefs, double[] stdErrs, double[] probs, double intercept, String result) {
        if (variableNames.length != numRegressors) {
            throw new IllegalArgumentException();
        }
        if (coefs.length != numRegressors + 1) {
            throw new IllegalArgumentException();
        }
        if (stdErrs.length != numRegressors + 1) {
            throw new IllegalArgumentException();
        }
        if (probs.length != numRegressors + 1) {
            throw new IllegalArgumentException();
        }
        if (xMeans.length != numRegressors + 1) {
            throw new IllegalArgumentException();
        }
        if (xStdDevs.length != numRegressors + 1) {
            throw new IllegalArgumentException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        this.intercept = intercept;
        this.target = target;
        this.xMeans = xMeans;
        this.xStdDevs = xStdDevs;
        this.variableNames = variableNames;
        this.numRegressors = numRegressors;
        this.ny0 = ny0;
        this.ny1 = ny1;
        this.coefs = coefs;
        this.stdErrs = stdErrs;
        this.probs = probs;
        this.result = result;
    }

    public static LogisticRegressionResult serializableInstance() {
        double[] values = new double[]{1.0, 2.0};
        return new LogisticRegressionResult("X1", new String[]{"X2"}, values, values, 1, 2, 3, values, values, values, 1.5, "");
    }

    public String getTarget() {
        return this.target;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public int getNumRegressors() {
        return this.numRegressors;
    }

    public int getNy0() {
        return this.ny0;
    }

    public int getNy1() {
        return this.ny1;
    }

    public int getnCases() {
        return this.ny0 + this.ny1;
    }

    public String[] getVariableNames() {
        return this.variableNames;
    }

    public double[] getCoefs() {
        return this.coefs;
    }

    public double[] getStdErrs() {
        return this.stdErrs;
    }

    public double[] getProbs() {
        return this.probs;
    }

    public String[] getVarNames() {
        return this.variableNames;
    }

    public String toString() {
        return this.result;
    }

    public double[] getxMeans() {
        return this.xMeans;
    }

    public double[] getxStdDevs() {
        return this.xStdDevs;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.xMeans == null) {
            throw new NullPointerException();
        }
        if (this.xStdDevs == null) {
            throw new NullPointerException();
        }
        if (this.variableNames == null) {
            throw new NullPointerException();
        }
        if (this.coefs == null) {
            throw new NullPointerException();
        }
        if (this.stdErrs == null) {
            throw new NullPointerException();
        }
        if (this.probs == null) {
            throw new NullPointerException();
        }
        if (this.result == null) {
            throw new NullPointerException();
        }
        if (this.target == null) {
            throw new NullPointerException();
        }
    }
}

