/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.regression;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.ProbUtils;
import java.io.PrintStream;
import java.text.NumberFormat;

public class RegressionOld {
    private NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private double alpha = 0.05;
    private double[][] regressors;
    private int sampleSize;
    private String[] regressorNames;
    private Graph outGraph;
    private PrintStream out = System.out;
    private PrintStream err = System.err;

    public double[][] getRegressors() {
        return this.regressors;
    }

    public void setRegressors(double[][] regressors) {
        if (regressors == null) {
            throw new NullPointerException("Regressor data must not be null.");
        }
        this.sampleSize = regressors[0].length;
        for (double[] regressor : regressors) {
            if (regressor == null) {
                throw new NullPointerException("All regressor columns must be non-null.");
            }
            if (regressor.length == this.sampleSize) continue;
            throw new IllegalArgumentException("Regressor data must all be the same length.");
        }
        this.regressors = regressors;
        this.regressorNames = null;
    }

    public String[] getRegressorNames() {
        return this.regressorNames;
    }

    public void setRegressorNames(String[] regressorNames) {
        if (regressorNames == null) {
            throw new NullPointerException("The variable names array must not be null.");
        }
        if (this.regressors == null) {
            throw new IllegalArgumentException("Please set the regressor data before setting the variable names; otherwise, I don't know whether you have the correct number of variable names.");
        }
        if (regressorNames.length != this.regressors.length) {
            throw new IllegalArgumentException("The number of variable names must match the number of regressors: " + regressorNames.length + " != " + this.regressors.length);
        }
        this.regressorNames = regressorNames;
    }

    public RegressionResult regress(double[] target, String targetName) {
        int k = this.regressors.length + 1;
        if (target.length != this.sampleSize) {
            throw new IllegalArgumentException("Target sample size must match regressor sample size.");
        }
        int n = this.sampleSize;
        if (target.length < this.regressors.length) {
            throw new IllegalArgumentException("Fewer sample points than regressors.");
        }
        this.outGraph = new EdgeListGraph();
        GraphNode targetNode = new GraphNode(targetName);
        this.outGraph.addNode(targetNode);
        double[][] x = new double[this.regressors.length + 1][];
        double[] c1 = new double[this.regressors[0].length];
        for (int i = 0; i < this.regressors[0].length; ++i) {
            c1[i] = 1.0;
        }
        x[0] = c1;
        System.arraycopy(this.regressors, 0, x, 1, this.regressors.length);
        double[][] y = new double[][]{target};
        double[][] xT = MatrixUtils.transpose(x);
        double[][] xTxInv = this.multiply(xT, x);
        xTxInv = MatrixUtils.inverse(xTxInv);
        double[][] pr2 = this.multiply(xT, y);
        double[][] b = this.multiply(xTxInv, pr2);
        double rss = this.residualSumOfSquares(x, y[0], b[0]);
        double se2 = rss / (double)(n - k);
        double[] t = new double[x.length];
        double[] p = new double[x.length];
        String summary = "\n REGRESSION RESULT";
        summary = summary + "\n n = " + n + ", k = " + k + ", alpha = " + this.alpha + "\n";
        String rssString = this.nf.format(rss);
        summary = summary + " SSE = " + rssString + "\n";
        double r2 = 1.0 - rss / this.calculateSSM(y[0]);
        String r2String = this.nf.format(r2);
        summary = summary + " R^2 = " + r2String + "\n\n";
        summary = summary + " VAR\tCOEF\tSE\tT\tP\n";
        double[] se = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            double se_bi;
            double s_ii = se2 * xTxInv[i][i];
            se[i] = se_bi = Math.pow(s_ii, 0.5);
            t[i] = b[0][i] / se_bi;
            p[i] = 2.0 * (1.0 - ProbUtils.tCdf(Math.abs(t[i]), n - k));
            String variableName = i > 0 ? this.regressorNames[i - 1] : "const";
            summary = summary + " " + variableName + "\t" + this.nf.format(b[0][i]) + "\t" + this.nf.format(se_bi) + "\t" + this.nf.format(t[i]) + "\t" + this.nf.format(p[i]) + "\t" + (p[i] < this.alpha ? "significant " : "") + "\n";
            if (!(p[i] < this.alpha)) continue;
            GraphNode predictorNode = new GraphNode(variableName);
            this.outGraph.addNode(predictorNode);
            Edge newEdge = new Edge(predictorNode, targetNode, Endpoint.TAIL, Endpoint.ARROW);
            this.outGraph.addEdge(newEdge);
        }
        return new RegressionResult(false, this.regressorNames, n, b[0], t, p, se, r2, rss, this.alpha, null, null);
    }

    public Graph getOutGraph() {
        return this.outGraph;
    }

    private double calculateSSM(double[] y) {
        double mean = 0.0;
        for (double aY : y) {
            mean += aY;
        }
        mean /= (double)y.length;
        double ssm = 0.0;
        for (double aY1 : y) {
            double d = mean - aY1;
            ssm += d * d;
        }
        return ssm;
    }

    private double residualSumOfSquares(double[][] x, double[] y, double[] b) {
        double rss = 0.0;
        for (int i = 0; i < x[0].length; ++i) {
            double yH = 0.0;
            for (int j = 0; j < b.length; ++j) {
                yH += b[j] * x[j][i];
            }
            double d = y[i] - yH;
            rss += d * d;
        }
        return rss;
    }

    private double[][] multiply(double[][] m1, double[][] m2) {
        int mi = m1[0].length;
        int mj = m1.length;
        int mk = m2.length;
        if (m2[0].length != mj) {
            throw new IllegalArgumentException("can't multiply these matrices!");
        }
        double[][] m3 = new double[mk][mi];
        for (int i = 0; i < mi; ++i) {
            for (int k = 0; k < mk; ++k) {
                for (int j = 0; j < mj; ++j) {
                    double[] dArray = m3[k];
                    int n = i;
                    dArray[n] = dArray[n] + m1[j][i] * m2[k][j];
                }
            }
        }
        return m3;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }
}

