/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.regression;

public class RegressionPlane {
    private String summary;
    private String[] varNames;
    private int sampleSize;
    private int numRegressors;
    private double[] coefs;
    private double[] coefT;
    private double[] coefP;
    private double[] coefSE;
    private boolean zeroIntercept;
    private double rSquare;

    public RegressionPlane(boolean zeroIntercept, String[] varNames, int numRegressors, int sampleSize, double[] coefs, double[] coefT, double[] coefP, double rsquare, double[] coefSE, String summary) {
        int error;
        this.zeroIntercept = zeroIntercept;
        int n = error = zeroIntercept ? 0 : 1;
        if (varNames.length != numRegressors + error) {
            throw new IllegalArgumentException();
        }
        if (coefs.length != numRegressors + error) {
            throw new IllegalArgumentException();
        }
        if (coefT.length != numRegressors + error) {
            throw new IllegalArgumentException();
        }
        if (coefP.length != numRegressors + error) {
            throw new IllegalArgumentException();
        }
        this.varNames = varNames;
        this.numRegressors = numRegressors;
        this.sampleSize = sampleSize;
        this.coefs = coefs;
        this.coefT = coefT;
        this.coefP = coefP;
        this.coefSE = coefSE;
        this.rSquare = rsquare;
        this.summary = summary;
    }

    public double[] getCoefSE() {
        return this.coefSE;
    }

    public double getRSquare() {
        return this.rSquare;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public int getNumRegressors() {
        return this.numRegressors;
    }

    public double[] getCoef() {
        return this.coefs;
    }

    public double[] getCoefT() {
        return this.coefT;
    }

    public double[] getCoefP() {
        return this.coefP;
    }

    public String[] getVarNames() {
        return this.varNames;
    }

    public double getPredictedValue(double[] x) {
        int offset;
        double yHat = 0.0;
        for (int i = offset = this.zeroIntercept ? 0 : 1; i < this.numRegressors; ++i) {
            yHat += this.coefs[i + offset] * x[i];
        }
        if (!this.zeroIntercept) {
            yHat += this.coefs[0];
        }
        return yHat;
    }

    public String toString() {
        return this.summary;
    }
}

