/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.regression;

import cern.colt.matrix.DoubleMatrix1D;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.util.TextTable;
import java.text.NumberFormat;

public class RegressionResult
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private boolean zeroInterceptAssumed;
    private String[] regressorNames;
    private int n;
    private double[] b;
    private double[] t;
    private double[] p;
    private double[] se;
    private double r2;
    private double rss;
    private double alpha;
    private DoubleMatrix1D yHat;
    private DoubleMatrix1D res;

    public RegressionResult(boolean zeroInterceptAssumed, String[] regressorNames, int n, double[] b, double[] t, double[] p, double[] se, double r2, double rss, double alpha, DoubleMatrix1D yHat, DoubleMatrix1D res) {
        int error;
        if (regressorNames == null) {
            throw new NullPointerException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (t == null) {
            throw new NullPointerException();
        }
        if (p == null) {
            throw new NullPointerException();
        }
        if (se == null) {
            throw new NullPointerException();
        }
        this.zeroInterceptAssumed = zeroInterceptAssumed;
        this.regressorNames = regressorNames;
        int n2 = error = zeroInterceptAssumed ? 0 : 1;
        if (this.getNumRegressors() > 0 && b.length != this.getNumRegressors() + error) {
            throw new IllegalArgumentException();
        }
        this.n = n;
        this.b = b;
        this.t = t;
        this.p = p;
        this.se = se;
        this.r2 = r2;
        this.alpha = alpha;
        this.rss = rss;
        this.yHat = yHat;
        this.res = res;
    }

    public static RegressionResult serializableInstance() {
        return new RegressionResult(true, new String[0], 10, new double[0], new double[0], new double[0], new double[0], 0.0, 0.0, 0.0, null, null);
    }

    public boolean isZeroInterceptAssumed() {
        return this.zeroInterceptAssumed;
    }

    public double getRSquared() {
        return this.r2;
    }

    public int getN() {
        return this.n;
    }

    public int getNumRegressors() {
        return this.regressorNames.length;
    }

    public double[] getCoef() {
        return this.b;
    }

    public double[] getT() {
        return this.t;
    }

    public double[] getP() {
        return this.p;
    }

    public double[] getSe() {
        return this.se;
    }

    public String[] getRegressorNames() {
        return this.regressorNames;
    }

    public double getPredictedValue(double[] x) {
        int offset;
        double yHat = 0.0;
        for (int i = offset = this.zeroInterceptAssumed ? 0 : 1; i < this.getNumRegressors(); ++i) {
            yHat += this.b[i + offset] * x[i];
        }
        if (!this.zeroInterceptAssumed) {
            yHat += this.b[0];
        }
        return yHat;
    }

    public String toString() {
        StringBuilder summary = new StringBuilder(this.getPreamble());
        TextTable table = this.getResultsTable();
        summary.append(table.toString());
        return summary.toString();
    }

    public TextTable getResultsTable() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        TextTable table = new TextTable(this.getNumRegressors() + 3, 6);
        table.setToken(0, 0, "VAR");
        table.setToken(0, 1, "COEF");
        table.setToken(0, 2, "SE");
        table.setToken(0, 3, "T");
        table.setToken(0, 4, "P");
        table.setToken(0, 5, "");
        for (int i = 0; i < this.getNumRegressors() + 1; ++i) {
            String variableName = i > 0 ? this.regressorNames[i - 1] : "const";
            table.setToken(i + 2, 0, variableName);
            table.setToken(i + 2, 1, nf.format(this.b[i]));
            if (this.se.length != 0) {
                table.setToken(i + 2, 2, nf.format(this.se[i]));
            } else {
                table.setToken(i + 2, 2, "-1");
            }
            if (this.t.length != 0) {
                table.setToken(i + 2, 3, nf.format(this.t[i]));
            } else {
                table.setToken(i + 2, 3, "-1");
            }
            if (this.p.length != 0) {
                table.setToken(i + 2, 4, nf.format(this.p[i]));
            } else {
                table.setToken(i + 2, 4, "-1");
            }
            if (this.p.length != 0) {
                table.setToken(i + 2, 5, this.p[i] < this.alpha ? "significant " : "");
                continue;
            }
            table.setToken(i + 2, 5, "(p not defined)");
        }
        return table;
    }

    public String getPreamble() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        String rssString = nf.format(this.rss);
        String r2String = nf.format(this.r2);
        StringBuilder preamble = new StringBuilder();
        preamble.append("\n REGRESSION RESULT");
        preamble.append("\n n = ").append(this.n).append(", k = ");
        preamble.append(this.getNumRegressors() + 1).append(", alpha = ").append(this.alpha);
        preamble.append("\n").append(" SSE = ").append(rssString);
        preamble.append("\n").append(" R^2 = ").append(r2String);
        preamble.append("\n");
        return preamble.toString();
    }

    public DoubleMatrix1D getYHat() {
        return this.yHat;
    }

    public DoubleMatrix1D getResiduals() {
        return this.res;
    }
}

