/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.regression;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.RegressionUtils;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRegressionUtils
extends TestCase {
    DataSet data;

    public TestRegressionUtils(String name) {
        super(name);
    }

    public void testRegressionUtils() {
        Dag graph = new Dag(GraphUtils.randomDag(5, 0, 3, 3, 3, 3, false));
        System.out.println(graph);
        SemPm pm = new SemPm(graph);
        SemIm im = new SemIm(pm);
        DataSet dataSet = im.simulateData(1000, false);
        System.out.println(dataSet);
        DataSet residuals = RegressionUtils.residuals(dataSet, graph);
        System.out.println(residuals);
        for (Node node : graph.getNodes()) {
            if (!graph.getParents(node).isEmpty()) continue;
            Node nodeDataSet = dataSet.getVariable(node.getName());
            int j = dataSet.getVariables().indexOf(nodeDataSet);
            for (int i = 0; i < dataSet.getNumRows(); ++i) {
                System.out.println(i);
                TestRegressionUtils.assertEquals(dataSet.getDouble(i, j), residuals.getDouble(i, j), 0.001);
            }
        }
    }

    public static Test suite() {
        return new TestSuite(TestRegressionUtils.class);
    }
}

