/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

public class BinaryFunction {
    private long functionIndex;
    private int numArgs;
    int[] functionColumn;

    public BinaryFunction(int numArgs, long functionIndex) {
        this.numArgs = numArgs;
        if (functionIndex > this.getNumFunctions()) {
            throw new IllegalArgumentException("Function index out of range for " + numArgs + " arguments.");
        }
        this.functionColumn = new int[this.getNumRows()];
        this.resetFunction(functionIndex);
    }

    public BinaryFunction(int numArgs, boolean[] functionColumn) {
        this.numArgs = numArgs;
        if (functionColumn.length > this.getNumRows()) {
            throw new IllegalArgumentException("Function column does not have the right number of rows for " + numArgs + " argument: " + functionColumn.length);
        }
        this.functionColumn = new int[this.getNumRows()];
        this.resetFunction(this.getIndex(functionColumn));
    }

    public void resetFunction(long functionIndex) {
        this.functionIndex = functionIndex;
        for (int i = 0; i < this.getNumRows(); ++i) {
            this.functionColumn[this.getNumRows() - i - 1] = (int)functionIndex % 2;
            functionIndex /= 2L;
        }
    }

    public long getOppositeFunction() {
        long functionIndex = 0L;
        for (int i = 0; i < this.getNumRows(); ++i) {
            functionIndex *= 2L;
            functionIndex = this.getFunctionIndex(i, functionIndex);
        }
        return functionIndex;
    }

    public long getSymmetricFunction() {
        long functionIndex = 0L;
        for (int i = 0; i < this.getNumRows(); ++i) {
            functionIndex *= 2L;
            functionIndex += (long)this.functionColumn[this.getNumRows() - i - 1];
        }
        return functionIndex;
    }

    public long getSymmetricOppositeFunction() {
        long functionIndex = 0L;
        for (int i = 0; i < this.getNumRows(); ++i) {
            functionIndex *= 2L;
            functionIndex += (long)(1 - this.functionColumn[this.getNumRows() - i - 1]);
        }
        return functionIndex;
    }

    public long switchColsBinary(int col1, int col2) {
        int[] functionColumn = new int[this.getNumRows()];
        for (int i = 0; i < this.getNumRows(); ++i) {
            boolean[] row = this.getRow(i);
            boolean temp = row[col1];
            row[col1] = row[col2];
            row[col2] = temp;
            boolean b = this.getValue(row);
            functionColumn[i] = b ? 1 : 0;
        }
        return this.getIndex(functionColumn);
    }

    public long switchColsFull(int[] permutation) {
        int[] functionColumn = new int[this.getNumRows()];
        for (int i = 0; i < this.getNumRows(); ++i) {
            boolean[] row = this.getRow(i);
            boolean[] newRow = new boolean[row.length];
            for (int j = 0; j < row.length; ++j) {
                newRow[permutation[j]] = row[j];
            }
            boolean b = this.getValue(newRow);
            functionColumn[i] = b ? 1 : 0;
        }
        return this.getIndex(functionColumn);
    }

    public boolean getValue(boolean[] values) {
        if (values.length != this.numArgs) {
            throw new IllegalArgumentException();
        }
        return this.functionColumn[this.getRowIndex(values)] == 1;
    }

    public boolean getValue(int row) {
        return this.functionColumn[row] == 1;
    }

    public boolean[] getRow(int rowIndex) {
        boolean[] values = new boolean[this.numArgs];
        for (int i = 0; i < this.numArgs; ++i) {
            values[i] = rowIndex % 2 == 1;
            rowIndex /= 2;
        }
        return values;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n");
        for (int j = 0; j < this.numArgs; ++j) {
            buf.append("V").append(j + 1).append("   \t");
        }
        buf.append("G");
        buf.append("\n");
        for (int i = 0; i < this.getNumRows(); ++i) {
            boolean[] argumentVals = this.getRow(i);
            for (int j = 0; j < this.numArgs; ++j) {
                buf.append(argumentVals[j]).append("\t");
            }
            buf.append(this.getValue(argumentVals));
            buf.append("\n");
        }
        buf.append("\n");
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BinaryFunction)) {
            return false;
        }
        return this.functionIndex == ((BinaryFunction)o).getFunctionIndex();
    }

    public int getNumRows() {
        int numRows = 1;
        for (int i = 0; i < this.getNumArgs(); ++i) {
            numRows *= 2;
        }
        return numRows;
    }

    public int getNumArgs() {
        return this.numArgs;
    }

    public long getFunctionIndex() {
        return this.functionIndex;
    }

    public long getNumFunctions() {
        long n = 1L;
        for (int i = 0; i < this.getNumRows(); ++i) {
            n *= 2L;
        }
        return n;
    }

    private long getIndex(int[] functionColumn) {
        long functionIndex = 0L;
        for (int i = 0; i < this.getNumRows(); ++i) {
            functionIndex *= 2L;
            functionIndex += (long)functionColumn[i];
        }
        return functionIndex;
    }

    private long getIndex(boolean[] functionColumn) {
        long functionIndex = 0L;
        for (int i = 0; i < this.getNumRows(); ++i) {
            functionIndex *= 2L;
            functionIndex += functionColumn[i] ? 1L : 0L;
        }
        return functionIndex;
    }

    private long getFunctionIndex(int i, long functionIndex) {
        return functionIndex += (long)(1 - this.functionColumn[i]);
    }

    private int getRowIndex(boolean[] values) {
        int rowIndex = 0;
        for (int i = 0; i < this.numArgs; ++i) {
            rowIndex *= 2;
            rowIndex += values[i] ? 1 : 0;
        }
        return rowIndex;
    }
}

