/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.TetradTest;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.RandomUtil;
import pal.math.ConjugateDirectionSearch;
import pal.math.MFWithGradient;

public final class BinaryTetradTest
implements TetradTest {
    private DataSet dataSet;
    private double[][] pis;
    private double[][][][] pis4;
    private int[][][][][][][][] counts4;
    private int[][] values;
    private int[] indices;
    private int sampleSize;
    private double[] prob;
    private double tempProb;
    private double sig1;
    private double sig2;
    private double sig3;
    private double sig;
    private double stat;
    private boolean[] bvalues;
    private static final double FUNC_TOLERANCE = 1.0E-4;
    private static final double PARAM_TOLERANCE = 0.001;

    public BinaryTetradTest(DataSet dataSet, double sig) {
        this.dataSet = dataSet;
        this.sampleSize = dataSet.getNumRows();
        this.sig = sig;
        this.initialization();
    }

    @Override
    public String[] getVarNames() {
        return this.dataSet.getVariableNames().toArray(new String[0]);
    }

    @Override
    public DataSet getDataSet() {
        return this.dataSet;
    }

    private void initialization() {
        int numRows = this.dataSet.getNumRows();
        int numColumns = this.dataSet.getNumColumns();
        this.prob = new double[3];
        this.bvalues = new boolean[3];
        this.sig1 = this.sig / 3.0;
        this.sig2 = 2.0 * this.sig / 3.0;
        this.sig3 = this.sig;
        this.values = new int[numColumns][];
        int[] tempValues = new int[2];
        boolean[] marked = new boolean[2];
        for (int i = 0; i < numColumns; ++i) {
            int j;
            int vSize = 0;
            block1: for (j = 0; j < numRows; ++j) {
                int value = this.dataSet.getInt(j, i);
                for (int k = 0; k < vSize; ++k) {
                    if (tempValues[k] == value) continue block1;
                }
                if (vSize < 2) {
                    tempValues[vSize++] = value;
                    continue;
                }
                throw new RuntimeException("Maximum number of distinct values for a binary variable exceeded!");
            }
            if (vSize == 1) {
                throw new RuntimeException("Error: variable assumes only one value!");
            }
            this.values[i] = new int[vSize];
            for (j = 0; j < vSize; ++j) {
                marked[j] = false;
            }
            for (j = 0; j < vSize; ++j) {
                int minValue = Integer.MAX_VALUE;
                int minIndexValue = -1;
                for (int k = 0; k < vSize; ++k) {
                    if (marked[k] || tempValues[k] >= minValue) continue;
                    minValue = tempValues[k];
                    minIndexValue = k;
                }
                this.values[i][j] = minValue;
                marked[minIndexValue] = true;
            }
        }
        this.pis = new double[numColumns][numColumns];
        this.pis4 = new double[4][4][4][4];
        this.counts4 = new int[numColumns][numColumns][numColumns][numColumns][2][2][2][2];
        this.indices = new int[4];
        this.computeCounts();
        this.computeCounts4();
    }

    @Override
    public int tetradScore(int v1, int v2, int v3, int v4) {
        this.evalTetradDifferences(v1, v2, v3, v4);
        for (int i = 0; i < 3; ++i) {
            this.bvalues[i] = this.prob[i] >= this.sig;
        }
        if (this.prob[1] < this.prob[0] && this.prob[1] < this.prob[2]) {
            this.tempProb = this.prob[0];
            this.prob[0] = this.prob[1];
            this.prob[1] = this.tempProb;
        } else if (this.prob[2] < this.prob[0] && this.prob[2] < this.prob[0]) {
            this.tempProb = this.prob[0];
            this.prob[0] = this.prob[2];
            this.prob[2] = this.tempProb;
        }
        if (this.prob[2] < this.prob[1]) {
            this.tempProb = this.prob[1];
            this.prob[1] = this.prob[2];
            this.prob[2] = this.tempProb;
        }
        if (this.prob[2] <= this.sig3) {
            return 0;
        }
        if (this.prob[1] <= this.sig2) {
            return 1;
        }
        if (this.prob[0] <= this.sig1) {
            return 3;
        }
        return 3;
    }

    @Override
    public boolean tetradScore1(int v1, int v2, int v3, int v4) {
        if (this.tetradScore(v1, v2, v3, v4) != 1) {
            return false;
        }
        return this.bvalues[2];
    }

    @Override
    public double getSignificance() {
        return this.sig;
    }

    @Override
    public void setSignificance(double sig) {
        this.sig = sig;
    }

    @Override
    public boolean tetradScore3(int v1, int v2, int v3, int v4) {
        return this.tetradScore(v1, v2, v3, v4) == 3;
    }

    @Override
    public boolean tetradHolds(int v1, int v2, int v3, int v4) {
        this.evalTetradDifference(v1, v2, v3, v4);
        this.bvalues[0] = this.prob[0] >= this.sig;
        return this.prob[0] >= this.sig;
    }

    @Override
    public double tetradPValue(int v1, int v2, int v3, int v4) {
        this.evalTetradDifference(v1, v2, v3, v4);
        return this.prob[0];
    }

    private void computeCounts() {
        int j;
        int i;
        double[][] cij = new double[this.dataSet.getNumColumns()][this.dataSet.getNumColumns()];
        for (i = 0; i < this.dataSet.getNumColumns(); ++i) {
            for (j = 0; j < this.dataSet.getNumColumns(); ++j) {
                cij[i][j] = 0.0;
            }
        }
        for (int d = 0; d < this.dataSet.getNumRows(); ++d) {
            for (int i2 = 0; i2 < this.dataSet.getNumColumns(); ++i2) {
                for (int j2 = 0; j2 < this.dataSet.getNumColumns(); ++j2) {
                    double[] dArray = cij[i2];
                    int n = j2;
                    dArray[n] = dArray[n] + (double)(this.dataSet.getInt(d, i2) * this.dataSet.getInt(d, j2));
                }
            }
        }
        for (i = 0; i < this.dataSet.getNumColumns(); ++i) {
            for (j = 0; j < this.dataSet.getNumColumns(); ++j) {
                this.pis[i][j] = cij[i][j] / (double)this.dataSet.getNumRows();
            }
        }
    }

    private void computeCounts4(int[] indices) {
        int l;
        int k;
        int j;
        int i;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                for (k = 0; k < 4; ++k) {
                    for (l = 0; l < 4; ++l) {
                        this.pis4[i][j][k][l] = 0.0;
                    }
                }
            }
        }
        for (int d = 0; d < this.dataSet.getNumRows(); ++d) {
            for (int i2 = 0; i2 < 4; ++i2) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    for (int k2 = 0; k2 < 4; ++k2) {
                        for (int l2 = 0; l2 < 4; ++l2) {
                            double[] dArray = this.pis4[i2][j2][k2];
                            int n = l2;
                            dArray[n] = dArray[n] + (double)(this.dataSet.getInt(d, indices[i2]) * this.dataSet.getInt(d, indices[j2]) * this.dataSet.getInt(d, indices[k2]) * this.dataSet.getInt(d, indices[l2]));
                        }
                    }
                }
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                for (k = 0; k < 4; ++k) {
                    l = 0;
                    while (l < 4) {
                        double[] dArray = this.pis4[i][j][k];
                        int n = l++;
                        dArray[n] = dArray[n] / (double)this.dataSet.getNumRows();
                    }
                }
            }
        }
    }

    private void computeCounts4() {
        for (int i = 0; i < this.dataSet.getNumColumns(); ++i) {
            for (int j = 0; j < this.dataSet.getNumColumns(); ++j) {
                for (int k = 0; k < this.dataSet.getNumColumns(); ++k) {
                    for (int l = 0; l < this.dataSet.getNumColumns(); ++l) {
                        for (int x1 = 0; x1 < 2; ++x1) {
                            for (int x2 = 0; x2 < 2; ++x2) {
                                for (int x3 = 0; x3 < 2; ++x3) {
                                    for (int x4 = 0; x4 < 2; ++x4) {
                                        this.counts4[i][j][k][l][x1][x2][x3][x4] = 0;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        for (int d = 0; d < this.dataSet.getNumRows(); ++d) {
            for (int i = 0; i < this.dataSet.getNumColumns(); ++i) {
                for (int j = 0; j < this.dataSet.getNumColumns(); ++j) {
                    for (int k = 0; k < this.dataSet.getNumColumns(); ++k) {
                        for (int l = 0; l < this.dataSet.getNumColumns(); ++l) {
                            int[] nArray = this.counts4[i][j][k][l][this.dataSet.getInt(d, i)][this.dataSet.getInt(d, j)][this.dataSet.getInt(d, k)];
                            int n = this.dataSet.getInt(d, l);
                            nArray[n] = nArray[n] + 1;
                        }
                    }
                }
            }
        }
    }

    private void evalTetradDifferences(int i, int j, int k, int l) {
        this.prob[0] = this.testOneTetrad(i, l, k, j);
        this.prob[1] = this.testOneTetrad(i, k, j, l);
        this.prob[2] = this.testOneTetrad(i, j, k, l);
        System.out.println(i + " " + j + " " + k + " " + l);
        System.out.println(this.prob[0] + " " + this.prob[1] + " " + this.prob[2]);
        System.exit(0);
    }

    private void evalTetradDifference(int i, int j, int k, int l) {
        this.prob[0] = this.testOneTetrad(i, l, k, j);
    }

    private double tetradTest(int i, int j, int k, int l) {
        double a = this.pis[i][j];
        double b = this.pis[k][l];
        double c = this.pis[i][k];
        double d = this.pis[j][l];
        double e = this.pis[i][i];
        double f = this.pis[j][j];
        double g = this.pis[k][k];
        double h = this.pis[l][l];
        this.indices[0] = i;
        this.indices[1] = j;
        this.indices[2] = k;
        this.indices[3] = l;
        this.computeCounts4(this.indices);
        double[] pi = new double[]{a, b, c, d, e, f, g, h};
        double[] jacobian = new double[]{b - g * h, a - e * f, f * h - d, e * g - c, d * g - b * f, c * h - b * e, d * e - a * h, c * f - a * g};
        double[][] pCov = new double[8][8];
        for (int x = 0; x < 8; ++x) {
            int idx1 = -1;
            int idx2 = -1;
            switch (x) {
                case 0: {
                    idx1 = 0;
                    idx2 = 1;
                    break;
                }
                case 1: {
                    idx1 = 2;
                    idx2 = 3;
                    break;
                }
                case 2: {
                    idx1 = 0;
                    idx2 = 2;
                    break;
                }
                case 3: {
                    idx1 = 1;
                    idx2 = 3;
                    break;
                }
                case 4: {
                    idx1 = 0;
                    idx2 = 0;
                    break;
                }
                case 5: {
                    idx1 = 1;
                    idx2 = 1;
                    break;
                }
                case 6: {
                    idx1 = 2;
                    idx2 = 2;
                    break;
                }
                case 7: {
                    idx1 = 3;
                    idx2 = 3;
                }
            }
            for (int y = x; y < 8; ++y) {
                int idx3 = -1;
                int idx4 = -1;
                switch (y) {
                    case 0: {
                        idx3 = 0;
                        idx4 = 1;
                        break;
                    }
                    case 1: {
                        idx3 = 2;
                        idx4 = 3;
                        break;
                    }
                    case 2: {
                        idx3 = 0;
                        idx4 = 2;
                        break;
                    }
                    case 3: {
                        idx3 = 1;
                        idx4 = 3;
                        break;
                    }
                    case 4: {
                        idx3 = 0;
                        idx4 = 0;
                        break;
                    }
                    case 5: {
                        idx3 = 1;
                        idx4 = 1;
                        break;
                    }
                    case 6: {
                        idx3 = 2;
                        idx4 = 2;
                        break;
                    }
                    case 7: {
                        idx3 = 3;
                        idx4 = 3;
                    }
                }
                pCov[x][y] = this.pis4[idx1][idx2][idx3][idx4] - pi[x] * pi[y];
                pCov[y][x] = pCov[x][y];
            }
        }
        double mle = (a - e * f) * (b - g * h) - (c - e * g) * (d - f * h);
        double var = MatrixUtils.innerProduct(MatrixUtils.product(jacobian, pCov), jacobian);
        double std = Math.sqrt(var / (double)this.dataSet.getNumRows());
        this.stat = -Math.abs(mle) / std;
        return 2.0 * ProbUtils.normalCdf(this.stat);
    }

    @Override
    public boolean oneFactorTest(int a, int b, int c, int d) {
        assert (false);
        return false;
    }

    @Override
    public boolean oneFactorTest(int a, int b, int c, int d, int e) {
        assert (false);
        return false;
    }

    @Override
    public boolean oneFactorTest(int a, int b, int c, int d, int e, int f) {
        assert (false);
        return false;
    }

    @Override
    public boolean twoFactorTest(int a, int b, int c, int d) {
        assert (false);
        return false;
    }

    @Override
    public boolean twoFactorTest(int a, int b, int c, int d, int e) {
        assert (false);
        return false;
    }

    @Override
    public boolean twoFactorTest(int a, int b, int c, int d, int e, int f) {
        assert (false);
        return false;
    }

    public double testOneTetrad(int i, int j, int k, int l) {
        this.indices[0] = i;
        this.indices[1] = j;
        this.indices[2] = k;
        this.indices[3] = l;
        double[] params = new double[11];
        this.estimateTwoFactorModel(params);
        this.debugParams(params);
        return 1.0 - ProbUtils.chisqCdf(this.scoreParams(params), 4.0);
    }

    private void twoFactorGradientInst(int[] values, double[] params, double[] gradient) {
        int c;
        assert (gradient.length == 11);
        assert (values.length == 4);
        assert (params.length == 11);
        double[][] core = new double[2][2];
        for (int n1 = 0; n1 < 2; ++n1) {
            for (int n2 = 0; n2 < 2; ++n2) {
                int v;
                core[n1][n2] = n1 == 1 && n2 == 1 ? params[8] * params[10] : (n1 == 1 && n2 == 0 ? params[8] * (1.0 - params[10]) : (n1 == 0 && n2 == 1 ? (1.0 - params[8]) * params[9] : (1.0 - params[8]) * (1.0 - params[9])));
                for (v = 0; v < 2; ++v) {
                    if (values[v] == 1) {
                        double[] dArray = core[n1];
                        int n = n2;
                        dArray[n] = dArray[n] * params[4 * n1 + v];
                        continue;
                    }
                    double[] dArray = core[n1];
                    int n = n2;
                    dArray[n] = dArray[n] * (1.0 - params[4 * n1 + v]);
                }
                for (v = 2; v < 4; ++v) {
                    if (values[v] == 1) {
                        double[] dArray = core[n1];
                        int n = n2;
                        dArray[n] = dArray[n] * params[4 * n2 + v];
                        continue;
                    }
                    double[] dArray = core[n1];
                    int n = n2;
                    dArray[n] = dArray[n] * (1.0 - params[4 * n2 + v]);
                }
            }
        }
        for (c = 0; c < 2; ++c) {
            if (values[c] == 1) {
                gradient[c] = (core[0][0] + core[0][1]) / params[c];
                gradient[4 + c] = (core[1][0] + core[1][1]) / params[4 + c];
                continue;
            }
            gradient[c] = (core[0][0] + core[0][1]) / (1.0 - params[c]);
            gradient[4 + c] = (core[1][0] + core[1][1]) / (1.0 - params[4 + c]);
        }
        for (c = 2; c < 4; ++c) {
            if (values[c] == 1) {
                gradient[c] = (core[0][0] + core[1][0]) / params[c];
                gradient[4 + c] = (core[0][1] + core[1][1]) / params[4 + c];
                continue;
            }
            gradient[c] = (core[0][0] + core[1][0]) / (1.0 - params[c]);
            gradient[4 + c] = (core[0][1] + core[1][1]) / (1.0 - params[4 + c]);
        }
        gradient[8] = (core[1][0] + core[1][1]) / params[8] - (core[0][0] + core[1][0]) / (1.0 - params[8]);
        gradient[9] = core[0][1] / params[9] - core[0][0] / (1.0 - params[9]);
        gradient[10] = core[1][1] / params[10] - core[1][0] / (1.0 - params[10]);
    }

    protected void computeTwoFactorGradient(double[] params, double[] gradient) {
        int i;
        double[][][][] impProb = new double[2][2][2][2];
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int p = 0; p < 2; ++p) {
                    for (int q = 0; q < 2; ++q) {
                        impProb[i][j][p][q] = 0.0;
                        for (int p1 = 0; p1 < 2; ++p1) {
                            for (int p2 = 0; p2 < 2; ++p2) {
                                double[] dArray = impProb[i][j][p];
                                int n = q;
                                dArray[n] = dArray[n] + Math.pow(params[4 * p1], i) * Math.pow(1.0 - params[4 * p1], 1 - i) * Math.pow(params[4 * p1 + 1], j) * Math.pow(1.0 - params[4 * p1 + 1], 1 - j) * Math.pow(params[4 * p2 + 2], p) * Math.pow(1.0 - params[4 * p2 + 2], 1 - p) * Math.pow(params[4 * p2 + 3], q) * Math.pow(1.0 - params[4 * p2 + 3], 1 - q) * Math.pow(params[8], p1) * Math.pow(1.0 - params[8], 1 - p1) * Math.pow(Math.pow(params[9], p2) * Math.pow(1.0 - params[9], 1 - p2), 1 - p1) * Math.pow(Math.pow(params[10], p2) * Math.pow(1.0 - params[10], 1 - p2), p1);
                            }
                        }
                    }
                }
            }
        }
        for (i = 0; i < gradient.length; ++i) {
            gradient[i] = 0.0;
        }
        int[] values = new int[4];
        double[] subgradient = new double[11];
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    for (int l = 0; l < 2; ++l) {
                        values[0] = i2;
                        values[1] = j;
                        values[2] = k;
                        values[3] = l;
                        this.twoFactorGradientInst(values, params, subgradient);
                        double factor = (double)this.counts4[this.indices[0]][this.indices[1]][this.indices[2]][this.indices[3]][i2][j][k][l] / impProb[i2][j][k][l];
                        for (int g = 0; g < gradient.length; ++g) {
                            int n = g;
                            gradient[n] = gradient[n] + factor * subgradient[g];
                        }
                    }
                }
            }
        }
    }

    private double paramsLikelihood(double[] params) {
        double[][][][] impProb = new double[2][2][2][2];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int p = 0; p < 2; ++p) {
                    for (int q = 0; q < 2; ++q) {
                        impProb[i][j][p][q] = 0.0;
                        for (int p1 = 0; p1 < 2; ++p1) {
                            for (int p2 = 0; p2 < 2; ++p2) {
                                double[] dArray = impProb[i][j][p];
                                int n = q;
                                dArray[n] = dArray[n] + Math.pow(params[4 * p1], i) * Math.pow(1.0 - params[4 * p1], 1 - i) * Math.pow(params[4 * p1 + 1], j) * Math.pow(1.0 - params[4 * p1 + 1], 1 - j) * Math.pow(params[4 * p2 + 2], p) * Math.pow(1.0 - params[4 * p2 + 2], 1 - p) * Math.pow(params[4 * p2 + 3], q) * Math.pow(1.0 - params[4 * p2 + 3], 1 - q) * Math.pow(params[8], p1) * Math.pow(1.0 - params[8], 1 - p1) * Math.pow(Math.pow(params[9], p2) * Math.pow(1.0 - params[9], 1 - p2), 1 - p1) * Math.pow(Math.pow(params[10], p2) * Math.pow(1.0 - params[10], 1 - p2), p1);
                            }
                        }
                    }
                }
            }
        }
        double loglike = 0.0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int p = 0; p < 2; ++p) {
                    for (int q = 0; q < 2; ++q) {
                        loglike -= (double)this.counts4[this.indices[0]][this.indices[1]][this.indices[2]][this.indices[3]][i][j][p][q] * Math.log(impProb[i][j][p][q]);
                    }
                }
            }
        }
        return loglike;
    }

    private double scoreParams(double[] params) {
        double[][][][] impProb = new double[2][2][2][2];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int p = 0; p < 2; ++p) {
                    for (int q = 0; q < 2; ++q) {
                        impProb[i][j][p][q] = 0.0;
                        for (int p1 = 0; p1 < 2; ++p1) {
                            for (int p2 = 0; p2 < 2; ++p2) {
                                double[] dArray = impProb[i][j][p];
                                int n = q;
                                dArray[n] = dArray[n] + Math.pow(params[4 * p1], i) * Math.pow(1.0 - params[4 * p1], 1 - i) * Math.pow(params[4 * p1 + 1], j) * Math.pow(1.0 - params[4 * p1 + 1], 1 - j) * Math.pow(params[4 * p2 + 2], p) * Math.pow(1.0 - params[4 * p2 + 2], 1 - p) * Math.pow(params[4 * p2 + 3], q) * Math.pow(1.0 - params[4 * p2 + 3], 1 - q) * Math.pow(params[8], p1) * Math.pow(1.0 - params[8], 1 - p1) * Math.pow(Math.pow(params[9], p2) * Math.pow(1.0 - params[9], 1 - p2), 1 - p1) * Math.pow(Math.pow(params[10], p2) * Math.pow(1.0 - params[10], 1 - p2), p1);
                            }
                        }
                    }
                }
            }
        }
        double chisq = 0.0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int p = 0; p < 2; ++p) {
                    for (int q = 0; q < 2; ++q) {
                        int count = this.counts4[this.indices[0]][this.indices[1]][this.indices[2]][this.indices[3]][i][j][p][q];
                        if (count == 0) continue;
                        double prob = (double)count / (double)this.dataSet.getNumRows();
                        chisq += (double)count * Math.log(prob / impProb[i][j][p][q]);
                    }
                }
            }
        }
        return 2.0 * chisq;
    }

    private void debugParams(double[] params) {
        int i;
        double[][][][] impProb = new double[2][2][2][2];
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int j = 0; j < 2; ++j) {
                for (int p = 0; p < 2; ++p) {
                    for (int q = 0; q < 2; ++q) {
                        impProb[i2][j][p][q] = 0.0;
                        for (int p1 = 0; p1 < 2; ++p1) {
                            for (int p2 = 0; p2 < 2; ++p2) {
                                double[] dArray = impProb[i2][j][p];
                                int n = q;
                                dArray[n] = dArray[n] + Math.pow(params[4 * p1], i2) * Math.pow(1.0 - params[4 * p1], 1 - i2) * Math.pow(params[4 * p1 + 1], j) * Math.pow(1.0 - params[4 * p1 + 1], 1 - j) * Math.pow(params[4 * p2 + 2], p) * Math.pow(1.0 - params[4 * p2 + 2], 1 - p) * Math.pow(params[4 * p2 + 3], q) * Math.pow(1.0 - params[4 * p2 + 3], 1 - q) * Math.pow(params[8], p1) * Math.pow(1.0 - params[8], 1 - p1) * Math.pow(Math.pow(params[9], p2) * Math.pow(1.0 - params[9], 1 - p2), 1 - p1) * Math.pow(Math.pow(params[10], p2) * Math.pow(1.0 - params[10], 1 - p2), p1);
                            }
                        }
                    }
                }
            }
        }
        double[][][][] impProb2 = new double[2][2][2][2];
        for (int i3 = 0; i3 < 2; ++i3) {
            for (int j = 0; j < 2; ++j) {
                for (int p = 0; p < 2; ++p) {
                    for (int q = 0; q < 2; ++q) {
                        impProb2[i3][j][p][q] = 0.0;
                        for (int p1 = 0; p1 < 2; ++p1) {
                            for (int p2 = 0; p2 < 2; ++p2) {
                                double product = 1.0;
                                product = i3 == 1 ? (product *= params[4 * p1]) : (product *= 1.0 - params[4 * p1]);
                                product = j == 1 ? (product *= params[4 * p1 + 1]) : (product *= 1.0 - params[4 * p1 + 1]);
                                product = p == 1 ? (product *= params[4 * p2 + 2]) : (product *= 1.0 - params[4 * p2 + 2]);
                                product = q == 1 ? (product *= params[4 * p2 + 3]) : (product *= 1.0 - params[4 * p2 + 3]);
                                product = p1 == 1 && p2 == 1 ? (product *= params[8] * params[10]) : (p1 == 1 && p2 == 0 ? (product *= params[8] * (1.0 - params[10])) : (p1 == 0 && p2 == 1 ? (product *= (1.0 - params[8]) * params[9]) : (product *= (1.0 - params[8]) * (1.0 - params[9]))));
                                double[] dArray = impProb2[i3][j][p];
                                int n = q;
                                dArray[n] = dArray[n] + product;
                            }
                        }
                    }
                }
            }
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int p = 0; p < 2; ++p) {
                    for (int q = 0; q < 2; ++q) {
                        int count = this.counts4[this.indices[0]][this.indices[1]][this.indices[2]][this.indices[3]][i][j][p][q];
                        if (count == 0) continue;
                        System.out.println(impProb[i][j][p][q] + " x " + (double)count / (double)this.dataSet.getNumRows() + " x " + impProb2[i][j][p][q]);
                    }
                }
            }
        }
        System.out.println();
        for (i = 0; i < 11; ++i) {
            System.out.println(params[i]);
        }
        System.out.println();
    }

    private void estimateTwoFactorModel(double[] params) {
        double bestScore = Double.MAX_VALUE;
        double[] bestParams = new double[params.length];
        for (int i = 0; i < 5; ++i) {
            for (int c = 0; c < 11; ++c) {
                params[c] = RandomUtil.getInstance().nextDouble() / 2.0 + 0.2;
            }
            new ConjugateDirectionSearch().optimize(new FittingFunction(this), params, 1.0E-4, 0.001);
            double newScore = this.scoreParams(params);
            if (!(newScore < bestScore)) continue;
            System.arraycopy(params, 0, bestParams, 0, params.length);
            bestScore = newScore;
        }
        System.arraycopy(bestParams, 0, params, 0, params.length);
    }

    public double testOneTetradBootstrap(int i, int j, int k, int l) {
        this.indices[0] = i;
        this.indices[1] = j;
        this.indices[2] = k;
        this.indices[3] = l;
        double[] params = new double[11];
        this.estimateTwoFactorModel(params);
        String[] vNames = new String[4];
        for (int v1 = 0; v1 < 4; ++v1) {
            vNames[v1] = this.dataSet.getVariableNames().get(this.indices[v1]);
        }
        EdgeListGraph factorModel = new EdgeListGraph();
        GraphNode eta1 = new GraphNode("eta1");
        eta1.setNodeType(NodeType.LATENT);
        factorModel.addNode(eta1);
        GraphNode eta2 = new GraphNode("eta2");
        eta2.setNodeType(NodeType.LATENT);
        factorModel.addNode(eta2);
        for (int n = 0; n < 4; ++n) {
            GraphNode xi = new GraphNode(vNames[n]);
            factorModel.addNode(xi);
            if (n < 2) {
                factorModel.addDirectedEdge(eta1, xi);
                continue;
            }
            factorModel.addDirectedEdge(eta2, xi);
        }
        factorModel.addDirectedEdge(eta1, eta2);
        BayesPm bayesPm = new BayesPm(new Dag(factorModel));
        MlBayesIm bayesIm = new MlBayesIm(bayesPm);
        bayesIm.setProbability(0, 0, 0, 1.0 - params[8]);
        bayesIm.setProbability(0, 0, 1, params[8]);
        bayesIm.setProbability(1, 0, 0, 1.0 - params[9]);
        bayesIm.setProbability(1, 0, 1, params[9]);
        bayesIm.setProbability(1, 1, 0, 1.0 - params[10]);
        bayesIm.setProbability(1, 1, 1, params[10]);
        for (int n = 0; n < 4; ++n) {
            bayesIm.setProbability(n + 2, 0, 0, 1.0 - params[n]);
            bayesIm.setProbability(n + 2, 0, 1, params[n]);
            bayesIm.setProbability(n + 2, 1, 0, 1.0 - params[n + 4]);
            bayesIm.setProbability(n + 2, 1, 1, params[n + 4]);
        }
        this.debugParams(params);
        int[][] counts2 = new int[4][4];
        int[][][][] counts4 = new int[4][4][4][4];
        this.tetradTest(i, k, l, j);
        this.indices[0] = i;
        this.indices[1] = j;
        this.indices[2] = k;
        this.indices[3] = l;
        double tetradPvalue = this.stat * this.stat;
        int successes = 0;
        for (int b = 0; b < 10; ++b) {
            int w;
            int z;
            int y;
            int x;
            DataSet dataBoot = bayesIm.simulateData(this.dataSet.getNumRows(), false);
            for (int v1 = 0; v1 < 4; ++v1) {
                for (int v2 = 0; v2 < 4; ++v2) {
                    counts2[v1][v2] = 0;
                    for (int v3 = 0; v3 < 4; ++v3) {
                        for (int v4 = 0; v4 < 4; ++v4) {
                            counts4[v1][v2][v3][v4] = 0;
                        }
                    }
                }
            }
            for (int d = 0; d < dataBoot.getNumRows(); ++d) {
                for (int v1 = 0; v1 < 4; ++v1) {
                    for (int v2 = 0; v2 < 4; ++v2) {
                        int[] nArray = counts2[v1];
                        int n = v2;
                        nArray[n] = nArray[n] + dataBoot.getInt(d, v1) * dataBoot.getInt(d, v2);
                        for (int v3 = 0; v3 < 4; ++v3) {
                            for (int v4 = 0; v4 < 4; ++v4) {
                                int[] nArray2 = counts4[v1][v2][v3];
                                int n2 = v4;
                                nArray2[n2] = nArray2[n2] + dataBoot.getInt(d, v1) * dataBoot.getInt(d, v2) * dataBoot.getInt(d, v3) * dataBoot.getInt(d, v4);
                            }
                        }
                    }
                }
            }
            int[][][][] counts42 = new int[2][2][2][2];
            for (x = 0; x < 2; ++x) {
                for (y = 0; y < 2; ++y) {
                    for (z = 0; z < 2; ++z) {
                        for (w = 0; w < 2; ++w) {
                            counts42[x][y][z][w] = 0;
                        }
                    }
                }
            }
            for (int d = 0; d < dataBoot.getNumRows(); ++d) {
                int[] nArray = counts42[dataBoot.getInt(d, 0)][dataBoot.getInt(d, 1)][dataBoot.getInt(d, 2)];
                int n = dataBoot.getInt(d, 3);
                nArray[n] = nArray[n] + 1;
            }
            for (x = 0; x < 2; ++x) {
                for (y = 0; y < 2; ++y) {
                    for (z = 0; z < 2; ++z) {
                        for (w = 0; w < 2; ++w) {
                            System.out.println(counts42[x][y][z][w] + " x " + this.counts4[i][j][k][l][x][y][z][w]);
                        }
                    }
                }
            }
            System.out.println();
            System.exit(0);
            double tetradBoot = this.tetradStat(0, 2, 3, 1, counts2, counts4);
            tetradBoot *= tetradBoot;
            if (!(tetradBoot >= tetradPvalue)) continue;
            ++successes;
        }
        return (double)successes / 10.0;
    }

    private double tetradStat(int i, int j, int k, int l, int[][] counts2, int[][][][] counts4) {
        double a = (double)counts2[i][j] / (double)this.dataSet.getNumRows();
        double b = (double)counts2[k][l] / (double)this.dataSet.getNumRows();
        double c = (double)counts2[i][k] / (double)this.dataSet.getNumRows();
        double d = (double)counts2[j][l] / (double)this.dataSet.getNumRows();
        double e = (double)counts2[i][i] / (double)this.dataSet.getNumRows();
        double f = (double)counts2[j][j] / (double)this.dataSet.getNumRows();
        double g = (double)counts2[k][k] / (double)this.dataSet.getNumRows();
        double h = (double)counts2[l][l] / (double)this.dataSet.getNumRows();
        double[] pi = new double[]{a, b, c, d, e, f, g, h};
        double[] jacobian = new double[]{b - g * h, a - e * f, f * h - d, e * g - c, d * g - b * f, c * h - b * e, d * e - a * h, c * f - a * g};
        double[][] pCov = new double[8][8];
        for (int x = 0; x < 8; ++x) {
            int idx1 = -1;
            int idx2 = -1;
            switch (x) {
                case 0: {
                    idx1 = i;
                    idx2 = j;
                    break;
                }
                case 1: {
                    idx1 = k;
                    idx2 = l;
                    break;
                }
                case 2: {
                    idx1 = i;
                    idx2 = k;
                    break;
                }
                case 3: {
                    idx1 = j;
                    idx2 = l;
                    break;
                }
                case 4: {
                    idx1 = i;
                    idx2 = i;
                    break;
                }
                case 5: {
                    idx1 = j;
                    idx2 = j;
                    break;
                }
                case 6: {
                    idx1 = k;
                    idx2 = k;
                    break;
                }
                case 7: {
                    idx1 = l;
                    idx2 = l;
                }
            }
            for (int y = x; y < 8; ++y) {
                int idx3 = -1;
                int idx4 = -1;
                switch (y) {
                    case 0: {
                        idx3 = i;
                        idx4 = j;
                        break;
                    }
                    case 1: {
                        idx3 = k;
                        idx4 = l;
                        break;
                    }
                    case 2: {
                        idx3 = i;
                        idx4 = k;
                        break;
                    }
                    case 3: {
                        idx3 = j;
                        idx4 = l;
                        break;
                    }
                    case 4: {
                        idx3 = i;
                        idx4 = i;
                        break;
                    }
                    case 5: {
                        idx3 = j;
                        idx4 = j;
                        break;
                    }
                    case 6: {
                        idx3 = k;
                        idx4 = k;
                        break;
                    }
                    case 7: {
                        idx3 = l;
                        idx4 = l;
                    }
                }
                pCov[x][y] = (double)counts4[idx1][idx2][idx3][idx4] - pi[x] * pi[y];
                pCov[y][x] = pCov[x][y];
            }
        }
        double mle = (a - e * f) * (b - g * h) - (c - e * g) * (d - f * h);
        double var = MatrixUtils.innerProduct(MatrixUtils.product(jacobian, pCov), jacobian);
        double std = Math.sqrt(var / (double)this.dataSet.getNumRows());
        System.out.println("stat = " + -Math.abs(mle) / std);
        return -Math.abs(mle) / std;
    }

    public double tetradStat(int i, int j, int k, int l) {
        double a = this.pis[i][j];
        double b = this.pis[k][l];
        double c = this.pis[i][k];
        double d = this.pis[j][l];
        double e = this.pis[i][i];
        double f = this.pis[j][j];
        double g = this.pis[k][k];
        double h = this.pis[l][l];
        this.indices[0] = i;
        this.indices[1] = j;
        this.indices[2] = k;
        this.indices[3] = l;
        this.computeCounts4(this.indices);
        double[] pi = new double[]{a, b, c, d, e, f, g, h};
        double[] jacobian = new double[]{b - g * h, a - e * f, f * h - d, e * g - c, d * g - b * f, c * h - b * e, d * e - a * h, c * f - a * g};
        double[][] pCov = new double[8][8];
        for (int x = 0; x < 8; ++x) {
            int idx1 = -1;
            int idx2 = -1;
            switch (x) {
                case 0: {
                    idx1 = 0;
                    idx2 = 1;
                    break;
                }
                case 1: {
                    idx1 = 2;
                    idx2 = 3;
                    break;
                }
                case 2: {
                    idx1 = 0;
                    idx2 = 2;
                    break;
                }
                case 3: {
                    idx1 = 1;
                    idx2 = 3;
                    break;
                }
                case 4: {
                    idx1 = 0;
                    idx2 = 0;
                    break;
                }
                case 5: {
                    idx1 = 1;
                    idx2 = 1;
                    break;
                }
                case 6: {
                    idx1 = 2;
                    idx2 = 2;
                    break;
                }
                case 7: {
                    idx1 = 3;
                    idx2 = 3;
                }
            }
            for (int y = x; y < 8; ++y) {
                int idx3 = -1;
                int idx4 = -1;
                switch (y) {
                    case 0: {
                        idx3 = 0;
                        idx4 = 1;
                        break;
                    }
                    case 1: {
                        idx3 = 2;
                        idx4 = 3;
                        break;
                    }
                    case 2: {
                        idx3 = 0;
                        idx4 = 2;
                        break;
                    }
                    case 3: {
                        idx3 = 1;
                        idx4 = 3;
                        break;
                    }
                    case 4: {
                        idx3 = 0;
                        idx4 = 0;
                        break;
                    }
                    case 5: {
                        idx3 = 1;
                        idx4 = 1;
                        break;
                    }
                    case 6: {
                        idx3 = 2;
                        idx4 = 2;
                        break;
                    }
                    case 7: {
                        idx3 = 3;
                        idx4 = 3;
                    }
                }
                pCov[x][y] = this.pis4[idx1][idx2][idx3][idx4] - pi[x] * pi[y];
                pCov[y][x] = pCov[x][y];
            }
        }
        double mle = (a - e * f) * (b - g * h) - (c - e * g) * (d - f * h);
        double var = MatrixUtils.innerProduct(MatrixUtils.product(jacobian, pCov), jacobian);
        double std = Math.sqrt(var / (double)this.dataSet.getNumRows());
        return mle / std;
    }

    public double tetradTest2(int i, int j, int k, int l) {
        double a = this.pis[i][j];
        double b = this.pis[k][l];
        double c = this.pis[i][k];
        double d = this.pis[j][l];
        double e = this.pis[i][i];
        double f = this.pis[j][j];
        double g = this.pis[k][k];
        double h = this.pis[l][l];
        this.indices[0] = i;
        this.indices[1] = j;
        this.indices[2] = k;
        this.indices[3] = l;
        this.computeCounts4(this.indices);
        double[] pi = new double[]{a, b, c, d, e, f, g, h};
        double[] jacobian = new double[]{b - g * h, a - e * f, f * h - d, e * g - c, d * g - b * f, c * h - b * e, d * e - a * h, c * f - a * g};
        double[] jacobian2 = new double[]{0.0, jacobian[7], jacobian[6], jacobian[1] + jacobian[6] + jacobian[7], jacobian[5], jacobian[3] + jacobian[5] + jacobian[7], jacobian[5] + jacobian[6], jacobian[3] + jacobian[5] + jacobian[6] + jacobian[7], jacobian[4], jacobian[4] + jacobian[7], jacobian[2] + jacobian[4] + jacobian[6], jacobian[2] + jacobian[1] + jacobian[4] + jacobian[6] + jacobian[7], jacobian[0] + jacobian[4] + jacobian[5], jacobian[0] + jacobian[3] + jacobian[4] + jacobian[5] + jacobian[7], jacobian[0] + jacobian[2] + jacobian[4] + jacobian[5] + jacobian[6], jacobian[0] + jacobian[1] + jacobian[2] + jacobian[3] + jacobian[4] + jacobian[5] + jacobian[6] + jacobian[7]};
        double[][] pCov = new double[16][16];
        for (int v1 = 0; v1 < 2; ++v1) {
            for (int v2 = 0; v2 < 2; ++v2) {
                for (int v3 = 0; v3 < 2; ++v3) {
                    for (int v4 = 0; v4 < 2; ++v4) {
                        for (int vv1 = 0; vv1 < 2; ++vv1) {
                            for (int vv2 = 0; vv2 < 2; ++vv2) {
                                for (int vv3 = 0; vv3 < 2; ++vv3) {
                                    for (int vv4 = 0; vv4 < 2; ++vv4) {
                                        int idx1 = 8 * v1 + 4 * v2 + 2 * v3 + v4;
                                        int idx2 = 8 * vv1 + 4 * vv2 + 2 * vv3 + vv4;
                                        double prob1 = (double)this.counts4[i][j][k][l][v1][v2][v3][v4] / (double)this.sampleSize;
                                        double prob2 = (double)this.counts4[i][j][k][l][vv1][vv2][vv3][vv4] / (double)this.sampleSize;
                                        pCov[idx1][idx2] = idx1 == idx2 ? prob1 * (1.0 - prob1) : -prob1 * prob2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        double[] jacobian3 = new double[15];
        for (int v = 0; v < 15; ++v) {
            jacobian3[v] = jacobian2[v + 1];
        }
        double[][] pCov3 = new double[15][15];
        for (int v = 0; v < 15; ++v) {
            for (int v2 = 0; v2 < 15; ++v2) {
                pCov3[v][v2] = pCov[v + 1][v2 + 1];
            }
        }
        double mle = (a - e * f) * (b - g * h) - (c - e * g) * (d - f * h);
        double var = MatrixUtils.innerProduct(MatrixUtils.product(jacobian3, pCov3), jacobian3);
        double std = Math.sqrt(var / (double)this.dataSet.getNumRows());
        this.stat = -Math.abs(mle) / std;
        System.out.println("original stat = " + this.stat);
        return 2.0 * ProbUtils.normalCdf(this.stat);
    }

    public int tempTetradScore(int v1, int v2, int v3, int v4) {
        this.evalTetradDifferences(v1, v2, v3, v4);
        System.out.println(this.prob[0]);
        System.out.println(this.prob[1]);
        System.out.println(this.prob[2]);
        for (int i = 0; i < 3; ++i) {
            this.bvalues[i] = this.prob[i] >= this.sig;
        }
        if (this.prob[1] < this.prob[0] && this.prob[1] < this.prob[2]) {
            this.tempProb = this.prob[0];
            this.prob[0] = this.prob[1];
            this.prob[1] = this.tempProb;
        } else if (this.prob[2] < this.prob[0] && this.prob[2] < this.prob[0]) {
            this.tempProb = this.prob[0];
            this.prob[0] = this.prob[2];
            this.prob[2] = this.tempProb;
        }
        if (this.prob[2] < this.prob[1]) {
            this.tempProb = this.prob[1];
            this.prob[1] = this.prob[2];
            this.prob[2] = this.tempProb;
        }
        if (this.prob[2] <= this.sig3) {
            return 0;
        }
        if (this.prob[1] <= this.sig2) {
            return 1;
        }
        if (this.prob[0] <= this.sig1) {
            return 3;
        }
        return 3;
    }

    static class FittingFunction
    implements MFWithGradient {
        private final BinaryTetradTest estimator;

        public FittingFunction(BinaryTetradTest estimator) {
            this.estimator = estimator;
        }

        @Override
        public double evaluate(double[] argument) {
            return this.estimator.paramsLikelihood(argument);
        }

        @Override
        public double evaluate(double[] argument, double[] gradient) {
            this.computeGradient(argument, gradient);
            return this.estimator.paramsLikelihood(argument);
        }

        @Override
        public void computeGradient(double[] argument, double[] gradient) {
            this.estimator.computeTwoFactorGradient(argument, gradient);
        }

        @Override
        public int getNumArguments() {
            return 11;
        }

        @Override
        public double getLowerBound(int n) {
            return 0.01;
        }

        @Override
        public double getUpperBound(int n) {
            return 0.99;
        }
    }
}

