/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.ContinuousTetradTest;
import edu.cmu.tetrad.search.DiscreteTetradTest;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndTestGSquare;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Purify;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.search.TetradTest;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerEm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class BuildPureClusters {
    private boolean outputMessage;
    private CorrelationMatrix correlationMatrix;
    private int numVariables;
    private TestType sigTestType;
    private TestType purifyTestType;
    private int[] labels;
    private boolean scoreTestMode;
    private List impurePairs;
    final int EDGE_NONE = 0;
    final int EDGE_BLACK = 1;
    final int EDGE_GRAY = 2;
    final int EDGE_BLUE = 3;
    final int EDGE_YELLOW = 4;
    final int EDGE_RED = 4;
    final int MAX_PURIFY_TRIALS = 50;
    final int MAX_CLIQUE_TRIALS = 50;
    private TetradTest tetradTest;
    private IndependenceTest independenceTest;
    private DataSet dataSet;
    private TetradLogger logger = TetradLogger.getInstance();

    public BuildPureClusters(CovarianceMatrix covarianceMatrix, double alpha, TestType sigTestType, TestType purifyTestType) {
        if (covarianceMatrix == null) {
            throw new IllegalArgumentException("Covariance matrix cannot be null.");
        }
        if (sigTestType == TestType.TETRAD_BOLLEN) {
            throw new RuntimeException("Covariance Matrix is not enough to run Bollen's tetrad test.");
        }
        this.correlationMatrix = new CorrelationMatrix(covarianceMatrix);
        this.initAlgorithm(alpha, sigTestType, purifyTestType);
    }

    public BuildPureClusters(CorrelationMatrix correlationMatrix, double alpha, TestType sigTestType, TestType purifyTestType) {
        if (correlationMatrix == null) {
            throw new IllegalArgumentException("Correlation matrix cannot be null.");
        }
        if (sigTestType == TestType.TETRAD_BOLLEN) {
            throw new RuntimeException("Correlation Matrix is not enough to run Bollen's tetrad test.");
        }
        this.correlationMatrix = correlationMatrix;
        this.initAlgorithm(alpha, sigTestType, purifyTestType);
    }

    public BuildPureClusters(DataSet dataSet, double alpha, TestType sigTestType, TestType purifyTestType) {
        if (dataSet.isContinuous()) {
            this.dataSet = dataSet;
            this.correlationMatrix = new CorrelationMatrix(dataSet);
            this.initAlgorithm(alpha, sigTestType, purifyTestType);
        } else if (dataSet.isDiscrete()) {
            throw new IllegalArgumentException("Discrete data is not supported for this search.");
        }
    }

    private void initAlgorithm(double alpha, TestType sigTestType, TestType purifyTestType) {
        if (DataUtils.containsMissingValue(this.getCorrelationMatrix().getMatrix())) {
            throw new IllegalArgumentException("Please remove or impute missing values first.");
        }
        this.shuffleVariables();
        this.outputMessage = true;
        this.sigTestType = sigTestType;
        this.purifyTestType = purifyTestType;
        boolean bl = this.scoreTestMode = this.sigTestType == TestType.DISCRETE || this.sigTestType == TestType.GAUSSIAN_FACTOR;
        if (sigTestType == TestType.DISCRETE) {
            this.purifyTestType = TestType.NONE;
            this.numVariables = this.dataSet.getNumColumns();
            this.independenceTest = new IndTestGSquare(this.dataSet, alpha);
            this.tetradTest = new DiscreteTetradTest(this.dataSet, alpha);
        } else {
            this.numVariables = this.getCorrelationMatrix().getSize();
            this.independenceTest = new IndTestFisherZ(this.getCorrelationMatrix(), alpha);
            if (sigTestType != TestType.TETRAD_WISHART && sigTestType != TestType.TETRAD_BOLLEN && sigTestType != TestType.GAUSSIAN_FACTOR) {
                throw new IllegalArgumentException("Expecting TETRAD_WISHART, TETRAD_BOLLEN, or GAUSSIAN FACTOR " + sigTestType);
            }
            TestType type = sigTestType;
            this.tetradTest = sigTestType == TestType.TETRAD_BOLLEN || purifyTestType == TestType.TETRAD_BOLLEN ? new ContinuousTetradTest(this.dataSet, type, alpha) : new ContinuousTetradTest(this.getCorrelationMatrix(), type, alpha);
        }
        this.impurePairs = new ArrayList();
        this.labels = new int[this.numVariables()];
        for (int i = 0; i < this.numVariables(); ++i) {
            this.labels[i] = i + 1;
        }
    }

    private void shuffleVariables() {
        int numVariables = this.getCorrelationMatrix() != null ? this.getCorrelationMatrix().getSize() : this.dataSet.getNumColumns();
        this.print("Shuffling variable order...");
        ArrayList<Integer> indicesList = new ArrayList<Integer>();
        for (int i = 0; i < numVariables; ++i) {
            indicesList.add(i);
        }
        Collections.shuffle(indicesList);
        int[] indices = new int[numVariables];
        for (int i = 0; i < numVariables; ++i) {
            indices[i] = (Integer)indicesList.get(i);
        }
        if (this.getCorrelationMatrix() != null) {
            this.correlationMatrix = this.getCorrelationMatrix().getSubCorrMatrix(indices);
        }
        if (this.dataSet != null) {
            this.dataSet = this.dataSet.subsetColumns(indices);
        }
    }

    public Graph search() {
        Date start = new Date();
        this.print("\n**************Starting BPC search!!!*************\n");
        List clustering = this.findMeasurementPattern();
        Date end = new Date();
        this.print("Started at " + start.toString() + ", finished at " + end.toString());
        Graph graph = this.convertSearchGraph(clustering);
        if (graph.getNumNodes() > 1) {
            SemOptimizerEm optimizer = new SemOptimizerEm();
            SemPm semPm = new SemPm(graph);
            SemEstimator estimator = new SemEstimator(this.getCorrelationMatrix(), semPm, (SemOptimizer)optimizer);
            estimator.estimate();
            this.print("chisq = " + estimator.getEstimatedSem().getChiSquare());
            this.print("p-value = " + estimator.getEstimatedSem().getPValue());
        }
        this.logger.log("graph", "\nReturning this graph: " + graph);
        return graph;
    }

    private Graph convertSearchGraph(List clusters) {
        int i;
        int i2;
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (clusters == null || clusters.size() == 0) {
            nodes.add(new GraphNode("No_model."));
            return new EdgeListGraph(nodes);
        }
        HashSet<GraphNode> latentsSet = new HashSet<GraphNode>();
        for (i2 = 0; i2 < clusters.size(); ++i2) {
            GraphNode latent = new GraphNode("_L" + (i2 + 1));
            latent.setNodeType(NodeType.LATENT);
            nodes.add(latent);
            latentsSet.add(latent);
        }
        for (i2 = 0; i2 < clusters.size(); ++i2) {
            int[] indicators = (int[])clusters.get(i2);
            for (int j = 0; j < indicators.length; ++j) {
                String indicatorName = this.tetradTest.getVarNames()[indicators[j]];
                System.out.println("Indicator name = " + indicatorName);
                GraphNode indicator = new GraphNode(indicatorName);
                nodes.add(indicator);
            }
            System.out.println();
        }
        EdgeListGraph graph = new EdgeListGraph(nodes);
        int acc = clusters.size();
        for (i = 0; i < clusters.size(); ++i) {
            int j;
            int[] indicators = (int[])clusters.get(i);
            for (j = 0; j < indicators.length; ++j) {
                graph.setEndpoint((Node)nodes.get(i), (Node)nodes.get(acc), Endpoint.ARROW);
                graph.setEndpoint((Node)nodes.get(acc), (Node)nodes.get(i), Endpoint.TAIL);
                ++acc;
            }
            for (j = i + 1; j < clusters.size(); ++j) {
                graph.removeEdges((Node)nodes.get(i), (Node)nodes.get(j));
            }
        }
        this.print("#ImpurePairs = " + this.impurePairs.size() / 2);
        for (i = 0; i < this.impurePairs.size(); i += 2) {
            graph.setEndpoint((Node)this.impurePairs.get(i), (Node)this.impurePairs.get(i + 1), Endpoint.ARROW);
            graph.setEndpoint((Node)this.impurePairs.get(i + 1), (Node)this.impurePairs.get(i), Endpoint.ARROW);
        }
        return graph;
    }

    public void setHighPrecision(boolean p) {
        if (this.tetradTest instanceof DiscreteTetradTest) {
            ((DiscreteTetradTest)this.tetradTest).setHighPrecision(p);
        }
    }

    public boolean getHighPrecision() {
        if (this.tetradTest instanceof DiscreteTetradTest) {
            return ((DiscreteTetradTest)this.tetradTest).getHighPrecision();
        }
        return false;
    }

    private List convertGraphToList(Graph solutionGraph) {
        this.impurePairs.clear();
        Iterator<Node> it1 = solutionGraph.getNodes().iterator();
        ArrayList<Node> latentsList = new ArrayList<Node>();
        ArrayList clusters = new ArrayList();
        while (it1.hasNext()) {
            Node next = it1.next();
            if (next.getNodeType() != NodeType.LATENT) continue;
            latentsList.add(next);
            clusters.add(new ArrayList());
        }
        for (Node next : solutionGraph.getNodes()) {
            if (next.getNodeType() == NodeType.LATENT) continue;
            for (int w = 0; w < latentsList.size(); ++w) {
                if (!solutionGraph.getNodesInTo(next, Endpoint.ARROW).contains(latentsList.get(w))) continue;
                ((ArrayList)clusters.get(w)).add(next);
            }
        }
        ArrayList<int[]> arrayClusters = new ArrayList<int[]>();
        String[] names = this.tetradTest.getVarNames();
        for (int w = 0; w < clusters.size(); ++w) {
            List listCluster = (List)clusters.get(w);
            int[] newCluster = new int[listCluster.size()];
            block4: for (int v = 0; v < newCluster.length; ++v) {
                for (int s = 0; s < names.length; ++s) {
                    if (!names[s].equals(listCluster.get(v).toString())) continue;
                    newCluster[v] = s;
                    continue block4;
                }
            }
            arrayClusters.add(newCluster);
        }
        for (int i = 0; i < solutionGraph.getNodes().size() - 1; ++i) {
            for (int j = i + 1; j < solutionGraph.getNodes().size(); ++j) {
                Node nodei = solutionGraph.getNodes().get(i);
                Node nodej = solutionGraph.getNodes().get(j);
                if (nodei.getNodeType() == NodeType.LATENT || nodej.getNodeType() == NodeType.LATENT || !solutionGraph.isAdjacentTo(nodei, nodej)) continue;
                this.impurePairs.add(solutionGraph.getNodes().get(i));
                this.impurePairs.add(solutionGraph.getNodes().get(j));
            }
        }
        return arrayClusters;
    }

    private boolean uncorrelatedPopulation(int v1, int v2) {
        return Math.abs(this.getCorrelationMatrix().getValue(v1, v2)) < 1.0E-4;
    }

    private boolean vanishingPartialCorrPopulation(int x, int y, int z) {
        double pc = this.getCorrelationMatrix().getValue(x, y) - this.getCorrelationMatrix().getValue(x, z) * this.getCorrelationMatrix().getValue(y, z);
        double r = 0.5 * Math.sqrt(this.getCorrelationMatrix().getSampleSize() - 4) * Math.log((1.0 + (pc /= Math.sqrt(1.0 - this.getCorrelationMatrix().getValue(x, z) * this.getCorrelationMatrix().getValue(x, z)) * Math.sqrt(1.0 - this.getCorrelationMatrix().getValue(y, z) * this.getCorrelationMatrix().getValue(y, z)))) / (1.0 - pc));
        return Math.abs(r) <= 1.0E-4;
    }

    private boolean unclusteredPartial1(int v1, int v2, int v3, int v4) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(v1, v2, v3, v4);
        }
        return this.tetradTest.tetradScore3(v1, v2, v3, v4);
    }

    private boolean validClusterPairPartial1(int v1, int v2, int v3, int v4, int[][] cv) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(v1, v2, v3, v4);
        }
        if (cv[v1][v4] == 0 && cv[v2][v4] == 0 && cv[v3][v4] == 0) {
            return true;
        }
        boolean test1 = this.tetradTest.tetradHolds(v1, v2, v3, v4);
        boolean test2 = this.tetradTest.tetradHolds(v1, v2, v4, v3);
        if (test1 && test2) {
            return true;
        }
        boolean test3 = this.tetradTest.tetradHolds(v1, v3, v4, v2);
        return test1 && test3 || test2 && test3;
    }

    private boolean unclusteredPartial2(int v1, int v2, int v3, int v4, int v5) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(v1, v2, v3, v5) && !this.tetradTest.oneFactorTest(v1, v2, v3, v4, v5) && this.tetradTest.twoFactorTest(v1, v2, v3, v4, v5);
        }
        return this.tetradTest.tetradScore3(v1, v2, v3, v5) && this.tetradTest.tetradScore1(v1, v2, v4, v5) && this.tetradTest.tetradScore1(v2, v3, v4, v5) && this.tetradTest.tetradScore1(v1, v3, v4, v5);
    }

    private boolean validClusterPairPartial2(int v1, int v2, int v3, int v5, int[][] cv) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(v1, v2, v3, v5);
        }
        if (cv[v1][v5] == 0 && cv[v2][v5] == 0 && cv[v3][v5] == 0) {
            return true;
        }
        boolean test1 = this.tetradTest.tetradHolds(v1, v2, v3, v5);
        boolean test2 = this.tetradTest.tetradHolds(v1, v2, v5, v3);
        boolean test3 = this.tetradTest.tetradHolds(v1, v3, v5, v2);
        return test1 && test2 || test1 && test3 || test2 && test3;
    }

    private boolean unclusteredPartial3(int v1, int v2, int v3, int v4, int v5, int v6) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(v1, v2, v3, v6) && this.tetradTest.oneFactorTest(v4, v5, v6, v1) && this.tetradTest.oneFactorTest(v4, v5, v6, v2) && this.tetradTest.oneFactorTest(v4, v5, v6, v3) && this.tetradTest.twoFactorTest(v1, v2, v3, v4, v5, v6);
        }
        return this.tetradTest.tetradScore3(v1, v2, v3, v6) && this.tetradTest.tetradScore3(v4, v5, v6, v1) && this.tetradTest.tetradScore3(v4, v5, v6, v2) && this.tetradTest.tetradScore3(v4, v5, v6, v3) && this.tetradTest.tetradScore1(v1, v2, v4, v6) && this.tetradTest.tetradScore1(v1, v2, v5, v6) && this.tetradTest.tetradScore1(v2, v3, v4, v6) && this.tetradTest.tetradScore1(v2, v3, v5, v6) && this.tetradTest.tetradScore1(v1, v3, v4, v6) && this.tetradTest.tetradScore1(v1, v3, v5, v6);
    }

    private boolean validClusterPairPartial3(int v1, int v2, int v3, int v4, int v5, int v6, int[][] cv) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(v1, v2, v3, v6) && this.tetradTest.oneFactorTest(v4, v5, v6, v1) && this.tetradTest.oneFactorTest(v4, v5, v6, v2) && this.tetradTest.oneFactorTest(v4, v5, v6, v3);
        }
        if (cv[v1][v6] == 0 && cv[v2][v6] == 0 && cv[v3][v6] == 0) {
            return true;
        }
        boolean test1 = this.tetradTest.tetradHolds(v1, v2, v3, v6);
        boolean test2 = this.tetradTest.tetradHolds(v1, v2, v6, v3);
        boolean test3 = this.tetradTest.tetradHolds(v1, v3, v6, v2);
        if (!(test1 && test2 || test1 && test3 || test2 && test3)) {
            return false;
        }
        test1 = this.tetradTest.tetradHolds(v4, v5, v6, v1);
        test2 = this.tetradTest.tetradHolds(v4, v5, v1, v6);
        test3 = this.tetradTest.tetradHolds(v4, v6, v1, v5);
        if (!(test1 && test2 || test1 && test3 || test2 && test3)) {
            return false;
        }
        test1 = this.tetradTest.tetradHolds(v4, v5, v6, v2);
        test2 = this.tetradTest.tetradHolds(v4, v5, v2, v6);
        test3 = this.tetradTest.tetradHolds(v4, v6, v2, v5);
        if (!(test1 && test2 || test1 && test3 || test2 && test3)) {
            return false;
        }
        test1 = this.tetradTest.tetradHolds(v4, v5, v6, v3);
        test2 = this.tetradTest.tetradHolds(v4, v5, v3, v6);
        test3 = this.tetradTest.tetradHolds(v4, v6, v3, v5);
        return test1 && test2 || test1 && test3 || test2 && test3;
    }

    private boolean partialRule1_1(int x1, int x2, int x3, int y1) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(x1, y1, x2, x3);
        }
        return this.tetradTest.tetradScore3(x1, y1, x2, x3);
    }

    private boolean partialRule1_2(int x1, int x2, int y1, int y2) {
        if (this.scoreTestMode) {
            return !this.tetradTest.oneFactorTest(x1, x2, y1, y2) && this.tetradTest.twoFactorTest(x1, x2, y1, y2);
        }
        return !this.tetradTest.tetradHolds(x1, x2, y2, y1) && !this.tetradTest.tetradHolds(x1, y1, x2, y2) && this.tetradTest.tetradHolds(x1, y1, y2, x2);
    }

    private boolean partialRule1_3(int x1, int y1, int y2, int y3) {
        if (this.scoreTestMode) {
            return this.tetradTest.oneFactorTest(x1, y1, y2, y3);
        }
        return this.tetradTest.tetradScore3(x1, y1, y2, y3);
    }

    private boolean partialRule2_1(int x1, int x2, int y1, int y2) {
        if (this.scoreTestMode) {
            return !this.tetradTest.oneFactorTest(x1, x2, y1, y2) && this.tetradTest.twoFactorTest(x1, x2, y1, y2);
        }
        return this.tetradTest.tetradHolds(x1, y1, y2, x2) && !this.tetradTest.tetradHolds(x1, x2, y2, y1) && !this.tetradTest.tetradHolds(x1, y1, x2, y2) && this.tetradTest.tetradHolds(x1, y1, y2, x2);
    }

    private boolean partialRule2_2(int x1, int x2, int x3, int y2) {
        if (this.scoreTestMode) {
            return this.tetradTest.twoFactorTest(x1, x3, x2, y2);
        }
        return this.tetradTest.tetradHolds(x1, x2, y2, x3);
    }

    private boolean partialRule2_3(int x2, int y1, int y2, int y3) {
        if (this.scoreTestMode) {
            this.tetradTest.twoFactorTest(x2, y2, y1, y3);
        }
        return this.tetradTest.tetradHolds(x2, y1, y3, y2);
    }

    private boolean uncorrelated(int v1, int v2) {
        if (this.getCorrelationMatrix() != null) {
            if (this.getIndependenceTest().isIndependent(this.getCorrelationMatrix().getVariables().get(v1), this.getCorrelationMatrix().getVariables().get(v2), new ArrayList<Node>())) {
                System.out.println(this.getCorrelationMatrix().getVariables().get(v1) + " " + this.getCorrelationMatrix().getVariables().get(v2) + " == " + this.getCorrelationMatrix().getValue(v1, v2));
            }
            return this.getIndependenceTest().isIndependent(this.getCorrelationMatrix().getVariables().get(v1), this.getCorrelationMatrix().getVariables().get(v2), new ArrayList<Node>());
        }
        return this.getIndependenceTest().isIndependent(this.dataSet.getVariable(v1), this.dataSet.getVariable(v2), new ArrayList<Node>());
    }

    private boolean vanishingPartialCorr(int x, int y, int z) {
        return false;
    }

    private void printClustering(List clustering) {
        for (int[] c : clustering) {
            this.printClusterNames(c);
        }
    }

    private void printClusterIds(int[] c) {
        int i;
        int[] sorted = new int[c.length];
        for (i = 0; i < c.length; ++i) {
            sorted[i] = this.labels[c[i]];
        }
        for (i = 0; i < sorted.length - 1; ++i) {
            int min = 1000000;
            int min_idx = -1;
            for (int j = i; j < sorted.length; ++j) {
                if (sorted[j] >= min) continue;
                min = sorted[j];
                min_idx = j;
            }
            int temp = sorted[i];
            sorted[i] = min;
            sorted[min_idx] = temp;
        }
        for (i = 0; i < sorted.length; ++i) {
            this.printMessage(sorted[i] + " ");
        }
        this.printlnMessage();
    }

    private void printClusterNames(int[] c) {
        int i;
        String[] sorted = new String[c.length];
        for (i = 0; i < c.length; ++i) {
            sorted[i] = this.tetradTest.getVarNames()[c[i]];
        }
        for (i = 0; i < sorted.length - 1; ++i) {
            String min = sorted[i];
            int min_idx = i;
            for (int j = i + 1; j < sorted.length; ++j) {
                if (sorted[j].compareTo(min) >= 0) continue;
                min = sorted[j];
                min_idx = j;
            }
            String temp = sorted[i];
            sorted[i] = min;
            sorted[min_idx] = temp;
        }
        for (i = 0; i < sorted.length; ++i) {
            this.printMessage(sorted[i] + " ");
        }
        this.printlnMessage();
    }

    private void printLatentClique(int[] latents, int size) {
        int i;
        this.printMessage(">>> CLUSTER CLIQUE: ");
        int[] sorted = new int[latents.length];
        System.arraycopy(latents, 0, sorted, 0, latents.length);
        for (i = 0; i < sorted.length - 1; ++i) {
            int min = 1000000;
            int min_idx = -1;
            for (int j = i; j < sorted.length; ++j) {
                if (sorted[j] >= min) continue;
                min = sorted[j];
                min_idx = j;
            }
            int temp = sorted[i];
            sorted[i] = min;
            sorted[min_idx] = temp;
        }
        for (i = 0; i < sorted.length; ++i) {
            this.printMessage("T" + (sorted[i] + 1) + " ");
        }
        this.print(" SIZE = " + size);
    }

    void printMessage(String message) {
        if (this.outputMessage) {
            System.out.print(message);
        }
    }

    void print(String message) {
        if (this.outputMessage) {
            System.out.println(message);
        }
    }

    void printlnMessage() {
        if (this.outputMessage) {
            System.out.println();
        }
    }

    void printlnMessage(boolean flag) {
        if (this.outputMessage) {
            System.out.println(flag);
        }
    }

    private List findComponents(int[][] graph, int size, int color) {
        boolean[] marked = new boolean[size];
        for (int i = 0; i < size; ++i) {
            marked[i] = false;
        }
        int numMarked = 0;
        ArrayList<int[]> output = new ArrayList<int[]>();
        int[] tempComponent = new int[size];
        while (numMarked != size) {
            boolean noChange;
            int sizeTemp = 0;
            do {
                noChange = true;
                for (int i = 0; i < size; ++i) {
                    if (marked[i]) continue;
                    boolean inComponent = false;
                    for (int j = 0; j < sizeTemp && !inComponent; ++j) {
                        if (graph[i][tempComponent[j]] != color) continue;
                        inComponent = true;
                    }
                    if (sizeTemp != 0 && !inComponent) continue;
                    tempComponent[sizeTemp++] = i;
                    marked[i] = true;
                    noChange = false;
                    ++numMarked;
                }
            } while (!noChange);
            if (sizeTemp <= true) continue;
            int[] newPartition = new int[sizeTemp];
            for (int i = 0; i < sizeTemp; ++i) {
                newPartition[i] = tempComponent[i];
            }
            output.add(newPartition);
        }
        return output;
    }

    private List findMaximalCliques(int[] elements, int[][] ng) {
        boolean[][] connected = new boolean[this.numVariables()][this.numVariables()];
        for (int i = 0; i < connected.length; ++i) {
            for (int j = i; j < connected.length; ++j) {
                if (i != j) {
                    boolean bl = ng[i][j] != 0;
                    connected[j][i] = bl;
                    connected[i][j] = bl;
                    continue;
                }
                connected[i][j] = true;
            }
        }
        int[] numCalls = new int[]{0};
        int[] c = new int[]{0};
        ArrayList output = new ArrayList();
        int[] compsub = new int[elements.length];
        int[] old = new int[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            old[i] = elements[i];
        }
        this.findMaximalCliquesOperator(numCalls, elements, output, connected, compsub, c, old, 0, elements.length);
        return output;
    }

    private void findMaximalCliquesOperator(int[] numCalls, int[] elements, List output, boolean[][] connected, int[] compsub, int[] c, int[] old, int ne, int ce) {
        int p;
        int i;
        if (numCalls[0] > 50) {
            return;
        }
        int[] newA = new int[ce];
        int fixp = -1;
        int pos = -1;
        int s = -1;
        int minnod = ce;
        int nod = 0;
        for (i = 0; i < ce && minnod != 0; ++i) {
            p = old[i];
            int count = 0;
            for (int j = ne; j < ce && count < minnod; ++j) {
                if (connected[p][old[j]]) continue;
                ++count;
                pos = j;
            }
            if (count >= minnod) continue;
            fixp = p;
            minnod = count;
            if (i < ne) {
                s = pos;
                continue;
            }
            s = i;
            nod = 1;
        }
        for (nod = minnod + nod; nod >= 1; --nod) {
            p = old[s];
            old[s] = old[ne];
            int sel = old[ne] = p;
            int newne = 0;
            for (i = 0; i < ne; ++i) {
                if (!connected[sel][old[i]]) continue;
                newA[newne++] = old[i];
            }
            int newce = newne;
            for (i = ne + 1; i < ce; ++i) {
                if (!connected[sel][old[i]]) continue;
                newA[newce++] = old[i];
            }
            int n = c[0];
            c[0] = n + 1;
            compsub[n] = sel;
            if (newce == 0) {
                int[] clique = new int[c[0]];
                System.arraycopy(compsub, 0, clique, 0, c[0]);
                output.add(clique);
            } else if (newne < newce) {
                numCalls[0] = numCalls[0] + 1;
                this.findMaximalCliquesOperator(numCalls, elements, output, connected, compsub, c, newA, newne, newce);
            }
            c[0] = c[0] - 1;
            ++ne;
            if (nod <= 1) continue;
            s = ne;
            while (connected[fixp][old[s]]) {
                ++s;
            }
        }
    }

    private boolean cliqueContained(int[] newClique, int size, List clustering) {
        for (int[] next : clustering) {
            if (size > next.length) continue;
            boolean found = true;
            block1: for (int i = 0; i < size && found; ++i) {
                found = false;
                for (int j = 0; j < next.length && !found; ++j) {
                    if (newClique[i] != next[j]) continue;
                    found = true;
                    continue block1;
                }
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    private List trimCliqueList(List cliqueList) {
        ArrayList<int[]> trimmed = new ArrayList<int[]>();
        ArrayList<int[]> cliqueCopy = new ArrayList<int[]>();
        cliqueCopy.addAll(cliqueList);
        for (int[] cluster : cliqueList) {
            cliqueCopy.remove(cluster);
            if (!this.cliqueContained(cluster, cluster.length, cliqueCopy)) {
                trimmed.add(cluster);
            }
            cliqueCopy.add(cluster);
        }
        return trimmed;
    }

    private int clustersize(List cluster) {
        int total = 0;
        for (int[] next : cluster) {
            total += next.length;
        }
        return total;
    }

    private int clustersize3(List cluster) {
        int total = 0;
        for (int[] next : cluster) {
            if (next.length <= 2) continue;
            total += next.length;
        }
        return total;
    }

    private void sortClusterings(int start, int end, List clusterings, int[] criterion) {
        for (int i = start; i < end - 1; ++i) {
            int max = -1;
            int max_idx = -1;
            for (int j = i; j < end; ++j) {
                if (criterion[j] <= max) continue;
                max = criterion[j];
                max_idx = j;
            }
            Object temp = clusterings.get(i);
            clusterings.set(i, clusterings.get(max_idx));
            clusterings.set(max_idx, temp);
            int old_c = criterion[i];
            criterion[i] = criterion[max_idx];
            criterion[max_idx] = old_c;
        }
    }

    private int scoreClustering(List clustering, int[][] ng, boolean[] buffer) {
        int score = 0;
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = true;
        }
        for (int[] currentCluster : clustering) {
            block2: for (int i = 0; i < currentCluster.length; ++i) {
                if (!buffer[currentCluster[i]]) continue;
                for (int[] nextCluster : clustering) {
                    if (nextCluster == currentCluster) continue;
                    for (int j = 0; j < nextCluster.length; ++j) {
                        if (currentCluster[i] != nextCluster[j]) continue;
                        buffer[currentCluster[i]] = false;
                        continue block2;
                    }
                }
            }
        }
        for (int c1 = 0; c1 < clustering.size(); ++c1) {
            int[] currentCluster = (int[])clustering.get(c1);
            int localScore = 0;
            for (int i = 0; i < currentCluster.length; ++i) {
                if (!buffer[currentCluster[i]]) continue;
                for (int c2 = c1 + 1; c2 < clustering.size(); ++c2) {
                    int[] nextCluster = (int[])clustering.get(c2);
                    for (int j = 0; j < nextCluster.length; ++j) {
                        if (buffer[nextCluster[j]]) continue;
                    }
                }
                ++localScore;
            }
            if (localScore <= true) continue;
            score += localScore;
        }
        return score;
    }

    private List filterAndOrderClusterings(List baseListOfClusterings, List baseListOfIds, List clusteringIds, int[][] ng) {
        int i;
        assert (clusteringIds != null);
        ArrayList listOfClusterings = new ArrayList();
        clusteringIds.clear();
        for (int i2 = 0; i2 < baseListOfClusterings.size(); ++i2) {
            ArrayList<int[]> newClustering = new ArrayList<int[]>();
            List baseClustering = (List)baseListOfClusterings.get(i2);
            System.out.println("* Base clustering");
            this.printClustering(baseClustering);
            List baseIds = (List)baseListOfIds.get(i2);
            ArrayList<Integer> usedIds = new ArrayList<Integer>();
            for (int j = 0; j < baseClustering.size(); ++j) {
                int[] currentCluster = (int[])baseClustering.get(j);
                Integer currentId = (Integer)baseIds.get(j);
                int[] draftArea = new int[currentCluster.length];
                int draftCount = 0;
                block2: for (int jj = 0; jj < currentCluster.length; ++jj) {
                    for (int k = 0; k < baseClustering.size(); ++k) {
                        if (k == j) continue;
                        int[] nextCluster = (int[])baseClustering.get(k);
                        for (int q = 0; q < nextCluster.length; ++q) {
                            if (currentCluster[jj] == nextCluster[q]) continue block2;
                        }
                    }
                    draftArea[draftCount++] = currentCluster[jj];
                }
                if (draftCount <= true) continue;
                int[] newCluster = new int[draftCount];
                System.arraycopy(draftArea, 0, newCluster, 0, draftCount);
                newClustering.add(newCluster);
                usedIds.add(currentId);
            }
            System.out.println("* Filtered clustering 1");
            this.printClustering(newClustering);
            boolean[][] impurities = new boolean[this.numVariables()][this.numVariables()];
            for (int j = 0; j < newClustering.size() - 1; ++j) {
                int[] currentCluster = (int[])newClustering.get(j);
                for (int jj = j + 1; jj < currentCluster.length; ++jj) {
                    for (int k = 0; k < newClustering.size(); ++k) {
                        if (k == j) continue;
                        int[] nextCluster = (int[])newClustering.get(k);
                        for (int q = 0; q < nextCluster.length; ++q) {
                            impurities[currentCluster[jj]][nextCluster[q]] = ng[currentCluster[jj]][nextCluster[q]] != 0;
                            impurities[nextCluster[q]][currentCluster[jj]] = impurities[currentCluster[jj]][nextCluster[q]];
                        }
                    }
                }
            }
            List newClustering2 = this.removeMarkedImpurities(newClustering, impurities);
            ArrayList finalNewClustering = new ArrayList();
            ArrayList finalUsedIds = new ArrayList();
            for (int j = 0; j < newClustering2.size(); ++j) {
                if (((int[])newClustering2.get(j)).length <= 0) continue;
                finalNewClustering.add(newClustering2.get(j));
                finalUsedIds.add(usedIds.get(j));
            }
            if (finalNewClustering.size() <= 0) continue;
            listOfClusterings.add(finalNewClustering);
            int[] usedIdsArray = new int[finalUsedIds.size()];
            for (int j = 0; j < finalUsedIds.size(); ++j) {
                usedIdsArray[j] = (Integer)finalUsedIds.get(j);
            }
            clusteringIds.add(usedIdsArray);
            System.out.println("* Filtered clustering 2");
            this.printClustering(finalNewClustering);
            System.out.print("* ID/Size: ");
            this.printLatentClique(usedIdsArray, this.clustersize3(finalNewClustering));
            System.out.println();
        }
        int[] numIndicators = new int[listOfClusterings.size()];
        for (i = 0; i < listOfClusterings.size(); ++i) {
            numIndicators[i] = this.clustersize3((List)listOfClusterings.get(i));
        }
        this.sortClusterings(0, listOfClusterings.size(), listOfClusterings, numIndicators);
        for (i = 0; i < listOfClusterings.size(); ++i) {
            numIndicators[i] = this.clustersize((List)listOfClusterings.get(i));
        }
        int start = 0;
        while (start < listOfClusterings.size()) {
            int size3 = this.clustersize3((List)listOfClusterings.get(start));
            int end = start + 1;
            for (int j = start + 1; j < listOfClusterings.size() && size3 == this.clustersize3((List)listOfClusterings.get(j)); ++j) {
                ++end;
            }
            this.sortClusterings(start, end, listOfClusterings, numIndicators);
            start = end;
        }
        for (int i3 = 0; i3 < listOfClusterings.size(); ++i3) {
            this.printMessage("    >>> ");
            this.printLatentClique((int[])clusteringIds.get(i3), numIndicators[i3]);
        }
        this.printlnMessage();
        return listOfClusterings;
    }

    private List removeMarkedImpurities(List partition, boolean[][] impurities) {
        int i;
        System.out.println("sizecluster = " + this.clustersize(partition));
        int[][] elements = new int[this.clustersize(partition)][3];
        int[] partitionCount = new int[partition.size()];
        int countElements = 0;
        for (int p = 0; p < partition.size(); ++p) {
            int[] next = (int[])partition.get(p);
            partitionCount[p] = 0;
            for (int i2 = 0; i2 < next.length; ++i2) {
                elements[countElements][0] = next[i2];
                elements[countElements][1] = p;
                ++countElements;
                int n = p;
                partitionCount[n] = partitionCount[n] + 1;
            }
        }
        for (int i3 = 0; i3 < elements.length; ++i3) {
            elements[i3][2] = 0;
            for (int j = 0; j < elements.length; ++j) {
                if (!impurities[elements[i3][0]][elements[j][0]]) continue;
                int[] nArray = elements[i3];
                nArray[2] = nArray[2] + 1;
            }
        }
        boolean[] eliminated = new boolean[this.numVariables()];
        for (i = 0; i < eliminated.length; ++i) {
            eliminated[i] = false;
        }
        while (!this.validSolution(elements, eliminated)) {
            this.sortByImpurityPriority(elements, partitionCount, eliminated);
            eliminated[elements[0][0]] = true;
            for (i = 0; i < elements.length; ++i) {
                if (!impurities[elements[i][0]][elements[0][0]]) continue;
                int[] nArray = elements[i];
                nArray[2] = nArray[2] - 1;
            }
            int n = elements[0][1];
            partitionCount[n] = partitionCount[n] - 1;
        }
        ArrayList<int[]> solution = new ArrayList<int[]>();
        for (int[] next : partition) {
            int[] draftArea = new int[next.length];
            int draftCount = 0;
            for (int i4 = 0; i4 < next.length; ++i4) {
                for (int j = 0; j < elements.length; ++j) {
                    if (elements[j][0] != next[i4] || eliminated[elements[j][0]]) continue;
                    draftArea[draftCount++] = next[i4];
                }
            }
            if (draftCount <= 0) continue;
            int[] realCluster = new int[draftCount];
            System.arraycopy(draftArea, 0, realCluster, 0, draftCount);
            solution.add(realCluster);
        }
        return solution;
    }

    private void sortByImpurityPriority(int[][] elements, int[] partitionCount, boolean[] eliminated) {
        int j;
        int total;
        int[] temp = new int[3];
        block0: for (int i = 0; i < elements.length - 1; ++i) {
            if (!eliminated[elements[i][0]]) continue;
            for (int j2 = i + 1; j2 < elements.length; ++j2) {
                if (eliminated[elements[j2][0]]) continue;
                this.swapElements(elements, i, j2, temp);
                continue block0;
            }
        }
        for (total = 0; total < elements.length && !eliminated[elements[total][0]]; ++total) {
        }
        for (int i = 0; i < total - 1; ++i) {
            int max = -1;
            int max_idx = -1;
            for (j = i; j < total; ++j) {
                if (elements[j][2] <= max) continue;
                max = elements[j][2];
                max_idx = j;
            }
            this.swapElements(elements, i, max_idx, temp);
        }
        int start = 0;
        while (start < total) {
            int i;
            int size = partitionCount[elements[start][1]];
            int end = start + 1;
            for (j = start + 1; j < total && size == partitionCount[elements[j][1]]; ++j) {
                ++end;
            }
            for (i = start + 1; i < end; ++i) {
                if (partitionCount[elements[i][1]] != 1) continue;
                this.swapElements(elements, i, start, temp);
                ++start;
            }
            for (i = start + 1; i < end; ++i) {
                if (partitionCount[elements[i][1]] != 2) continue;
                this.swapElements(elements, i, start, temp);
                ++start;
            }
            for (i = start; i < end - 1; ++i) {
                int max = -1;
                int max_idx = -1;
                for (int j3 = i; j3 < end; ++j3) {
                    if (partitionCount[elements[j3][1]] <= max) continue;
                    max = partitionCount[elements[j3][1]];
                    max_idx = j3;
                }
                this.swapElements(elements, i, max_idx, temp);
            }
            start = end;
        }
    }

    private void swapElements(int[][] elements, int i, int j, int[] buffer) {
        buffer[0] = elements[i][0];
        buffer[1] = elements[i][1];
        buffer[2] = elements[i][2];
        elements[i][0] = elements[j][0];
        elements[i][1] = elements[j][1];
        elements[i][2] = elements[j][2];
        elements[j][0] = buffer[0];
        elements[j][1] = buffer[1];
        elements[j][2] = buffer[2];
    }

    private boolean validSolution(int[][] elements, boolean[] eliminated) {
        for (int i = 0; i < elements.length; ++i) {
            if (eliminated[elements[i][0]] || elements[i][2] <= 0) continue;
            return false;
        }
        return true;
    }

    private List initialMeasurementPattern(int[][] ng, int[][] cv) {
        int v4;
        int v3;
        boolean notFound;
        int j;
        int i;
        int v2;
        int v1;
        boolean[][] notYellow = new boolean[this.numVariables()][this.numVariables()];
        this.print("\n****************\nFIND PATTERN!!!\n****************\n");
        this.print(">> Stage 0.1");
        for (v1 = 0; v1 < this.numVariables() - 1; ++v1) {
            for (v2 = v1 + 1; v2 < this.numVariables(); ++v2) {
                ng[v2][v1] = 1;
                ng[v1][v2] = 1;
            }
        }
        for (v1 = 0; v1 < this.numVariables() - 1; ++v1) {
            for (v2 = v1 + 1; v2 < this.numVariables(); ++v2) {
                if (this.uncorrelated(v1, v2)) {
                    cv[v2][v1] = 0;
                    cv[v1][v2] = 0;
                } else {
                    cv[v2][v1] = 1;
                    cv[v1][v2] = 1;
                }
                int n = cv[v1][v2];
                ng[v2][v1] = n;
                ng[v1][v2] = n;
            }
        }
        for (v1 = 0; v1 < this.numVariables() - 1; ++v1) {
            block5: for (v2 = v1 + 1; v2 < this.numVariables(); ++v2) {
                if (cv[v1][v2] == 0) continue;
                for (int v32 = 0; v32 < this.numVariables(); ++v32) {
                    if (v1 == v32 || v2 == v32 || !this.vanishingPartialCorr(v1, v2, v32)) continue;
                    cv[v2][v1] = 0;
                    cv[v1][v2] = 0;
                    continue block5;
                }
            }
        }
        for (i = 0; i < this.numVariables(); ++i) {
            for (j = i + 1; j < this.numVariables(); ++j) {
                if (cv[i][j] != 0) continue;
                this.print(this.tetradTest.getVarNames()[i] + " || " + this.tetradTest.getVarNames()[j] + "? YES");
            }
        }
        for (v1 = 0; v1 < this.numVariables() - 1; ++v1) {
            for (v2 = v1 + 1; v2 < this.numVariables(); ++v2) {
                if (ng[v1][v2] != 1) continue;
                notFound = true;
                for (v3 = 0; v3 < this.numVariables() - 1 && notFound; ++v3) {
                    if (v1 == v3 || v2 == v3 || ng[v1][v3] == 0 || ng[v1][v3] == 2 || ng[v2][v3] == 0 || ng[v2][v3] == 2) continue;
                    for (v4 = v3 + 1; v4 < this.numVariables() && notFound; ++v4) {
                        if (v1 == v4 || v2 == v4 || ng[v1][v4] == 0 || ng[v1][v4] == 2 || ng[v2][v4] == 0 || ng[v2][v4] == 2 || ng[v3][v4] == 0 || ng[v3][v4] == 2 || !this.tetradTest.tetradScore3(v1, v2, v3, v4)) continue;
                        notFound = false;
                        ng[v2][v1] = 3;
                        ng[v1][v2] = 3;
                        ng[v3][v1] = 3;
                        ng[v1][v3] = 3;
                        ng[v4][v1] = 3;
                        ng[v1][v4] = 3;
                        ng[v3][v2] = 3;
                        ng[v2][v3] = 3;
                        ng[v4][v2] = 3;
                        ng[v2][v4] = 3;
                        ng[v4][v3] = 3;
                        ng[v3][v4] = 3;
                    }
                }
                if (!notFound) continue;
                ng[v2][v1] = 2;
                ng[v1][v2] = 2;
                this.print("Pairwise test: " + this.tetradTest.getVarNames()[v1] + " x " + this.tetradTest.getVarNames()[v2] + " = " + notFound);
            }
        }
        this.print(">> Stage 0.2");
        for (i = 0; i < this.numVariables() - 1; ++i) {
            for (j = i + 1; j < this.numVariables(); ++j) {
                notYellow[j][i] = false;
                notYellow[i][j] = false;
            }
        }
        for (v1 = 0; v1 < this.numVariables() - 1; ++v1) {
            for (v2 = v1 + 1; v2 < this.numVariables(); ++v2) {
                int v6;
                if (ng[v1][v2] != 3) continue;
                this.printMessage("Searching for " + this.tetradTest.getVarNames()[v1] + " x " + this.tetradTest.getVarNames()[v2] + "...");
                notFound = true;
                for (v3 = 0; v3 < this.numVariables() - 1 && notFound; ++v3) {
                    if (v1 == v3 || v2 == v3 || ng[v1][v3] == 2 || ng[v2][v3] == 2 || cv[v1][v3] != 1 || cv[v2][v3] != 1) continue;
                    for (int v5 = v3 + 1; v5 < this.numVariables() && notFound; ++v5) {
                        if (v1 == v5 || v2 == v5 || ng[v1][v5] == 2 || ng[v2][v5] == 2 || ng[v3][v5] == 2 || cv[v1][v5] != 1 || cv[v2][v5] != 1 || cv[v3][v5] != 1 || !this.unclusteredPartial1(v1, v3, v5, v2)) continue;
                        for (int v42 = 0; v42 < this.numVariables() - 1 && notFound; ++v42) {
                            if (v1 == v42 || v2 == v42 || v3 == v42 || v5 == v42 || ng[v1][v42] == 2 || ng[v2][v42] == 2 || ng[v3][v42] == 2 || ng[v5][v42] == 2 || cv[v1][v42] != 1 || cv[v2][v42] != 1 || cv[v3][v42] != 1 || cv[v5][v42] != 1 || !this.unclusteredPartial2(v1, v3, v5, v2, v42)) continue;
                            for (v6 = v42 + 1; v6 < this.numVariables() && notFound; ++v6) {
                                if (v1 == v6 || v2 == v6 || v3 == v6 || v5 == v6 || ng[v1][v6] == 2 || ng[v2][v6] == 2 || ng[v3][v6] == 2 || ng[v42][v6] == 2 || ng[v5][v6] == 2 || cv[v1][v6] != 1 || cv[v2][v6] != 1 || cv[v3][v6] != 1 || cv[v42][v6] != 1 || cv[v5][v6] != 1 || !this.unclusteredPartial3(v1, v3, v5, v2, v42, v6)) continue;
                                notFound = false;
                                ng[v2][v1] = 0;
                                ng[v1][v2] = 0;
                                ng[v42][v1] = 0;
                                ng[v1][v42] = 0;
                                ng[v6][v1] = 0;
                                ng[v1][v6] = 0;
                                ng[v2][v3] = 0;
                                ng[v3][v2] = 0;
                                ng[v42][v3] = 0;
                                ng[v3][v42] = 0;
                                ng[v6][v3] = 0;
                                ng[v3][v6] = 0;
                                ng[v2][v5] = 0;
                                ng[v5][v2] = 0;
                                ng[v42][v5] = 0;
                                ng[v5][v42] = 0;
                                ng[v6][v5] = 0;
                                ng[v5][v6] = 0;
                                notYellow[v3][v1] = true;
                                notYellow[v1][v3] = true;
                                notYellow[v5][v1] = true;
                                notYellow[v1][v5] = true;
                                notYellow[v5][v3] = true;
                                notYellow[v3][v5] = true;
                                notYellow[v42][v2] = true;
                                notYellow[v2][v42] = true;
                                notYellow[v6][v2] = true;
                                notYellow[v2][v6] = true;
                                notYellow[v6][v42] = true;
                                notYellow[v42][v6] = true;
                                this.print("(" + this.labels[v1] + ", " + this.labels[v3] + ", " + this.labels[v5] + ", " + this.labels[v2] + ", " + this.labels[v42] + ", " + this.labels[v6] + ") --> NONE");
                            }
                        }
                    }
                }
                if (notYellow[v1][v2]) {
                    if (notFound) {
                        this.print("BLUE");
                    }
                    notFound = false;
                }
                if (notFound) {
                    for (v3 = 0; v3 < this.numVariables() && notFound; ++v3) {
                        if (v1 == v3 || v2 == v3 || ng[v1][v3] == 2 || ng[v2][v3] == 2 || cv[v1][v3] != 1 || cv[v2][v3] != 1) continue;
                        for (v4 = 0; v4 < this.numVariables() - 2 && notFound; ++v4) {
                            if (v1 == v4 || v2 == v4 || v3 == v4 || ng[v1][v4] == 2 || ng[v2][v4] == 2 || ng[v3][v4] == 2 || cv[v1][v4] != 1 || cv[v2][v4] != 1 || cv[v3][v4] != 1 || !this.unclusteredPartial1(v1, v2, v3, v4)) continue;
                            for (int v5 = v4 + 1; v5 < this.numVariables() - 1 && notFound; ++v5) {
                                if (v1 == v5 || v2 == v5 || v3 == v5 || ng[v1][v5] == 2 || ng[v2][v5] == 2 || ng[v3][v5] == 2 || ng[v4][v5] == 2 || cv[v1][v5] != 1 || cv[v2][v5] != 1 || cv[v3][v5] != 1 || cv[v4][v5] != 1 || !this.unclusteredPartial2(v1, v2, v3, v4, v5)) continue;
                                for (v6 = v5 + 1; v6 < this.numVariables() && notFound; ++v6) {
                                    if (v1 == v6 || v2 == v6 || v3 == v6 || ng[v1][v6] == 2 || ng[v2][v6] == 2 || ng[v3][v6] == 2 || ng[v4][v6] == 2 || ng[v5][v6] == 2 || cv[v1][v6] != 1 || cv[v2][v6] != 1 || cv[v3][v6] != 1 || cv[v4][v6] != 1 || cv[v5][v6] != 1 || !this.unclusteredPartial3(v1, v2, v3, v4, v5, v6)) continue;
                                    notFound = false;
                                    ng[v4][v1] = 0;
                                    ng[v1][v4] = 0;
                                    ng[v5][v1] = 0;
                                    ng[v1][v5] = 0;
                                    ng[v6][v1] = 0;
                                    ng[v1][v6] = 0;
                                    ng[v4][v2] = 0;
                                    ng[v2][v4] = 0;
                                    ng[v5][v2] = 0;
                                    ng[v2][v5] = 0;
                                    ng[v6][v2] = 0;
                                    ng[v2][v6] = 0;
                                    ng[v4][v3] = 0;
                                    ng[v3][v4] = 0;
                                    ng[v5][v3] = 0;
                                    ng[v3][v5] = 0;
                                    ng[v6][v3] = 0;
                                    ng[v3][v6] = 0;
                                    notYellow[v2][v1] = true;
                                    notYellow[v1][v2] = true;
                                    notYellow[v3][v1] = true;
                                    notYellow[v1][v3] = true;
                                    notYellow[v3][v2] = true;
                                    notYellow[v2][v3] = true;
                                    notYellow[v5][v4] = true;
                                    notYellow[v4][v5] = true;
                                    notYellow[v6][v4] = true;
                                    notYellow[v4][v6] = true;
                                    notYellow[v6][v5] = true;
                                    notYellow[v5][v6] = true;
                                    this.print("(" + this.labels[v1] + ", " + this.labels[v2] + ", " + this.labels[v3] + ", " + this.labels[v4] + ", " + this.labels[v5] + ", " + this.labels[v6] + ") --> BLUE");
                                }
                            }
                        }
                    }
                }
                if (!notFound) continue;
                ng[v2][v1] = 4;
                ng[v1][v2] = 4;
                this.print("YELLOW!");
            }
        }
        this.print(">> Stage 0.3.1");
        List clustering = new ArrayList();
        List components = this.findComponents(ng, this.numVariables(), 3);
        Iterator it = components.iterator();
        this.print(">> Stage 0.3.2");
        while (it.hasNext()) {
            int[] component = (int[])it.next();
            this.print(">>> Searching for cliques in ");
            this.printClusterIds(component);
            List nextClustering = this.findMaximalCliques(component, ng);
            System.out.println("nextClustering.size() = " + nextClustering.size());
            clustering.addAll(this.trimCliqueList(nextClustering));
            System.out.println("clustering.size() = " + clustering.size());
        }
        for (int i2 = 0; i2 < clustering.size() - 1; ++i2) {
            int max = 0;
            int max_idx = -1;
            for (int j2 = i2; j2 < clustering.size(); ++j2) {
                if (((int[])clustering.get(j2)).length <= max) continue;
                max = ((int[])clustering.get(j2)).length;
                max_idx = j2;
            }
            Object temp = clustering.get(i2);
            clustering.set(i2, clustering.get(max_idx));
            clustering.set(max_idx, temp);
        }
        this.print("**** INITIAL CLUSTERING OUTPUT: ");
        this.printClustering(clustering);
        this.print("**** INDIVIDUAL CLUSTER PURIFICATION: ");
        List individualOneFactors = this.individualPurification(clustering);
        this.printClustering(individualOneFactors);
        clustering = individualOneFactors;
        this.print(">> Stage 0.4 - Finding pairwise cluster relations");
        ArrayList ids = new ArrayList();
        List clusterings = this.chooseClusterings(clustering, ng, ids, true, cv);
        this.print(">> Stage 0.5 - Finding a pure measurement model");
        ArrayList orderedIds = new ArrayList();
        List actualClustering = this.filterAndOrderClusterings(clusterings, ids, orderedIds, ng);
        return this.purify(actualClustering, orderedIds, null);
    }

    private List individualPurification(List clustering) {
        boolean oldOutputMessage = this.outputMessage;
        ArrayList<Object> purified = new ArrayList<Object>();
        int[] ids = new int[]{1};
        for (int i = 0; i < clustering.size(); ++i) {
            this.print(" * Solving cluster #" + (i + 1));
            this.outputMessage = false;
            int[] rawCluster = (int[])clustering.get(i);
            if (rawCluster.length <= 4) {
                this.outputMessage = oldOutputMessage;
                purified.add(rawCluster);
                continue;
            }
            ArrayList dummyClusterings = new ArrayList();
            ArrayList<int[]> dummyClustering = new ArrayList<int[]>();
            dummyClustering.add(rawCluster);
            dummyClusterings.add(dummyClustering);
            ArrayList<int[]> dummyIds = new ArrayList<int[]>();
            dummyIds.add(ids);
            List purification = this.purify(dummyClusterings, dummyIds, null);
            if (purification.size() > 0) {
                purified.add(purification.get(0));
            } else {
                int[] newFakeCluster = new int[4];
                System.arraycopy(rawCluster, 0, newFakeCluster, 0, 4);
                purified.add(newFakeCluster);
            }
            this.outputMessage = oldOutputMessage;
        }
        return purified;
    }

    private boolean compatibleClusters(int[] cluster1, int[] cluster2, int[][] cv) {
        int cset1 = cluster1.length;
        int cset2 = cluster2.length;
        for (int o1 = 0; o1 < cset1 - 2; ++o1) {
            for (int o2 = o1 + 1; o2 < cset1 - 1; ++o2) {
                for (int o3 = o2 + 1; o3 < cset1; ++o3) {
                    for (int o4 = 0; o4 < cset2 - 2; ++o4) {
                        if (!this.validClusterPairPartial1(cluster1[o1], cluster1[o2], cluster1[o3], cluster2[o4], cv)) continue;
                        for (int o5 = o4 + 1; o5 < cset2 - 1; ++o5) {
                            if (!this.validClusterPairPartial2(cluster1[o1], cluster1[o2], cluster1[o3], cluster2[o5], cv)) continue;
                            for (int o6 = o5 + 1; o6 < cset2; ++o6) {
                                if (!this.validClusterPairPartial3(cluster1[o1], cluster1[o2], cluster1[o3], cluster2[o4], cluster2[o5], cluster2[o6], cv)) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        System.out.println("INCOMPATIBLE!:");
        this.printClusterNames(cluster1);
        this.printClusterNames(cluster2);
        return false;
    }

    private List findMeasurementPattern() {
        boolean found;
        int x1;
        int i;
        int[][] ng = new int[this.numVariables()][this.numVariables()];
        int[][] cv = new int[this.numVariables()][this.numVariables()];
        boolean[] selected = new boolean[this.numVariables()];
        for (int i2 = 0; i2 < this.numVariables(); ++i2) {
            selected[i2] = false;
        }
        List initialClustering = this.initialMeasurementPattern(ng, cv);
        this.print("Initial clustering:");
        this.printClustering(initialClustering);
        ArrayList forbiddenList = new ArrayList();
        for (int c1 = 0; c1 < initialClustering.size(); ++c1) {
            int[] nextCluster = (int[])initialClustering.get(c1);
            for (int i3 = 0; i3 < nextCluster.length; ++i3) {
                selected[nextCluster[i3]] = true;
                for (int j = i3 + 1; j < nextCluster.length; ++j) {
                    HashSet<String> nextPair = new HashSet<String>();
                    nextPair.add(this.tetradTest.getVarNames()[nextCluster[i3]]);
                    nextPair.add(this.tetradTest.getVarNames()[nextCluster[j]]);
                    forbiddenList.add(nextPair);
                }
            }
            for (int c2 = c1 + 1; c2 < initialClustering.size(); ++c2) {
                int[] nextCluster2 = (int[])initialClustering.get(c2);
                for (int i4 = 0; i4 < nextCluster.length; ++i4) {
                    for (int j = 0; j < nextCluster2.length; ++j) {
                        HashSet<String> nextPair = new HashSet<String>();
                        nextPair.add(this.tetradTest.getVarNames()[nextCluster[i4]]);
                        nextPair.add(this.tetradTest.getVarNames()[nextCluster2[j]]);
                        forbiddenList.add(nextPair);
                    }
                }
            }
        }
        this.print(">> Stage 0");
        this.print("\n****************\nFIND FINAL PATTERN!!!\n****************\n");
        this.print(">> Stage 1: reidentify edge colors");
        for (i = 0; i < this.numVariables(); ++i) {
            for (int j = 0; j < this.numVariables(); ++j) {
                if (selected[i] && selected[j] && (ng[i][j] == 3 || ng[i][j] == 4)) {
                    ng[i][j] = 4;
                    continue;
                }
                if (selected[i] && selected[j] || ng[i][j] != 4) continue;
                ng[i][j] = 3;
            }
        }
        this.print(">> Stage 2");
        for (x1 = 0; x1 < this.numVariables() - 1; ++x1) {
            block10: for (int y1 = x1 + 1; y1 < this.numVariables(); ++y1) {
                if (ng[x1][y1] != 3) continue;
                found = false;
                this.printMessage("Searching for " + this.tetradTest.getVarNames()[x1] + " x " + this.tetradTest.getVarNames()[y1] + "...");
                for (int x2 = 0; x2 < this.numVariables(); ++x2) {
                    if (x1 == x2 || y1 == x2 || cv[x1][x2] == 0 || cv[y1][x2] == 0) continue;
                    for (int x3 = 0; x3 < this.numVariables(); ++x3) {
                        if (x1 == x3 || x2 == x3 || y1 == x3 || cv[x1][x3] == 0 || cv[x2][x3] == 0 || cv[y1][x3] == 0 || !this.partialRule1_1(x1, x2, x3, y1)) continue;
                        for (int y2 = 0; y2 < this.numVariables(); ++y2) {
                            if (x1 == y2 || x2 == y2 || x3 == y2 || y1 == y2 || cv[x1][y2] == 0 || cv[x2][y2] == 0 || cv[x3][y2] == 0 || cv[y1][y2] == 0 || !this.partialRule1_2(x1, x2, y1, y2)) continue;
                            for (int y3 = 0; y3 < this.numVariables(); ++y3) {
                                if (x1 == y3 || x2 == y3 || x3 == y3 || y1 == y3 || y2 == y3 || cv[x1][y3] == 0 || cv[x2][y3] == 0 || cv[x3][y3] == 0 || cv[y1][y3] == 0 || cv[y2][y3] == 0 || !this.partialRule1_3(x1, y1, y2, y3)) continue;
                                ng[y1][x1] = 0;
                                ng[x1][y1] = 0;
                                this.print("(" + this.labels[x1] + ", " + this.labels[x2] + ", " + this.labels[x3] + ", " + this.labels[y1] + ", " + this.labels[y2] + ", " + this.labels[y3] + ") --> RULE1");
                                found = true;
                                continue block10;
                            }
                        }
                    }
                }
                if (found) continue;
                this.printlnMessage();
            }
        }
        System.out.println("Trying RULE 2 now!");
        for (x1 = 0; x1 < this.numVariables() - 1; ++x1) {
            block16: for (int y1 = x1 + 1; y1 < this.numVariables(); ++y1) {
                if (ng[x1][y1] != 3) continue;
                found = false;
                this.printMessage("Searching for " + this.tetradTest.getVarNames()[x1] + " x " + this.tetradTest.getVarNames()[y1] + "...");
                for (int x2 = 0; x2 < this.numVariables(); ++x2) {
                    if (x1 == x2 || y1 == x2 || cv[x1][x2] == 0 || cv[y1][x2] == 0 || ng[x1][x2] == 2) continue;
                    for (int y2 = 0; y2 < this.numVariables(); ++y2) {
                        if (x1 == y2 || x2 == y2 || y1 == y2 || cv[x1][y2] == 0 || cv[x2][y2] == 0 || cv[y1][y2] == 0 || ng[y1][y2] == 2 || !this.partialRule2_1(x1, x2, y1, y2)) continue;
                        for (int x3 = 0; x3 < this.numVariables(); ++x3) {
                            if (x1 == x3 || x2 == x3 || y1 == x3 || y2 == x3 || ng[x1][x3] == 2 || cv[x1][x3] == 0 || cv[x2][x3] == 0 || cv[y1][x3] == 0 || cv[y2][x3] == 0 || !this.partialRule2_2(x1, x2, x3, y2)) continue;
                            for (int y3 = 0; y3 < this.numVariables(); ++y3) {
                                if (x1 == y3 || x2 == y3 || x3 == y3 || y1 == y3 || y2 == y3 || ng[y1][y3] == 2 || cv[x1][y3] == 0 || cv[x2][y3] == 0 || cv[x3][y3] == 0 || cv[y1][y3] == 0 || cv[y2][y3] == 0 || !this.partialRule2_3(x2, y1, y2, y3)) continue;
                                ng[y1][x1] = 0;
                                ng[x1][y1] = 0;
                                this.print("(" + this.labels[x1] + ", " + this.labels[x2] + ", " + this.labels[x3] + ", " + this.labels[y1] + ", " + this.labels[y2] + ", " + this.labels[y3] + ") --> RULE2");
                                found = true;
                                continue block16;
                            }
                        }
                    }
                }
                if (found) continue;
                this.printlnMessage();
            }
        }
        for (i = 0; i < this.numVariables(); ++i) {
            for (int j = 0; j < this.numVariables(); ++j) {
                if (ng[i][j] != 4) continue;
                ng[i][j] = 3;
            }
        }
        this.print(">> Stage 3.1");
        ArrayList clustering = new ArrayList();
        List components = this.findComponents(ng, this.numVariables(), 3);
        Iterator it = components.iterator();
        this.print(">> Stage 3.2");
        while (it.hasNext()) {
            int[] component = (int[])it.next();
            this.print(">>> Searching for cliques in ");
            this.printClusterIds(component);
            List nextClustering = this.findMaximalCliques(component, ng);
            clustering.addAll(this.trimCliqueList(nextClustering));
        }
        for (int i5 = 0; i5 < clustering.size() - 1; ++i5) {
            int max = 0;
            int max_idx = -1;
            for (int j = i5; j < clustering.size(); ++j) {
                if (((int[])clustering.get(j)).length <= max) continue;
                max = ((int[])clustering.get(j)).length;
                max_idx = j;
            }
            Object temp = clustering.get(i5);
            clustering.set(i5, clustering.get(max_idx));
            clustering.set(max_idx, temp);
        }
        this.print("**** CLUSTERING OUTPUT: ");
        this.printClustering(clustering);
        this.print(">> Stage 4 - Choosing clusters");
        ArrayList ids = new ArrayList();
        List clusterings = this.chooseClusterings(clustering, ng, ids, false, cv);
        this.print(">> Stage 5 - Finding a pure measurement model");
        ArrayList orderedIds = new ArrayList();
        List actualClustering = this.filterAndOrderClusterings(clusterings, ids, orderedIds, ng);
        List finalPureModel = this.purify(actualClustering, orderedIds, forbiddenList);
        this.print("\n\n**** FINAL PURE/MARKED MEASUREMENT MODEL: ");
        if (finalPureModel != null) {
            this.printClustering(finalPureModel);
        } else {
            this.print("No model.");
        }
        this.printlnMessage();
        return finalPureModel;
    }

    private List chooseClusterings(List clustering, int[][] ng, List outputIds, boolean need3, int[][] cv) {
        int i;
        ArrayList clusterings = new ArrayList();
        boolean[] marked = new boolean[clustering.size()];
        boolean[] buffer = new boolean[this.numVariables()];
        int max = clustering.size() < 1000 ? clustering.size() : 1000;
        boolean[][] compatibility = new boolean[clustering.size()][clustering.size()];
        if (need3) {
            for (i = 0; i < clustering.size() - 1; ++i) {
                for (int j = i + 1; j < clustering.size(); ++j) {
                    boolean bl = this.compatibleClusters((int[])clustering.get(i), (int[])clustering.get(j), cv);
                    compatibility[j][i] = bl;
                    compatibility[i][j] = bl;
                }
            }
        }
        System.out.println("Total number of clusters: " + clustering.size());
        for (i = 0; i < max; ++i) {
            int bestChoice;
            ArrayList<Integer> nextIds = new ArrayList<Integer>();
            ArrayList newClustering = new ArrayList();
            nextIds.add(new Integer(i));
            newClustering.add(clustering.get(i));
            for (int j = 0; j < clustering.size(); ++j) {
                marked[j] = false;
            }
            marked[i] = true;
            double bestScore = ((int[])clustering.get(i)).length;
            do {
                bestChoice = -1;
                block5: for (int j = 0; j < clustering.size(); ++j) {
                    if (marked[j]) continue;
                    for (int k = 0; k < newClustering.size(); ++k) {
                        if (!need3 || compatibility[j][clustering.indexOf(newClustering.get(k))]) continue;
                        marked[j] = true;
                        continue block5;
                    }
                    newClustering.add(clustering.get(j));
                    int localScore = this.scoreClustering(newClustering, ng, buffer);
                    newClustering.remove(clustering.get(j));
                    if (!((double)localScore >= bestScore)) continue;
                    bestChoice = j;
                    bestScore = localScore;
                }
                if (bestChoice == -1) continue;
                marked[bestChoice] = true;
                newClustering.add(clustering.get(bestChoice));
                nextIds.add(new Integer(bestChoice));
            } while (bestChoice > -1);
            if (!this.isNewClustering(clusterings, newClustering)) continue;
            clusterings.add(newClustering);
            outputIds.add(nextIds);
        }
        return clusterings;
    }

    private boolean isNewClustering(List clusterings, List newClustering) {
        block0: for (List nextClustering : clusterings) {
            block1: for (int[] cluster : nextClustering) {
                block2: for (int[] newCluster : newClustering) {
                    if (cluster.length != newCluster.length) continue;
                    block3: for (int i = 0; i < cluster.length; ++i) {
                        for (int j = 0; j < newCluster.length; ++j) {
                            if (cluster[i] == newCluster[j]) continue block3;
                        }
                        continue block2;
                    }
                    continue block1;
                }
                continue block0;
            }
            return false;
        }
        return true;
    }

    int clusterPairwiseScoring(int[] cluster1, int[] cluster2, int[][] ng, boolean[] usedNodes, boolean[] toRemove) {
        int ci;
        int score = cluster1.length + cluster2.length;
        for (ci = 0; ci < cluster1.length; ++ci) {
            if (toRemove[cluster1[ci]]) {
                --score;
                continue;
            }
            if (!usedNodes[cluster1[ci]]) continue;
            score -= 2;
        }
        for (ci = 0; ci < cluster2.length; ++ci) {
            if (toRemove[cluster2[ci]]) {
                --score;
                continue;
            }
            if (!usedNodes[cluster2[ci]]) continue;
            score -= 2;
        }
        for (ci = 0; ci < cluster1.length; ++ci) {
            if (usedNodes[cluster1[ci]]) continue;
            for (int cj = 0; cj < cluster2.length; ++cj) {
                if (usedNodes[cluster2[cj]]) continue;
                if (cluster1[ci] == cluster2[cj]) {
                    score -= 2;
                }
                if (ng[cluster1[ci]][cluster2[cj]] == 0) continue;
                --score;
            }
        }
        return score;
    }

    int extraClusterScoring(int[] cluster1, int[] cluster2, int[][] ng, boolean[] usedNodes, boolean[] toRemove) {
        int ci;
        int score = cluster1.length;
        for (ci = 0; ci < cluster1.length; ++ci) {
            if (toRemove[cluster1[ci]]) {
                --score;
                continue;
            }
            if (!usedNodes[cluster1[ci]]) continue;
            score -= 2;
        }
        for (ci = 0; ci < cluster1.length; ++ci) {
            if (usedNodes[cluster1[ci]]) continue;
            for (int cj = 0; cj < cluster2.length; ++cj) {
                if (usedNodes[cluster2[cj]] || ng[cluster1[ci]][cluster2[cj]] == 0) continue;
                --score;
            }
        }
        return score;
    }

    void updateContribution(int[] cluster1, int[] cluster2, boolean[] contribution, int[][] ng, boolean[] usedNodes, boolean[] toRemove) {
        int ci;
        for (ci = 0; ci < cluster1.length; ++ci) {
            if (toRemove[cluster1[ci]]) {
                contribution[ci] = false;
                continue;
            }
            if (!usedNodes[cluster1[ci]]) continue;
            contribution[ci] = false;
        }
        for (ci = 0; ci < cluster1.length; ++ci) {
            if (usedNodes[cluster1[ci]]) continue;
            for (int cj = 0; cj < cluster2.length; ++cj) {
                if (usedNodes[cluster2[cj]] || ng[cluster1[ci]][cluster2[cj]] == 0) continue;
                contribution[ci] = false;
            }
        }
    }

    void updateOverlap(List clustering, int[] newCluster, boolean[] toRemove, boolean[] usedNodes) {
        for (int i = 0; i < clustering.size(); ++i) {
            int[] nextCluster = (int[])clustering.get(i);
            for (int ci = 0; ci < nextCluster.length; ++ci) {
                if (toRemove[nextCluster[ci]]) continue;
                for (int cj = 0; cj < newCluster.length; ++cj) {
                    if (nextCluster[ci] != newCluster[cj]) continue;
                    toRemove[nextCluster[ci]] = true;
                }
            }
        }
        for (int cj = 0; cj < newCluster.length; ++cj) {
            usedNodes[newCluster[cj]] = true;
        }
    }

    void removeNodes(List clustering, boolean[] toRemove) {
        ArrayList<int[]> removeList = new ArrayList<int[]>();
        ArrayList<int[]> addList = new ArrayList<int[]>();
        for (int i = 0; i < clustering.size(); ++i) {
            int[] nextCluster = (int[])clustering.get(i);
            int toCopy = 0;
            for (int j = 0; j < nextCluster.length; ++j) {
                if (toRemove[nextCluster[j]]) continue;
                ++toCopy;
            }
            if (toCopy == nextCluster.length) continue;
            removeList.add(nextCluster);
            if (toCopy <= 0) continue;
            int[] newCluster = new int[toCopy];
            int pos = 0;
            for (int j = 0; j < nextCluster.length; ++j) {
                if (toRemove[nextCluster[j]]) continue;
                newCluster[pos++] = nextCluster[j];
            }
            addList.add(newCluster);
        }
        clustering.removeAll(removeList);
        clustering.addAll(addList);
    }

    private List purify(List actualClusterings, List clusterIds, List forbiddenList) {
        this.printlnMessage();
        this.print("** PURIFY: total number of clustering candidates = " + actualClusterings.size());
        int i = 0;
        if (i < actualClusterings.size() && i < 10) {
            List partition = (List)actualClusterings.get(i);
            this.printMessage("Trying to purify");
            this.printLatentClique((int[])clusterIds.get(i), this.clustersize(partition));
            this.print("Remaining: " + (actualClusterings.size() - i - 1));
            Clusters knowledge = new Clusters();
            int clusterId = 0;
            Iterator it = partition.iterator();
            this.printClustering(partition);
            while (it.hasNext()) {
                int[] codes = (int[])it.next();
                for (int k = 0; k < codes.length; ++k) {
                    String var = this.tetradTest.getVarNames()[codes[k]];
                    knowledge.addToCluster(clusterId, var);
                }
                ++clusterId;
            }
            TestType oldPurifyTest = ((ContinuousTetradTest)this.tetradTest).getTestType();
            ((ContinuousTetradTest)this.tetradTest).setTestType(this.purifyTestType);
            Purify purifier = new Purify(this.tetradTest, knowledge);
            purifier.setConstraintSearchVariation(1);
            purifier.setForbiddenList(forbiddenList);
            purifier.setOutputMessage(this.outputMessage);
            Graph solutionGraph = purifier.search();
            if (!(this.tetradTest instanceof DiscreteTetradTest)) {
                ((ContinuousTetradTest)this.tetradTest).setTestType(oldPurifyTest);
            }
            if (solutionGraph != null && solutionGraph.getNodes().size() > 1) {
                List clusteringOutput = this.convertGraphToList(solutionGraph);
                return clusteringOutput;
            }
            if (actualClusterings.size() > 1) {
                this.rebuildClusteringList(actualClusterings, i, clusterIds);
            }
            return new ArrayList();
        }
        return new ArrayList();
    }

    private void rebuildClusteringList(List clusterings, int position, List clusterIds) {
        List currentClustering = (List)clusterings.get(position);
        if (currentClustering.size() < 2) {
            return;
        }
        boolean found = false;
        this.print("* Substituting invalid solution for new one");
        int[] currentIds = (int[])clusterIds.get(position);
        for (int j = position + 1; j < clusterings.size() && !found; ++j) {
            if (((List)clusterings.get(j)).size() >= currentClustering.size()) continue;
            found = true;
            for (int i = 0; i < currentClustering.size(); ++i) {
                ArrayList newClustering = new ArrayList();
                int[] newIds = new int[currentClustering.size() - 1];
                for (int k = 0; k < currentClustering.size(); ++k) {
                    if (i == k) continue;
                    newClustering.add(currentClustering.get(k));
                    if (k > i) {
                        newIds[k - 1] = currentIds[k];
                        continue;
                    }
                    newIds[k] = currentIds[k];
                }
                clusterings.add(j, newClustering);
                clusterIds.add(j, newIds);
            }
        }
        if (!found) {
            for (int i = 0; i < currentClustering.size(); ++i) {
                ArrayList newClustering = new ArrayList();
                int[] newIds = new int[currentClustering.size() - 1];
                for (int k = 0; k < currentClustering.size(); ++k) {
                    if (i == k) continue;
                    newClustering.add(currentClustering.get(k));
                    if (k > i) {
                        newIds[k - 1] = currentIds[k];
                        continue;
                    }
                    newIds[k] = currentIds[k];
                }
                clusterings.add(newClustering);
                clusterIds.add(newIds);
            }
        }
    }

    public CorrelationMatrix getCorrelationMatrix() {
        return this.correlationMatrix;
    }

    public int numVariables() {
        return this.numVariables;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }
}

