/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class Cccd {
    private IndependenceTest test;
    private int depth = -1;
    private Knowledge knowledge;
    private List<Node> nodes;
    private Set<Triple> allTriples;
    private Set<Triple> colliderTriples;
    private Set<Triple> noncolliderTriples;
    private Set<Triple> ambiguousTriples;
    private TetradLogger logger = TetradLogger.getInstance();
    private Graph graph;
    private SepsetMap sepsets;

    public Cccd(IndependenceTest test, Knowledge knowledge) {
        this.knowledge = knowledge;
        this.test = test;
        this.nodes = new LinkedList<Node>(test.getVariables());
    }

    public Cccd(IndependenceTest test) {
        this(test, new Knowledge());
    }

    public Graph search() {
        int a;
        SepsetMap sepsets;
        this.allTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        TetradLogger.getInstance().log("info", "Starting CCD algorithm.");
        TetradLogger.getInstance().log("info", "Independence test = " + this.test);
        TetradLogger.getInstance().log("info", "Depth = " + this.depth);
        this.graph = new EdgeListGraph(new ArrayList<Node>(this.nodes));
        this.graph.fullyConnect(Endpoint.CIRCLE);
        HashMap<Triple, ArrayList<Node>> supSepset = new HashMap<Triple, ArrayList<Node>>();
        TetradLogger.getInstance().log("info", "\nStep A");
        int _depth = this.depth;
        if (_depth == -1) {
            _depth = Integer.MAX_VALUE;
        }
        Fas search = new Fas(this.graph, this.test);
        search.setDepth(_depth);
        search.setKnowledge(this.getKnowledge());
        this.graph = search.search();
        this.sepsets = sepsets = search.getSepsets();
        TetradLogger.getInstance().log("info", "\nStep B");
        for (Node bnode : this.nodes) {
            int[] choice;
            List<Node> adjB = this.graph.getAdjacentNodes(bnode);
            if (adjB.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjB.size(), 2);
            while ((choice = cg.next()) != null) {
                Node cnode;
                Node anode = adjB.get(choice[0]);
                if (this.graph.isAdjacentTo(anode, cnode = adjB.get(choice[1]))) continue;
                if (!sepsets.get(anode, cnode).contains(bnode)) {
                    this.graph.setEndpoint(anode, bnode, Endpoint.ARROW);
                    this.graph.setEndpoint(bnode, anode, Endpoint.TAIL);
                    this.graph.setEndpoint(cnode, bnode, Endpoint.ARROW);
                    this.graph.setEndpoint(bnode, cnode, Endpoint.TAIL);
                    TetradLogger.getInstance().log("colliderOrientations", "Orienting collider " + anode + "-->" + bnode + "<--" + cnode);
                    continue;
                }
                this.graph.addUnderlineTriple(anode, bnode, cnode);
                TetradLogger.getInstance().log("underlines", "Adding underline " + new Triple(anode, bnode, cnode));
            }
        }
        TetradLogger.getInstance().log("info", "\nStep C");
        for (int x = 0; x < this.nodes.size(); ++x) {
            Node xnode = this.nodes.get(x);
            for (int y = 0; y < this.nodes.size(); ++y) {
                Node ynode;
                if (x == y || !this.graph.isAdjacentTo(xnode, ynode = this.nodes.get(y))) continue;
                boolean numOriented = false;
                int numTotal = 0;
                int max = -1;
                boolean oriented = false;
                Node _anode = null;
                List<Node> _aySepset = null;
                for (int a2 = 0; a2 < this.nodes.size(); ++a2) {
                    Node anode = this.nodes.get(a2);
                    if (anode == xnode || anode == ynode || this.graph.isAdjacentTo(xnode, anode) || this.graph.isAdjacentTo(ynode, anode) || !this.graph.isAdjacentTo(xnode, ynode)) continue;
                    List<Node> aySepset = sepsets.get(anode, ynode);
                    if (aySepset.size() > max) {
                        if (aySepset.contains(xnode)) continue;
                        oriented = !this.test.isIndependent(anode, xnode, aySepset);
                        max = aySepset.size();
                        _anode = anode;
                        _aySepset = aySepset;
                    }
                    ++numTotal;
                }
                boolean orientedXY = oriented;
                if (!orientedXY) continue;
                this.graph.setEndpoint(ynode, xnode, Endpoint.ARROW);
                TetradLogger.getInstance().log("impliedOrientations", "a Orienting " + ynode + "-->" + xnode + " A = " + _anode + " aySepset = " + _aySepset);
            }
        }
        TetradLogger.getInstance().log("info", "\nStep D");
        ArrayList[] local = new ArrayList[this.nodes.size()];
        for (int v = 0; v < this.nodes.size(); ++v) {
            Node vnode = this.nodes.get(v);
            local[v] = new ArrayList();
            for (int x = 0; x < this.nodes.size(); ++x) {
                if (x == v) continue;
                Node xnode = this.nodes.get(x);
                if (this.graph.isAdjacentTo(vnode, xnode)) {
                    local[v].add(xnode);
                }
                for (int y = 0; y < this.nodes.size(); ++y) {
                    Node ynode;
                    if (y == v || y == x || this.graph.getEndpoint(xnode, ynode = this.nodes.get(y)) != Endpoint.ARROW || this.graph.getEndpoint(ynode, xnode) != Endpoint.TAIL || this.graph.getEndpoint(vnode, ynode) != Endpoint.ARROW || this.graph.getEndpoint(ynode, vnode) != Endpoint.TAIL) continue;
                    local[v].add(xnode);
                }
            }
        }
        for (int m = 1; Cccd.maxCountLocalMinusSep(this.graph, sepsets, local, this.graph) >= m; ++m) {
            for (int a3 = 0; a3 < this.nodes.size(); ++a3) {
                Node anode = this.nodes.get(a3);
                for (int c = a3 + 1; c < this.nodes.size(); ++c) {
                    Node cnode = this.nodes.get(c);
                    if (this.graph.isAdjacentTo(anode, cnode)) continue;
                    block11: for (int b = 0; b < this.nodes.size(); ++b) {
                        int[] choice;
                        Set<Node> localMinusSep;
                        int count;
                        Node bnode;
                        if (b == c || b == a3 || supSepset.get(new Triple(anode, bnode = this.nodes.get(b), cnode)) != null || !Cccd.isCollider(this.graph, anode, bnode, cnode) || (count = (localMinusSep = Cccd.countLocalMinusSep(this.graph, sepsets, local, anode, bnode, cnode)).size()) < m) continue;
                        Object[] v = new Object[count];
                        for (int i = 0; i < count; ++i) {
                            v[i] = localMinusSep.toArray()[i];
                        }
                        ChoiceGenerator generator = new ChoiceGenerator(count, m);
                        while ((choice = generator.next()) != null) {
                            LinkedHashSet<Node> setT = new LinkedHashSet<Node>();
                            for (int i = 0; i < m; ++i) {
                                setT.add((Node)v[choice[i]]);
                            }
                            setT.add(bnode);
                            setT.addAll(sepsets.get(this.nodes.get(a3), this.nodes.get(c)));
                            ArrayList<Node> listT = new ArrayList<Node>(setT);
                            if (!this.test.isIndependent(anode, cnode, listT)) continue;
                            supSepset.put(new Triple(anode, bnode, cnode), listT);
                            this.graph.addDottedUnderlineTriple(anode, bnode, cnode);
                            TetradLogger.getInstance().log("underlines", "Adding dotted underline: " + new Triple(anode, bnode, cnode));
                            continue block11;
                        }
                    }
                }
            }
        }
        TetradLogger.getInstance().log("info", "\nStep E");
        if (this.nodes.size() < 4) {
            return this.graph;
        }
        for (a = 0; a < this.nodes.size(); ++a) {
            Node nodeA = this.nodes.get(a);
            for (int b = 0; b < this.nodes.size(); ++b) {
                if (b == a) continue;
                Node nodeB = this.nodes.get(b);
                for (int c = 0; c < this.nodes.size(); ++c) {
                    if (c == a || c == b) continue;
                    Node nodeC = this.nodes.get(c);
                    for (int d = 0; d < this.nodes.size(); ++d) {
                        if (d == a || d == b || d == c) continue;
                        Node nodeD = this.nodes.get(d);
                        if (!Cccd.isCollider(this.graph, nodeA, nodeB, nodeC) || !this.graph.isDottedUnderlineTriple(nodeA, nodeB, nodeC) || !Cccd.isCollider(this.graph, nodeA, nodeD, nodeC) || !this.graph.isAdjacentTo(nodeB, nodeD)) continue;
                        if (((List)supSepset.get(new Triple(nodeA, nodeB, nodeC))).contains(nodeD)) {
                            if (this.graph.getEndpoint(nodeB, nodeD) != Endpoint.CIRCLE) continue;
                            this.graph.setEndpoint(nodeB, nodeD, Endpoint.TAIL);
                            TetradLogger.getInstance().log("impliedOrientations", "Orienting " + nodeB + "*--" + nodeD);
                            continue;
                        }
                        if (this.graph.getEndpoint(nodeD, nodeB) == Endpoint.ARROW || this.graph.getEndpoint(nodeB, nodeD) != Endpoint.CIRCLE) continue;
                        TetradLogger.getInstance().log("impliedOrientations", "Orienting " + nodeB + "->" + nodeD);
                        this.graph.setEndpoint(nodeB, nodeD, Endpoint.ARROW);
                    }
                }
            }
        }
        TetradLogger.getInstance().log("info", "\nStep F");
        for (a = 0; a < this.nodes.size(); ++a) {
            Node nodeA = this.nodes.get(a);
            for (int b = 0; b < this.nodes.size(); ++b) {
                if (b == a) continue;
                Node nodeB = this.nodes.get(b);
                for (int c = 0; c < this.nodes.size(); ++c) {
                    Node nodeC;
                    if (c == a || c == b || !new Triple(nodeA, nodeB, nodeC = this.nodes.get(c)).alongPathIn(this.graph) || !this.graph.isDottedUnderlineTriple(nodeA, nodeB, nodeC) || !Cccd.isCollider(this.graph, nodeA, nodeB, nodeC)) continue;
                    for (int d = 0; d < this.nodes.size(); ++d) {
                        Node nodeD;
                        if (d == a || d == b || d == c || this.graph.isAdjacentTo(nodeA, nodeD = this.nodes.get(d)) && this.graph.isAdjacentTo(nodeC, nodeD) || !this.graph.isAdjacentTo(nodeB, nodeD)) continue;
                        LinkedHashSet<Node> supSepUnionD = new LinkedHashSet<Node>();
                        supSepUnionD.add(nodeD);
                        supSepUnionD.addAll((Collection)supSepset.get(new Triple(nodeA, nodeB, nodeC)));
                        ArrayList<Node> listSupSepUnionD = new ArrayList<Node>(supSepUnionD);
                        if (this.test.isIndependent(nodeA, nodeC, listSupSepUnionD) || this.graph.getEndpoint(nodeB, nodeD) != Endpoint.CIRCLE || this.graph.getEndpoint(nodeD, nodeB) == Endpoint.ARROW) continue;
                        this.graph.setEndpoint(nodeB, nodeD, Endpoint.ARROW);
                        this.graph.setEndpoint(nodeD, nodeB, Endpoint.TAIL);
                        TetradLogger.getInstance().log("impliedOrientations", "Orienting " + nodeB + "->" + nodeD);
                    }
                }
            }
        }
        TetradLogger.getInstance().log("graph", "\nFinal Graph:");
        TetradLogger.getInstance().log("graph", ((Object)this.graph).toString());
        this.logger.log("graph", "\nReturning this graph: " + this.graph);
        return this.graph;
    }

    private static boolean isCollider(Graph phi, Node a, Node b, Node c) {
        return phi.getEndpoint(a, b) == Endpoint.ARROW && phi.getEndpoint(b, a) == Endpoint.TAIL && phi.getEndpoint(c, b) == Endpoint.ARROW && phi.getEndpoint(b, c) == Endpoint.TAIL;
    }

    private static Set<Node> countLocalMinusSep(Graph phi, SepsetMap sepset, List<Node>[] loc, Node anode, Node bnode, Node cnode) {
        List<Node> nodes = phi.getNodes();
        int a = nodes.indexOf(anode);
        HashSet<Node> localMinusSep = new HashSet<Node>();
        localMinusSep.addAll(loc[a]);
        localMinusSep.removeAll(sepset.get(anode, cnode));
        localMinusSep.remove(bnode);
        localMinusSep.remove(cnode);
        return localMinusSep;
    }

    private static int maxCountLocalMinusSep(Graph phi, SepsetMap sep, List<Node>[] loc, Graph graph) {
        List<Node> nodes = phi.getNodes();
        int num = nodes.size();
        int maxCount = -1;
        for (int a = 0; a < num; ++a) {
            Node anode = nodes.get(a);
            for (int c = a + 1; c < num; ++c) {
                Node cnode;
                if (c == a || phi.isAdjacentTo(anode, cnode = nodes.get(c))) continue;
                for (int b = 0; b < num; ++b) {
                    Set<Node> localMinusSep;
                    int count;
                    Node bnode;
                    if (b == a || b == c || phi.isUnderlineTriple(anode, bnode = nodes.get(b), cnode) || !Cccd.isCollider(phi, anode, bnode, cnode) || (count = (localMinusSep = Cccd.countLocalMinusSep(phi, sep, loc, anode, bnode, cnode)).size()) <= maxCount) continue;
                    maxCount = count;
                }
            }
        }
        return maxCount;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    private void orientUnshieldedTriples(Knowledge knowledge, IndependenceTest test, int depth) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        for (Node y : this.graph.getNodes()) {
            int[] combination;
            List<Node> adjacentNodes = this.graph.getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node z;
                Node x = adjacentNodes.get(combination[0]);
                if (this.graph.isAdjacentTo(x, z = adjacentNodes.get(combination[1]))) continue;
                this.getAllTriples().add(new Triple(x, y, z));
                SearchGraphUtils.CpcTripleType type = SearchGraphUtils.getCpcTripleType(x, y, z, test, depth, this.graph);
                if (type == SearchGraphUtils.CpcTripleType.COLLIDER) {
                    if (this.colliderAllowed(x, y, z, knowledge)) {
                        this.graph.setEndpoint(x, y, Endpoint.ARROW);
                        this.graph.setEndpoint(z, y, Endpoint.ARROW);
                        if (this.graph.getEndpoint(y, x) != Endpoint.ARROW) {
                            this.graph.setEndpoint(y, x, Endpoint.TAIL);
                        }
                        if (this.graph.getEndpoint(y, z) != Endpoint.ARROW) {
                            this.graph.setEndpoint(y, z, Endpoint.TAIL);
                        }
                        TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(x, y, z));
                    }
                    this.colliderTriples.add(new Triple(x, y, z));
                    continue;
                }
                if (type == SearchGraphUtils.CpcTripleType.AMBIGUOUS) {
                    Triple triple = new Triple(x, y, z);
                    this.ambiguousTriples.add(triple);
                    this.graph.addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
                    continue;
                }
                this.graph.addUnderlineTriple(x, y, z);
                this.noncolliderTriples.add(new Triple(x, y, z));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    public Set<Triple> getColliderTriples() {
        return new HashSet<Triple>(this.colliderTriples);
    }

    public Set<Triple> getNoncolliderTriples() {
        return new HashSet<Triple>(this.noncolliderTriples);
    }

    public Set<Triple> getAllTriples() {
        return new HashSet<Triple>(this.allTriples);
    }

    private boolean colliderAllowed(Node x, Node y, Node z, Knowledge knowledge) {
        return Cccd.isArrowpointAllowed1(x, y, knowledge) && Cccd.isArrowpointAllowed1(z, y, knowledge);
    }

    private static boolean isArrowpointAllowed1(Node from, Node to, Knowledge knowledge) {
        return knowledge == null || !knowledge.edgeRequired(((Object)to).toString(), ((Object)from).toString()) && !knowledge.edgeForbidden(((Object)from).toString(), ((Object)to).toString());
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }
}

