/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class Ccd
implements GraphSearch {
    private IndependenceTest test;
    private int depth = -1;
    private Knowledge knowledge;
    private List<Node> nodes;
    private TetradLogger logger = TetradLogger.getInstance();

    public Ccd(IndependenceTest test, Knowledge knowledge) {
        this.knowledge = knowledge;
        this.test = test;
        this.nodes = new LinkedList<Node>(test.getVariables());
    }

    public Ccd(IndependenceTest test) {
        this(test, new Knowledge());
    }

    @Override
    public Graph search() {
        Node nodeC;
        int a;
        Node anode;
        TetradLogger.getInstance().log("info", "Starting CCD algorithm.");
        TetradLogger.getInstance().log("info", "Independence test = " + this.test);
        TetradLogger.getInstance().log("info", "Depth = " + this.depth);
        Graph phi = new EdgeListGraph(new LinkedList<Node>(this.nodes));
        phi.fullyConnect(Endpoint.CIRCLE);
        HashMap<Triple, ArrayList<Node>> supSepset = new HashMap<Triple, ArrayList<Node>>();
        TetradLogger.getInstance().log("info", "\nStep A");
        int _depth = this.depth;
        if (_depth == -1) {
            _depth = Integer.MAX_VALUE;
        }
        Fas search = new Fas(phi, this.test);
        search.setDepth(_depth);
        search.setKnowledge(this.getKnowledge());
        phi = search.search();
        SepsetMap sepsets = search.getSepsets();
        TetradLogger.getInstance().log("info", "\nStep B");
        for (Node bnode : this.nodes) {
            int[] choice;
            List<Node> adjB = phi.getAdjacentNodes(bnode);
            if (adjB.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjB.size(), 2);
            while ((choice = cg.next()) != null) {
                Node cnode;
                anode = adjB.get(choice[0]);
                if (phi.isAdjacentTo(anode, cnode = adjB.get(choice[1]))) continue;
                if (!sepsets.get(anode, cnode).contains(bnode)) {
                    phi.setEndpoint(anode, bnode, Endpoint.ARROW);
                    phi.setEndpoint(bnode, anode, Endpoint.TAIL);
                    phi.setEndpoint(cnode, bnode, Endpoint.ARROW);
                    phi.setEndpoint(bnode, cnode, Endpoint.TAIL);
                    TetradLogger.getInstance().log("colliderOrientations", "Orienting collider " + anode + "-->" + bnode + "<--" + cnode);
                    continue;
                }
                phi.addUnderlineTriple(anode, bnode, cnode);
                TetradLogger.getInstance().log("underlines", "Adding underline " + new Triple(anode, bnode, cnode));
            }
        }
        TetradLogger.getInstance().log("info", "\nStep C");
        for (int x = 0; x < this.nodes.size(); ++x) {
            Node xnode = this.nodes.get(x);
            for (int y = 0; y < this.nodes.size(); ++y) {
                Node ynode;
                if (x == y || !phi.isAdjacentTo(xnode, ynode = this.nodes.get(y))) continue;
                for (int a2 = 0; a2 < this.nodes.size(); ++a2) {
                    List<Node> _sepset;
                    if (a2 == x || a2 == y || phi.isAdjacentTo(xnode, anode = this.nodes.get(a2)) || phi.isAdjacentTo(ynode, anode) || (_sepset = sepsets.get(anode, ynode)).contains(xnode) || this.test.isIndependent(anode, xnode, _sepset) || phi.getEndpoint(ynode, xnode) != Endpoint.CIRCLE || phi.getEndpoint(xnode, ynode) == Endpoint.ARROW) continue;
                    phi.setEndpoint(ynode, xnode, Endpoint.ARROW);
                    phi.setEndpoint(xnode, ynode, Endpoint.TAIL);
                    TetradLogger.getInstance().log("impliedOrientations", "Orienting " + xnode + "<--" + ynode);
                }
            }
        }
        TetradLogger.getInstance().log("info", "\nStep D");
        ArrayList[] local = new ArrayList[this.nodes.size()];
        for (int v = 0; v < this.nodes.size(); ++v) {
            Node vnode = this.nodes.get(v);
            local[v] = new ArrayList();
            for (int x = 0; x < this.nodes.size(); ++x) {
                if (x == v) continue;
                Node xnode = this.nodes.get(x);
                if (phi.isAdjacentTo(vnode, xnode)) {
                    local[v].add(xnode);
                }
                for (int y = 0; y < this.nodes.size(); ++y) {
                    Node ynode;
                    if (y == v || y == x || phi.getEndpoint(xnode, ynode = this.nodes.get(y)) != Endpoint.ARROW || phi.getEndpoint(ynode, xnode) != Endpoint.TAIL || phi.getEndpoint(vnode, ynode) != Endpoint.ARROW || phi.getEndpoint(ynode, vnode) != Endpoint.TAIL) continue;
                    local[v].add(xnode);
                }
            }
        }
        for (int m = 1; Ccd.maxCountLocalMinusSep(phi, sepsets, local, phi) >= m; ++m) {
            for (int a3 = 0; a3 < this.nodes.size(); ++a3) {
                Node anode2 = this.nodes.get(a3);
                for (int c = a3 + 1; c < this.nodes.size(); ++c) {
                    Node cnode = this.nodes.get(c);
                    if (phi.isAdjacentTo(anode2, cnode)) continue;
                    block11: for (int b = 0; b < this.nodes.size(); ++b) {
                        int[] choice;
                        Set<Node> localMinusSep;
                        int count;
                        Node bnode;
                        if (b == c || b == a3 || supSepset.get(new Triple(anode2, bnode = this.nodes.get(b), cnode)) != null || !Ccd.isCollider(phi, anode2, bnode, cnode) || (count = (localMinusSep = Ccd.countLocalMinusSep(phi, sepsets, local, anode2, bnode, cnode)).size()) < m) continue;
                        Object[] v = new Object[count];
                        for (int i = 0; i < count; ++i) {
                            v[i] = localMinusSep.toArray()[i];
                        }
                        ChoiceGenerator generator = new ChoiceGenerator(count, m);
                        while ((choice = generator.next()) != null) {
                            LinkedHashSet<Node> setT = new LinkedHashSet<Node>();
                            for (int i = 0; i < m; ++i) {
                                setT.add((Node)v[choice[i]]);
                            }
                            setT.add(bnode);
                            setT.addAll(sepsets.get(this.nodes.get(a3), this.nodes.get(c)));
                            ArrayList<Node> listT = new ArrayList<Node>(setT);
                            if (!this.test.isIndependent(anode2, cnode, listT)) continue;
                            supSepset.put(new Triple(anode2, bnode, cnode), listT);
                            phi.addDottedUnderlineTriple(anode2, bnode, cnode);
                            TetradLogger.getInstance().log("underlines", "Adding dotted underline: " + new Triple(anode2, bnode, cnode));
                            continue block11;
                        }
                    }
                }
            }
        }
        TetradLogger.getInstance().log("info", "\nStep E");
        if (this.nodes.size() < 4) {
            return phi;
        }
        for (a = 0; a < this.nodes.size(); ++a) {
            Node nodeA = this.nodes.get(a);
            for (int b = 0; b < this.nodes.size(); ++b) {
                if (b == a) continue;
                Node nodeB = this.nodes.get(b);
                for (int c = 0; c < this.nodes.size(); ++c) {
                    if (c == a || c == b) continue;
                    nodeC = this.nodes.get(c);
                    for (int d = 0; d < this.nodes.size(); ++d) {
                        if (d == a || d == b || d == c) continue;
                        Node nodeD = this.nodes.get(d);
                        if (!Ccd.isCollider(phi, nodeA, nodeB, nodeC) || !phi.isDottedUnderlineTriple(nodeA, nodeB, nodeC) || !Ccd.isCollider(phi, nodeA, nodeD, nodeC) || !phi.isAdjacentTo(nodeB, nodeD)) continue;
                        if (((List)supSepset.get(new Triple(nodeA, nodeB, nodeC))).contains(nodeD)) {
                            if (phi.getEndpoint(nodeB, nodeD) != Endpoint.CIRCLE) continue;
                            phi.setEndpoint(nodeB, nodeD, Endpoint.TAIL);
                            TetradLogger.getInstance().log("impliedOrientations", "Orienting " + nodeB + "*--" + nodeD);
                            continue;
                        }
                        if (phi.getEndpoint(nodeD, nodeB) == Endpoint.ARROW || phi.getEndpoint(nodeB, nodeD) != Endpoint.CIRCLE) continue;
                        TetradLogger.getInstance().log("impliedOrientations", "Orienting " + nodeB + "->" + nodeD);
                        phi.setEndpoint(nodeB, nodeD, Endpoint.ARROW);
                    }
                }
            }
        }
        TetradLogger.getInstance().log("info", "\nStep F");
        for (a = 0; a < this.nodes.size(); ++a) {
            Node nodeA = this.nodes.get(a);
            for (int b = 0; b < this.nodes.size(); ++b) {
                if (b == a) continue;
                Node nodeB = this.nodes.get(b);
                for (int c = 0; c < this.nodes.size(); ++c) {
                    if (c == a || c == b || !new Triple(nodeA, nodeB, nodeC = this.nodes.get(c)).alongPathIn(phi) || !phi.isDottedUnderlineTriple(nodeA, nodeB, nodeC) || !Ccd.isCollider(phi, nodeA, nodeB, nodeC)) continue;
                    for (int d = 0; d < this.nodes.size(); ++d) {
                        Node nodeD;
                        if (d == a || d == b || d == c || phi.isAdjacentTo(nodeA, nodeD = this.nodes.get(d)) && phi.isAdjacentTo(nodeC, nodeD) || !phi.isAdjacentTo(nodeB, nodeD)) continue;
                        LinkedHashSet<Node> supSepUnionD = new LinkedHashSet<Node>();
                        supSepUnionD.add(nodeD);
                        supSepUnionD.addAll((Collection)supSepset.get(new Triple(nodeA, nodeB, nodeC)));
                        ArrayList<Node> listSupSepUnionD = new ArrayList<Node>(supSepUnionD);
                        if (this.test.isIndependent(nodeA, nodeC, listSupSepUnionD) || phi.getEndpoint(nodeB, nodeD) != Endpoint.CIRCLE || phi.getEndpoint(nodeD, nodeB) == Endpoint.ARROW) continue;
                        phi.setEndpoint(nodeB, nodeD, Endpoint.ARROW);
                        phi.setEndpoint(nodeD, nodeB, Endpoint.TAIL);
                        TetradLogger.getInstance().log("impliedOrientations", "Orienting " + nodeB + "->" + nodeD);
                    }
                }
            }
        }
        TetradLogger.getInstance().log("graph", "\nFinal Graph:");
        TetradLogger.getInstance().log("graph", ((Object)phi).toString());
        this.logger.log("graph", "\nReturning this graph: " + phi);
        return phi;
    }

    @Override
    public long getElapsedTime() {
        return 0L;
    }

    private static boolean isCollider(Graph phi, Node a, Node b, Node c) {
        return phi.getEndpoint(a, b) == Endpoint.ARROW && phi.getEndpoint(b, a) == Endpoint.TAIL && phi.getEndpoint(c, b) == Endpoint.ARROW && phi.getEndpoint(b, c) == Endpoint.TAIL;
    }

    private static Set<Node> countLocalMinusSep(Graph phi, SepsetMap sepset, List<Node>[] loc, Node anode, Node bnode, Node cnode) {
        List<Node> nodes = phi.getNodes();
        int a = nodes.indexOf(anode);
        HashSet<Node> localMinusSep = new HashSet<Node>();
        localMinusSep.addAll(loc[a]);
        localMinusSep.removeAll(sepset.get(anode, cnode));
        localMinusSep.remove(bnode);
        localMinusSep.remove(cnode);
        return localMinusSep;
    }

    private static int maxCountLocalMinusSep(Graph phi, SepsetMap sep, List<Node>[] loc, Graph graph) {
        List<Node> nodes = phi.getNodes();
        int num = nodes.size();
        int maxCount = -1;
        for (int a = 0; a < num; ++a) {
            Node anode = nodes.get(a);
            for (int c = a + 1; c < num; ++c) {
                Node cnode;
                if (c == a || phi.isAdjacentTo(anode, cnode = nodes.get(c))) continue;
                for (int b = 0; b < num; ++b) {
                    Set<Node> localMinusSep;
                    int count;
                    Node bnode;
                    if (b == a || b == c || phi.isUnderlineTriple(anode, bnode = nodes.get(b), cnode) || !Ccd.isCollider(phi, anode, bnode, cnode) || (count = (localMinusSep = Ccd.countLocalMinusSep(phi, sep, loc, anode, bnode, cnode)).size()) <= maxCount) continue;
                    maxCount = count;
                }
            }
        }
        return maxCount;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }
}

