/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MbUtils;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class CefsSepset {
    public static final int UNTRIMMED_UNORIENTED_ADJACENCY_GRAPH = 0;
    public static final int UNTRIMMED_ORIENTED_ADJACENCY_GRAPH = 1;
    public static final int TRIMMED_ORIENTED_ADJACENCY_GRAPH = 2;
    private int stopPoint = 2;
    private IndependenceTest test;
    private List<Node> variables;
    private Node target;
    private int depth;
    private Graph resultGraph;
    private long numIndependenceTests;
    private int[] maxRemainingAtDepth;
    private Node[] maxVariableAtDepth;
    private Set<Node> visited;
    private long elapsedTime;
    private Dag trueMb;
    private SepsetMap sepset;

    public CefsSepset(IndependenceTest test, int depth) {
        if (test == null) {
            throw new NullPointerException();
        }
        if (depth == -1) {
            depth = Integer.MAX_VALUE;
        }
        if (depth < 0) {
            throw new IllegalArgumentException("Depth must be >= -1: " + depth);
        }
        this.test = test;
        this.depth = depth;
        this.variables = test.getVariables();
    }

    public Graph search(String targetName) {
        long start = System.currentTimeMillis();
        this.numIndependenceTests = 0L;
        this.sepset = new SepsetMap();
        if (targetName == null) {
            throw new IllegalArgumentException("Null target name not permitted");
        }
        this.target = this.getVariableForName(targetName);
        this.maxRemainingAtDepth = new int[20];
        this.maxVariableAtDepth = new Node[20];
        Arrays.fill(this.maxRemainingAtDepth, -1);
        Arrays.fill(this.maxVariableAtDepth, null);
        TetradLogger.getInstance().log("info", "target = " + this.getTarget());
        EdgeListGraph graph = new EdgeListGraph();
        this.visited = new HashSet<Node>();
        TetradLogger.getInstance().log("info", "BEGINNING step 1 (prune target).");
        graph.addNode(this.getTarget());
        this.constructFan(this.getTarget(), graph);
        TetradLogger.getInstance().log("graph", "After step 1 (prune target)" + graph);
        TetradLogger.getInstance().log("info", "BEGINNING step 2 (prune PC).");
        for (Node v : graph.getAdjacentNodes(this.getTarget())) {
            this.constructFan(v, graph);
        }
        TetradLogger.getInstance().log("graph", "After step 2 (prune PC)" + graph);
        TetradLogger.getInstance().log("info", "BEGINNING step 4 (PC Orient).");
        Knowledge bk = new Knowledge();
        SearchGraphUtils.pcOrientbk(bk, graph, graph.getNodes());
        LinkedList<Node> _visited = new LinkedList<Node>(this.getVisited());
        Knowledge knowledge = new Knowledge();
        TetradLogger.getInstance().log("info", "Staring PC Orientation.");
        SearchGraphUtils.pcOrientbk(knowledge, graph, graph.getNodes());
        SearchGraphUtils.orientCollidersUsingSepsets(this.sepset, knowledge, graph);
        MeekRules rules = new MeekRules();
        rules.setKnowledge(knowledge);
        rules.orientImplied(graph);
        TetradLogger.getInstance().log("info", "Finishing PC Orientation");
        if (this.getStopPoint() == 1) {
            this.finishUp(start, graph);
            return graph;
        }
        TetradLogger.getInstance().log("graph", "After step 4 (PC Orient)" + graph);
        TetradLogger.getInstance().log("info", "BEGINNING step 5 (Trim graph to {T} U PC U {Parents(Children(T))}).");
        MbUtils.trimToNeighborhood(graph, _visited);
        TetradLogger.getInstance().log("graph", "After step 5 (Trim graph to {T} U PC U {Parents(Children(T))})" + graph);
        TetradLogger.getInstance().log("details", "Bounds: ");
        for (int i = 0; i < this.maxRemainingAtDepth.length; ++i) {
            if (this.maxRemainingAtDepth[i] == -1) continue;
            TetradLogger.getInstance().log("details", "\ta" + i + " = " + this.maxRemainingAtDepth[i] + " (" + this.maxVariableAtDepth[i] + ")");
        }
        this.finishUp(start, graph);
        return graph;
    }

    private void finishUp(long start, Graph graph) {
        long stop = System.currentTimeMillis();
        this.elapsedTime = stop - start;
        double seconds = (double)this.elapsedTime / 1000.0;
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        TetradLogger.getInstance().log("info", "MB fan search took " + nf.format(seconds) + " seconds.");
        TetradLogger.getInstance().log("info", "Number of independence tests performed = " + this.getNumIndependenceTests());
        this.resultGraph = graph;
    }

    public List<Graph> generateDags(boolean orientBidirectedEdges) {
        return new LinkedList<Graph>(this.listDags(new EdgeListGraph(this.resultGraph()), orientBidirectedEdges));
    }

    public List<Graph> generateDags(Graph resultGraph, boolean orientBidirectedEdges) {
        return new LinkedList<Graph>(this.listDags(new EdgeListGraph(resultGraph), orientBidirectedEdges));
    }

    public long getNumIndependenceTests() {
        return this.numIndependenceTests;
    }

    public Node getTarget() {
        return this.target;
    }

    public String getAlgorithmName() {
        return "CE Fan Search Sepset";
    }

    public Graph getMbPattern() {
        return null;
    }

    public Dag getTrueMb() {
        return this.trueMb;
    }

    public void setTrueMb(Dag trueMb) {
        this.trueMb = trueMb;
    }

    public int getStopPoint() {
        return this.stopPoint;
    }

    public void setStopPoint(int stopPoint) {
        switch (stopPoint) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Must be one of UNTRIMMED_UNORIENTED_ADJACENCY_GRAPH,UNTRIMMED_ORIENTED_ADJACENCY_GRAPH, or TRIMMED_ORIENTED_ADJACENCY_GRAPH.");
            }
        }
        this.stopPoint = stopPoint;
    }

    private void constructFan(Node target, Graph graph) {
        this.addAllowableAssociates(target, graph);
        this.prune(target, graph);
    }

    private void addAllowableAssociates(Node v, Graph graph) {
        this.getVisited().add(v);
        int numAssociated = 0;
        for (Node w : this.variables) {
            if (this.getVisited().contains(w) || graph.containsNode(w) && graph.isAdjacentTo(v, w) || this.independent(v, w, new LinkedList<Node>())) continue;
            this.addEdge(graph, w, v);
            ++numAssociated;
        }
        this.noteMaxAtDepth(0, numAssociated, v);
    }

    private void prune(Node node, Graph graph) {
        for (int depth = 1; depth <= this.getDepth(); ++depth) {
            if (graph.getAdjacentNodes(node).size() < depth) {
                return;
            }
            this.prune(node, graph, depth);
        }
    }

    private void prune(Node node, Graph graph, int depth) {
        TetradLogger.getInstance().log("details", "Trying node remove edges adjacent node " + node + ", depth = " + depth + ".");
        LinkedList<Node> a = new LinkedList<Node>(graph.getAdjacentNodes(node));
        block0: for (Node y : a) {
            int[] choice;
            LinkedList<Node> adjX = new LinkedList<Node>(graph.getAdjacentNodes(node));
            adjX.remove(y);
            if (adjX.size() < depth) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjX.size(), depth);
            while ((choice = cg.next()) != null) {
                List<Node> condSet = SearchGraphUtils.asList(choice, adjX);
                if (!this.independent(node, y, condSet)) continue;
                graph.removeEdge(node, y);
                if (!graph.getEdges(y).isEmpty() || y == this.getTarget()) continue block0;
                graph.removeNode(y);
                continue block0;
            }
        }
        int numAdjacents = graph.getAdjacentNodes(node).size();
        this.noteMaxAtDepth(depth, numAdjacents, node);
    }

    private boolean independent(Node v, Node w, List<Node> z) {
        boolean independent = this.getTest().isIndependent(v, w, z);
        if (independent) {
            this.sepset.set(v, w, z);
            if (this.getTrueMb() != null) {
                Edge edge;
                Node node1 = this.getTrueMb().getNode(v.getName());
                Node node2 = this.getTrueMb().getNode(w.getName());
                if (node1 != null && node2 != null && (edge = this.getTrueMb().getEdge(node1, node2)) != null) {
                    NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
                    System.out.println("Edge removed that was in the true MB:");
                    System.out.println("\tTrue edge = " + edge);
                    System.out.println("\t" + SearchLogUtils.independenceFact(v, w, z) + "\tp = " + nf.format(this.getTest().getPValue()));
                }
            }
        }
        ++this.numIndependenceTests;
        return independent;
    }

    private void addEdge(Graph graph, Node w, Node v) {
        if (!graph.containsNode(w)) {
            graph.addNode(w);
        }
        graph.addUndirectedEdge(v, w);
    }

    private Node getVariableForName(String targetVariableName) {
        Node target = null;
        for (Node V : this.variables) {
            if (!V.getName().equals(targetVariableName)) continue;
            target = V;
            break;
        }
        if (target == null) {
            throw new IllegalArgumentException("Target variable not in dataset: " + targetVariableName);
        }
        return target;
    }

    private void noteMaxAtDepth(int depth, int numAdjacents, Node to) {
        if (depth < this.maxRemainingAtDepth.length && numAdjacents > this.maxRemainingAtDepth[depth]) {
            this.maxRemainingAtDepth[depth] = numAdjacents;
            this.maxVariableAtDepth[depth] = to;
        }
    }

    private int getDepth() {
        return this.depth;
    }

    private Set<Graph> listDags(Graph pattern, boolean orientBidirectedEdges) {
        HashSet<Graph> dags = new HashSet<Graph>();
        EdgeListGraph graph = new EdgeListGraph(pattern);
        this.doAbbreviatedOrientation(graph);
        List<Edge> edges = graph.getEdges();
        Edge edge = null;
        for (Edge _edge : edges) {
            if (orientBidirectedEdges && Edges.isBidirectedEdge(_edge)) {
                edge = _edge;
                break;
            }
            if (!Edges.isUndirectedEdge(_edge)) continue;
            edge = _edge;
            break;
        }
        if (edge == null) {
            dags.add(graph);
            return dags;
        }
        graph.setEndpoint(edge.getNode2(), edge.getNode1(), Endpoint.TAIL);
        graph.setEndpoint(edge.getNode1(), edge.getNode2(), Endpoint.ARROW);
        dags.addAll(this.listDags(graph, orientBidirectedEdges));
        graph.setEndpoint(edge.getNode1(), edge.getNode2(), Endpoint.TAIL);
        graph.setEndpoint(edge.getNode2(), edge.getNode1(), Endpoint.ARROW);
        dags.addAll(this.listDags(graph, orientBidirectedEdges));
        return dags;
    }

    private void doAbbreviatedOrientation(Graph graph) {
        SearchGraphUtils.orientUsingMeekRulesLocally(new Knowledge(), graph, this.getTest(), this.depth);
        MbUtils.trimToMbNodes(graph, this.getTarget(), false);
        MbUtils.trimEdgesAmongParents(graph, this.getTarget());
        MbUtils.trimEdgesAmongParentsOfChildren(graph, this.getTarget());
    }

    private Graph resultGraph() {
        return this.resultGraph;
    }

    public static void orientCollidersLocally(Knowledge knowledge, Graph graph, IndependenceTest test, int depth, List<Node> nodesToVisit) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        if (nodesToVisit == null) {
            nodesToVisit = graph.getNodes();
        }
        for (Node a : nodesToVisit) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node c;
                Node b = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1])) || !SearchGraphUtils.isArrowpointAllowed1(b, a, knowledge) || !SearchGraphUtils.isArrowpointAllowed1(c, a, knowledge) || SearchGraphUtils.existsLocalSepsetWith(b, a, c, test, graph, depth)) continue;
                graph.setEndpoint(b, a, Endpoint.ARROW);
                graph.setEndpoint(c, a, Endpoint.ARROW);
                TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(b, a, c));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    public static void orientUsingMeekRulesLocally(Knowledge knowledge, Graph graph, IndependenceTest test, int depth, List<Node> neighborhood) {
        TetradLogger.getInstance().log("info", "Starting Orientation Step D.");
        while (CefsSepset.meekR1Locally(graph, knowledge, test, depth, neighborhood) || CefsSepset.meekR2(graph, knowledge, neighborhood) || CefsSepset.meekR3(graph, knowledge, neighborhood) || CefsSepset.meekR4(graph, knowledge, neighborhood)) {
        }
        TetradLogger.getInstance().log("info", "Finishing Orientation Step D.");
    }

    public static boolean meekR1Locally(Graph graph, Knowledge knowledge, IndependenceTest test, int depth, List<Node> neighborhood) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Node a : neighborhood) {
                int[] combination;
                List<Node> adjacentNodes = graph.getAdjacentNodes(a);
                adjacentNodes.retainAll(neighborhood);
                if (adjacentNodes.size() < 2) continue;
                ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node c;
                    Node b = adjacentNodes.get(combination[0]);
                    if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1]))) continue;
                    if (graph.getEndpoint(b, a) == Endpoint.ARROW && graph.isUndirectedFromTo(a, c)) {
                        if (SearchGraphUtils.existsLocalSepsetWithout(b, a, c, test, graph, depth) || !CefsSepset.isArrowpointAllowed(a, c, knowledge)) continue;
                        graph.setEndpoint(a, c, Endpoint.ARROW);
                        TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1", graph.getEdge(a, c)));
                        changed = true;
                        continue;
                    }
                    if (graph.getEndpoint(c, a) != Endpoint.ARROW || !graph.isUndirectedFromTo(a, b) || SearchGraphUtils.existsLocalSepsetWithout(b, a, c, test, graph, depth) || !CefsSepset.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1", graph.getEdge(a, b)));
                    changed = true;
                }
            }
        }
        return changed;
    }

    public static boolean meekR2(Graph graph, Knowledge knowledge, List<Node> neighborhood) {
        boolean changed = false;
        for (Node a : neighborhood) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            adjacentNodes.retainAll(neighborhood);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node b = adjacentNodes.get(combination[0]);
                Node c = adjacentNodes.get(combination[1]);
                if (graph.isDirectedFromTo(b, a) && graph.isDirectedFromTo(a, c) && graph.isUndirectedFromTo(b, c)) {
                    if (!CefsSepset.isArrowpointAllowed(b, c, knowledge)) continue;
                    graph.setEndpoint(b, c, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(b, c)));
                    continue;
                }
                if (!graph.isDirectedFromTo(c, a) || !graph.isDirectedFromTo(a, b) || !graph.isUndirectedFromTo(c, b) || !CefsSepset.isArrowpointAllowed(c, b, knowledge)) continue;
                graph.setEndpoint(c, b, Endpoint.ARROW);
                TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(c, b)));
            }
        }
        return changed;
    }

    public static boolean meekR3(Graph graph, Knowledge knowledge, List<Node> neighborhood) {
        boolean changed = false;
        for (Node a : neighborhood) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            adjacentNodes.retainAll(neighborhood);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node b : adjacentNodes) {
                int[] combination;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(b);
                if (!graph.isUndirectedFromTo(a, b)) continue;
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node d;
                    Node c = (Node)otherAdjacents.get(combination[0]);
                    if (graph.isAdjacentTo(c, d = (Node)otherAdjacents.get(combination[1])) || !graph.isUndirectedFromTo(a, c) || !graph.isUndirectedFromTo(a, d) || !graph.isDirectedFromTo(c, b) || !graph.isDirectedFromTo(d, b) || !CefsSepset.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R3", graph.getEdge(a, b)));
                    changed = true;
                    continue block1;
                }
            }
        }
        return changed;
    }

    public static boolean meekR4(Graph graph, Knowledge knowledge, List<Node> neighborhood) {
        if (knowledge == null) {
            return false;
        }
        boolean changed = false;
        for (Node a : neighborhood) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            adjacentNodes.retainAll(neighborhood);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node d : adjacentNodes) {
                int[] combination;
                if (!graph.isUndirectedFromTo(a, d)) continue;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(d);
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node b = (Node)otherAdjacents.get(combination[0]);
                    Node c = (Node)otherAdjacents.get(combination[1]);
                    if (graph.isAdjacentTo(b, d) || !graph.isUndirectedFromTo(a, b) || !graph.isAdjacentTo(a, c)) continue;
                    if (graph.isDirectedFromTo(b, c) && graph.isDirectedFromTo(c, d)) {
                        if (!CefsSepset.isArrowpointAllowed(a, d, knowledge)) continue;
                        graph.setEndpoint(a, d, Endpoint.ARROW);
                        TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R4", graph.getEdge(a, d)));
                        changed = true;
                        continue block1;
                    }
                    if (!graph.isDirectedFromTo(d, c) || !graph.isDirectedFromTo(c, b) || !CefsSepset.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R4", graph.getEdge(a, b)));
                    changed = true;
                    continue block1;
                }
            }
        }
        return changed;
    }

    public static boolean isArrowpointAllowed(Object from, Object to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.edgeRequired(to.toString(), from.toString()) && !knowledge.edgeForbidden(from.toString(), to.toString());
    }

    public List<Node> findMb(String targetName) {
        Graph graph = this.search(targetName);
        List<Node> nodes = graph.getNodes();
        nodes.remove(this.target);
        return nodes;
    }

    public IndependenceTest getTest() {
        return this.test;
    }

    public Set<Node> getVisited() {
        return this.visited;
    }
}

