/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.search.TetradTest;
import edu.cmu.tetrad.sem.MimBuildEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.ProbUtils;
import java.util.Arrays;

public final class ContinuousTetradTest
implements TetradTest {
    private double sig;
    private double sig1;
    private double sig2;
    private double sig3;
    private double[] prob;
    private double[][][][] fourthMM;
    private boolean[] bvalues;
    private boolean outputMessage;
    private CovarianceMatrix covMatrix;
    private CorrelationMatrix corrMatrix;
    private double[][] dataMatrix;
    private TestType sigTestType;
    private int sampleSize;
    private DataSet dataSet;
    private OneFactorEstimator oneFactorEst4;
    private OneFactorEstimator oneFactorEst5;
    private OneFactorEstimator oneFactorEst6;
    private TwoFactorsEstimator twoFactorsEst4;
    private TwoFactorsEstimator twoFactorsEst5;
    private TwoFactorsEstimator twoFactorsEst6;
    private boolean modeX = false;
    private double[][] bufferMatrix;

    public ContinuousTetradTest(DataSet dataSet, TestType sigTestType, double sig) {
        if (sigTestType != TestType.TETRAD_WISHART && sigTestType != TestType.TETRAD_BOLLEN && sigTestType != TestType.GAUSSIAN_FACTOR) {
            throw new IllegalArgumentException("Unexpected type: " + sigTestType);
        }
        this.corrMatrix = new CorrelationMatrix(dataSet);
        this.dataSet = dataSet;
        this.sigTestType = sigTestType;
        this.setSignificance(sig);
        this.sampleSize = dataSet.getNumRows();
        this.covMatrix = new CovarianceMatrix(dataSet);
        this.fourthMM = this.getFourthMomentsMatrix(dataSet);
        this.initialization();
    }

    public ContinuousTetradTest(CovarianceMatrix CovarianceMatrix2, TestType sigTestType, double sig) {
        if (sigTestType != TestType.TETRAD_WISHART && sigTestType != TestType.TETRAD_BOLLEN && sigTestType != TestType.GAUSSIAN_FACTOR) {
            throw new IllegalArgumentException("Unexpected type: " + sigTestType);
        }
        this.dataSet = null;
        this.corrMatrix = new CorrelationMatrix(CovarianceMatrix2);
        this.covMatrix = this.corrMatrix;
        this.sigTestType = sigTestType;
        this.setSignificance(sig);
        this.sampleSize = CovarianceMatrix2.getSize();
        this.initialization();
    }

    public ContinuousTetradTest(CorrelationMatrix correlationMatrix, TestType sigTestType, double sig) {
        if (sigTestType != TestType.TETRAD_WISHART && sigTestType != TestType.TETRAD_BOLLEN && sigTestType != TestType.GAUSSIAN_FACTOR) {
            throw new IllegalArgumentException("Unexpected type: " + sigTestType);
        }
        if (correlationMatrix == null) {
            throw new NullPointerException();
        }
        this.dataSet = null;
        this.corrMatrix = correlationMatrix;
        this.covMatrix = correlationMatrix;
        this.sigTestType = sigTestType;
        this.setSignificance(sig);
        this.sampleSize = correlationMatrix.getSize();
        this.initialization();
    }

    @Override
    public double getSignificance() {
        return this.sig;
    }

    @Override
    public void setSignificance(double sig) {
        this.sig = sig;
        this.sig1 = sig / 3.0;
        this.sig2 = 2.0 * sig / 3.0;
        this.sig3 = sig;
    }

    @Override
    public DataSet getDataSet() {
        return this.dataSet;
    }

    public CorrelationMatrix getCorrMatrix() {
        return this.corrMatrix;
    }

    public CovarianceMatrix getCovMatrix() {
        if (this.covMatrix != null) {
            return this.covMatrix;
        }
        if (this.dataSet != null) {
            this.covMatrix = new CovarianceMatrix(this.dataSet);
            return this.covMatrix;
        }
        return this.corrMatrix;
    }

    @Override
    public String[] getVarNames() {
        return this.corrMatrix.getVariableNames().toArray(new String[0]);
    }

    public TestType getTestType() {
        return this.sigTestType;
    }

    public void setTestType(TestType sigTestType) {
        this.sigTestType = sigTestType;
    }

    private void initialization() {
        this.sampleSize = this.corrMatrix.getSampleSize();
        this.outputMessage = false;
        this.prob = new double[3];
        this.bvalues = new boolean[3];
        this.oneFactorEst4 = new OneFactorEstimator(this.corrMatrix, this.sig, 4);
        this.oneFactorEst5 = new OneFactorEstimator(this.corrMatrix, this.sig, 5);
        this.oneFactorEst6 = new OneFactorEstimator(this.corrMatrix, this.sig, 6);
        this.twoFactorsEst4 = new TwoFactorsEstimator(this.corrMatrix, this.sig, 4);
        this.twoFactorsEst5 = new TwoFactorsEstimator(this.corrMatrix, this.sig, 5);
        this.twoFactorsEst6 = new TwoFactorsEstimator(this.corrMatrix, this.sig, 6);
        this.bufferMatrix = new double[4][4];
        this.dataMatrix = this.corrMatrix.getMatrix().toArray();
    }

    @Override
    public int tetradScore(int v1, int v2, int v3, int v4) {
        this.evalTetradDifferences(v1, v2, v3, v4);
        for (int i = 0; i < 3; ++i) {
            this.bvalues[i] = this.prob[i] >= this.sig;
        }
        if (this.prob[1] < this.prob[0] && this.prob[1] < this.prob[2]) {
            double tempProb = this.prob[0];
            this.prob[0] = this.prob[1];
            this.prob[1] = tempProb;
        } else if (this.prob[2] < this.prob[0] && this.prob[2] < this.prob[0]) {
            double tempProb = this.prob[0];
            this.prob[0] = this.prob[2];
            this.prob[2] = tempProb;
        }
        if (this.prob[2] < this.prob[1]) {
            double tempProb = this.prob[1];
            this.prob[1] = this.prob[2];
            this.prob[2] = tempProb;
        }
        if (this.prob[2] <= this.sig3) {
            return 0;
        }
        if (this.prob[1] <= this.sig2) {
            return 1;
        }
        if (this.prob[0] <= this.sig1) {
            return 1;
        }
        return 3;
    }

    @Override
    public boolean tetradScore1(int v1, int v2, int v3, int v4) {
        return this.tetradHolds(v1, v3, v4, v2) && !this.tetradHolds(v1, v3, v2, v4) && !this.tetradHolds(v1, v4, v2, v3);
    }

    @Override
    public boolean tetradScore3(int v1, int v2, int v3, int v4) {
        if (this.sigTestType != TestType.GAUSSIAN_FACTOR) {
            return this.tetradScore(v1, v2, v3, v4) == 3;
        }
        return this.oneFactorTest(v1, v2, v3, v4);
    }

    @Override
    public boolean tetradHolds(int v1, int v2, int v3, int v4) {
        this.evalTetradDifference(v1, v2, v3, v4);
        this.bvalues[0] = this.prob[0] >= this.sig;
        return this.prob[0] >= this.sig;
    }

    @Override
    public double tetradPValue(int v1, int v2, int v3, int v4) {
        this.evalTetradDifference(v1, v2, v3, v4);
        return this.prob[0];
    }

    private double[][][][] getFourthMomentsMatrix(DataSet dataSet) {
        int t;
        int k;
        int j;
        int i;
        int d;
        int i2;
        this.printlnMessage("Bollen's test preparation: starting computation of fourth moments");
        int numVars = this.corrMatrix.getSize();
        double[][][][] fourthMM = new double[numVars][numVars][numVars][numVars];
        double[][] data = dataSet.getDoubleData().viewDice().toArray();
        double[] means = new double[numVars];
        for (i2 = 0; i2 < numVars; ++i2) {
            means[i2] = 0.0;
        }
        for (d = 0; d < this.sampleSize; ++d) {
            for (i = 0; i < numVars; ++i) {
                int n = i;
                means[n] = means[n] + data[i][d];
            }
        }
        i2 = 0;
        while (i2 < numVars) {
            int n = i2++;
            means[n] = means[n] / (double)this.sampleSize;
        }
        for (i2 = 0; i2 < numVars; ++i2) {
            for (j = 0; j < numVars; ++j) {
                for (k = 0; k < numVars; ++k) {
                    for (t = 0; t < numVars; ++t) {
                        fourthMM[i2][j][k][t] = 0.0;
                    }
                }
            }
        }
        for (d = 0; d < this.sampleSize; ++d) {
            for (i = 0; i < numVars; ++i) {
                for (int j2 = 0; j2 < numVars; ++j2) {
                    for (int k2 = 0; k2 < numVars; ++k2) {
                        for (int t2 = 0; t2 < numVars; ++t2) {
                            double[] dArray = fourthMM[i][j2][k2];
                            int n = t2;
                            dArray[n] = dArray[n] + (data[i][d] - means[i]) * (data[j2][d] - means[j2]) * (data[k2][d] - means[k2]) * (data[t2][d] - means[t2]);
                        }
                    }
                }
            }
        }
        for (i2 = 0; i2 < numVars; ++i2) {
            for (j = 0; j < numVars; ++j) {
                for (k = 0; k < numVars; ++k) {
                    t = 0;
                    while (t < numVars) {
                        double[] dArray = fourthMM[i2][j][k];
                        int n = t++;
                        dArray[n] = dArray[n] / (double)this.sampleSize;
                    }
                }
            }
        }
        this.printlnMessage("Done with fourth moments");
        return fourthMM;
    }

    private void evalTetradDifferences(int i, int j, int k, int l) {
        switch (this.sigTestType) {
            case TETRAD_BASED: 
            case TETRAD_BASED2: 
            case TETRAD_WISHART: {
                this.wishartEvalTetradDifferences(i, j, k, l);
                break;
            }
            case TETRAD_BOLLEN: {
                this.bollenEvalTetradDifferences(i, j, k, l);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void evalTetradDifference(int i, int j, int k, int l) {
        switch (this.sigTestType) {
            case TETRAD_BASED: 
            case TETRAD_BASED2: 
            case TETRAD_WISHART: {
                this.wishartEvalTetradDifference(i, j, k, l);
                break;
            }
            case TETRAD_BOLLEN: {
                this.bollenEvalTetradDifference(i, j, k, l);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void wishartEvalTetradDifferences(int i, int j, int k, int l) {
        double TAUijkl = this.dataMatrix[i][j] * this.dataMatrix[k][l] - this.dataMatrix[i][k] * this.dataMatrix[j][l];
        double SD = this.wishartTestTetradDifference(i, j, k, l);
        double ratio = TAUijkl / SD;
        if (ratio > 0.0) {
            ratio = -ratio;
        }
        this.prob[0] = 2.0 * ProbUtils.normalCdf(ratio);
        double TAUijlk = this.dataMatrix[i][j] * this.dataMatrix[k][l] - this.dataMatrix[i][l] * this.dataMatrix[j][k];
        SD = this.wishartTestTetradDifference(i, j, l, k);
        ratio = TAUijlk / SD;
        if (ratio > 0.0) {
            ratio = -ratio;
        }
        this.prob[1] = 2.0 * ProbUtils.normalCdf(ratio);
        double TAUiklj = this.dataMatrix[i][k] * this.dataMatrix[j][l] - this.dataMatrix[i][l] * this.dataMatrix[j][k];
        SD = this.wishartTestTetradDifference(i, k, l, j);
        ratio = TAUiklj / SD;
        if (ratio > 0.0) {
            ratio = -ratio;
        }
        this.prob[2] = 2.0 * ProbUtils.normalCdf(ratio);
    }

    private void wishartEvalTetradDifference(int i, int j, int k, int l) {
        double ratio;
        double TAUijkl = this.dataMatrix[i][j] * this.dataMatrix[k][l] - this.dataMatrix[i][k] * this.dataMatrix[j][l];
        if (this.modeX) {
            System.out.println("T = " + TAUijkl);
        }
        double SD = this.wishartTestTetradDifference(i, j, k, l);
        if (this.modeX) {
            System.out.println("T = " + TAUijkl);
            System.out.println("SD = " + SD);
            System.out.println();
        }
        if ((ratio = TAUijkl / SD) > 0.0) {
            ratio = -ratio;
        }
        this.prob[0] = 2.0 * ProbUtils.normalCdf(ratio);
    }

    private double wishartTestTetradDifference(int a, int b, int c, int d) {
        int[] indices = new int[]{a, b, c, d};
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.bufferMatrix[i][j] = this.dataMatrix[indices[i]][indices[j]];
            }
        }
        double product1 = this.dataMatrix[a][a] * this.dataMatrix[d][d] - this.dataMatrix[a][d] * this.dataMatrix[a][d];
        double product2 = this.dataMatrix[b][b] * this.dataMatrix[c][c] - this.dataMatrix[b][c] * this.dataMatrix[b][c];
        double n = this.sampleSize;
        double product3 = (n + 1.0) / ((n - 1.0) * (n - 2.0)) * product1 * product2;
        double determinant = MatrixUtils.determinant(this.bufferMatrix);
        double SD = product3 - determinant / (n - 2.0);
        return Math.sqrt(SD);
    }

    private void bollenEvalTetradDifferences(int i, int j, int k, int l) {
        double bt;
        double TAUijkl = this.covMatrix.getValue(i, j) * this.covMatrix.getValue(k, l) - this.covMatrix.getValue(i, k) * this.covMatrix.getValue(j, l);
        double ratio = TAUijkl / Math.sqrt(bt = this.bollenTetradStatistic(i, j, k, l));
        if (ratio > 0.0) {
            ratio = -ratio;
        }
        this.prob[0] = 2.0 * ProbUtils.normalCdf(ratio);
        double TAUijlk = this.covMatrix.getValue(i, j) * this.covMatrix.getValue(k, l) - this.covMatrix.getValue(i, l) * this.covMatrix.getValue(j, k);
        ratio = TAUijlk / Math.sqrt(bt = this.bollenTetradStatistic(i, j, l, k));
        if (ratio > 0.0) {
            ratio = -ratio;
        }
        this.prob[1] = 2.0 * ProbUtils.normalCdf(ratio);
        double TAUiklj = this.covMatrix.getValue(i, k) * this.covMatrix.getValue(j, l) - this.covMatrix.getValue(i, l) * this.covMatrix.getValue(j, k);
        ratio = TAUiklj / Math.sqrt(bt = this.bollenTetradStatistic(i, k, l, j));
        if (ratio > 0.0) {
            ratio = -ratio;
        }
        this.prob[2] = 2.0 * ProbUtils.normalCdf(ratio);
    }

    private void bollenEvalTetradDifference(int i, int j, int k, int l) {
        double bt;
        double TAUijkl = this.covMatrix.getValue(i, j) * this.covMatrix.getValue(k, l) - this.covMatrix.getValue(i, k) * this.covMatrix.getValue(j, l);
        double ratio = TAUijkl / Math.sqrt(bt = this.bollenTetradStatistic(i, j, k, l));
        if (ratio > 0.0) {
            ratio = -ratio;
        }
        this.prob[0] = 2.0 * ProbUtils.normalCdf(ratio);
    }

    private double bollenTetradStatistic(int t1, int t2, int t3, int t4) {
        double cov2413;
        double cov2314;
        double prod2413;
        double prod1413;
        double prod1233;
        double prod2313;
        double prod2324;
        double prod2314;
        double prod1313;
        double prod2424;
        double prod1414;
        if (this.covMatrix == null) {
            throw new NullPointerException();
        }
        if (this.fourthMM == null) {
            throw new NullPointerException();
        }
        double prod2323 = this.covMatrix.getValue(t2, t3) * this.covMatrix.getValue(t2, t3) * this.fourthMM[t1][t1][t4][t4];
        double nStat = prod2323 + (prod1414 = this.covMatrix.getValue(t1, t4) * this.covMatrix.getValue(t1, t4) * this.fourthMM[t2][t2][t3][t3]) + (prod2424 = this.covMatrix.getValue(t2, t4) * this.covMatrix.getValue(t2, t4) * this.fourthMM[t1][t1][t3][t3]) + (prod1313 = this.covMatrix.getValue(t1, t3) * this.covMatrix.getValue(t1, t3) * this.fourthMM[t2][t2][t4][t4]) + 2.0 * ((prod2314 = this.covMatrix.getValue(t2, t3) * this.covMatrix.getValue(t1, t4) * this.fourthMM[t1][t2][t3][t4]) - (prod2324 = this.covMatrix.getValue(t2, t3) * this.covMatrix.getValue(t2, t4) * this.fourthMM[t1][t1][t3][t4]) - (prod2313 = this.covMatrix.getValue(t2, t3) * this.covMatrix.getValue(t1, t3) * this.fourthMM[t1][t2][t4][t4]) - (prod1233 = this.covMatrix.getValue(t1, t4) * this.covMatrix.getValue(t2, t4) * this.fourthMM[t1][t2][t3][t3]) - (prod1413 = this.covMatrix.getValue(t1, t4) * this.covMatrix.getValue(t1, t3) * this.fourthMM[t2][t2][t3][t4]) + (prod2413 = this.covMatrix.getValue(t2, t4) * this.covMatrix.getValue(t1, t3) * this.fourthMM[t1][t2][t3][t4])) - 4.0 * Math.pow((cov2314 = this.covMatrix.getValue(t2, t3) * this.covMatrix.getValue(t1, t4)) - (cov2413 = this.covMatrix.getValue(t2, t4) * this.covMatrix.getValue(t1, t3)), 2.0);
        double stat = nStat / (double)this.sampleSize;
        if (stat < 0.0) {
            stat = 1.0E-6;
        }
        return stat;
    }

    void printMessage(String message) {
        if (this.outputMessage) {
            System.out.print(message);
        }
    }

    void printlnMessage(String message) {
        if (this.outputMessage) {
            System.out.println(message);
        }
    }

    void printlnMessage() {
        if (this.outputMessage) {
            System.out.println();
        }
    }

    void printlnMessage(boolean flag) {
        if (this.outputMessage) {
            System.out.println(flag);
        }
    }

    @Override
    public boolean oneFactorTest(int v1, int v2, int v3, int v4) {
        int[] indices = new int[]{v1, v2, v3, v4};
        this.oneFactorEst4.init(indices);
        return this.oneFactorEst4.isSignificant();
    }

    @Override
    public boolean oneFactorTest(int v1, int v2, int v3, int v4, int v5) {
        int[] indices = new int[]{v1, v2, v3, v4, v5};
        this.oneFactorEst5.init(indices);
        return this.oneFactorEst5.isSignificant();
    }

    @Override
    public boolean oneFactorTest(int v1, int v2, int v3, int v4, int v5, int v6) {
        int[] indices = new int[]{v1, v2, v3, v4, v5, v6};
        this.oneFactorEst6.init(indices);
        return this.oneFactorEst6.isSignificant();
    }

    @Override
    public boolean twoFactorTest(int v1, int v2, int v3, int v4) {
        int[] indices = new int[]{v1, v2, v3, v4};
        this.twoFactorsEst4.init(indices, 2);
        return this.twoFactorsEst4.isSignificant();
    }

    @Override
    public boolean twoFactorTest(int v1, int v2, int v3, int v4, int v5) {
        int[] indices = new int[]{v1, v2, v3, v4, v5};
        this.twoFactorsEst5.init(indices, 3);
        return this.twoFactorsEst5.isSignificant();
    }

    @Override
    public boolean twoFactorTest(int v1, int v2, int v3, int v4, int v5, int v6) {
        int[] indices = new int[]{v1, v2, v3, v4, v5, v6};
        this.twoFactorsEst6.init(indices, 3);
        return this.twoFactorsEst6.isSignificant();
    }

    public int tempTetradScore(int v1, int v2, int v3, int v4) {
        this.evalTetradDifferences(v1, v2, v3, v4);
        System.out.println(this.prob[0]);
        System.out.println(this.prob[1]);
        System.out.println(this.prob[2]);
        for (int i = 0; i < 3; ++i) {
            this.bvalues[i] = this.prob[i] >= this.sig;
        }
        if (this.prob[1] < this.prob[0] && this.prob[1] < this.prob[2]) {
            double tempProb = this.prob[0];
            this.prob[0] = this.prob[1];
            this.prob[1] = tempProb;
        } else if (this.prob[2] < this.prob[0] && this.prob[2] < this.prob[0]) {
            double tempProb = this.prob[0];
            this.prob[0] = this.prob[2];
            this.prob[2] = tempProb;
        }
        if (this.prob[2] < this.prob[1]) {
            double tempProb = this.prob[1];
            this.prob[1] = this.prob[2];
            this.prob[2] = tempProb;
        }
        if (this.prob[2] <= this.sig3) {
            return 0;
        }
        if (this.prob[1] <= this.sig2) {
            return 1;
        }
        if (this.prob[0] <= this.sig1) {
            return 3;
        }
        return 3;
    }

    class TwoFactorsEstimator
    extends SimpleFactorEstimator {
        static final long serialVersionUID = 23L;
        int nleft;

        public TwoFactorsEstimator(CovarianceMatrix sampleCov, double sig, int nvar) {
            super(sampleCov, sig, nvar);
        }

        public void init(int[] indices, int nleft) {
            this.nleft = nleft;
            super.init(indices);
        }

        @Override
        protected SemPm buildSemPm(int[] values) {
            EdgeListGraph graph = new EdgeListGraph();
            GraphNode latent1 = new GraphNode("__l1");
            GraphNode latent2 = new GraphNode("__l2");
            latent1.setNodeType(NodeType.LATENT);
            latent2.setNodeType(NodeType.LATENT);
            graph.addNode(latent1);
            graph.addNode(latent2);
            graph.addDirectedEdge(latent1, latent2);
            for (int i = 0; i < this.nvar; ++i) {
                GraphNode node = new GraphNode(this.submatrixNames[i]);
                graph.addNode(node);
                if (i < this.nleft) {
                    graph.addDirectedEdge(latent1, node);
                    continue;
                }
                graph.addDirectedEdge(latent2, node);
            }
            this.semPm = new SemPm(graph);
            return this.semPm;
        }
    }

    class OneFactorEstimator
    extends SimpleFactorEstimator {
        static final long serialVersionUID = 23L;

        public OneFactorEstimator(CovarianceMatrix sampleCov, double sig, int nvar) {
            super(sampleCov, sig, nvar);
        }

        @Override
        protected SemPm buildSemPm(int[] values) {
            EdgeListGraph graph = new EdgeListGraph();
            GraphNode latent = new GraphNode("__l");
            latent.setNodeType(NodeType.LATENT);
            graph.addNode(latent);
            for (int i = 0; i < this.nvar; ++i) {
                GraphNode node = new GraphNode(this.submatrixNames[i]);
                graph.addNode(node);
                graph.addDirectedEdge(latent, node);
            }
            this.semPm = new SemPm(graph);
            return this.semPm;
        }
    }

    abstract class SimpleFactorEstimator {
        CovarianceMatrix sampleCov;
        CovarianceMatrix subSampleCov;
        double sig;
        int[] indices;
        int nvar;
        SemPm semPm;
        String[] varNames;
        String[] submatrixNames;

        public SimpleFactorEstimator(CovarianceMatrix sampleCov, double sig, int nvar) {
            this.sampleCov = sampleCov;
            this.sig = sig;
            this.nvar = nvar;
            this.varNames = sampleCov.getVariableNames().toArray(new String[0]);
            this.submatrixNames = new String[nvar];
        }

        public void refreshDataMatrix(CovarianceMatrix sampleCov) {
            this.sampleCov = sampleCov;
            this.varNames = sampleCov.getVariableNames().toArray(new String[0]);
        }

        public void init(int[] indices) {
            Arrays.sort(indices);
            for (int i = 0; i < indices.length; ++i) {
                this.submatrixNames[i] = this.varNames[indices[i]];
            }
            this.semPm = this.buildSemPm(indices);
            this.subSampleCov = this.sampleCov.getSubmatrix(this.submatrixNames);
        }

        public boolean isSignificant() {
            MimBuildEstimator estimator = MimBuildEstimator.newInstance(this.subSampleCov, this.semPm, 3, 1);
            estimator.estimate();
            SemIm semIm = estimator.getEstimatedSem();
            return semIm.getPValue() > this.sig;
        }

        protected abstract SemPm buildSemPm(int[] var1);
    }
}

