/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.MeekRules;
import java.util.LinkedList;

public class DagInPatternIterator {
    private LinkedList<DecoratedGraph> decoratedGraphs = new LinkedList();
    private Graph storedGraph;
    private boolean returnedOne = false;
    private Knowledge knowledge = new Knowledge();

    public DagInPatternIterator(Graph pattern) {
        if (this.knowledge == null) {
            throw new IllegalArgumentException();
        }
        for (Edge edge : pattern.getEdges()) {
            if (Edges.isDirectedEdge(edge) || Edges.isUndirectedEdge(edge)) continue;
            throw new IllegalArgumentException("A pattern consist only of directed and undirected edges: " + edge);
        }
        this.decoratedGraphs.add(new DecoratedGraph(pattern, this.getKnowledge()));
    }

    public Graph next() {
        DecoratedGraph graph;
        if (this.storedGraph != null) {
            Graph temp = this.storedGraph;
            this.storedGraph = null;
            return temp;
        }
        if (this.decoratedGraphs.size() == 1 && this.decoratedGraphs.getLast().getEdge() == null && !this.returnedOne) {
            this.returnedOne = true;
            return new EdgeListGraph(this.decoratedGraphs.getLast().getGraph());
        }
        while (!this.decoratedGraphs.isEmpty()) {
            graph = this.decoratedGraphs.removeLast();
            if (!graph.isOrientable()) continue;
            this.decoratedGraphs.addLast(graph);
            break;
        }
        if (this.decoratedGraphs.isEmpty()) {
            return null;
        }
        while ((graph = this.decoratedGraphs.getLast().orient()) != null) {
            this.decoratedGraphs.addLast(graph);
        }
        return new EdgeListGraph(this.decoratedGraphs.getLast().getGraph());
    }

    public boolean hasNext() {
        if (this.storedGraph == null) {
            this.storedGraph = this.next();
        }
        return this.storedGraph != null;
    }

    public Knowledge getKnowledge() {
        return new Knowledge(this.knowledge);
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new IllegalArgumentException();
        }
        this.knowledge = knowledge;
    }

    private static class DecoratedGraph {
        private Graph graph;
        private Edge edge;
        private boolean triedLeft = false;
        private boolean triedRight = false;
        private Knowledge knowledge;

        public DecoratedGraph(Graph graph, Knowledge knowledge) {
            this.graph = graph;
            this.edge = this.findUndirectedEdge(graph);
            this.knowledge = knowledge;
        }

        private Edge findUndirectedEdge(Graph graph) {
            for (Edge edge : graph.getEdges()) {
                if (!Edges.isUndirectedEdge(edge)) continue;
                return edge;
            }
            return null;
        }

        public Graph getGraph() {
            return this.graph;
        }

        public Edge getEdge() {
            return this.edge;
        }

        public String toString() {
            return ((Object)this.graph).toString();
        }

        public void triedDirectLeft() {
            this.triedLeft = true;
        }

        public boolean isOrientable() {
            if (this.edge == null) {
                return false;
            }
            Node node1 = this.edge.getNode1();
            Node node2 = this.edge.getNode2();
            if (!(this.triedLeft || this.graph.isAncestorOf(node1, node2) || this.getKnowledge().edgeForbidden(node2.getName(), node1.getName()))) {
                return true;
            }
            return !this.triedRight && !this.graph.isAncestorOf(node2, node1) && !this.getKnowledge().edgeForbidden(node1.getName(), node2.getName());
        }

        public DecoratedGraph orient() {
            if (this.edge == null) {
                return null;
            }
            Node node1 = this.edge.getNode1();
            Node node2 = this.edge.getNode2();
            if (!(this.triedLeft || this.graph.isAncestorOf(node1, node2) || this.getKnowledge().edgeForbidden(node2.getName(), node1.getName()))) {
                EdgeListGraph graph = new EdgeListGraph(this.graph);
                graph.removeEdge(this.edge.getNode1(), this.edge.getNode2());
                graph.addDirectedEdge(this.edge.getNode2(), this.edge.getNode1());
                MeekRules meek = new MeekRules();
                meek.setKnowledge(this.knowledge);
                meek.orientImplied(graph);
                this.triedLeft = true;
                return new DecoratedGraph(graph, this.getKnowledge());
            }
            if (!(this.triedRight || this.graph.isAncestorOf(node2, node1) || this.getKnowledge().edgeForbidden(node1.getName(), node2.getName()))) {
                EdgeListGraph graph = new EdgeListGraph(this.graph);
                graph.removeEdge(this.edge.getNode1(), this.edge.getNode2());
                graph.addDirectedEdge(this.edge.getNode1(), this.edge.getNode2());
                MeekRules meek = new MeekRules();
                meek.setKnowledge(this.knowledge);
                meek.orientImplied(graph);
                meek.orientImplied(graph);
                this.triedRight = true;
                return new DecoratedGraph(graph, this.getKnowledge());
            }
            return null;
        }

        private Knowledge getKnowledge() {
            return this.knowledge;
        }
    }
}

