/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.CombinationGenerator;
import edu.cmu.tetrad.util.DepthChoiceGenerator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DagIterator3 {
    private LinkedList<Dag> dags = new LinkedList();
    private int index = -1;
    private DepthChoiceGenerator generator1;
    private CombinationGenerator generator2;
    private List<Edge> edges;
    private List<Node> nodes;
    private Dag storedDag;
    private ArrayList<Edge> undirectedEdges;
    private int minEdges;
    private int maxEdges;

    public DagIterator3(List<Node> nodes, int minEdges, int maxEdges) {
        if (nodes == null) {
            throw new IllegalArgumentException("No nodes provided.");
        }
        if (minEdges < 0) {
            throw new IllegalArgumentException("Min edges should >= 0");
        }
        if (maxEdges < -1) {
            throw new IllegalArgumentException("Min edges should >= 0 or -1 (unbounded)");
        }
        int n = nodes.size();
        int realMaxEdges = n * (n - 1) / 2;
        if (maxEdges < -1 || maxEdges > realMaxEdges) {
            throw new IllegalArgumentException("Max edges should be in [-1, " + realMaxEdges + "]: " + maxEdges);
        }
        this.nodes = new ArrayList<Node>(nodes);
        this.minEdges = minEdges;
        this.maxEdges = maxEdges;
        EdgeListGraph graph = new EdgeListGraph(nodes);
        graph.fullyConnect(Endpoint.TAIL);
        this.edges = graph.getEdges();
        this.generator1 = new DepthChoiceGenerator(this.edges.size(), maxEdges);
        this.nextEdgeCombination();
    }

    public Dag next() {
        Dag dag;
        if (this.storedDag != null) {
            Dag temp = this.storedDag;
            this.storedDag = null;
            return temp;
        }
        if (this.generator2 != null && (dag = this.nextDag()) != null) {
            return dag;
        }
        if (this.generator1 != null) {
            this.nextEdgeCombination();
            if (this.generator2 != null && (dag = this.nextDag()) != null) {
                return dag;
            }
        }
        return null;
    }

    public boolean hasNext() {
        if (this.generator1 == null) {
            return false;
        }
        if (this.storedDag == null) {
            this.storedDag = this.next();
        }
        return this.storedDag != null;
    }

    private void nextEdgeCombination() {
        int[] choice;
        if (this.generator1 == null) {
            throw new IllegalArgumentException();
        }
        while ((choice = this.generator1.next()) != null && choice.length < this.minEdges) {
        }
        if (choice == null || this.maxEdges != -1 && choice.length > this.maxEdges) {
            this.generator1 = null;
            return;
        }
        this.undirectedEdges = new ArrayList();
        for (int i = 0; i < choice.length; ++i) {
            this.undirectedEdges.add(this.edges.get(choice[i]));
        }
        int[] dims = new int[this.undirectedEdges.size()];
        for (int i = 0; i < this.undirectedEdges.size(); ++i) {
            dims[i] = 2;
        }
        this.generator2 = new CombinationGenerator(dims);
    }

    private Dag nextDag() {
        int[] combination;
        if (this.generator2 == null) {
            throw new IllegalArgumentException();
        }
        while ((combination = this.generator2.next()) != null) {
            EdgeListGraph graph = new EdgeListGraph(this.nodes);
            for (int k = 0; k < combination.length; ++k) {
                Edge edge = this.undirectedEdges.get(k);
                graph.removeEdge(edge.getNode1(), edge.getNode2());
                if (combination[k] == 0) {
                    graph.addDirectedEdge(edge.getNode1(), edge.getNode2());
                    continue;
                }
                graph.addDirectedEdge(edge.getNode2(), edge.getNode1());
            }
            if (graph.existsDirectedCycle()) continue;
            return new Dag(graph);
        }
        this.generator2 = null;
        return null;
    }
}

