/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SepsetMapDci;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FasDci2 {
    private Graph graph;
    private Set<String> variables;
    private List<Set<String>> marginalVars;
    private List<IndependenceTest> independenceTests;
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private String method;
    private SepsetMapDci knownIndependencies;
    private SepsetMapDci knownAssociations;
    private TetradLogger logger = TetradLogger.getInstance();

    public FasDci2(Graph graph, List<IndependenceTest> independenceTests, String method, Set<String> variables, List<Set<String>> marginalVars, SepsetMapDci knownIndependencies, SepsetMapDci knownAssociations) {
        this.graph = graph;
        this.independenceTests = independenceTests;
        this.variables = variables;
        this.marginalVars = marginalVars;
        this.method = method;
        this.independenceTests = independenceTests;
        this.knownIndependencies = knownIndependencies;
        this.knownAssociations = knownAssociations;
    }

    public SepsetMapDci search() {
        boolean more;
        this.logger.log("info", "Starting Fast Adjacency Search (DCI).");
        List<Edge> edges = this.graph.getEdges();
        for (Edge _edge : edges) {
            String name2;
            String name1 = _edge.getNode1().getName();
            if (!this.knowledge.edgeForbidden(name1, name2 = _edge.getNode2().getName()) || !this.knowledge.edgeForbidden(name2, name1)) continue;
            this.graph.removeEdge(_edge);
            this.logger.log("edgeRemoved", "Removed " + _edge + " because it was " + "forbidden by background knowledge.");
        }
        SepsetMapDci sepset = new SepsetMapDci();
        int _depth = this.depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        for (int d = 0; d <= _depth && (more = this.searchAtDepth(sepset, d)); ++d) {
        }
        this.logger.log("info", "Finishing Fast Adjacency Search.");
        return sepset;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException("Cannot set knowledge to null");
        }
        this.knowledge = knowledge;
    }

    private List<Node> possibleParents(Node x, List<Node> adjx, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z = z.getName();
            if (!this.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        return !knowledge.edgeForbidden(z, x) && !knowledge.edgeRequired(x, z);
    }

    private boolean searchAtDepth(SepsetMapDci sepset, int depth) {
        boolean more = false;
        for (String var : this.variables) {
            Node x = this.graph.getNode(var);
            LinkedList<Node> b = new LinkedList<Node>();
            for (Node node : this.graph.getAdjacentNodes(x)) {
                if (!this.variables.contains(node.getName())) continue;
                b.add(node);
            }
            block2: for (Node y : b) {
                int[] choice;
                ArrayList<Node> adjx = new ArrayList<Node>(b);
                adjx.remove(y);
                List<Node> ppx = this.possibleParents(x, adjx, this.knowledge);
                boolean noEdgeRequired = this.knowledge.noEdgeRequired(x.getName(), y.getName());
                if (ppx.size() < depth) continue;
                ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), depth);
                while ((choice = cg.next()) != null) {
                    List<Node> condSet = SearchGraphUtils.asList(choice, ppx);
                    boolean independent = false;
                    boolean known = false;
                    if (this.knownIndependencies != null && this.knownIndependencies.get(x, y) != null) {
                        for (List<Node> set : this.knownIndependencies.getSet(x, y)) {
                            if (!set.containsAll(condSet) || set.size() != condSet.size()) continue;
                            independent = true;
                            known = true;
                            break;
                        }
                    }
                    if (this.knownAssociations != null && this.knownAssociations.get(x, y) != null) {
                        for (List<Node> set : this.knownAssociations.getSet(x, y)) {
                            if (!set.containsAll(condSet) || set.size() != condSet.size()) continue;
                            independent = false;
                            known = true;
                            break;
                        }
                    }
                    if (!known) {
                        double alpha = this.independenceTests.get(0).getAlpha();
                        double tf = 0.0;
                        int k = 0;
                        for (int i = 0; i < this.independenceTests.size(); ++i) {
                            boolean usetest = true;
                            ArrayList<Node> localCondSet = new ArrayList<Node>();
                            IndependenceTest test = this.independenceTests.get(i);
                            Set<String> marginal = this.marginalVars.get(i);
                            for (Node node : condSet) {
                                if (!marginal.contains(node.getName())) {
                                    usetest = false;
                                    break;
                                }
                                localCondSet.add(test.getVariable(node.getName()));
                            }
                            if (!usetest || !marginal.contains(x.getName()) || !marginal.contains(y.getName())) continue;
                            test.isIndependent(test.getVariable(x.getName()), test.getVariable(y.getName()), localCondSet);
                            tf += -2.0 * Math.log(test.getPValue());
                            ++k;
                        }
                        double p = 1.0 - ProbUtils.chisqCdf(tf, 2 * k);
                        independent = p > alpha;
                    }
                    if (!independent || !noEdgeRequired) continue;
                    this.graph.removeEdge(x, y);
                    sepset.set(x, y, new LinkedList<Node>(condSet));
                    continue block2;
                }
            }
            ArrayList<Node> currentAdjNodes = new ArrayList<Node>();
            for (Node node : this.graph.getAdjacentNodes(x)) {
                if (!this.variables.contains(node.getName())) continue;
                currentAdjNodes.add(node);
            }
            if (currentAdjNodes.size() - 1 <= depth) continue;
            more = true;
        }
        return more;
    }
}

