/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.LinkedList;
import java.util.List;

public class FasPcStar {
    private Graph graph;
    private IndependenceTest test;
    private Knowledge knowledge;
    private int depth = Integer.MAX_VALUE;
    private int numIndependenceTests;
    private TetradLogger logger = TetradLogger.getInstance();
    private Graph trueGraph;

    public FasPcStar(Graph graph, IndependenceTest test) {
        this.graph = graph;
        this.test = test;
    }

    public SepsetMap search() {
        this.logger.log("info", "Starting Fast Adjacency Search.");
        List<Edge> edges = this.graph.getEdges();
        for (Edge _edge : edges) {
            String name2;
            String name1 = _edge.getNode1().getName();
            if (!this.knowledge.edgeForbidden(name1, name2 = _edge.getNode2().getName()) || !this.knowledge.edgeForbidden(name2, name1)) continue;
            this.graph.removeEdge(_edge);
            this.logger.log("edgeRemoved", "Removed " + _edge + " because it was " + "forbidden by background knowledge.");
        }
        SepsetMap sepset = new SepsetMap();
        int _depth = this.depth;
        if (_depth == -1) {
            _depth = Integer.MAX_VALUE;
        }
        for (int d = 0; d <= _depth && this.searchAtDepth(this.graph, this.test, new Knowledge(), sepset, d); ++d) {
        }
        this.logger.log("info", "Finishing Fast Adjacency Search.");
        return sepset;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException("Cannot set knowledge to null");
        }
        this.knowledge = knowledge;
    }

    private static List<Node> possibleParents(Node x, List<Node> adjx, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z = z.getName();
            if (!FasPcStar.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private static boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        return !knowledge.edgeForbidden(z, x) && !knowledge.edgeRequired(x, z);
    }

    private boolean searchAtDepth(Graph graph, IndependenceTest test, Knowledge knowledge, SepsetMap sepset, int depth) {
        boolean more = false;
        LinkedList<Node> nodes = new LinkedList<Node>(graph.getNodes());
        for (Node x : nodes) {
            LinkedList<Node> b = new LinkedList<Node>(graph.getAdjacentNodes(x));
            block1: for (Node y : b) {
                int[] choice;
                List<Node> adjx = graph.getAdjacentNodes(x);
                adjx.remove(y);
                List<Node> ppx = FasPcStar.possibleParents(x, adjx, knowledge);
                boolean noEdgeRequired = knowledge.noEdgeRequired(x.getName(), y.getName());
                if (ppx.size() < depth) continue;
                ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), depth);
                block2: while ((choice = cg.next()) != null) {
                    List<Node> condSet = SearchGraphUtils.asList(choice, ppx);
                    for (Node node : condSet) {
                        List<List<Node>> paths = GraphUtils.allPathsFromTo(graph, x, y);
                        boolean onPath = false;
                        for (List<Node> path : paths) {
                            if (!path.contains(node)) continue;
                            onPath = true;
                            break;
                        }
                        if (onPath) continue;
                        continue block2;
                    }
                    boolean independent = test.isIndependent(x, y, condSet);
                    ++this.numIndependenceTests;
                    if (this.trueGraph != null) {
                        IndTestDSep dsep = new IndTestDSep(this.trueGraph);
                        Node _x = this.trueGraph.getNode(x.getName());
                        Node _y = this.trueGraph.getNode(y.getName());
                        LinkedList<Node> _condSet = new LinkedList<Node>();
                        for (Node node : condSet) {
                            _condSet.add(this.trueGraph.getNode(node.getName()));
                        }
                        if (dsep.isDSeparated(_x, _y, _condSet)) {
                            System.out.println("1\t" + test.getPValue() + "\t\"" + new IndependenceFact(x, y, condSet) + "\"");
                        } else {
                            System.out.println("0\t" + test.getPValue() + "\t\"" + new IndependenceFact(x, y, condSet) + "\"");
                        }
                    }
                    if (!independent || !noEdgeRequired) continue;
                    graph.removeEdge(x, y);
                    sepset.set(x, y, new LinkedList<Node>(condSet));
                    continue block1;
                }
            }
            if (graph.getAdjacentNodes(x).size() - 1 <= depth) continue;
            more = true;
        }
        return more;
    }

    public int getNumIndependenceTests() {
        return this.numIndependenceTests;
    }

    public void setTrueGraph(Graph trueGraph) {
        this.trueGraph = trueGraph;
    }
}

