/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.LegalPairs;
import java.util.List;
import java.util.Set;

class FciDsepLegalPairs2
implements LegalPairs {
    private Graph graph;
    private Set<Triple> ambiguousTriples;

    public FciDsepLegalPairs2(Graph graph, Set<Triple> unfaithfulTriples) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.graph = graph;
        this.ambiguousTriples = unfaithfulTriples;
    }

    @Override
    public boolean isLegalFirstEdge(Node x, Node y) {
        return this.graph.isAdjacentTo(x, y);
    }

    @Override
    public boolean isLegalPair(Node x, Node y, Node z, List<Node> c, List<Node> d) {
        if (!this.graph.isAdjacentTo(x, y) || !this.graph.isAdjacentTo(y, z)) {
            throw new IllegalArgumentException();
        }
        if (this.graph.isDefCollider(x, y, z)) {
            return true;
        }
        if (this.ambiguousTriples.contains(new Triple(x, y, z))) {
            return true;
        }
        return this.graph.isAdjacentTo(x, z);
    }
}

