/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.GraphScorer;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.LocalDiscreteScore;
import edu.cmu.tetrad.search.LocalScoreCache;
import edu.cmu.tetrad.search.MdluScore;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.ScoredGraph;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Ges
implements GraphSearch,
GraphScorer {
    private DataSet dataSet;
    private DoubleMatrix2D variances;
    private int sampleSize;
    private Knowledge knowledge = new Knowledge();
    private double structurePrior;
    private double samplePrior;
    private HashMap<Node, Integer> hashIndices;
    private String[] varNames;
    private List<Node> variables;
    private boolean discrete;
    private Graph trueGraph;
    private final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private final Algebra algebra = new Algebra();
    private final LocalScoreCache localScoreCache = new LocalScoreCache();
    private long elapsedTime;
    private boolean aggressivelyPreventCycles = false;
    private transient List<PropertyChangeListener> listeners;
    private double penaltyDiscount = 1.0;
    private int maxNumEdges = -1;
    private LocalDiscreteScore discreteScore;
    private TetradLogger logger = TetradLogger.getInstance();
    private SortedSet<ScoredGraph> topGraphs = new TreeSet<ScoredGraph>();
    private int numPatternsToStore = 10;

    public Ges(DataSet dataSet) {
        this.setDataSet(dataSet);
        if (dataSet != null) {
            this.discreteScore = new MdluScore(dataSet, 0.001);
        }
        this.initialize(10.0, 0.001);
    }

    public Ges(CovarianceMatrix covMatrix) {
        this.setCorrMatrix(new CorrelationMatrix(covMatrix));
        if (this.dataSet != null) {
            this.discreteScore = new MdluScore(this.dataSet, 0.001);
        }
        this.initialize(10.0, 0.001);
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    @Override
    public Graph search() {
        long startTime = System.currentTimeMillis();
        if (this.variances != null && DataUtils.containsMissingValue(this.variances)) {
            throw new IllegalArgumentException("Please remove or impute missing values first.");
        }
        if (this.dataSet != null && DataUtils.containsMissingValue(this.dataSet)) {
            throw new IllegalArgumentException("Please remove or impute missing values first.");
        }
        EdgeListGraph graph = new EdgeListGraph(new LinkedList<Node>(this.getVariables()));
        this.fireGraphChange(graph);
        this.buildIndexing(graph);
        this.addRequiredEdges(graph);
        double score = this.scoreGraph(graph);
        this.storeGraph(graph, score);
        score = this.fes(graph, score);
        this.bes(graph, score);
        long endTime = System.currentTimeMillis();
        this.elapsedTime = endTime - startTime;
        this.logger.log("graph", "\nReturning this graph: " + graph);
        this.logger.log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        this.logger.flush();
        return graph;
    }

    public Graph search(List<Node> nodes) {
        long startTime = System.currentTimeMillis();
        this.localScoreCache.clear();
        if (!this.dataSet().getVariables().containsAll(nodes)) {
            throw new IllegalArgumentException("All of the nodes must be in the supplied data set.");
        }
        EdgeListGraph graph = new EdgeListGraph(nodes);
        this.buildIndexing(graph);
        this.addRequiredEdges(graph);
        double score = this.scoreGraph(graph);
        score = this.fes(graph, score);
        this.bes(graph, score);
        long endTime = System.currentTimeMillis();
        this.elapsedTime = endTime - startTime;
        this.logger.log("graph", "\nReturning this graph: " + graph);
        this.logger.log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        this.logger.flush();
        return graph;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException("Knowledge must not be null.");
        }
        this.knowledge = knowledge;
    }

    public void setStructurePrior(double structurePrior) {
        if (this.getDiscreteScore() != null) {
            this.getDiscreteScore().setStructurePrior(structurePrior);
        }
        this.structurePrior = structurePrior;
    }

    public void setSamplePrior(double samplePrior) {
        if (this.getDiscreteScore() != null) {
            this.getDiscreteScore().setSamplePrior(samplePrior);
        }
        this.samplePrior = samplePrior;
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getListeners().add(l);
    }

    public double getPenaltyDiscount() {
        return this.penaltyDiscount;
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        if (penaltyDiscount < 0.0) {
            throw new IllegalArgumentException("Penalty discount must be >= 0: " + penaltyDiscount);
        }
        this.penaltyDiscount = penaltyDiscount;
    }

    public int getMaxNumEdges() {
        return this.maxNumEdges;
    }

    public void setMaxNumEdges(int maxNumEdges) {
        if (maxNumEdges < -1) {
            throw new IllegalArgumentException();
        }
        this.maxNumEdges = maxNumEdges;
    }

    public void setTrueGraph(Graph trueGraph) {
        this.trueGraph = trueGraph;
    }

    public double getScore(Graph dag) {
        return this.scoreGraph(dag);
    }

    public SortedSet<ScoredGraph> getTopGraphs() {
        return this.topGraphs;
    }

    public int getNumPatternsToStore() {
        return this.numPatternsToStore;
    }

    public void setNumPatternsToStore(int numPatternsToStore) {
        if (numPatternsToStore < 1) {
            throw new IllegalArgumentException("Must store at least one pattern: " + numPatternsToStore);
        }
        this.numPatternsToStore = numPatternsToStore;
    }

    private void initialize(double samplePrior, double structurePrior) {
        this.setStructurePrior(structurePrior);
        this.setSamplePrior(samplePrior);
    }

    private double fes(Graph graph, double score) {
        Node x;
        TetradLogger.getInstance().log("info", "** FORWARD EQUIVALENCE SEARCH");
        double bestScore = score;
        TetradLogger.getInstance().log("info", "Initial Score = " + this.nf.format(bestScore));
        Set<Node> t = new HashSet<Node>();
        do {
            Node y = null;
            x = null;
            List<Node> nodes = graph.getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                Node _x = nodes.get(i);
                for (Node _y : nodes) {
                    if (_x == _y || graph.isAdjacentTo(_x, _y) || this.getKnowledge().edgeForbidden(_x.getName(), _y.getName())) continue;
                    List<Node> tNeighbors = Ges.getTNeighbors(_x, _y, graph);
                    List<Set<Node>> tSubsets = Ges.powerSet(tNeighbors);
                    for (Set<Node> tSubset : tSubsets) {
                        if (!this.validSetByKnowledge(_x, _y, tSubset, true)) continue;
                        double insertEval = this.insertEval(_x, _y, tSubset, graph);
                        double evalScore = score + insertEval;
                        TetradLogger.getInstance().log("edgeEvaluations", "Trying to add " + _x + "-->" + _y + " evalScore = " + evalScore);
                        if (!(evalScore > bestScore) || !(evalScore > score) || !this.validInsert(_x, _y, tSubset, graph)) continue;
                        this.storeGraphInsert(graph, _x, _y, tSubset, evalScore);
                        bestScore = evalScore;
                        x = _x;
                        y = _y;
                        t = tSubset;
                    }
                }
            }
            if (x == null) continue;
            score = bestScore;
            this.insert(x, y, t, graph, score, true);
            this.rebuildPattern(graph);
            if (this.getMaxNumEdges() != -1 && graph.getNumEdges() > this.getMaxNumEdges()) break;
        } while (x != null);
        return score;
    }

    private double bes(Graph graph, double initialScore) {
        Node x;
        double score;
        TetradLogger.getInstance().log("info", "** BACKWARD ELIMINATION SEARCH");
        TetradLogger.getInstance().log("info", "Initial Score = " + this.nf.format(initialScore));
        double bestScore = score = initialScore;
        Set<Node> t = new HashSet<Node>();
        do {
            Node y = null;
            x = null;
            List<Edge> graphEdges = graph.getEdges();
            for (Edge edge : graphEdges) {
                Node _y;
                Node _x;
                if (Edges.isUndirectedEdge(edge)) {
                    _x = edge.getNode1();
                    _y = edge.getNode2();
                } else {
                    _x = Edges.getDirectedEdgeTail(edge);
                    _y = Edges.getDirectedEdgeHead(edge);
                }
                if (!this.getKnowledge().noEdgeRequired(_x.getName(), _y.getName())) continue;
                List<Node> hNeighbors = Ges.getHNeighbors(_x, _y, graph);
                List<Set<Node>> hSubsets = Ges.powerSet(hNeighbors);
                for (Set<Node> hSubset : hSubsets) {
                    if (!this.validSetByKnowledge(_x, _y, hSubset, false)) continue;
                    double deleteEval = this.deleteEval(_x, _y, hSubset, graph);
                    double evalScore = score + deleteEval;
                    TetradLogger.getInstance().log("edgeEvaluations", "Attempt removing " + _x + "-->" + _y + "(" + evalScore + ")");
                    if (!(evalScore > bestScore) || !Ges.validDelete(_x, _y, hSubset, graph)) continue;
                    this.storeGraphDelete(graph, _x, _y, hSubset, evalScore);
                    bestScore = evalScore;
                    x = _x;
                    y = _y;
                    t = hSubset;
                }
            }
            if (x == null) continue;
            if (!graph.isAdjacentTo(x, y)) {
                throw new IllegalArgumentException("trying to delete a nonexistent edge! " + x + "---" + y);
            }
            score = bestScore;
            this.delete(x, y, t, graph, score, true);
            this.rebuildPattern(graph);
        } while (x != null);
        return score;
    }

    private static List<Node> getTNeighbors(Node x, Node y, Graph graph) {
        LinkedList<Node> tNeighbors = new LinkedList<Node>(graph.getAdjacentNodes(y));
        tNeighbors.removeAll(graph.getAdjacentNodes(x));
        for (int i = tNeighbors.size() - 1; i >= 0; --i) {
            Node z = (Node)tNeighbors.get(i);
            Edge edge = graph.getEdge(y, z);
            if (Edges.isUndirectedEdge(edge)) continue;
            tNeighbors.remove(z);
        }
        return tNeighbors;
    }

    private static List<Node> getHNeighbors(Node x, Node y, Graph graph) {
        LinkedList<Node> hNeighbors = new LinkedList<Node>(graph.getAdjacentNodes(y));
        hNeighbors.retainAll(graph.getAdjacentNodes(x));
        for (int i = hNeighbors.size() - 1; i >= 0; --i) {
            Node z = (Node)hNeighbors.get(i);
            Edge edge = graph.getEdge(y, z);
            if (Edges.isUndirectedEdge(edge)) continue;
            hNeighbors.remove(z);
        }
        return hNeighbors;
    }

    private double insertEval(Node x, Node y, Set<Node> t, Graph graph) {
        HashSet<Node> set2 = new HashSet<Node>(Ges.findNaYX(x, y, graph));
        set2.addAll(t);
        set2.addAll(graph.getParents(y));
        HashSet<Node> set1 = new HashSet<Node>(set2);
        set1.add(x);
        return this.scoreGraphChange(y, set1, set2);
    }

    private double deleteEval(Node x, Node y, Set<Node> h, Graph graph) {
        HashSet<Node> set2 = new HashSet<Node>(Ges.findNaYX(x, y, graph));
        set2.removeAll(h);
        set2.addAll(graph.getParents(y));
        HashSet<Node> set1 = new HashSet<Node>(set2);
        set1.remove(x);
        return this.scoreGraphChange(y, set1, set2);
    }

    private void insert(Node x, Node y, Set<Node> subset, Graph graph, double score, boolean log) {
        Edge trueEdge = null;
        if (this.trueGraph != null) {
            Node _x = this.trueGraph.getNode(x.getName());
            Node _y = this.trueGraph.getNode(y.getName());
            trueEdge = this.trueGraph.getEdge(_x, _y);
        }
        graph.addDirectedEdge(x, y);
        if (log) {
            String label = this.trueGraph != null && trueEdge != null ? "*" : "";
            TetradLogger.getInstance().log("insertedEdges", graph.getNumEdges() + ". INSERT " + graph.getEdge(x, y) + " " + subset + " (" + this.nf.format(score) + ") " + label);
        }
        for (Node t : subset) {
            Edge oldEdge = graph.getEdge(t, y);
            if (!Edges.isUndirectedEdge(oldEdge)) {
                throw new IllegalArgumentException("Should be undirected: " + oldEdge);
            }
            graph.removeEdge(t, y);
            graph.addDirectedEdge(t, y);
            if (!log) continue;
            TetradLogger.getInstance().log("directedEdges", "--- Directing " + oldEdge + " to " + graph.getEdge(t, y));
        }
    }

    private void delete(Node x, Node y, Set<Node> subset, Graph graph, double score, boolean log) {
        if (log) {
            Edge oldEdge = graph.getEdge(x, y);
            TetradLogger.getInstance().log("deletedEdges", graph.getNumEdges() + ". DELETE " + oldEdge + " " + subset + " (" + this.nf.format(score) + ")");
        }
        graph.removeEdge(x, y);
        for (Node h : subset) {
            Edge oldEdge;
            if (Edges.isUndirectedEdge(graph.getEdge(x, h))) {
                graph.removeEdge(x, h);
                graph.addDirectedEdge(x, h);
                if (log) {
                    oldEdge = graph.getEdge(x, h);
                    TetradLogger.getInstance().log("directedEdges", "--- Directing " + oldEdge + " to " + graph.getEdge(x, h));
                }
            }
            if (!Edges.isUndirectedEdge(graph.getEdge(y, h))) continue;
            graph.removeEdge(y, h);
            graph.addDirectedEdge(y, h);
            if (!log) continue;
            oldEdge = graph.getEdge(y, h);
            TetradLogger.getInstance().log("directedEdges", "--- Directing " + oldEdge + " to " + graph.getEdge(y, h));
        }
    }

    private boolean validInsert(Node x, Node y, Set<Node> subset, Graph graph) {
        LinkedList<Node> naYXT = new LinkedList<Node>(subset);
        naYXT.addAll(Ges.findNaYX(x, y, graph));
        if (!Ges.isClique(naYXT, graph)) {
            return false;
        }
        return this.isSemiDirectedBlocked(x, y, naYXT, graph, new HashSet<Node>());
    }

    private static boolean validDelete(Node x, Node y, Set<Node> h, Graph graph) {
        List<Node> naYXH = Ges.findNaYX(x, y, graph);
        naYXH.removeAll(h);
        return Ges.isClique(naYXH, graph);
    }

    private void addRequiredEdges(Graph graph) {
        Node nextNode;
        Iterator<Node> itn;
        Node nodeB;
        Node nodeA;
        String b;
        String a;
        KnowledgeEdge next;
        Iterator<KnowledgeEdge> it = this.getKnowledge().requiredEdgesIterator();
        while (it.hasNext()) {
            next = it.next();
            a = next.getFrom();
            b = next.getTo();
            nodeA = null;
            nodeB = null;
            itn = graph.getNodes().iterator();
            while (itn.hasNext() && (nodeA == null || nodeB == null)) {
                nextNode = itn.next();
                if (nextNode.getName().equals(a)) {
                    nodeA = nextNode;
                }
                if (!nextNode.getName().equals(b)) continue;
                nodeB = nextNode;
            }
            if (graph.isAncestorOf(nodeB, nodeA)) continue;
            graph.removeEdge(nodeA, nodeB);
            graph.addDirectedEdge(nodeA, nodeB);
            TetradLogger.getInstance().log("insertedEdges", "Adding edge by knowledge: " + graph.getEdge(nodeA, nodeB));
        }
        it = this.getKnowledge().forbiddenEdgesIterator();
        while (it.hasNext()) {
            next = it.next();
            a = next.getFrom();
            b = next.getTo();
            nodeA = null;
            nodeB = null;
            itn = graph.getNodes().iterator();
            while (itn.hasNext() && (nodeA == null || nodeB == null)) {
                nextNode = itn.next();
                if (nextNode.getName().equals(a)) {
                    nodeA = nextNode;
                }
                if (!nextNode.getName().equals(b)) continue;
                nodeB = nextNode;
            }
            if (nodeA == null || nodeB == null || !graph.isAdjacentTo(nodeA, nodeB) || graph.isChildOf(nodeA, nodeB) || graph.isAncestorOf(nodeA, nodeB)) continue;
            graph.removeEdges(nodeA, nodeB);
            graph.addDirectedEdge(nodeB, nodeA);
            TetradLogger.getInstance().log("insertedEdges", "Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
        }
    }

    private boolean validSetByKnowledge(Node x, Node y, Set<Node> subset, boolean insertMode) {
        if (insertMode) {
            for (Node aSubset : subset) {
                if (!this.getKnowledge().edgeForbidden(aSubset.getName(), y.getName())) continue;
                return false;
            }
        } else {
            for (Node nextElement : subset) {
                if (this.getKnowledge().edgeForbidden(x.getName(), nextElement.getName())) {
                    return false;
                }
                if (!this.getKnowledge().edgeForbidden(y.getName(), nextElement.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private static List<Node> findNaYX(Node x, Node y, Graph graph) {
        LinkedList<Node> naYX = new LinkedList<Node>(graph.getAdjacentNodes(y));
        naYX.retainAll(graph.getAdjacentNodes(x));
        for (int i = 0; i < naYX.size(); ++i) {
            Node z = (Node)naYX.get(i);
            Edge edge = graph.getEdge(y, z);
            if (Edges.isUndirectedEdge(edge)) continue;
            naYX.remove(z);
        }
        return naYX;
    }

    private static boolean isClique(List<Node> set, Graph graph) {
        LinkedList<Node> setv = new LinkedList<Node>(set);
        for (int i = 0; i < setv.size() - 1; ++i) {
            for (int j = i + 1; j < setv.size(); ++j) {
                if (graph.isAdjacentTo((Node)setv.get(i), (Node)setv.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSemiDirectedBlocked(Node x, Node y, List<Node> naYXT, Graph graph, Set<Node> marked) {
        if (naYXT.contains(y)) {
            return true;
        }
        if (y == x) {
            return false;
        }
        for (Node node1 : graph.getNodes()) {
            if (node1 == y || marked.contains(node1) || !graph.isAdjacentTo(y, node1) || graph.isParentOf(node1, y)) continue;
            marked.add(node1);
            if (!this.isSemiDirectedBlocked(x, node1, naYXT, graph, marked)) {
                return false;
            }
            marked.remove(node1);
        }
        return true;
    }

    private static List<Set<Node>> powerSet(List<Node> nodes) {
        ArrayList<Set<Node>> subsets = new ArrayList<Set<Node>>();
        int total = (int)Math.pow(2.0, nodes.size());
        for (int i = 0; i < total; ++i) {
            HashSet<Node> newSet = new HashSet<Node>();
            String selection = Integer.toBinaryString(i);
            for (int j = selection.length() - 1; j >= 0; --j) {
                if (selection.charAt(j) != '1') continue;
                newSet.add(nodes.get(selection.length() - j - 1));
            }
            subsets.add(newSet);
        }
        return subsets;
    }

    private void rebuildPattern(Graph graph) {
        SearchGraphUtils.basicPattern(graph);
        this.addRequiredEdges(graph);
        this.pdagWithBk(graph, this.getKnowledge());
        TetradLogger.getInstance().log("rebuiltPatterns", "Rebuilt pattern = " + graph);
    }

    private void pdagWithBk(Graph graph, Knowledge knowledge) {
        MeekRules rules = new MeekRules();
        rules.setAggressivelyPreventCycles(this.aggressivelyPreventCycles);
        rules.setKnowledge(knowledge);
        rules.orientImplied(graph);
    }

    private void setDataSet(DataSet dataSet) {
        List<String> _varNames = dataSet.getVariableNames();
        this.varNames = _varNames.toArray(new String[0]);
        this.variables = dataSet.getVariables();
        this.dataSet = dataSet;
        this.discrete = dataSet.isDiscrete();
        if (!this.isDiscrete()) {
            this.variances = dataSet.getCovarianceMatrix();
        }
        this.sampleSize = dataSet.getNumRows();
    }

    private void setCorrMatrix(CovarianceMatrix covarianceMatrix) {
        this.variances = covarianceMatrix.getMatrix();
        List<String> _varNames = covarianceMatrix.getVariableNames();
        this.varNames = _varNames.toArray(new String[0]);
        this.variables = covarianceMatrix.getVariables();
        this.sampleSize = covarianceMatrix.getSampleSize();
    }

    private void buildIndexing(Graph graph) {
        this.hashIndices = new HashMap();
        block0: for (Node next : graph.getNodes()) {
            for (int i = 0; i < this.varNames.length; ++i) {
                if (!this.varNames[i].equals(next.getName())) continue;
                this.hashIndices.put(next, i);
                continue block0;
            }
        }
    }

    private static int getRowIndex(int[] dim, int[] values) {
        int rowIndex = 0;
        for (int i = 0; i < dim.length; ++i) {
            rowIndex *= dim[i];
            rowIndex += values[i];
        }
        return rowIndex;
    }

    @Override
    public double scoreGraph(Graph graph) {
        Graph dag = SearchGraphUtils.dagFromPattern(graph);
        double score = 0.0;
        for (Node next : dag.getNodes()) {
            List<Node> parents = dag.getParents(next);
            int nextIndex = -1;
            for (int i = 0; i < this.getVariables().size(); ++i) {
                if (!this.varNames[i].equals(next.getName())) continue;
                nextIndex = i;
                break;
            }
            int[] parentIndices = new int[parents.size()];
            Iterator pi = parents.iterator();
            int count = 0;
            block2: while (pi.hasNext()) {
                Node nextParent = (Node)pi.next();
                for (int i = 0; i < this.getVariables().size(); ++i) {
                    if (!this.varNames[i].equals(nextParent.getName())) continue;
                    parentIndices[count++] = i;
                    continue block2;
                }
            }
            if (this.isDiscrete()) {
                score += this.localDiscreteScore(nextIndex, parentIndices);
                continue;
            }
            score += this.localSemScore(nextIndex, parentIndices);
        }
        return score;
    }

    private double scoreGraphChange(Node y, Set<Node> parents1, Set<Node> parents2) {
        int yIndex = this.hashIndices.get(y);
        int[] parentIndices1 = new int[parents1.size()];
        int count = 0;
        for (Node aParents1 : parents1) {
            parentIndices1[count++] = this.hashIndices.get(aParents1);
        }
        int[] parentIndices2 = new int[parents2.size()];
        int count2 = 0;
        for (Node aParents2 : parents2) {
            parentIndices2[count2++] = this.hashIndices.get(aParents2);
        }
        if (this.isDiscrete()) {
            double score1 = this.localDiscreteScore(yIndex, parentIndices1);
            double score2 = this.localDiscreteScore(yIndex, parentIndices2);
            return score1 - score2;
        }
        double score1 = this.localSemScore(yIndex, parentIndices1);
        double score2 = this.localSemScore(yIndex, parentIndices2);
        return score1 - score2;
    }

    private double localDiscreteScore(int i, int[] parents) {
        return this.getDiscreteScore().localScore(i, parents);
    }

    private int numCategories(int i) {
        return ((DiscreteVariable)this.dataSet().getVariable(i)).getNumCategories();
    }

    private double localSemScore(int i, int[] parents) {
        double variance = this.getCovMatrix().get(i, i);
        int n = this.sampleSize();
        double k = parents.length + 1;
        if (parents.length > 0) {
            DoubleMatrix2D inverse;
            DoubleMatrix2D Czz = this.getCovMatrix().viewSelection(parents, parents);
            try {
                inverse = this.algebra().inverse(Czz);
            }
            catch (Exception e) {
                StringBuilder buf = new StringBuilder();
                buf.append("Could not invert matrix for variables: ");
                for (int j = 0; j < parents.length; ++j) {
                    buf.append(this.variables.get(parents[j]));
                    if (j >= parents.length - 1) continue;
                    buf.append(", ");
                }
                throw new IllegalArgumentException(buf.toString());
            }
            DoubleMatrix1D Cyz = this.getCovMatrix().viewColumn(i);
            Cyz = Cyz.viewSelection(parents);
            DoubleMatrix1D b = this.algebra().mult(inverse, Cyz);
            variance -= this.algebra().mult(Cyz, b);
        }
        double penalty = this.getPenaltyDiscount();
        return (double)(-n) * Math.log(variance) - penalty * k * Math.log(n);
    }

    private int sampleSize() {
        return this.sampleSize;
    }

    private List<Node> getVariables() {
        return this.variables;
    }

    private DoubleMatrix2D getCovMatrix() {
        return this.variances;
    }

    private Algebra algebra() {
        return this.algebra;
    }

    private DataSet dataSet() {
        return this.dataSet;
    }

    private double getStructurePrior() {
        return this.structurePrior;
    }

    private double getSamplePrior() {
        return this.samplePrior;
    }

    private boolean isDiscrete() {
        return this.discrete;
    }

    private void fireGraphChange(Graph graph) {
        for (PropertyChangeListener l : this.getListeners()) {
            l.propertyChange(new PropertyChangeEvent(this, "graph", null, graph));
        }
    }

    private List<PropertyChangeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        return this.listeners;
    }

    private void storeGraph(Graph graph, double score) {
        if (this.topGraphs.isEmpty() || score > this.topGraphs.first().getScore()) {
            EdgeListGraph graphCopy = new EdgeListGraph(graph);
            this.topGraphs.add(new ScoredGraph(graphCopy, score));
            if (this.topGraphs.size() > this.getNumPatternsToStore()) {
                this.topGraphs.remove(this.topGraphs.first());
            }
        }
    }

    private void storeGraphInsert(Graph graph, Node x, Node y, Set t, double score) {
        if (this.topGraphs.isEmpty() || score > this.topGraphs.first().getScore()) {
            EdgeListGraph graphCopy = new EdgeListGraph(graph);
            this.insert(x, y, t, graphCopy, score, false);
            this.rebuildPattern(graphCopy);
            this.topGraphs.add(new ScoredGraph(graphCopy, score));
            if (this.topGraphs.size() > this.getNumPatternsToStore()) {
                this.topGraphs.remove(this.topGraphs.first());
            }
        }
    }

    private void storeGraphDelete(Graph graph, Node x, Node y, Set t, double score) {
        if (this.topGraphs.isEmpty() || score > this.topGraphs.first().getScore()) {
            EdgeListGraph graphCopy = new EdgeListGraph(graph);
            this.delete(x, y, t, graphCopy, score, false);
            this.rebuildPattern(graph);
            this.topGraphs.add(new ScoredGraph(graphCopy, score));
            if (this.topGraphs.size() > this.getNumPatternsToStore()) {
                this.topGraphs.remove(this.topGraphs.first());
            }
        }
    }

    public LocalDiscreteScore getDiscreteScore() {
        return this.discreteScore;
    }

    public void setDiscreteScore(LocalDiscreteScore discreteScore) {
        if (discreteScore.getDataSet() != this.dataSet) {
            throw new IllegalArgumentException("Must use the same data set.");
        }
        this.discreteScore = discreteScore;
    }
}

