/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.EvaluationResult;
import edu.cmu.tetrad.search.Shimizu2006SearchOld;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class GraphWithParameters {
    private Graph graph;
    public String generatingMethodName = null;
    private HashMap<Edge, Double> weightHash;
    int errorsOfOmission = 0;
    int errorsOfCommission = 0;
    int oriEvaluated = 0;
    int oriCorrect = 0;
    int directedWrongWay = 0;
    int undirectedWhenShouldBeDirected = 0;
    int directedWhenShouldBeUndirected = 0;
    List<Edge> correctDirectedOrientationEdges;
    double totalCoeffErrorSq;
    List<List<Integer>> cycles = null;

    public String getGeneratingMethodName() {
        return this.generatingMethodName;
    }

    public GraphWithParameters(SemIm semIm, Graph truePattern) {
        this(truePattern);
        for (Node node : this.getGraph().getNodes()) {
            if (!GraphUtils.allAdjacenciesAreDirected(node, this.getGraph())) continue;
            for (Edge edge : this.getGraph().getEdges(node)) {
                double semImWeight = semIm.getEdgeCoef(edge);
                this.getWeightHash().put(edge, semImWeight);
            }
        }
        this.graph = this.getGraph();
    }

    public GraphWithParameters(Graph graph) {
        this.graph = graph;
        this.weightHash = new HashMap();
    }

    public void addEdge(Node node1, Node node2, double weight) {
        Edge edge = new Edge(node1, node2, Endpoint.TAIL, Endpoint.ARROW);
        this.getGraph().addEdge(edge);
        this.getWeightHash().put(edge, weight);
    }

    public void addEdge(String nodeName1, String nodeName2, double weight) {
        Node node1 = this.getGraph().getNode(nodeName1);
        Node node2 = this.getGraph().getNode(nodeName2);
        this.addEdge(node1, node2, weight);
    }

    public GraphWithParameters(DataSet dataSet) {
        int i;
        DoubleMatrix2D Bmatrix = dataSet.getDoubleData();
        this.graph = new EdgeListGraph();
        this.weightHash = new HashMap();
        int n = Bmatrix.rows();
        for (i = 0; i < n; ++i) {
            GraphNode node = new GraphNode(dataSet.getVariableNames().get(i));
            this.getGraph().addNode(node);
        }
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double value = Bmatrix.get(i, j);
                if (!(value > 1.0E-15) && !(value < -1.0E-15)) continue;
                Node node1 = this.getGraph().getNode(dataSet.getVariableNames().get(i));
                Node node2 = this.getGraph().getNode(dataSet.getVariableNames().get(j));
                Edge edge = new Edge(node1, node2, Endpoint.TAIL, Endpoint.ARROW);
                this.getGraph().addEdge(edge);
                this.getWeightHash().put(edge, value);
            }
        }
    }

    public String toString() {
        String str = "";
        for (Edge edge : this.getGraph().getEdges()) {
            str = str + edge.toString();
            str = str + "   " + this.getWeightHash().get(edge) + "\n";
        }
        return str;
    }

    public EvaluationResult.AdjacencyEvaluationResult evalAdjacency(Graph standardDag) {
        boolean adjCorrect;
        for (Edge thisEdge : this.getGraph().getEdges()) {
            System.out.print("thisEdge = " + thisEdge);
            Edge standardEdge = GraphWithParameters.getCorrespondingEdge(standardDag, thisEdge);
            System.out.println(", standardEdge = " + standardEdge);
            adjCorrect = standardEdge != null;
            if (adjCorrect) continue;
            ++this.errorsOfCommission;
        }
        for (Edge standardEdge : standardDag.getEdges()) {
            System.out.print("standardEdge = " + standardEdge);
            Edge thisEdge = GraphWithParameters.getCorrespondingEdge(this.getGraph(), standardEdge);
            System.out.println(", thisEdge = " + thisEdge);
            adjCorrect = thisEdge != null;
            if (adjCorrect) continue;
            ++this.errorsOfOmission;
        }
        return new EvaluationResult.AdjacencyEvaluationResult(this.errorsOfOmission, this.errorsOfCommission);
    }

    public void printAdjacencyEvaluation() {
        System.out.println("== Results of evaluating adjacency ==");
        System.out.println("errorsOfOmission = " + this.errorsOfOmission);
        System.out.println("errorsOfCommission = " + this.errorsOfCommission);
    }

    public EvaluationResult.OrientationEvaluationResult evalOrientations(Graph standardGraph) {
        this.correctDirectedOrientationEdges = new Vector<Edge>();
        for (Edge standardEdge : standardGraph.getEdges()) {
            Edge thisEdge = GraphWithParameters.getCorrespondingEdge(this.getGraph(), standardEdge);
            System.out.print("standardEdge = " + standardEdge + (standardEdge == null ? "" : " (directed = " + standardEdge.isDirected()));
            System.out.println("), thisEdge = " + thisEdge + (thisEdge == null ? "" : " (directed = " + thisEdge.isDirected()) + ")");
            if (thisEdge == null) continue;
            ++this.oriEvaluated;
            if (!standardEdge.isDirected()) {
                if (!thisEdge.isDirected()) {
                    ++this.oriCorrect;
                } else {
                    ++this.directedWhenShouldBeUndirected;
                }
            } else if (thisEdge.isDirected()) {
                if (GraphWithParameters.getCorrespondingDirectedEdge(this.getGraph(), standardEdge) != null) {
                    ++this.oriCorrect;
                    this.correctDirectedOrientationEdges.add(thisEdge);
                } else {
                    ++this.directedWrongWay;
                }
            } else {
                ++this.undirectedWhenShouldBeDirected;
            }
            System.out.print("\n");
        }
        return new EvaluationResult.OrientationEvaluationResult(this.oriCorrect, this.directedWrongWay, this.undirectedWhenShouldBeDirected, this.directedWhenShouldBeUndirected);
    }

    public void printOrientationEvaluation() {
        System.out.println("== Results of evaluating orientation ==");
        System.out.println("oriCorrect = " + this.oriCorrect + "  directedWrongWay = " + this.directedWrongWay + "  undirectedWhenShouldBeDirected = " + this.undirectedWhenShouldBeDirected + "  directedWhenShouldBeUndirected = " + this.directedWhenShouldBeUndirected);
        System.out.println("oriEvaluated = " + this.oriEvaluated);
    }

    public EvaluationResult.CoefficientEvaluationResult evalCoeffs(GraphWithParameters standardGraph) {
        this.totalCoeffErrorSq = 0.0;
        List<Node> nodes = this.getGraph().getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            Node node1 = nodes.get(i);
            Node realNode1 = GraphWithParameters.getCorrespondingNode(standardGraph.getGraph(), node1);
            for (int j = 0; j < i; ++j) {
                Node node2 = nodes.get(j);
                Node realNode2 = GraphWithParameters.getCorrespondingNode(standardGraph.getGraph(), node2);
                System.out.println("node1 = " + node1 + "  node2 = " + node2);
                double coeff12 = this.getDirectedEdgeCoeff(node1, node2);
                double realCoeff12 = standardGraph.getDirectedEdgeCoeff(realNode1, realNode2);
                double err12 = Math.pow(coeff12 - realCoeff12, 2.0);
                System.out.println("err12 = " + err12);
                double coeff21 = this.getDirectedEdgeCoeff(node2, node1);
                double realCoeff21 = standardGraph.getDirectedEdgeCoeff(realNode2, realNode1);
                double err21 = Math.pow(coeff21 - realCoeff21, 2.0);
                System.out.println("err21 = " + err21);
                double error = err12 + err21;
                System.out.println("error = " + error);
                this.totalCoeffErrorSq += error;
            }
        }
        return new EvaluationResult.CoefficientEvaluationResult(this.totalCoeffErrorSq, null);
    }

    public EvaluationResult.CoefficientEvaluationResult evalCoeffsForNodePairs(GraphWithParameters standardGraph, List<Edge> edges) {
        this.totalCoeffErrorSq = 0.0;
        for (Edge edge : edges) {
            Node node1Edges = edge.getNode1();
            Node node2Edges = edge.getNode2();
            System.out.println("node1Edges = " + node1Edges + "  node2Edges = " + node2Edges);
            Node node1this = GraphWithParameters.getCorrespondingNode(this.getGraph(), node1Edges);
            Node node2this = GraphWithParameters.getCorrespondingNode(this.getGraph(), node2Edges);
            double coeff12 = this.getDirectedEdgeCoeff(node1this, node2this);
            Node node1sta = GraphWithParameters.getCorrespondingNode(standardGraph.getGraph(), node1Edges);
            Node node2sta = GraphWithParameters.getCorrespondingNode(standardGraph.getGraph(), node2Edges);
            double realCoeff12 = standardGraph.getDirectedEdgeCoeff(node1sta, node2sta);
            double err12 = Math.pow(coeff12 - realCoeff12, 2.0);
            System.out.println("err12 = " + err12);
            double coeff21 = this.getDirectedEdgeCoeff(node2this, node1this);
            double realCoeff21 = standardGraph.getDirectedEdgeCoeff(node2sta, node1sta);
            double err21 = Math.pow(coeff21 - realCoeff21, 2.0);
            System.out.println("err21 = " + err21);
            double error = err12 + err21;
            System.out.println("error = " + error);
            this.totalCoeffErrorSq += error;
        }
        return new EvaluationResult.CoefficientEvaluationResult(this.totalCoeffErrorSq, edges.size());
    }

    private double getDirectedEdgeCoeff(Node node1, Node node2) {
        Edge edge = this.getGraph().getDirectedEdge(node1, node2);
        double result = edge == null ? 0.0 : this.getWeightHash().get(edge);
        return result;
    }

    public void evalCoeffsCorrectOrientation(GraphWithParameters standardGraph) {
        List<Edge> edgesToEvaluate = this.correctDirectedOrientationEdges;
        System.out.println("correctOrientationEdges = " + this.correctDirectedOrientationEdges);
        for (Edge edge : edgesToEvaluate) {
            double thisCoeff = this.getWeightHash().get(edge);
            Edge standardEdge = GraphWithParameters.getCorrespondingEdge(standardGraph.getGraph(), edge);
            double standardCoeff = standardGraph.getWeightHash().get(standardEdge);
            double diff = thisCoeff - standardCoeff;
            System.out.println("thisEdge " + edge + ": " + thisCoeff + "   err = " + diff);
            this.totalCoeffErrorSq += Math.pow(diff, 2.0);
        }
    }

    private boolean oriAgrees(Edge edge1, Edge edge2) {
        int count = 0;
        System.out.println();
        if (edge1.pointsTowards(edge1.getNode1())) {
            ++count;
        }
        if (edge2.pointsTowards(edge2.getNode1())) {
            ++count;
        }
        return count % 2 == 0;
    }

    public void printCoefficientEvaluation() {
        System.out.println("== Results of evaluating coefficients ==");
        System.out.println("totalCoeffErrorSq = " + this.totalCoeffErrorSq);
    }

    public static Node getCorrespondingNode(Graph graph, Node node) {
        String nodeName = node.getName();
        Node node1 = graph.getNode(nodeName);
        return node1;
    }

    public static Edge getCorrespondingEdge(Graph graph, Edge edge) {
        Node node1 = GraphWithParameters.getCorrespondingNode(graph, edge.getNode1());
        Node node2 = GraphWithParameters.getCorrespondingNode(graph, edge.getNode2());
        Edge result = graph.getEdge(node1, node2);
        return result;
    }

    public static Edge getCorrespondingDirectedEdge(Graph graph, Edge edge) {
        if (edge == null) {
            return null;
        }
        String nodeName1 = edge.getNode1().getName();
        String nodeName2 = edge.getNode2().getName();
        Node node1 = graph.getNode(nodeName1);
        Node node2 = graph.getNode(nodeName2);
        Edge result = graph.getDirectedEdge(node1, node2);
        return result;
    }

    private static boolean hasCorrespondingAdjacency(Graph graph, Edge edge) {
        Edge corrEdge = GraphWithParameters.getCorrespondingEdge(graph, edge);
        return corrEdge != null;
    }

    private static boolean directionAgrees(Graph graph, Edge edge) {
        String edgeDirection = edge.toString().indexOf(">") == -1 ? "left" : "right";
        String nodeName1 = edge.getNode1().getName();
        String nodeName2 = edge.getNode2().getName();
        Node node1 = graph.getNode(nodeName1);
        Node node2 = graph.getNode(nodeName2);
        Edge graphEdge = graph.getEdge(node1, node2);
        String graphEdgeDirection = graphEdge.toString().indexOf(">") == -1 ? "left" : "right";
        return edgeDirection.equals(graphEdgeDirection);
    }

    public static GraphWithParameters regress(DataSet dataSet, Graph graph) {
        SemPm semPmEstDag = new SemPm(graph);
        SemEstimator estimatorEstDag = new SemEstimator(dataSet, semPmEstDag);
        estimatorEstDag.estimate();
        SemIm semImEstDag = estimatorEstDag.getEstimatedSem();
        GraphWithParameters estimatedGraph = new GraphWithParameters(semImEstDag, graph);
        return estimatedGraph;
    }

    public ColtDataSet getGraphMatrix() {
        int n = this.getGraph().getNumNodes();
        DenseDoubleMatrix2D matrix = new DenseDoubleMatrix2D(n, n);
        for (Edge edge : this.getGraph().getEdges()) {
            Node node1 = edge.getNode1();
            Node node2 = edge.getNode2();
            int node1Index = this.getGraph().getNodes().indexOf(node1);
            int node2Index = this.getGraph().getNodes().indexOf(node2);
            double value = this.getWeightHash().get(edge);
            matrix.set(node2Index, node1Index, value);
        }
        return Shimizu2006SearchOld.makeDataSet(matrix, this.getGraph().getNodes());
    }

    public List<List<Integer>> getCycles() {
        if (this.cycles == null) {
            // empty if block
        }
        return this.cycles;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public HashMap<Edge, Double> getWeightHash() {
        return this.weightHash;
    }
}

