/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MbSearch;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.DepthChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class HitonVariant
implements MbSearch {
    private IndependenceTest independenceTest;
    private List<Node> variables;
    private List<Node> sortedVariables;
    private int depth;

    public HitonVariant(IndependenceTest test, int depth) {
        if (test == null) {
            throw new NullPointerException();
        }
        this.independenceTest = test;
        this.variables = test.getVariables();
        this.depth = depth;
    }

    @Override
    public List<Node> findMb(String targetName) {
        TetradLogger.getInstance().log("info", "target = " + targetName);
        long time = System.currentTimeMillis();
        final Node t = this.getVariableForName(targetName);
        this.sortedVariables = new LinkedList<Node>(this.variables);
        Collections.sort(this.sortedVariables, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                double score2;
                double score1 = o1 == t ? 1.0 : HitonVariant.this.association(o1, t);
                double d = score2 = o2 == t ? 1.0 : HitonVariant.this.association(o2, t);
                if (score1 < score2) {
                    return 1;
                }
                if (score1 > score2) {
                    return -1;
                }
                return 0;
            }
        });
        List<Node> nodes = this.hitonMb(t);
        long time2 = System.currentTimeMillis() - time;
        TetradLogger.getInstance().log("info", "Number of seconds: " + (double)time2 / 1000.0);
        return nodes;
    }

    private List<Node> hitonMb(Node t) {
        HashSet<Node> mb = new HashSet<Node>();
        HashMap<Node, List<Node>> pcSets = new HashMap<Node, List<Node>>();
        List<Node> pc = this.hitonPc(t);
        pcSets.put(t, pc);
        HashSet<Node> _pcpc = new HashSet<Node>();
        for (Node node : pc) {
            List<Node> f = this.hitonPc(node);
            pcSets.put(node, f);
            _pcpc.addAll(f);
        }
        LinkedList pcpc = new LinkedList(_pcpc);
        HashSet<Node> currentMb = new HashSet<Node>(pc);
        currentMb.addAll(pcpc);
        currentMb.remove(t);
        HashSet<Node> diff = new HashSet<Node>(currentMb);
        diff.removeAll(pc);
        diff.remove(t);
        block1: for (Node x : diff) {
            int[] choice;
            LinkedList<Node> s = null;
            DepthChoiceGenerator generator = new DepthChoiceGenerator(pcpc.size(), this.depth);
            while ((choice = generator.next()) != null) {
                LinkedList<Node> _s = new LinkedList<Node>();
                for (int index : choice) {
                    _s.add((Node)pcpc.get(index));
                }
                if (!this.independenceTest.isIndependent(t, x, _s)) continue;
                s = _s;
                break;
            }
            if (s == null) {
                System.out.println("S not found.");
                continue;
            }
            HashSet<Node> ySet = new HashSet<Node>();
            for (Node y : pc) {
                if (!((List)pcSets.get(y)).contains(x)) continue;
                ySet.add(y);
            }
            for (Node y : ySet) {
                if (x == y) continue;
                LinkedList<Node> _s = new LinkedList<Node>(s);
                _s.add(y);
                if (this.independenceTest.isIndependent(t, x, _s)) continue;
                mb.add(x);
                continue block1;
            }
        }
        mb.addAll(pc);
        return new LinkedList<Node>(mb);
    }

    private List<Node> hitonPc(Node t) {
        LinkedList<Node> variables = new LinkedList<Node>(this.sortedVariables);
        variables.remove(t);
        ArrayList<Node> currentPc = new ArrayList<Node>();
        while (!variables.isEmpty()) {
            Node vi = variables.removeFirst();
            currentPc.add(vi);
            block1: for (Node x : new LinkedList<Node>(currentPc)) {
                currentPc.remove(x);
                for (int d = 0; d <= Math.min(currentPc.size(), this.depth); ++d) {
                    int[] choice;
                    ChoiceGenerator generator = new ChoiceGenerator(currentPc.size(), d);
                    while ((choice = generator.next()) != null) {
                        LinkedList<Node> s = new LinkedList<Node>();
                        for (int index : choice) {
                            s.add((Node)currentPc.get(index));
                        }
                        if (x != vi && !s.contains(vi) || !this.independenceTest.isIndependent(x, t, s)) continue;
                        continue block1;
                    }
                }
                currentPc.add(x);
            }
        }
        return currentPc;
    }

    private double association(Node x, Node y) {
        this.independenceTest.isIndependent(x, y, new LinkedList<Node>());
        return 1.0 - this.independenceTest.getPValue();
    }

    @Override
    public String getAlgorithmName() {
        return "HITON-VARIANT";
    }

    @Override
    public int getNumIndependenceTests() {
        return 0;
    }

    private Node getVariableForName(String targetName) {
        Node target = null;
        for (Node V : this.variables) {
            if (!V.getName().equals(targetName)) continue;
            target = V;
            break;
        }
        if (target == null) {
            throw new IllegalArgumentException("Target variable not in dataset: " + targetName);
        }
        return target;
    }
}

