/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.CutoffFinder;
import edu.cmu.tetrad.util.Integrator;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.PartialCorrelationPdf;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class IndTestCramerT
implements IndependenceTest {
    private DataSet dataSet;
    private final CovarianceMatrix covMatrix;
    private final List<Node> variables;
    private double alpha;
    private PartialCorrelationPdf pdf;
    private double cutoff = 0.0;
    private double storedR = 0.0;
    private static final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();

    public IndTestCramerT(DataSet dataSet, double alpha) {
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        this.dataSet = dataSet;
        this.covMatrix = new CorrelationMatrix(dataSet);
        this.variables = Collections.unmodifiableList(this.covMatrix.getVariables());
        this.setAlpha(alpha);
    }

    public IndTestCramerT(CorrelationMatrix covMatrix, double alpha) {
        this.covMatrix = covMatrix;
        this.variables = Collections.unmodifiableList(covMatrix.getVariables());
        this.setAlpha(alpha);
    }

    public IndTestCramerT(CovarianceMatrix covMatrix, double alpha) {
        CorrelationMatrix corrMatrix = new CorrelationMatrix(covMatrix);
        this.variables = Collections.unmodifiableList(corrMatrix.getVariables());
        this.covMatrix = corrMatrix;
        this.setAlpha(alpha);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        for (Node var : vars) {
            if (this.variables.contains(var)) continue;
            throw new IllegalArgumentException("All vars must be original vars");
        }
        int[] indices = new int[vars.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.variables.indexOf(vars.get(i));
        }
        CovarianceMatrix newCorrMatrix = this.covMatrix.getSubmatrix(indices);
        double alphaNew = this.getAlpha();
        return new IndTestCramerT(newCorrMatrix, alphaNew);
    }

    @Override
    public boolean isIndependent(Node x, Node y, List<Node> z) {
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        int size = z.size() + 2;
        int[] indices = new int[size];
        indices[0] = this.getVariables().indexOf(x);
        indices[1] = this.getVariables().indexOf(y);
        for (int i = 0; i < z.size(); ++i) {
            indices[i + 2] = this.getVariables().indexOf(z.get(i));
        }
        DoubleMatrix2D submatrix = this.covMatrix().getMatrix().viewSelection(indices, indices);
        if (DataUtils.containsMissingValue(submatrix)) {
            throw new IllegalArgumentException("Please remove or impute missing values first.");
        }
        if (new Algebra().rank(submatrix) != submatrix.rows()) {
            throw new IllegalArgumentException("Matrix singularity detected while using correlations \nto check for independence; probably due to collinearity \nin the data. The independence fact being checked was \n" + x + " _||_ " + y + " | " + z + ".");
        }
        submatrix = MatrixUtils.inverseC(submatrix);
        double a = -1.0 * submatrix.get(0, 1);
        double b = Math.sqrt(submatrix.get(0, 0) * submatrix.get(1, 1));
        this.storedR = a / b;
        if (Math.abs(this.storedR) > 1.0) {
            this.storedR = Math.signum(this.storedR);
        }
        if (Double.isNaN(this.storedR)) {
            throw new IllegalArgumentException("Conditional correlation cannot be computed: " + SearchLogUtils.independenceFact(x, y, z));
        }
        boolean independent = this.isZero(this.storedR, size, this.getAlpha());
        double pValue = this.getPValue();
        if (independent) {
            TetradLogger.getInstance().log("independencies", SearchLogUtils.independenceFactMsg(x, y, z, pValue));
        } else {
            TetradLogger.getInstance().log("dependencies", SearchLogUtils.dependenceFactMsg(x, y, z, pValue));
        }
        return independent;
    }

    @Override
    public boolean isIndependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isIndependent(x, y, zList);
    }

    @Override
    public boolean isDependent(Node x, Node y, List<Node> z) {
        return !this.isIndependent(x, y, z);
    }

    @Override
    public boolean isDependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isDependent(x, y, zList);
    }

    @Override
    public double getPValue() {
        return 2.0 * Integrator.getArea(this.pdf(), Math.abs(this.storedR), 1.0, 100);
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    private CovarianceMatrix covMatrix() {
        return this.covMatrix;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public boolean determines(List z, Node x) throws UnsupportedOperationException {
        int[] parents = new int[z.size()];
        for (int j = 0; j < parents.length; ++j) {
            parents[j] = this.covMatrix.getVariables().indexOf(z.get(j));
        }
        int i = this.covMatrix.getVariables().indexOf(x);
        DoubleMatrix2D matrix2D = this.covMatrix.getMatrix();
        double variance = matrix2D.get(i, i);
        if (parents.length > 0) {
            DoubleMatrix2D inverse;
            DoubleMatrix2D Czz = matrix2D.viewSelection(parents, parents);
            try {
                inverse = new Algebra().inverse(Czz);
            }
            catch (Exception e) {
                return true;
            }
            DoubleMatrix1D Cyz = matrix2D.viewColumn(i);
            Cyz = Cyz.viewSelection(parents);
            DoubleMatrix1D b = new Algebra().mult(inverse, Cyz);
            variance -= new Algebra().mult(Cyz, b);
        }
        return variance < 0.01;
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable : variables) {
            variableNames.add(variable.getName());
        }
        return variableNames;
    }

    public String toString() {
        return "Partial Correlation T Test, alpha = " + nf.format(this.getAlpha());
    }

    private boolean isZero(double r, int k, double alpha) {
        if (this.pdf() == null || this.pdf().getK() != k) {
            this.cutoff = this.cutoff(k, alpha);
        }
        return Math.abs(r) <= this.cutoff;
    }

    private double cutoff(int k, double alpha) {
        this.pdf = new PartialCorrelationPdf(this.sampleSize() - 1, k);
        double upperBound = 1.0;
        double delta = 1.0E-5;
        return CutoffFinder.getCutoff(this.pdf(), 1.0, alpha, 1.0E-5);
    }

    private int sampleSize() {
        return this.covMatrix().getSampleSize();
    }

    private PartialCorrelationPdf pdf() {
        return this.pdf;
    }
}

