/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndTestDSep
implements IndependenceTest {
    private Graph graph;
    private Map<Node, Node> nodesToVariables;
    private Map<Node, Node> variablesToNodes;
    private List<Node> observedVars;

    public IndTestDSep(Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.graph = graph;
        this.nodesToVariables = new HashMap<Node, Node>();
        this.variablesToNodes = new HashMap<Node, Node>();
        List<Node> nodes = graph.getNodes();
        for (Node node : nodes) {
            this.nodesToVariables.put(node, node);
            this.variablesToNodes.put(node, node);
        }
        this.observedVars = this.calcObservedVars(graph);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        for (Node var : vars) {
            if (this.getVariables().contains(var)) continue;
            throw new IllegalArgumentException("All vars must be original vars");
        }
        return this;
    }

    private List<Node> calcObservedVars(Graph graph) {
        ArrayList<Node> observedVars = new ArrayList<Node>();
        for (Node node : graph.getNodes()) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            observedVars.add(this.getVariable(node));
        }
        return observedVars;
    }

    @Override
    public boolean isIndependent(Node x, Node y, List<Node> z) {
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        Node nodex = this.getNode(x);
        Node nodey = this.getNode(y);
        ArrayList<Node> nodesz = new ArrayList<Node>();
        for (Node aZ : z) {
            nodesz.add(this.getNode(aZ));
        }
        boolean dSeparated = this.getGraph().isDSeparatedFrom(nodex, nodey, nodesz);
        if (dSeparated) {
            double pValue = 1.0;
            TetradLogger.getInstance().log("independencies", SearchLogUtils.independenceFactMsg(x, y, z, pValue));
        }
        return dSeparated;
    }

    @Override
    public boolean isIndependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isIndependent(x, y, zList);
    }

    @Override
    public boolean isDependent(Node x, Node y, List<Node> z) {
        return !this.isIndependent(x, y, z);
    }

    @Override
    public boolean isDependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isDependent(x, y, zList);
    }

    public boolean isDSeparated(Node x, Node y, List<Node> z) {
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node aZ : z) {
            if (aZ != null) continue;
            throw new NullPointerException();
        }
        ArrayList<Node> nodesz = new ArrayList<Node>();
        for (Node node : z) {
            nodesz.add(node);
        }
        return this.getGraph().isDSeparatedFrom(x, y, nodesz);
    }

    @Override
    public double getPValue() {
        return Double.NaN;
    }

    @Override
    public List<Node> getVariables() {
        return Collections.unmodifiableList(this.observedVars);
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> nodes = this.getVariables();
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (Node var : nodes) {
            nodeNames.add(var.getName());
        }
        return nodeNames;
    }

    public boolean determines(List z, Node x1) {
        return z.contains(x1);
    }

    @Override
    public double getAlpha() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAlpha(double alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Node getVariable(Node node) {
        return this.nodesToVariables.get(node);
    }

    public Node getNode(Node variable) {
        return this.variablesToNodes.get(variable);
    }

    public String toString() {
        return "D-separation";
    }

    @Override
    public DataSet getData() {
        return null;
    }
}

