/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.cluster.KMeans;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.kernel.Kernel;
import edu.cmu.tetrad.search.kernel.KernelGaussian;
import edu.cmu.tetrad.search.kernel.KernelUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;

public final class IndTestHsic
implements IndependenceTest {
    private List<Node> variables;
    private double alpha;
    private double thresh = Double.NaN;
    private double hsic;
    private static NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private DataSet dataSet;
    private double pValue = Double.NaN;
    private double regularizer = 1.0E-4;
    private int perms = 100;
    private double useIncompleteCholesky = 1.0E-18;

    public IndTestHsic(DataSet dataSet, double alpha) {
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        List<Node> nodes = dataSet.getVariables();
        this.variables = Collections.unmodifiableList(nodes);
        this.setAlpha(alpha);
        this.dataSet = dataSet;
    }

    public IndTestHsic(DoubleMatrix2D data, List<Node> variables, double alpha) {
        ColtDataSet dataSet = ColtDataSet.makeContinuousData(variables, data);
        this.variables = Collections.unmodifiableList(variables);
        this.setAlpha(alpha);
        this.dataSet = dataSet;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        for (Node var : vars) {
            if (this.variables.contains(var)) continue;
            throw new IllegalArgumentException("All vars must be original vars");
        }
        int[] indices = new int[vars.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.variables.indexOf(vars.get(i));
        }
        double alphaNew = this.getAlpha();
        return new IndTestHsic(this.dataSet.subsetColumns(indices), alphaNew);
    }

    @Override
    public boolean isIndependent(Node y, Node x, List<Node> z) {
        int m = this.sampleSize();
        KernelGaussian xKernel = new KernelGaussian(1.0);
        KernelGaussian yKernel = new KernelGaussian(1.0);
        ArrayList<Kernel> zKernel = new ArrayList<Kernel>();
        yKernel.setDefaultBw(this.dataSet, y);
        xKernel.setDefaultBw(this.dataSet, x);
        if (!z.isEmpty()) {
            for (int i = 0; i < z.size(); ++i) {
                KernelGaussian Zi = new KernelGaussian(1.0);
                Zi.setDefaultBw(this.dataSet, z.get(i));
                zKernel.add(Zi);
            }
        }
        Matrix Ky = null;
        Matrix Kx = null;
        Matrix Kz = null;
        if (this.useIncompleteCholesky > 0.0) {
            Ky = KernelUtils.incompleteCholeskyGramMatrix(Arrays.asList(yKernel), this.dataSet, Arrays.asList(y), this.useIncompleteCholesky);
            Kx = KernelUtils.incompleteCholeskyGramMatrix(Arrays.asList(xKernel), this.dataSet, Arrays.asList(x), this.useIncompleteCholesky);
            if (!z.isEmpty()) {
                Kz = KernelUtils.incompleteCholeskyGramMatrix(zKernel, this.dataSet, z, this.useIncompleteCholesky);
            }
        } else {
            Ky = KernelUtils.constructCentralizedGramMatrix(Arrays.asList(yKernel), this.dataSet, Arrays.asList(y));
            Kx = KernelUtils.constructCentralizedGramMatrix(Arrays.asList(xKernel), this.dataSet, Arrays.asList(x));
            if (!z.isEmpty()) {
                Kz = KernelUtils.constructCentralizedGramMatrix(zKernel, this.dataSet, z);
            }
        }
        this.hsic = z.isEmpty() ? (this.useIncompleteCholesky > 0.0 ? this.empiricalHSICincompleteCholesky(Ky, Kx, m) : this.empiricalHSIC(Ky, Kx, m)) : (this.useIncompleteCholesky > 0.0 ? this.empiricalHSICincompleteCholesky(Ky, Kx, Kz, m) : this.empiricalHSIC(Ky, Kx, Kz, m));
        double[] nullapprox = new double[this.perms];
        int[] zind = null;
        int ycol = this.dataSet.getColumn(y);
        List<List<Integer>> clusterAssign = null;
        if (!z.isEmpty()) {
            KMeans kmeans = KMeans.randomClusters(m / 3);
            zind = new int[z.size()];
            for (int j = 0; j < z.size(); ++j) {
                zind[j] = this.dataSet.getColumn(z.get(j));
            }
            kmeans.cluster(this.dataSet.subsetColumns(z).getDoubleData());
            clusterAssign = kmeans.getClusters();
        }
        for (int i = 0; i < this.perms; ++i) {
            ColtDataSet shuffleData = new ColtDataSet((ColtDataSet)this.dataSet);
            if (z.isEmpty()) {
                int j;
                ArrayList<Integer> indicesList = new ArrayList<Integer>();
                for (j = 0; j < m; ++j) {
                    indicesList.add(j);
                }
                Collections.shuffle(indicesList);
                for (j = 0; j < m; ++j) {
                    double shuffleVal = this.dataSet.getDouble((Integer)indicesList.get(j), ycol);
                    shuffleData.setDouble(j, ycol, shuffleVal);
                }
            } else {
                for (int j = 0; j < clusterAssign.size(); ++j) {
                    ArrayList shuffleCluster = new ArrayList(clusterAssign.get(j));
                    Collections.shuffle(shuffleCluster);
                    for (int k = 0; k < shuffleCluster.size(); ++k) {
                        double swapVal = this.dataSet.getDouble(clusterAssign.get(j).get(k), ycol);
                        shuffleData.setDouble((Integer)shuffleCluster.get(k), ycol, swapVal);
                        for (int zi = 0; zi < z.size(); ++zi) {
                            swapVal = this.dataSet.getDouble(clusterAssign.get(j).get(k), zind[zi]);
                            shuffleData.setDouble((Integer)shuffleCluster.get(k), zind[zi], swapVal);
                        }
                    }
                }
            }
            yKernel.setDefaultBw(shuffleData, y);
            for (int j = 0; j < z.size(); ++j) {
                ((Kernel)zKernel.get(j)).setDefaultBw(shuffleData, z.get(j));
            }
            Matrix Kyn = null;
            Kyn = this.useIncompleteCholesky > 0.0 ? KernelUtils.incompleteCholeskyGramMatrix(Arrays.asList(yKernel), shuffleData, Arrays.asList(y), this.useIncompleteCholesky) : KernelUtils.constructCentralizedGramMatrix(Arrays.asList(yKernel), shuffleData, Arrays.asList(y));
            Matrix Kzn = null;
            if (!z.isEmpty()) {
                Kzn = this.useIncompleteCholesky > 0.0 ? KernelUtils.incompleteCholeskyGramMatrix(zKernel, shuffleData, z, this.useIncompleteCholesky) : KernelUtils.constructCentralizedGramMatrix(zKernel, shuffleData, z);
            }
            if (z.isEmpty()) {
                if (this.useIncompleteCholesky > 0.0) {
                    nullapprox[i] = this.empiricalHSICincompleteCholesky(Kyn, Kx, m);
                    continue;
                }
                nullapprox[i] = this.empiricalHSIC(Kyn, Kx, m);
                continue;
            }
            nullapprox[i] = this.useIncompleteCholesky > 0.0 ? this.empiricalHSICincompleteCholesky(Kyn, Kx, Kz, m) : this.empiricalHSIC(Kyn, Kx, Kz, m);
        }
        double evalCdf = 0.0;
        for (int i = 0; i < this.perms; ++i) {
            if (!(nullapprox[i] <= this.hsic)) continue;
            evalCdf += 1.0;
        }
        this.pValue = 1.0 - (evalCdf /= (double)this.perms);
        if (this.pValue <= this.alpha) {
            TetradLogger.getInstance().log("dependencies", SearchLogUtils.dependenceFactMsg(x, y, z, this.getPValue()));
            return false;
        }
        TetradLogger.getInstance().log("independencies", SearchLogUtils.independenceFactMsg(x, y, z, this.getPValue()));
        return true;
    }

    public double empiricalHSIC(Matrix Ky, Matrix Kx, int m) {
        DenseMatrix Kyx = new DenseMatrix(m, m);
        Ky.mult(Kx, Kyx);
        double empHSIC = 0.0;
        for (int i = 0; i < m; ++i) {
            empHSIC += Kyx.get(i, i);
        }
        return empHSIC /= Math.pow(m - 1, 2.0);
    }

    public double empiricalHSICincompleteCholesky(Matrix Gy, Matrix Gx, int m) {
        int ky = Gy.numColumns();
        int kx = Gx.numColumns();
        UpperSymmPackMatrix H = KernelUtils.constructH(m);
        DenseMatrix Gcy = new DenseMatrix(m, ky);
        H.mult(Gy, Gcy);
        DenseMatrix Gcx = new DenseMatrix(m, kx);
        H.mult(Gx, Gcx);
        DenseMatrix A = new DenseMatrix(ky, kx);
        DenseMatrix Gcyt = new DenseMatrix(ky, m);
        Gcy.transpose(Gcyt);
        Gcyt.mult(Gcx, A);
        DenseMatrix B = new DenseMatrix(m, kx);
        Gcy.mult(A, B);
        DenseMatrix Gcxt = new DenseMatrix(kx, m);
        Gcx.transpose(Gcxt);
        double empHSIC = 0.0;
        for (int i = 0; i < m; ++i) {
            empHSIC += this.matrixProductEntry(B, Gcxt, i, i);
        }
        return empHSIC /= Math.pow(m - 1, 2.0);
    }

    private double empiricalHSIC(Matrix Ky, Matrix Kx, Matrix Kz, int m) {
        DenseMatrix Kyx = new DenseMatrix(m, m);
        Ky.mult(Kx, Kyx);
        DenseMatrix Kyz = new DenseMatrix(m, m);
        Ky.mult(Kz, Kyz);
        DenseMatrix Kzx = new DenseMatrix(m, m);
        Kz.mult(Kx, Kzx);
        Matrix Kzreg = Kz.copy();
        for (int i = 0; i < m; ++i) {
            double ent = Kzreg.get(i, i) + this.regularizer;
            Kzreg.set(i, i, ent);
        }
        DenseMatrix A = new DenseMatrix(m, m);
        DenseMatrix I = Matrices.identity(m);
        Kzreg.solve(I, A);
        A.mult(A, Kzreg);
        DenseMatrix Kyzzregzx = new DenseMatrix(m, m);
        Kyz.mult(Kzreg, A);
        A.mult(Kzx, Kyzzregzx);
        Matrix Kyzzregzxzzregz = Kyzzregzx.copy();
        Kyzzregzx.mult(Kz, Kyzzregzxzzregz);
        Kyzzregzxzzregz.mult(Kzreg, A);
        A.mult(Kz, Kyzzregzxzzregz);
        double empHSIC = 0.0;
        for (int i = 0; i < m; ++i) {
            empHSIC += Kyx.get(i, i);
            empHSIC += -2.0 * Kyzzregzx.get(i, i);
            empHSIC += Kyzzregzxzzregz.get(i, i);
        }
        empHSIC /= Math.pow(m - 1, 2.0);
        double Bz = 0.0;
        for (int i = 0; i < m - 1; ++i) {
            for (int j = i + 1; j < m; ++j) {
                Bz += Math.pow(Kz.get(i, j), 2.0);
                Bz += Math.pow(Kz.get(j, i), 2.0);
            }
        }
        Bz = (double)(m * (m - 1)) / Bz;
        return empHSIC *= Bz;
    }

    public double empiricalHSICincompleteCholesky(Matrix Gy, Matrix Gx, Matrix Gz, int m) {
        int ky = Gy.numColumns();
        int kx = Gx.numColumns();
        int kz = Gz.numColumns();
        UpperSymmPackMatrix H = KernelUtils.constructH(m);
        DenseMatrix Gcy = new DenseMatrix(m, ky);
        H.mult(Gy, Gcy);
        DenseMatrix Gcx = new DenseMatrix(m, kx);
        H.mult(Gx, Gcx);
        DenseMatrix Gcz = new DenseMatrix(m, kz);
        H.mult(Gz, Gcz);
        DenseMatrix A = new DenseMatrix(ky, kx);
        DenseMatrix Gcyt = new DenseMatrix(ky, m);
        Gcy.transpose(Gcyt);
        Gcyt.mult(Gcx, A);
        DenseMatrix B = new DenseMatrix(m, kx);
        Gcy.mult(A, B);
        DenseMatrix Kyx = new DenseMatrix(m, m);
        DenseMatrix Gcxt = new DenseMatrix(kx, m);
        Gcx.transpose(Gcxt);
        B.mult(Gcxt, Kyx);
        double empHSIC = 0.0;
        double xy = 0.0;
        for (int i = 0; i < m; ++i) {
            empHSIC += this.matrixProductEntry(B, Gcxt, i, i);
        }
        DenseMatrix Gytz = new DenseMatrix(ky, kz);
        Gcyt.mult(Gcz, Gytz);
        DenseMatrix Gztx = new DenseMatrix(kz, kx);
        DenseMatrix Gczt = new DenseMatrix(kz, m);
        Gcz.transpose(Gczt);
        Gczt.mult(Gcx, Gztx);
        DenseMatrix Gztz = new DenseMatrix(kz, kz);
        Gczt.mult(Gcz, Gztz);
        Matrix Gztzr = Gztz.copy();
        for (int i = 0; i < kz; ++i) {
            Gztzr.set(i, i, Gztz.get(i, i) + this.regularizer);
        }
        DenseMatrix ZI = new DenseMatrix(kz, kz);
        Gztzr.solve(Matrices.identity(kz), ZI);
        DenseMatrix ZIzt = new DenseMatrix(kz, m);
        ZI.mult(Gczt, ZIzt);
        Matrix Gzr = Gcz.copy();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < kz; ++j) {
                Gzr.set(i, j, Gcz.get(i, j) * (-1.0 / this.regularizer));
            }
        }
        DenseMatrix Zinv = new DenseMatrix(m, m);
        Gzr.mult(ZIzt, Zinv);
        for (int i = 0; i < m; ++i) {
            Zinv.set(i, i, Zinv.get(i, i) + 1.0 / this.regularizer);
        }
        DenseMatrix Gztzinv = new DenseMatrix(kz, m);
        Gczt.mult(Zinv, Gztzinv);
        DenseMatrix Gzinvz = new DenseMatrix(m, kz);
        Zinv.mult(Gcz, Gzinvz);
        DenseMatrix Gztinv2z = new DenseMatrix(kz, kz);
        Gztzinv.mult(Gzinvz, Gztinv2z);
        DenseMatrix Gytzztzinv2z = new DenseMatrix(ky, kz);
        Gytz.mult(Gztinv2z, Gytzztzinv2z);
        DenseMatrix Gytzztzinv2zztx = new DenseMatrix(ky, kx);
        Gytzztzinv2z.mult(Gztx, Gytzztzinv2zztx);
        DenseMatrix Gyytzztzinv2zztx = new DenseMatrix(m, kx);
        Gcy.mult(Gytzztzinv2zztx, Gyytzztzinv2zztx);
        double second = 0.0;
        for (int i = 0; i < m; ++i) {
            second += this.matrixProductEntry(Gyytzztzinv2zztx, Gcxt, i, i);
        }
        empHSIC -= 2.0 * second;
        DenseMatrix Gxtz = new DenseMatrix(kx, kz);
        Gcxt.mult(Gcz, Gxtz);
        DenseMatrix Gxtzztinv2z = new DenseMatrix(kx, kz);
        Gxtz.mult(Gztinv2z, Gxtzztinv2z);
        DenseMatrix Gyytzztzinv2zztxxtzztinv2z = new DenseMatrix(m, kz);
        Gyytzztzinv2zztx.mult(Gxtzztinv2z, Gyytzztzinv2zztxxtzztinv2z);
        for (int i = 0; i < m; ++i) {
            empHSIC += this.matrixProductEntry(Gyytzztzinv2zztxxtzztinv2z, Gczt, i, i);
        }
        double betaz = 0.0;
        for (int i = 0; i < m - 1; ++i) {
            for (int j = i + 1; j < m; ++j) {
                betaz += Math.pow(this.matrixProductEntry(Gcz, Gczt, i, j), 2.0);
                betaz += Math.pow(this.matrixProductEntry(Gcz, Gczt, j, i), 2.0);
            }
        }
        return empHSIC *= (double)m / (betaz * (double)(m - 1));
    }

    public double empiricalHSICincompleteCholeskyOLD(Matrix Gy, Matrix Gx, Matrix Gz, int m) {
        int i;
        int i2;
        int ky = Gy.numColumns();
        int kx = Gx.numColumns();
        int kz = Gz.numColumns();
        UpperSymmPackMatrix H = KernelUtils.constructH(m);
        DenseMatrix Gcy = new DenseMatrix(m, ky);
        H.mult(Gy, Gcy);
        DenseMatrix Gcx = new DenseMatrix(m, kx);
        H.mult(Gx, Gcx);
        DenseMatrix Gcz = new DenseMatrix(m, kz);
        H.mult(Gz, Gcz);
        DenseMatrix A = new DenseMatrix(ky, kx);
        DenseMatrix Gcyt = new DenseMatrix(ky, m);
        Gcy.transpose(Gcyt);
        Gcyt.mult(Gcx, A);
        DenseMatrix B = new DenseMatrix(m, kx);
        Gcy.mult(A, B);
        DenseMatrix Kyx = new DenseMatrix(m, m);
        DenseMatrix Gcxt = new DenseMatrix(kx, m);
        Gcx.transpose(Gcxt);
        B.mult(Gcxt, Kyx);
        double empHSIC = 0.0;
        double xy = 0.0;
        for (int i3 = 0; i3 < m; ++i3) {
            empHSIC += this.matrixProductEntry(B, Gcxt, i3, i3);
        }
        DenseMatrix Gytz = new DenseMatrix(ky, kz);
        Gcyt.mult(Gcz, Gytz);
        DenseMatrix Gztx = new DenseMatrix(kz, kx);
        DenseMatrix Gczt = new DenseMatrix(kz, m);
        Gcz.transpose(Gczt);
        Gczt.mult(Gcx, Gztx);
        DenseMatrix Gztz = new DenseMatrix(kz, kz);
        Gczt.mult(Gcz, Gztz);
        DenseMatrix Gztzztx = new DenseMatrix(kz, kx);
        Gztz.mult(Gztx, Gztzztx);
        DenseMatrix Gytzztzztx = new DenseMatrix(ky, kx);
        Gytz.mult(Gztzztx, Gytzztzztx);
        DenseMatrix Gyytzztzztx = new DenseMatrix(m, kx);
        Gcy.mult(Gytzztzztx, Gyytzztzztx);
        double second = 0.0;
        for (int i4 = 0; i4 < m; ++i4) {
            second += this.matrixProductEntry(Gyytzztzztx, Gcxt, i4, i4);
        }
        Matrix Gztzr = Gztz.copy();
        for (int i5 = 0; i5 < kz; ++i5) {
            Gztzr.set(i5, i5, Gztz.get(i5, i5) + this.regularizer);
        }
        DenseMatrix ZI = new DenseMatrix(kz, kz);
        Gztzr.solve(Matrices.identity(kz), ZI);
        DenseMatrix GzGZI = new DenseMatrix(m, kz);
        Gcz.mult(ZI, GzGZI);
        DenseMatrix GzGZIGzt = new DenseMatrix(m, m);
        GzGZI.mult(Gczt, GzGZIGzt);
        double inv = 0.0;
        for (i2 = 0; i2 < m; ++i2) {
            for (int j = 0; j < m; ++j) {
                GzGZIGzt.set(i2, j, GzGZIGzt.get(i2, j) * (-1.0 / this.regularizer));
            }
        }
        for (i2 = 0; i2 < m; ++i2) {
            GzGZIGzt.set(i2, i2, GzGZIGzt.get(i2, i2) + 1.0 / this.regularizer);
        }
        for (i2 = 0; i2 < m; ++i2) {
            inv += GzGZIGzt.get(i2, i2);
        }
        System.out.println("inv " + inv);
        inv = 0.0;
        DenseMatrix ZI2 = new DenseMatrix(m, m);
        GzGZIGzt.mult(GzGZIGzt, ZI2);
        for (int i6 = 0; i6 < m; ++i6) {
            inv += ZI2.get(i6, i6);
        }
        System.out.println("inv " + inv);
        DenseMatrix Gyytz = new DenseMatrix(m, kz);
        Gcy.mult(Gytz, Gyytz);
        DenseMatrix Gyytzzt = new DenseMatrix(m, m);
        Gyytz.mult(Gczt, Gyytzzt);
        DenseMatrix Gzztx = new DenseMatrix(m, kx);
        Gcz.mult(Gztx, Gzztx);
        DenseMatrix Gzztxxt = new DenseMatrix(m, m);
        Gzztx.mult(Gcxt, Gzztxxt);
        DenseMatrix GyzZI = new DenseMatrix(m, m);
        Gyytzzt.mult(ZI2, GyzZI);
        DenseMatrix GyzZIzx = new DenseMatrix(m, m);
        GyzZI.mult(Gzztxxt, GyzZIzx);
        double sec = 0.0;
        for (int i7 = 0; i7 < m; ++i7) {
            sec += GyzZIzx.get(i7, i7);
        }
        System.out.println("sec " + sec);
        DenseMatrix Gytzztz = new DenseMatrix(ky, kz);
        Gytz.mult(Gztz, Gytzztz);
        DenseMatrix GytzztzZI = new DenseMatrix(ky, kz);
        Gytzztz.mult(ZI, GytzztzZI);
        DenseMatrix GytzztzZIztzztx = new DenseMatrix(ky, kx);
        GytzztzZI.mult(Gztzztx, GytzztzZIztzztx);
        DenseMatrix GyytzztzZIztzztx = new DenseMatrix(m, kx);
        Gcy.mult(GytzztzZIztzztx, GyytzztzZIztzztx);
        double s1 = 0.0;
        for (int i8 = 0; i8 < m; ++i8) {
            s1 += this.matrixProductEntry(GyytzztzZIztzztx, Gcxt, i8, i8);
        }
        second -= 2.0 * s1;
        DenseMatrix GZIztzztx = new DenseMatrix(kz, kx);
        ZI.mult(Gztzztx, GZIztzztx);
        DenseMatrix GytzztzZIztz = new DenseMatrix(ky, kz);
        GytzztzZI.mult(Gztz, GytzztzZIztz);
        DenseMatrix GytzztzZIztzZIztzztx = new DenseMatrix(ky, kx);
        GytzztzZIztz.mult(GZIztzztx, GytzztzZIztzZIztzztx);
        DenseMatrix GyytzztzZIztzZIztzztx = new DenseMatrix(m, kx);
        Gcy.mult(GytzztzZIztzZIztzztx, GyytzztzZIztzZIztzztx);
        for (int i9 = 0; i9 < m; ++i9) {
            second += this.matrixProductEntry(GyytzztzZIztzZIztzztx, Gcxt, i9, i9);
        }
        double reg2 = Math.pow(this.regularizer, 2.0);
        empHSIC -= 2.0 / reg2 * second;
        DenseMatrix Gxtz = new DenseMatrix(kx, kz);
        Gcxt.mult(Gcz, Gxtz);
        DenseMatrix Gxtzztz = new DenseMatrix(kx, kz);
        Gxtz.mult(Gztz, Gxtzztz);
        DenseMatrix Gxtzztzzt = new DenseMatrix(kx, m);
        Gxtzztz.mult(Gczt, Gxtzztzzt);
        DenseMatrix GxtzztzZI = new DenseMatrix(kx, kz);
        Gxtzztz.mult(ZI, GxtzztzZI);
        DenseMatrix GxtzztzZIztz = new DenseMatrix(kx, kz);
        GxtzztzZI.mult(Gztz, GxtzztzZIztz);
        DenseMatrix GxtzztzZIztzzt = new DenseMatrix(kx, m);
        GxtzztzZIztz.mult(Gczt, GxtzztzZIztzzt);
        DenseMatrix GxtzztzZIztzZI = new DenseMatrix(kx, kz);
        GxtzztzZIztz.mult(ZI, GxtzztzZIztzZI);
        DenseMatrix GxtzztzZIztzZIztz = new DenseMatrix(kx, kz);
        GxtzztzZIztzZI.mult(Gztz, GxtzztzZIztzZIztz);
        DenseMatrix GxtzztzZIztzZIztzzt = new DenseMatrix(kx, m);
        GxtzztzZIztzZIztz.mult(Gczt, GxtzztzZIztzZIztzzt);
        double third = 0.0;
        for (i = 0; i < m; ++i) {
            third += this.matrixProductEntry(GyytzztzZIztzztx, Gxtzztzzt, i, i);
            third += this.matrixProductEntry(GyytzztzZIztzztx, GxtzztzZIztzZIztzzt, i, i);
            third += this.matrixProductEntry(Gyytzztzztx, GxtzztzZIztzzt, i, i);
            third += this.matrixProductEntry(GyytzztzZIztzZIztzztx, GxtzztzZIztzzt, i, i);
        }
        third *= -2.0;
        for (i = 0; i < m; ++i) {
            third += this.matrixProductEntry(Gyytzztzztx, Gxtzztzzt, i, i);
            third += this.matrixProductEntry(GyytzztzZIztzZIztzztx, Gxtzztzzt, i, i);
            third += this.matrixProductEntry(Gyytzztzztx, GxtzztzZIztzZIztzzt, i, i);
            third += this.matrixProductEntry(GyytzztzZIztzZIztzztx, GxtzztzZIztzZIztzzt, i, i);
        }
        double t1 = 0.0;
        for (int i10 = 0; i10 < m; ++i10) {
            t1 += this.matrixProductEntry(GyytzztzZIztzztx, GxtzztzZIztzzt, i10, i10);
        }
        empHSIC += (third += 4.0 * t1) / Math.pow(reg2, 2.0);
        double betaz = 0.0;
        for (int i11 = 0; i11 < m - 1; ++i11) {
            for (int j = i11 + 1; j < m; ++j) {
                betaz += Math.pow(this.matrixProductEntry(Gcz, Gczt, i11, j), 2.0);
                betaz += Math.pow(this.matrixProductEntry(Gcz, Gczt, j, i11), 2.0);
            }
        }
        return empHSIC *= (double)m / (betaz * (double)(m - 1));
    }

    @Override
    public boolean isIndependent(Node x, Node y, Node ... z) {
        return this.isIndependent(x, y, Arrays.asList(z));
    }

    @Override
    public boolean isDependent(Node x, Node y, List<Node> z) {
        return !this.isIndependent(x, y, z);
    }

    @Override
    public boolean isDependent(Node x, Node y, Node ... z) {
        List<Node> zList = Arrays.asList(z);
        return this.isDependent(x, y, zList);
    }

    public double getHsic() {
        return this.hsic;
    }

    public double getThreshold() {
        return this.thresh;
    }

    @Override
    public double getPValue() {
        return this.pValue;
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
        this.thresh = Double.NaN;
    }

    public void setIncompleteCholesky(double precision) {
        this.useIncompleteCholesky = precision;
    }

    public void setPerms(int perms) {
        this.perms = perms;
    }

    public void setRegularizer(double regularizer) {
        this.regularizer = regularizer;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    public double getPrecision() {
        return this.useIncompleteCholesky;
    }

    public int getPerms() {
        return this.perms;
    }

    public double getRegularizer() {
        return this.regularizer;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    public void shuffleVariables() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.variables);
        Collections.shuffle(nodes);
        this.variables = Collections.unmodifiableList(nodes);
    }

    public String toString() {
        return "HSIC, alpha = " + nf.format(this.getAlpha());
    }

    public boolean determines(List z, Node x) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Method not implemented");
    }

    private int sampleSize() {
        return this.dataSet.getNumRows();
    }

    private double matrixProductEntry(Matrix X, Matrix Y, int i, int j) {
        double entry = 0.0;
        for (int k = 0; k < X.numColumns(); ++k) {
            entry += X.get(i, k) * Y.get(k, j);
        }
        return entry;
    }

    private static double trace(Matrix A, int m) {
        double trace = 0.0;
        for (int i = 0; i < m; ++i) {
            trace += A.get(i, i);
        }
        return trace;
    }
}

